/*
 * Decompiled with CFR 0.152.
 */
package redlight.utils;

import java.io.File;
import redlight.utils.TextUtils;

public class FilenameUtils {
    public static File getNextUniqueFile(File f) {
        if (!f.exists()) {
            return f;
        }
        String n = f.getName();
        String pre = f.getName();
        String post = "";
        if (n.indexOf(46) != -1) {
            pre = n.substring(0, n.indexOf(46));
            post = n.substring(n.indexOf(46));
        }
        pre = pre + "_";
        int tries = 0;
        while (tries < 2) {
            int i = 1;
            while (i < 100000) {
                if (!(f = new File(f.getParent(), pre + i + post)).exists()) {
                    return f;
                }
                ++i;
            }
            ++tries;
        }
        throw new RuntimeException("could not get unique file for " + f);
    }

    public static String qualify(String temp) {
        String filename = TextUtils.findAndReplace(temp, "/", "_");
        if (System.getProperty("os.name").startsWith("Mac") && !System.getProperty("os.name").equals("Mac OS X")) {
            if (filename.length() > 31) {
                filename = filename.substring(0, 14) + "..." + filename.substring(filename.length() - 14, filename.length());
            }
            filename = TextUtils.findAndReplace(filename, ":", "_");
        } else if (System.getProperty("os.name").startsWith("Windows")) {
            char[] c = filename.toCharArray();
            char[] c2 = new char[c.length];
            int i = 0;
            while (i < c.length) {
                int t = c[i];
                switch (c[i]) {
                    case '\"': 
                    case '*': 
                    case ',': 
                    case ':': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '\\': 
                    case '|': {
                        t = 95;
                    }
                }
                if (Character.isISOControl(c[i])) {
                    t = 95;
                }
                c2[i] = t;
                ++i;
            }
            filename = new String(c2);
        }
        return filename;
    }
}

