/**
 * $Id: UserListModel.java,v 1.1.1.1 2001/07/22 02:44:36 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;

import redlight.utils.DebuggerOutput;

public class UserListModel extends DefaultListModel {

    Object returnObject;
    int returnInt;
    boolean returnBoolean;

    UserListModel() {

	super();

    }

    public int indexOf(Object o) {
	
	if(SwingUtilities.isEventDispatchThread()) {

	    return super.indexOf(o);

	} else {

	    final Object object = o;
	    
	    try {
		
		SwingUtilities.invokeAndWait(new UserListWrapper(this) {
		    public void run() {
			returnInt = ulm.indexOf(object);
		    }
		});
		
	    } catch (Exception e) {
		
		DebuggerOutput.stackTrace(e);
		
	    }
	    
	    return returnInt;

	}

    }

    public void setElementAt(Object o, int i) {

	if(SwingUtilities.isEventDispatchThread()) {

	    super.setElementAt(o, i);
	    
	} else {

	    final Object object = o;
	    final int index = i;
	    
	    try {
		
		SwingUtilities.invokeAndWait(new UserListWrapper(this) {
		    public void run() {
			ulm.setElementAt(object, index);
		    }
		});
		
	    } catch (Exception e) {
		
		DebuggerOutput.stackTrace(e);
	    
	    }

	}

    }

    public boolean removeElement(Object o) {

	if(SwingUtilities.isEventDispatchThread()) {

	    return super.removeElement(o);

	} else {

	    final Object object = o;
	    
	    try {
		
		SwingUtilities.invokeAndWait(new UserListWrapper(this) {

		    public void run() {

			returnBoolean = ulm.removeElement(object);

		    }

		});
		
	    } catch (Exception e) {

		DebuggerOutput.stackTrace(e);
		
	    }

	    return returnBoolean;

	}

    }

    public void addElement(Object o) {
	
	if(SwingUtilities.isEventDispatchThread()) {

	    super.addElement(o);

	} else {

	    final Object object = o;
	    
	    try {
		
		SwingUtilities.invokeAndWait(new UserListWrapper(this) {
		    public void run() {
			ulm.addElement(object);
		    }
		});
		
	    } catch (Exception e) {
		
		DebuggerOutput.stackTrace(e);
		
	    }

	}

    }

    public Object getElementAt(int i) {

	if(SwingUtilities.isEventDispatchThread()) {

	    return super.getElementAt(i);

	} else {

	    final int index = i;
	    
	    try {
		
		SwingUtilities.invokeAndWait(new UserListWrapper(this) {
		    public void run() {
			returnObject = ulm.getElementAt(index);
		    }
		});
		
	    } catch (Exception e) {
		
		DebuggerOutput.stackTrace(e);
		
	    }

	}

	return returnObject;

    }

    public int getSize() {

	if(SwingUtilities.isEventDispatchThread()) {

	    return super.getSize();

	} else {

	    try {
		
		SwingUtilities.invokeAndWait(new UserListWrapper(this) {
		    public void run() {
			returnInt = ulm.getSize();
		    }
		});
		
	    } catch (Exception e) {
	    
		DebuggerOutput.stackTrace(e);
		
	    }
	    
	}

	return returnInt;

    }
    
}

class UserListWrapper 
    implements Runnable {
 
    UserListModel ulm;

    UserListWrapper(UserListModel lm) {
	ulm = lm;
    }

    public void run() {
    }

}
