/**
 * $Id: UsersInterface.java,v 1.9 2001/10/04 01:03:59 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.awt.*;
import java.awt.event.*;
import java.util.Hashtable;
import java.util.Enumeration;

import java.io.IOException;

import javax.swing.*;
import javax.swing.event.*;

import redlight.hotline.*;
import redlight.utils.DebuggerOutput;
import redlight.script.*;

public class UsersInterface implements ActionListener, 
                                       Scriptable {

    Machine rlm;
    Container contentPane;
    JList list;
    UserToolBar toolBar;
    JButton openAccount, createAccount;
    JCheckBox joinLeave;
    JFrame f;
    DefaultListModel listModel;
    Hashtable users;
    HLProtocol hlp;
    static int x = 0, y = 0;
    static Integer lock = new Integer(0);
    boolean swallow;

    public UsersInterface(Machine machine) {

	this(machine, false);

    }

    public UsersInterface(Machine machine, boolean sw) {

	rlm = machine;
	swallow = sw;
	users = new Hashtable();
	hlp = new HLProtocol();
	rlm.getScriptBroker().addTarget(this);
	
	if(swallow == false) {

	    f = new JFrame("Users (" + rlm.getServerName() + ")");
	    contentPane = f.getContentPane();

	    f.addWindowListener(new WindowAdapter() {

                    public void windowClosing(WindowEvent e) {
                        
                        e.getWindow().setVisible(false);
                        
                    }
                    
                });
            
	} else {

	    try {

		ScriptResult[] sr = rlm.getScriptBroker().
		    executeScript(new ScriptObject(Scripting.
						   SWALLOW_REQUEST, 
						   this));
		contentPane = (Container) sr[0].getUserObject();

	    } catch (UnknownMessageException e) {

		e.printStackTrace();

	    }

	}

	Font guiFont = (Font) Main.rlo.getProperty("Font.gui");

	toolBar = new UserToolBar(rlm, null) {

                public void actionPerformed(ActionEvent e) {

                    User user = (User) list.getSelectedValue();
                    
                    if(user != null) {
                        
                        this.user = user;
                        super.actionPerformed(e);

                    }

                }

            };

        JToolBar toolbarRight = new JToolBar();
	createAccount = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.NEWUSER_ICON]));
	openAccount = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.OPENUSER_ICON]));
	listModel = rlm.getUserListModel();
	list = new JList(listModel);

	GridBagLayout gbl = new GridBagLayout();
    	GridBagConstraints gbc = new GridBagConstraints();
	JPanel p2 = new JPanel();
	joinLeave = 
	    new JCheckBox("Show join/leave in chat", 
			  Main.rlo.getBooleanProperty("Toggle.JoinLeave"));
	
	createAccount.setFont(guiFont);
	openAccount.setFont(guiFont);
	joinLeave.setFont(guiFont);
        createAccount.setToolTipText("Create account");
        openAccount.setToolTipText("Edit account");
        joinLeave.setActionCommand("ActivateJoinLeave");
        createAccount.setActionCommand("ActivateNewuser");
        openAccount.setActionCommand("ActivateOpenuser");
	list.setBackground(rlm.getSchemeColor("background"));
	list.setForeground(rlm.getSchemeColor("foreground"));
	list.setCellRenderer(new UserCellRenderer((Font) Main.rlo.getProperty("Font.list")));
	
	list.addMouseListener(new MouseAdapter() {
                
                public void mouseClicked(MouseEvent e) {
                    
                    if(e.getClickCount() == 2) {
                        
                        User user = (User) list.getSelectedValue();
                        
                        if(user != null)
                            new MessageTransmit(rlm, user);
                        
                    }
                    
                }
                
            });

	list.addListSelectionListener(new ListSelectionListener() {

                public void valueChanged(ListSelectionEvent e) {
                    
                    if(!e.getValueIsAdjusting())
                        updateButtonStates();

                }

            });

	list.setFont((Font) Main.rlo.getProperty("Font.list"));
        createAccount.addActionListener(this);
        openAccount.addActionListener(this);
	joinLeave.addActionListener(this);

	contentPane.setLayout(gbl);

        toolBar.reload.setVisible(false);
        toolbarRight.setFloatable(false);
        toolbarRight.add(openAccount);
        toolbarRight.add(createAccount);
        
	gbc.gridx = GridBagConstraints.RELATIVE;
	gbc.gridy = GridBagConstraints.RELATIVE;
	gbc.fill = GridBagConstraints.NONE;
	gbc.anchor = GridBagConstraints.WEST;
	contentPane.add(toolBar, gbc);
        gbc.anchor = gbc.EAST;
        gbc.weightx = 1;
        contentPane.add(toolbarRight, gbc);
	gbc.gridx = 0;
	gbc.fill = GridBagConstraints.BOTH;
	gbc.weightx = 0; 
        gbc.weighty = 1;
	gbc.ipady = 50;
	gbc.gridwidth = 2;
	gbc.insets = new Insets(4, 4, 1, 4);
        gbc.anchor = gbc.NORTHEAST;
	contentPane.add(new JScrollPane(list), gbc);
	
	p2.setLayout(new GridBagLayout());
	GridBagConstraints gbc2 = new GridBagConstraints();
	gbc2.anchor = GridBagConstraints.WEST;
	gbc2.insets = new Insets(0, 8, 4, 0);
	p2.add(joinLeave, gbc2);

	gbc.anchor = gbc.WEST;
	gbc.ipady = 0;
	gbc.gridx = 0; gbc.gridy = GridBagConstraints.RELATIVE;
	gbc.fill = GridBagConstraints.NONE;
	gbc.weightx = 1; gbc.weighty = 0;
	contentPane.add(p2, gbc);

	if(swallow == false) {

	    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
	    Dimension w = f.getSize();
		
	    synchronized(lock) {
		if(x == 0) {
		    x = (d.width / 100) * 60;
		    y = (d.height / 100) * 2;
		}

		f.setLocation(x, y);
		x += w.width + 16; 
		
		if(x > d.width - w.width) { 
		    x = (d.width / 100) * 60; 
		    y += w.height; 
		}

		if(y > ((d.height / 100) * 60) - w.height) { 
		    y = (d.height / 100) * 20; 
		    x += w.width / 2; 
		}
	    }

	    f.pack();
	    f.show();

	}

	rlm.getHLC().addHLClientListener(new HLClientAdapter() {

                public void handleUserLeave(int sock) {
                    
                    updateButtonStates();
                    
                }
                
            });

        list.setSelectedIndex(0);
		
    }

    void updateButtonStates() {

	boolean state = list.getSelectedIndex() == -1 ? false : true;
	setButtonStates(state);

    }

    void setButtonStates(boolean state) {

	toolBar.priv.setEnabled(state);
	toolBar.info.setEnabled(state);
	toolBar.kick.setEnabled(state);
	toolBar.msg.setEnabled(state);

    }

    public void show() {

	if(swallow == false)
	    f.show();
        
        list.requestFocus();

    }

    ScriptResult processStateChange(StateObject state) {

	if(state.isPublicState()) {

	    switch(state.what) {
		
	    case StateObject.SHOW_JOIN_LEAVE:
		joinLeave.setSelected(rlm.isShowJoinLeaveEnabled());
                
	    }
	    
	}
        
	return new ScriptResult(this, null);

    }
    
    /**
     * Following method implements ActionListener.
     */
    public void actionPerformed(ActionEvent e) {

        if(e.getActionCommand().equals("ActivateNewuser")) {
            
            HLProtocol hlp = new HLProtocol();
            HLProtocol.AccountInfo account = hlp.new AccountInfo();
            new UserEditInterface(rlm, account, true);
            
        } else if(e.getActionCommand().equals("ActivateOpenuser")) {
            
            new UserOpenInterface(rlm);
            
        } if(e.getActionCommand().equals("ActivateJoinLeave")) {
            
            rlm.setState(StateObject.SHOW_JOIN_LEAVE,
                         new Boolean(joinLeave.isSelected()));
            
        }

    }

    /**
     * Following methods implement Child.
     */
    public void close() {

	if(swallow == false) {

	    f.setVisible(false);
	    f.dispose();

	} else {

	    try {
		rlm.getScriptBroker().
		    executeScript(new ScriptObject(Scripting.UNSWALLOW_REQUEST,
						   contentPane));
	    } catch (UnknownMessageException e) {
	    }

	}

	rlm.getScriptBroker().removeTarget(this);

    }
    
    public void displayPropertyChanged(String what, final Object property) {

	if(what.equals("listfont")) {

            SwingUtilities.invokeLater(new Runnable() {

                    public void run() {

                        list.setFont((Font) property);
                        list.repaint();

                    }

                });

	} else {

            SwingUtilities.invokeLater(new Runnable() {

                    public void run() {

                        list.setForeground(rlm.getSchemeColor("foreground"));
                        list.setBackground(rlm.getSchemeColor("background"));
                                                
                    }
                    
                });

	}

	contentPane.repaint();

    }

    /**
     * Following methods implement Scriptable.
     */

    public void gotTarget(ScriptBroker sb) {}
    public void lostTarget(ScriptBroker sb) {}
    public long getKnownMessages() {

	return Scripting.CLOSE_WINDOW |
	    Scripting.STATE_CHANGED;

    }
    
    public ScriptResult executeScript(ScriptObject s) 
	throws UnknownMessageException {

	int value = (int) s.getType();

	switch(value) {

	case Scripting.CLOSE_WINDOW:
            if(s.getUserObject() instanceof Container) {
                if((Container) s.getUserObject() == contentPane) {
                    //		closeUnregister();
                    return new ScriptResult(this, null);
                }
            }
	case Scripting.STATE_CHANGED:
            if(s.getUserObject() instanceof StateObject) {
                StateObject state = (StateObject) s.getUserObject();
                return processStateChange(state);
            }
	}

	throw new UnknownMessageException();

    }

}







