/**
 * $Id: ViewHTMLInterface.java,v 1.2 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.io.IOException;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import java.io.*;

import redlight.hotline.*;
import redlight.utils.TextUtils;
import redlight.utils.DebuggerOutput;

/**
 * This class displays a piece of text as it arrives on a
 * PipedInputStream.
 */
public class ViewHTMLInterface extends AbstractViewInterface
    implements Runnable {

    JScrollPane scrollPane;
    JEditorPane text;
    StringBuffer content = new StringBuffer();
    
    ViewHTMLInterface(Machine machine, 
                      TransferInterface transferInterface,
                      String filename,
                      long total,
                      PipedInputStream inputPipe) {
        
	super(machine, transferInterface, "HTML" ,filename, total, inputPipe);
        
	text = new JEditorPane("text/html", "<b>Please wait ...</b>");
        scrollPane = new JScrollPane(text);

	text.setBackground(machine.getSchemeColor("background"));
	text.setForeground(machine.getSchemeColor("foreground"));
	text.setEditable(false);
	text.setFont((Font) Main.rlo.getProperty("Font.text"));
        text.setContentType("text/html");
        text.addHyperlinkListener(new URLHandler(rlm, 
                                                 transferInterface.path, 
                                                 transferInterface.file));
        contentPane.setLayout(new BorderLayout());

        contentPane.add(scrollPane, BorderLayout.CENTER);

        f.pack();
        show();

        f.setSize(300, 300);

	new Thread(this).start();

    }

    public void setContent(Machine rlm,
                           TransferInterface transferInterface, 
                           String type,
                           String filename,
                           long total,
                           PipedInputStream inputPipe) {

        super.setContent(rlm, 
                         transferInterface, 
                         type, 
                         filename,
                         total,
                         inputPipe);

        if(text != null)
            new Thread(this).start();

    }


    public void closeWindow() {

        super.closeWindow();
        scrollPane.setViewportView(null);
        content = null;
        text.setText("");
        text = null;
        scrollPane = null;

    }

    /**
     * Just try and keep up with the stream ...
     */
    public synchronized void run() {

        LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(inputPipe));
        content.setLength(0);

        try {
            
            for(String line = lineReader.readLine(); 
                line != null; 
                line = lineReader.readLine())
                content.append(line + "\n");

        } catch(IOException e) {
            
            DebuggerOutput.stackTrace(e);
            
        }

        SwingUtilities.invokeLater(new Runnable() {

                public void run() {

                    text.setText(content.toString());

                }

            });

        DebuggerOutput.debug("ViewHTMLInterface.slurper: exiting");

    }

}
