/**
 * $Id: WindowBroker.java,v 1.1.1.1 2001/07/22 02:44:36 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.awt.*;
import java.awt.event.*;

import java.util.Hashtable;
import java.util.Vector;

import javax.swing.*;
import javax.swing.event.*;

import redlight.hotline.*;
import redlight.utils.DebuggerOutput;
import redlight.script.*;


public class WindowBroker {
    int policy;
    Hashtable windows;

    public WindowBroker() {
	windows = new Hashtable();
    }

    public class WindowAppearance {
	public Point topLeft;
	public Dimension size;
	WindowAppearance() {
	    topLeft = new Point(0, 0);
	    size = new Dimension(0, 0);
	}
    }

    public void setWindowPosition(String which, Point p) {
	if(!windows.containsKey(which))
	    windows.put(which, new WindowAppearance());
	((WindowAppearance) windows.get(which)).topLeft = p;
    }
    public void setWindowLocation(String which, Dimension s) {
	if(!windows.containsKey(which))
	    windows.put(which, new WindowAppearance());
	((WindowAppearance) windows.get(which)).size = s;
    }

    public Point getWindowPosition(String which) {
	if(windows.containsKey(which))
	    return ((WindowAppearance) windows.get(which)).topLeft;
	else
	    return null;
	
    }

    public Dimension getWindowDimension(String which) {
	if(windows.containsKey(which))
	    return ((WindowAppearance) windows.get(which)).size;
	else
	    return null;
	
    }

    public void setBrokerPolicy(int pol) {
	policy = pol;
    }
}










