/**
<<<<<<< MacBinaryMacFile.java
 * $Id: MacBinaryMacFile.java,v 1.1.1.1 2001/07/22 02:44:48 groomed Exp $
=======
 * $Id: MacBinaryMacFile.java,v 1.1.1.1 2001/07/22 02:44:48 groomed Exp $
>>>>>>> 1.1.1.1
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.macfiles;

import java.io.*;
import java.util.Calendar;

import redlight.utils.ToArrayConverters;
import redlight.utils.Meter;
import redlight.utils.MeterSource;
import redlight.utils.DebuggerOutput;

/**
 * A MacBinaryMacFile provides a mechanism to store a 
 * Macintosh file as a MacBinary file.
 * A MacBinaryMacFile creates a file with the extension ".bin".
 */
public class MacBinaryMacFile extends MacFile {
    byte[] macBinaryHeader;
    RandomAccessFile raf;

    /**
     * Constructs a MacBinaryMacFile. This creates a file
     * called f.getName() + ".bin", if it didn't already exist.
     * @param f the filename
     */
    public MacBinaryMacFile(File f, Integer p) throws IOException {
	super(new File(f.getParent(), f.getName() + ".bin"), p);
        String perms = new String();
        DebuggerOutput.debug("MacBinaryMacFile: p = "+p.toString());
        if((p.intValue() & MacFile.READ_PERM) == MacFile.READ_PERM)
            perms = "r";
        if((p.intValue() & MacFile.WRITE_PERM) == MacFile.WRITE_PERM)
            perms += "w";
	raf = new RandomAccessFile(getFile(), perms);
	resourceFork = new MacBinaryResourceFork(this);
	dataFork = new MacBinaryDataFork(this);
	macBinaryHeader = new byte[128];
	if(raf.length() > 128) 
	    readHeader();
    }

    /**
     * Reads a MacBinary header.
     */
    public void readHeader() throws IOException {
	raf.readFully(macBinaryHeader, 0, 128);
	byte[] r = new byte[4], d = new byte[4];
	System.arraycopy(macBinaryHeader, 83, d, 0, 4);
	System.arraycopy(macBinaryHeader, 87, r, 0, 4);
	setDataSize(ToArrayConverters.byteArrayToInt(d));
	setResourceSize(ToArrayConverters.byteArrayToInt(r));
	DebuggerOutput.debug("MacBinaryMacFile: header read (data size = "+getDataSize()+", rsrc size = "+getResourceSize()+")");
    }

    /**
     * Stores type and creator in the MacBinary file header.
     */
    public void writeHeader(String name, 
			    String type, 
			    String creator,
			    String comments, 
			    Calendar created, 
			    Calendar modifed, 
			    int finderFlags) throws IOException {
	byte[] header = macBinaryHeader;
	DataOutput dos = raf;
	try {
	    
	    header[0] = 0; // macbinary version
	    header[1] = (byte) name.length();
	    System.arraycopy(name.getBytes(), 0, header, 2, name.length());
	    System.arraycopy(type.getBytes(), 0, header, 65, type.length());
	    System.arraycopy(creator.getBytes(), 0, header, 69, creator.length());
	    byte[] b = ToArrayConverters.intToByteArray((int) getDataSize());
	    System.arraycopy(b, 0, header, 83, b.length);
	    b = ToArrayConverters.intToByteArray((int) getResourceSize());
	    System.arraycopy(b, 0, header, 87, b.length);
	    int mac_date = (int)System.currentTimeMillis();// + kTimeOffset;
	    b = ToArrayConverters.intToByteArray(mac_date);
	    System.arraycopy(b, 0, header, 91, 4);
	    System.arraycopy(b, 0, header, 95, 4);
	    dos.write(header);
	} catch(IOException e) {
	    e.printStackTrace();
	    throw e;
	}		
	
    }
   
    /**
     * Re-writes the size of the data fork and the resource
     * fork into the MacBinary header.
     */
    public void cleanup() throws IOException {
	RandomAccessFile dos = (RandomAccessFile) getDataFork().getDataOutput();
	dos.seek(83);
	DebuggerOutput.debug("MacBinaryMacFile: cleaning up (data size = "+getDataSize()+", rsrc size = "+getResourceSize()+")");
	byte[] b = ToArrayConverters.intToByteArray((int) getDataSize());
	dos.write(b, 0, b.length);
	b = ToArrayConverters.intToByteArray((int) getResourceSize());
	dos.write(b, 0, b.length);
    }

    RandomAccessFile getRandomAccessFile() {
	return raf;
    }
    
    public void close() throws IOException {
	raf.close();
	DebuggerOutput.debug("MacBinaryMacFile: output file closed");
    }

    public boolean exists() {
	try {
	DebuggerOutput.debug("MacBinaryMacFile: exists (raf.length() == "+raf.length());
	    return raf.length() > 0 ? true : false;
	} catch (IOException e) {
	}
	return false;
    }

    public boolean delete() {
	boolean s = false;
	try {
	raf.close();
	s = getFile().delete();
	raf = new RandomAccessFile(getFile(), "rw");
	macBinaryHeader = new byte[128];
	setDataSize(0);
	setResourceSize(0);
	} catch (IOException e) {
	}
	return s;
    }

    /**
     * NOT IMPLEMENTED in MacBinaryMacFile
     * @return false 
     */
    public boolean renameTo(File f) {
        
        return getFile().renameTo(new File(f.toString() + ".bin"));

    }

}








