import java.io.*;

public final class minicacheobject{

public  String name;      /* real! */
public  String localname;
public  String location; /* for redirects */

public  int httprc;
public  long date;
public  String ctype;
public  String enc;



minicacheobject(DataInputStream is, byte version) throws IOException
{
 name=is.readUTF();
 ctype=is.readUTF();
 localname=is.readUTF();
 location=is.readUTF();
 if(location.length()==0) location=null;
 is.readInt(); // size
 httprc=is.readInt(); // http return code
 is.readLong(); // expires
 date=is.readLong(); // date
 is.readLong(); // lastmod
 is.readLong(); // lru
 switch(version)
 {
     case 4:
         is.readUTF();
     case 3:
         enc=is.readUTF();
         if(enc.length()==0) enc=null;
         is.readBoolean();
         break;
     default:
    	 throw new IllegalArgumentException("Unsupported serialized object version: "+version);
 }
}


final public boolean equals(Object o)
{
 if(o==null || ! (o instanceof minicacheobject)) return false;
 minicacheobject o1=(minicacheobject)o;

 return name.equals(o1.name);
}

final public int hashCode()
{
 return name.hashCode();
}

} /* class */
