/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import xnap.XNap;
import xnap.gui.OptionsBox;
import xnap.gui.SearchPanel;
import xnap.gui.event.DoubleClickListener;
import xnap.gui.event.KeyAction;
import xnap.gui.event.PopupListener;
import xnap.gui.event.ShowAction;
import xnap.gui.table.SearchTableModel;
import xnap.net.SearchResultContainer;
import xnap.util.Debug;
import xnap.util.FilenameGrouper;
import xnap.util.FilesizeGrouper;
import xnap.util.Grouper;
import xnap.util.ISearchContainer;
import xnap.util.Preferences;
import xnap.util.SearchFilter;
import xnap.util.SearchFilterHelper;
import xnap.util.SearchManager;
import xnap.util.SearchResultCollector;
import xnap.util.event.StatusListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SearchSubPanel
extends JPanel
implements PropertyChangeListener,
StatusListener,
TableModelListener {
    protected SearchPanel parent;
    private JPanel jpOptions;
    private JTextField jtFilter;
    protected OptionsBox opBox;
    private JComboBox jcbGrouper;
    private JComboBox jcbMediaType;
    protected JTable jta;
    protected SearchTableModel stm;
    protected JScrollPane jspSearch;
    private JCheckBox jcbMaintainSortOrder;
    private JPanel jpa;
    private JLabel jlMyStatus;
    protected SearchFilter originalFilter;
    protected String title;
    protected ISearchContainer sc;
    protected SearchResultCollector srCollector;
    private Preferences prefs;

    protected void initialize() {
        this.initialize(true);
    }

    protected void initialize(boolean bl) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Box box = new Box(0);
        box.add(new JLabel(XNap.tr("Filter", 0, 1)));
        this.jtFilter = new JTextField("", 20);
        box.add(this.jtFilter);
        box.add(new JLabel(XNap.tr("Group by", 1)));
        this.jcbGrouper = new JComboBox<String>(new String[]{"", "Filesize"});
        this.jcbGrouper.setSelectedIndex(1);
        box.add(this.jcbGrouper);
        this.opBox = new OptionsBox(0);
        Box box2 = Box.createHorizontalBox();
        ApplyOptionsAction applyOptionsAction = new ApplyOptionsAction();
        KeyAction keyAction = new KeyAction(applyOptionsAction, keyStroke, this.jtFilter);
        keyAction = new KeyAction(applyOptionsAction, keyStroke, this.opBox.getFilesizeTextField());
        box2.add(new JLabel(XNap.tr("Media Type", 0, 1)));
        this.jcbMediaType = new JComboBox<Object>(SearchFilter.media);
        box2.add(this.jcbMediaType);
        box2.add(new JPanel());
        box2.add(new JButton(applyOptionsAction));
        box2.add(new JButton(new ResetOptionsAction()));
        this.jpOptions = new FocusHandlingJPanel(this.jtFilter);
        BoxLayout boxLayout = new BoxLayout(this.jpOptions, 1);
        this.jpOptions.setLayout(boxLayout);
        this.jpOptions.setBorder(new TitledBorder(XNap.tr("Options", 1)));
        this.jpOptions.add(box);
        this.jpOptions.add(this.opBox);
        this.jpOptions.add(box2);
        this.jpOptions.setVisible(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.jlMyStatus = new JLabel("");
        jPanel.add((Component)this.jlMyStatus, "Center");
        JPanel jPanel2 = new JPanel();
        this.jcbMaintainSortOrder = new JCheckBox(new ToggleSortOrderAction());
        this.jcbMaintainSortOrder.setSelected(this.prefs.getTableMaintainSortOrder(this.getTableModelName()));
        jPanel2.add((Component)this.jcbMaintainSortOrder, "Center");
        JButton jButton = new JButton(new ShowAction(this, this.jpOptions));
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(2, 2, 2, 2));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)this.jpOptions, "Center");
        this.stm = this.createTableModel();
        this.jta = this.stm.createJTable();
        this.jta.setShowGrid(false);
        this.stm.addTableModelListener(this);
        PopupListener popupListener = new PopupListener(this.parent.getPopupMenu());
        this.jta.addMouseListener(popupListener);
        DoubleClickListener doubleClickListener = new DoubleClickListener(this.parent.getDefaultAction(), this.jta);
        this.jta.addMouseListener(doubleClickListener);
        this.jta.getInputMap().put(keyStroke, this.parent.getDefaultAction());
        this.jta.getActionMap().put(this.parent.getDefaultAction(), this.parent.getDefaultAction());
        this.jspSearch = new JScrollPane(this.jta);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel3, "North");
        if (bl) {
            this.add((Component)this.jspSearch, "Center");
        }
    }

    public void abort() {
        if (this.sc != null) {
            this.sc.abort();
        }
    }

    public SearchResultCollector getSearchResultCollector() {
        return this.srCollector;
    }

    public SearchResultContainer getSelectedResult() {
        int n = this.jta.getSelectedRow();
        if (n != -1) {
            return this.stm.get(n);
        }
        return null;
    }

    public SearchResultContainer[] getSelectedResults() {
        int[] nArray = this.jta.getSelectedRows();
        SearchResultContainer[] searchResultContainerArray = new SearchResultContainer[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            searchResultContainerArray[n] = this.stm.get(nArray[n]);
            ++n;
        }
        return searchResultContainerArray;
    }

    public boolean isAutoDownloadable() {
        boolean bl = false;
        if (this.originalFilter != null) {
            bl = true;
        }
        return bl;
    }

    public void applyFilter(SearchFilter searchFilter) {
        this.srCollector.setFilter(searchFilter);
    }

    public void applyFilter() {
        this.applyFilter(this.getFilter());
    }

    public SearchFilter getFilter() {
        SearchFilter searchFilter = new SearchFilter(this.jtFilter.getText(), this.opBox.getBitrateCompare(), this.opBox.getBitrate(), this.opBox.getFilesizeCompare(), this.opBox.getFilesize(), this.jcbMediaType.getSelectedIndex());
        SearchFilter searchFilter2 = this.srCollector.getFilter();
        if (searchFilter2 != null) {
            searchFilter.setPath(searchFilter2.getPath());
        }
        return searchFilter;
    }

    private final void setFilter(SearchFilter searchFilter) {
        this.jtFilter.setText(searchFilter.getSearchText());
        this.opBox.setBitrateCompare(searchFilter.getBitrateCompare());
        this.opBox.setBitrate(SearchFilterHelper.getIndexFromBitrate(searchFilter.getBitrate()));
        this.opBox.setFilesizeCompare(searchFilter.getFilesizeCompare());
        this.opBox.setFilesize(searchFilter.getFilesize());
        this.jcbMediaType.setSelectedIndex(searchFilter.getMediaType());
        this.applyFilter();
    }

    public SearchFilter getOriginalFilter() {
        return this.originalFilter;
    }

    public Grouper getGrouper() {
        if (this.jcbGrouper.getSelectedItem().equals("Filename")) {
            return new FilenameGrouper();
        }
        if (this.jcbGrouper.getSelectedItem().equals("Filesize")) {
            return new FilesizeGrouper();
        }
        return new Grouper();
    }

    public void setStatus(String string) {
        this.jlMyStatus.setText(string);
        this.jlMyStatus.setToolTipText(string);
        this.parent.updateActions();
    }

    public String getTitle() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.title);
        if (this.srCollector.getData().size() > 0) {
            stringBuffer.append(" (");
            stringBuffer.append(this.stm.getRowCount());
            if (this.stm.getRowCount() != this.srCollector.getGroupedData().size()) {
                stringBuffer.append("/");
                stringBuffer.append(this.srCollector.getGroupedData().size());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    protected SearchTableModel createTableModel() {
        return new SearchTableModel();
    }

    protected String getTableModelName() {
        return "search";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.jcbMaintainSortOrder.setSelected(this.prefs.getTableMaintainSortOrder(this.getTableModelName()));
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateTitle();
    }

    protected void updateTitle() {
        this.parent.setTitle(this, this.getTitle());
    }

    public void removeNotify() {
        Debug.log("SearchSubPanel: removed");
        this.abort();
        super.removeNotify();
        SearchManager.getInstance().remove(this.sc);
    }

    private final /* synthetic */ void this() {
        this.prefs = Preferences.getInstance();
    }

    public SearchSubPanel(SearchPanel searchPanel, ISearchContainer iSearchContainer) {
        this.this();
        this.parent = searchPanel;
        this.sc = iSearchContainer;
        this.originalFilter = iSearchContainer.getFilter();
        this.title = this.originalFilter != null ? this.originalFilter.getSearchText() : iSearchContainer.toString();
        this.srCollector = new SearchResultCollector(iSearchContainer.getDefaultGrouper());
        this.initialize();
        this.stm.setFilteredData(this.srCollector.getGroupedData());
        iSearchContainer.setCollector(this.srCollector);
        iSearchContainer.setStatusListener(this);
        if (iSearchContainer.getFilter() != null && this.prefs.getFilterResults()) {
            this.setFilter(iSearchContainer.getFilter());
        }
        iSearchContainer.start();
        this.prefs.addPropertyChangeListener(this.getTableModelName() + "TableMaintainSortOrder", this);
    }

    private class ResetOptionsAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SearchSubPanel.this.jtFilter.setText("");
            SearchSubPanel.this.opBox.setBitrateCompare(0);
            SearchSubPanel.this.opBox.setFilesizeCompare(0);
            SearchSubPanel.this.jcbMediaType.setSelectedIndex(0);
            SearchSubPanel.this.applyFilter();
        }

        public ResetOptionsAction() {
            this.putValue("Name", XNap.tr("Reset"));
            this.putValue("ShortDescription", XNap.tr("Show all search results"));
            this.putValue("MnemonicKey", new Integer(82));
        }
    }

    private class ApplyOptionsAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SearchSubPanel.this.applyFilter();
            SearchSubPanel.this.srCollector.setGrouper(SearchSubPanel.this.getGrouper());
        }

        public ApplyOptionsAction() {
            this.putValue("Name", XNap.tr("Apply"));
            this.putValue("ShortDescription", XNap.tr("Filter search results"));
            this.putValue("MnemonicKey", new Integer(65));
        }
    }

    private class ToggleSortOrderAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SearchSubPanel.this.prefs.setTableMaintainSortOrder(SearchSubPanel.this.getTableModelName(), SearchSubPanel.this.jcbMaintainSortOrder.isSelected());
        }

        public ToggleSortOrderAction() {
            this.putValue("Name", XNap.tr("Maintain Sort Order"));
            this.putValue("ShortDescription", XNap.tr("If enabled, the sort order will be maintained as newitems are added to the table."));
            this.putValue("MnemonicKey", new Integer(84));
        }
    }

    private class FocusHandlingJPanel
    extends JPanel {
        private JComponent focusComponent;

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (bl) {
                this.focusComponent.grabFocus();
            }
        }

        public FocusHandlingJPanel(JComponent jComponent) {
            this.focusComponent = jComponent;
        }
    }
}

