/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.cmdl.AbstractCommand;
import xnap.cmdl.CommandLineSupport;
import xnap.cmdl.Console;
import xnap.cmdl.Executer;
import xnap.gui.AboutDialog;
import xnap.gui.ChatPanel;
import xnap.gui.ConsoleDialog;
import xnap.gui.Dialogs;
import xnap.gui.EditableComboBox;
import xnap.gui.FeedbackDialog;
import xnap.gui.GUINotifier;
import xnap.gui.HTMLDialog;
import xnap.gui.HotlistPanel;
import xnap.gui.LibraryPanel;
import xnap.gui.PluginDialog;
import xnap.gui.PreferencesDialog;
import xnap.gui.SearchPanel;
import xnap.gui.SplashWindow;
import xnap.gui.StartupWizardDialog;
import xnap.gui.StatusPanel;
import xnap.gui.ThemeManager;
import xnap.gui.ToggableIconPane;
import xnap.gui.TransferPanel;
import xnap.gui.UpdateDialog;
import xnap.gui.action.ActionHelper;
import xnap.gui.action.ActionSupport;
import xnap.gui.table.BrowseTableModel;
import xnap.gui.table.SearchTableModel;
import xnap.gui.table.UserTableModel;
import xnap.gui.util.GUIHelper;
import xnap.io.Repository;
import xnap.plugin.GUIPluginManager;
import xnap.plugin.IGUIPlugin;
import xnap.plugin.IPlugin;
import xnap.plugin.IViewerPlugin;
import xnap.plugin.PluginManager;
import xnap.user.UserManager;
import xnap.util.DownloadQueue;
import xnap.util.FileHelper;
import xnap.util.Preferences;
import xnap.util.Updater;
import xnap.util.UploadQueue;
import xnap.util.event.StateEvent;
import xnap.util.event.StateListener;
import xnap.util.event.StatusListener;
import ziga.gui.WindowsDesktopIndicator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XNapFrame
extends JFrame
implements ActionListener,
ChangeListener,
PropertyChangeListener,
StateListener,
CommandLineSupport,
StatusListener {
    public static final int PLUGIN_MENU_INDEX = 2;
    public static final int PLUGIN_STATUS_PANEL_INDEX = 0;
    public static final String CMD_HISTORY_FILENAME = FileHelper.getHomeDir() + "cmd_history";
    private static Logger logger;
    private static XNapFrame singleton;
    private static Preferences prefs;
    private static int focusExceptions;
    private AbstractCommand[] commands;
    private EditableComboBox ecbCmdl;
    private JToolBar jtbMain;
    private JToolBar jtbCmdl;
    private JMenuBar jmenubar;
    private int tbCount;
    private ToggableIconPane pane;
    private ChatPanel apChat;
    private HotlistPanel apHotlist;
    private LibraryPanel libraryPanel;
    private SearchPanel searchPanel;
    private StatusPanel statusPanel;
    private TransferPanel transferPanel;
    private Hashtable pluginStateMenuItemByPlugin;
    private Hashtable pluginMenuByPlugin;
    private JCheckBoxMenuItem jmiUseTabbedPane;
    private JCheckBoxMenuItem jmiUseTabbedTransferPane;
    private JCheckBoxMenuItem jmiChatAway;
    private JPanel jpStatus;
    private JMenu viewMenu;
    private ViewActionListener viewListener;
    private Hashtable viewMap;
    private PreferencesAction acPreferences;
    private ShowToolbarAction acShowCmdlToolbar;
    private ShowToolbarAction acShowMainToolbar;
    private WindowsDesktopIndicator wdi;
    public int chatIndex;
    static /* synthetic */ Class class$xnap$gui$XNapFrame;

    private final void initialize() {
        this.setDefaultCloseOperation(0);
        SplashWindow.setText(XNap.tr("Setting up Look & Feel"));
        SplashWindow.setProgress(15);
        ThemeManager.installLookAndFeels();
        this.updateLookAndFeel();
        SplashWindow.setText(XNap.tr("Setting up Gui"));
        SplashWindow.setProgress(20);
        this.initializeToolbars();
        this.initializePanels();
        SplashWindow.setText(XNap.tr("Setting up Menus"));
        SplashWindow.setProgress(50);
        this.initializeMenu();
        SplashWindow.setText(XNap.tr("Setting up Frame"));
        SplashWindow.setProgress(65);
        this.setTitle(XNap.tr("XNap - Java Filesharing Client"));
        ImageIcon imageIcon = XNapFrame.getSmallIcon("xnap.png");
        if (imageIcon != null) {
            this.setIconImage(imageIcon.getImage());
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.pane, "Center");
        jPanel.add((Component)this.jtbCmdl, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.statusPanel, "Center");
        jPanel2.add((Component)this.jpStatus, "East");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jtbMain, "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.pack();
        this.setBounds(prefs.getWindowX(), prefs.getWindowY(), prefs.getWindowWidth(), prefs.getWindowHeight());
        this.addWindowListener(new WindowListener());
        prefs.addPropertyChangeListener(this);
        Console.getInstance().setConsole(ConsoleDialog.getInstance());
        Executer.installHandler(this);
        GUINotifier.getGUIInstance().setStatusListener(this);
        if (prefs.getLastLaunchReleaseNr() == (long)-1) {
            SplashWindow.setText(XNap.tr("Loading Wizard"));
            StartupWizardDialog.showDialog(this, true);
        }
        SplashWindow.setProgress(95);
    }

    private final void initializeToolbars() {
        this.jtbMain = new JToolBar(XNap.tr("Show Main Toolbar"));
        this.jtbMain.add(this.acPreferences);
        this.jtbMain.addSeparator();
        this.jtbMain.add(ActionHelper.cutAction);
        this.jtbMain.add(ActionHelper.copyAction);
        this.jtbMain.add(ActionHelper.pasteAction);
        this.jtbMain.addSeparator();
        this.tbCount = this.jtbMain.getComponentCount();
        this.jtbCmdl = new JToolBar(XNap.tr("Show Command Line Toolbar"));
        this.jtbCmdl = new JToolBar(XNap.tr("Show Command Line"));
        this.jtbCmdl.add(new JLabel(XNap.tr("Command", 1)));
        CmdlAction cmdlAction = new CmdlAction();
        this.ecbCmdl = new EditableComboBox(cmdlAction);
        this.ecbCmdl.readHistoryFile(new File(CMD_HISTORY_FILENAME));
        this.jtbCmdl.add(this.ecbCmdl);
        this.jtbCmdl.add(new JButton(cmdlAction));
    }

    private final void initializePanels() {
        this.pane = new ToggableIconPane(prefs.getUseTabbedPane());
        this.pane.addChangeListener(this);
        SplashWindow.setProgress(25);
        this.searchPanel = new SearchPanel();
        this.searchPanel.setName("search");
        this.searchPanel.setStatusListener(this);
        this.pane.addTab(XNap.tr("Search"), XNapFrame.getBigIcon("find.png"), this.searchPanel);
        SplashWindow.setProgress(30);
        this.transferPanel = new TransferPanel();
        this.transferPanel.setName("transfer");
        this.transferPanel.addPropertyChangeListener(this);
        this.transferPanel.setStatusListener(this);
        this.pane.addTab(XNap.tr("Transfer"), XNapFrame.getBigIcon("connect.png"), this.transferPanel);
        SplashWindow.setText(XNap.tr("Setting up Library Panel"));
        SplashWindow.setProgress(35);
        this.apChat = new ChatPanel();
        this.apChat.setName("chat");
        this.apChat.setStatusListener(this);
        this.apChat.addChangeListener(this);
        this.pane.addTab(XNap.tr("Chat"), XNapFrame.getBigIcon("mail_generic.png"), this.apChat);
        this.chatIndex = this.pane.getTabCount() - 1;
        this.apHotlist = new HotlistPanel();
        this.apHotlist.setName("hotlist");
        this.apHotlist.setStatusListener(this);
        this.pane.addTab(XNap.tr("Hotlist"), XNapFrame.getBigIcon("kdmconfig.png"), this.apHotlist);
        this.libraryPanel = new LibraryPanel();
        this.libraryPanel.setName("library");
        this.libraryPanel.setStatusListener(this);
        this.pane.addTab(XNap.tr("Library"), XNapFrame.getBigIcon("contents.png"), this.libraryPanel);
        SplashWindow.setProgress(40);
        this.initializeStatusPanel();
        SplashWindow.setProgress(45);
    }

    private final void initializeStatusPanel() {
        this.statusPanel = new StatusPanel(10000);
        this.jpStatus = new JPanel();
        BoxLayout boxLayout = new BoxLayout(this.jpStatus, 0);
        this.jpStatus.setLayout(boxLayout);
        StatusPanel statusPanel = new StatusPanel(XNapFrame.getSmallIcon("down.png"));
        DownloadQueue.getInstance().setStatusListener(statusPanel);
        this.jpStatus.add(statusPanel);
        StatusPanel statusPanel2 = new StatusPanel(XNapFrame.getSmallIcon("up.png"));
        UploadQueue.getInstance().setStatusListener(statusPanel2);
        this.jpStatus.add(statusPanel2);
        StatusPanel statusPanel3 = new StatusPanel();
        Repository.getInstance().setStatusListener(statusPanel3);
        this.jpStatus.add(statusPanel3);
        if (Updater.isMacOSX()) {
            this.jpStatus.add(Box.createHorizontalStrut(15));
        }
    }

    private final void initializeMenu() {
        this.setJMenuBar(new JMenuBar());
        this.initializeFileMenu();
        this.initializeEditMenu();
        this.initializeViewMenu();
        this.initializePluginsMenu();
        this.initializeChatMenu();
        this.initializeSettingsMenu();
        this.initializeHelpMenu();
        if (!Updater.isMacOSX()) {
            GUIHelper.setMnemonics(this.getJMenuBar());
        }
    }

    private final void initializeFileMenu() {
        JMenu jMenu = new JMenu(XNap.tr("File"));
        JMenuItem jMenuItem = new JMenuItem(new UpdateRepositoryAction());
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(XNap.tr("Setup Wizard") + "...");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem(XNap.tr("Exit"));
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        this.getJMenuBar().add(jMenu);
    }

    private final void initializeEditMenu() {
        JMenu jMenu = new JMenu(XNap.tr("Edit"));
        JMenuItem jMenuItem = new JMenuItem(ActionHelper.cutAction);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(ActionHelper.copyAction);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(ActionHelper.pasteAction);
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem(new PurgeHistoryAction());
        jMenu.add(jMenuItem4);
        this.getJMenuBar().add(jMenu);
    }

    private final void initializeChatMenu() {
        JMenu jMenu = new JMenu(XNap.tr("Chat"));
        this.jmiChatAway = new JCheckBoxMenuItem(new ChatAwayAction());
        this.jmiChatAway.setSelected(prefs.getSendChatAwayMessage());
        jMenu.add(this.jmiChatAway);
        this.getJMenuBar().add(jMenu);
    }

    private final void initializePluginMenus() {
    }

    private final void initializePluginsMenu() {
        JMenu jMenu;
        IPlugin[] iPluginArray = PluginManager.getInstance().getPlugins();
        int n = 0;
        while (n < iPluginArray.length) {
            if (iPluginArray[n] instanceof IGUIPlugin && (jMenu = ((IGUIPlugin)iPluginArray[n]).getMenu()) != null) {
                jMenu.setEnabled(false);
                this.getJMenuBar().add(jMenu);
            }
            ++n;
        }
        JMenu jMenu2 = new JMenu(XNap.tr("Plugins"));
        jMenu = new JMenu(XNap.tr("Viewers"));
        jMenu2.add(jMenu);
        PluginActionListener pluginActionListener = new PluginActionListener();
        int n2 = 0;
        while (n2 < iPluginArray.length) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(iPluginArray[n2].getName());
            jCheckBoxMenuItem.setActionCommand(iPluginArray[n2].getClass().getName());
            jCheckBoxMenuItem.addActionListener(pluginActionListener);
            jCheckBoxMenuItem.setSelected(iPluginArray[n2].isEnabled());
            this.pluginStateMenuItemByPlugin.put(iPluginArray[n2], jCheckBoxMenuItem);
            if (iPluginArray[n2] instanceof IViewerPlugin) {
                jMenu.add(jCheckBoxMenuItem);
            } else {
                jMenu2.add((Component)jCheckBoxMenuItem, 0);
            }
            ++n2;
        }
        this.getJMenuBar().add(jMenu2);
    }

    private final void initializeViewMenu() {
        this.viewMenu = new JMenu(XNap.tr("View"));
        JMenuItem jMenuItem = new JMenuItem(XNap.tr("Search"));
        GUIHelper.setAccelerator(jMenuItem, 83);
        jMenuItem.addActionListener(this.viewListener);
        this.viewMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(XNap.tr("Transfer"));
        GUIHelper.setAccelerator(jMenuItem2, 84);
        jMenuItem2.addActionListener(this.viewListener);
        this.viewMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(XNap.tr("Chat"));
        jMenuItem3.addActionListener(this.viewListener);
        this.viewMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(XNap.tr("Hotlist"));
        jMenuItem4.addActionListener(this.viewListener);
        this.viewMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem(XNap.tr("Library"));
        GUIHelper.setAccelerator(jMenuItem5, 76);
        jMenuItem5.addActionListener(this.viewListener);
        this.viewMenu.add(jMenuItem5);
        this.viewMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem(XNap.tr("Console"));
        GUIHelper.setAccelerator(jMenuItem6, 87);
        jMenuItem6.addActionListener(this);
        this.viewMenu.add(jMenuItem6);
        this.getJMenuBar().add(this.viewMenu);
    }

    private final void initializeSettingsMenu() {
        JMenu jMenu = new JMenu(XNap.tr("Settings"));
        this.acShowMainToolbar = new ShowToolbarAction(this.jtbMain, prefs.getShowMainToolbar());
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.acShowMainToolbar);
        jCheckBoxMenuItem.setSelected(prefs.getShowMainToolbar());
        jMenu.add(jCheckBoxMenuItem);
        this.acShowCmdlToolbar = new ShowToolbarAction(this.jtbCmdl, prefs.getShowCmdlToolbar());
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(this.acShowCmdlToolbar);
        jCheckBoxMenuItem2.setSelected(prefs.getShowCmdlToolbar());
        jMenu.add(jCheckBoxMenuItem2);
        jMenu.addSeparator();
        this.jmiUseTabbedPane = new JCheckBoxMenuItem(new UseTabbedPaneAction());
        this.jmiUseTabbedPane.setSelected(prefs.getUseTabbedPane());
        jMenu.add(this.jmiUseTabbedPane);
        this.jmiUseTabbedTransferPane = new JCheckBoxMenuItem(new UseTabbedTransferPaneAction());
        this.jmiUseTabbedTransferPane.setSelected(prefs.getUseTabbedTransferPane());
        jMenu.add(this.jmiUseTabbedTransferPane);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu(XNap.tr("Visible Columns"));
        jMenu2.setIcon(XNapFrame.getSmallIcon("view_detailed.png"));
        SearchTableModel searchTableModel = new SearchTableModel();
        jMenu2.add(searchTableModel.createJMenu());
        searchTableModel = new BrowseTableModel();
        jMenu2.add(searchTableModel.createJMenu());
        jMenu2.add(this.libraryPanel.getTableMenu());
        jMenu2.add(this.transferPanel.getDownloadTableMenu());
        jMenu2.add(this.transferPanel.getUploadTableMenu());
        jMenu2.add(this.apChat.getChannelTableMenu());
        UserTableModel userTableModel = new UserTableModel("user");
        jMenu2.add(userTableModel.createJMenu());
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        JMenu jMenu3 = new JMenu(XNap.tr("Look & Feel"));
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = ThemeManager.getInstalledLookAndFeels();
        ButtonGroup buttonGroup = new ButtonGroup();
        LookAndFeelActionListener lookAndFeelActionListener = new LookAndFeelActionListener();
        String string = UIManager.getLookAndFeel().getClass().getName();
        int n = 0;
        while (n < lookAndFeelInfoArray.length) {
            String string2 = lookAndFeelInfoArray[n].getClassName();
            JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem(lookAndFeelInfoArray[n].getName());
            jCheckBoxMenuItem3.setActionCommand(lookAndFeelInfoArray[n].getClassName());
            jCheckBoxMenuItem3.addActionListener(lookAndFeelActionListener);
            if (string.equals(lookAndFeelInfoArray[n].getClassName())) {
                jCheckBoxMenuItem3.setSelected(true);
            }
            buttonGroup.add(jCheckBoxMenuItem3);
            jMenu3.add(jCheckBoxMenuItem3);
            ++n;
        }
        jMenu.add(jMenu3);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(new PreferencesAction());
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.getJMenuBar().add(jMenu);
    }

    private final void initializeHelpMenu() {
        JMenu jMenu = new JMenu(XNap.tr("Help"));
        JMenuItem jMenuItem = new JMenuItem(XNap.tr("Check For New Version") + "...");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(XNap.tr("Frequently Asked Questions") + "...");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(XNap.tr("Send Feedback") + "...");
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem(XNap.tr("About XNap") + "...");
        jMenuItem4.addActionListener(this);
        jMenu.add(jMenuItem4);
        this.getJMenuBar().add(jMenu);
    }

    public static XNapFrame getInstance() {
        return singleton;
    }

    public static final ImageIcon getImage(String string) {
        Preferences preferences = Preferences.getInstance();
        URL uRL = FileHelper.getResource("icons/" + string);
        if (uRL != null && preferences.getShowIcons()) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public static final ImageIcon getIcon(String string) {
        return XNapFrame.getImage("22/" + string);
    }

    public static final Icon getEmptyIcon() {
        return new EmptyIcon(22);
    }

    public static final ImageIcon getSmallIcon(String string) {
        return XNapFrame.getImage("16/" + string);
    }

    public static final Icon getSmallEmptyIcon() {
        return new EmptyIcon(16);
    }

    public static final ImageIcon getBigIcon(String string) {
        return XNapFrame.getImage("32/" + string);
    }

    public static final Icon getBigEmptyIcon() {
        return new EmptyIcon(32);
    }

    public static final void setNextFocusPolicy(boolean bl) {
        ++focusExceptions;
    }

    private static final boolean getFocusNextEvent() {
        if (focusExceptions > 0) {
            --focusExceptions;
            return prefs.getFocusOnAllEvents() ^ true;
        }
        return prefs.getFocusOnAllEvents();
    }

    public static final void setFocusTo(String string) {
        if (XNapFrame.getFocusNextEvent()) {
            XNapFrame.setFocusTo(XNapFrame.getInstance().pane, string);
        }
    }

    private static final void setFocusTo(Container container, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Component[] componentArray = container instanceof ToggableIconPane ? ((ToggableIconPane)container).getTabs() : container.getComponents();
            if (componentArray == null) {
                return;
            }
            int n = 0;
            while (n < componentArray.length) {
                if (string2.equals(componentArray[n].getName())) {
                    if (container instanceof ToggableIconPane) {
                        ((ToggableIconPane)container).setSelectedComponent(componentArray[n]);
                    } else if (container instanceof JTabbedPane) {
                        ((JTabbedPane)container).setSelectedComponent(componentArray[n]);
                    } else {
                        componentArray[n].requestFocus();
                    }
                    if (stringTokenizer.hasMoreTokens() && componentArray[n] instanceof Container) {
                        XNapFrame.setFocusTo((Container)componentArray[n], stringTokenizer.nextToken(""));
                    }
                    return;
                }
                ++n;
            }
        }
    }

    public AbstractCommand[] getCommands() {
        return this.commands;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() instanceof JMenuItem) {
            if (string.equals(XNap.tr("Exit"))) {
                this.doExit();
            } else if (string.equals(XNap.tr("Setup Wizard") + "...")) {
                StartupWizardDialog.showDialog(this, false);
            } else if (string.equals(XNap.tr("Console"))) {
                ConsoleDialog.showDialog(this);
            } else if (string.equals(XNap.tr("Send Feedback") + "...")) {
                FeedbackDialog.showDialog(this);
            } else if (string.equals(XNap.tr("About XNap") + "...")) {
                this.doShowAbout();
            } else if (string.equals(XNap.tr("Check For New Version") + "...")) {
                this.checkForUpdate(true);
            } else if (string.equals(XNap.tr("Frequently Asked Questions") + "...")) {
                this.statusPanel.setText(XNap.tr("Downloading FAQ") + "...");
                HTMLDialog.showDialog(this, XNap.tr("Frequently Asked Questions"), prefs.getFaqURL());
            }
        }
    }

    public void chatBlink() {
        if (this.pane.getSelectedComponent() != this.apChat) {
            this.pane.blink(this.chatIndex, XNapFrame.getBigIcon("penguin.png"));
        }
    }

    public void setEnabled(IPlugin iPlugin, boolean bl) {
        JMenuItem jMenuItem = (JMenuItem)this.pluginStateMenuItemByPlugin.get(iPlugin);
        if (jMenuItem != null) {
            jMenuItem.setSelected(bl);
        }
    }

    public void stateEnabled(StateEvent stateEvent) {
        if (stateEvent.getSource() instanceof IGUIPlugin) {
            JComponent jComponent;
            JComponent jComponent2;
            IGUIPlugin iGUIPlugin = (IGUIPlugin)stateEvent.getSource();
            JMenu jMenu = iGUIPlugin.getMenu();
            if (jMenu != null) {
                jMenu.setEnabled(true);
            }
            if ((jComponent2 = iGUIPlugin.getPanel()) != null) {
                if (jComponent2 instanceof JTabbedPane) {
                    ((JTabbedPane)jComponent2).addChangeListener(this);
                }
                jComponent = new JMenuItem(iGUIPlugin.getName());
                ((AbstractButton)jComponent).addActionListener(this.viewListener);
                this.viewMap.put(iGUIPlugin.getName(), jComponent);
                this.viewMenu.add((Component)jComponent, 2);
                GUIHelper.setMnemonics(this.viewMenu.getPopupMenu());
                this.pane.insertTab(iGUIPlugin.getName(), iGUIPlugin.getIcon(), jComponent2, "", 2);
                ++this.chatIndex;
            }
            if ((jComponent = iGUIPlugin.getStatusPanel()) != null) {
                this.jpStatus.add((Component)jComponent, 0);
            }
            iGUIPlugin.setStatusListener(this);
        }
        this.setEnabled((IPlugin)stateEvent.getSource(), true);
    }

    public void stateDisabled(StateEvent stateEvent) {
        if (stateEvent.getSource() instanceof IGUIPlugin) {
            JComponent jComponent;
            JComponent jComponent2;
            IGUIPlugin iGUIPlugin = (IGUIPlugin)stateEvent.getSource();
            JMenu jMenu = iGUIPlugin.getMenu();
            if (jMenu != null) {
                jMenu.setEnabled(false);
            }
            if ((jComponent2 = iGUIPlugin.getPanel()) != null) {
                if (jComponent2 instanceof JTabbedPane) {
                    ((JTabbedPane)jComponent2).removeChangeListener(this);
                }
                jComponent = (JMenuItem)this.viewMap.remove(iGUIPlugin.getName());
                this.viewMenu.remove((JMenuItem)jComponent);
                this.pane.remove(jComponent2);
                --this.chatIndex;
            }
            if ((jComponent = iGUIPlugin.getStatusPanel()) != null) {
                this.jpStatus.remove(jComponent);
            }
        }
        this.setEnabled((IPlugin)stateEvent.getSource(), false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getSource() == prefs && !string.equals("lookAndFeel")) {
            if (string.equals("useTabbedPane")) {
                this.jmiUseTabbedPane.setSelected(prefs.getUseTabbedPane());
            } else if (string.equals("useTabbedTransferPane")) {
                this.jmiUseTabbedTransferPane.setSelected(prefs.getUseTabbedTransferPane());
            } else if (string.equals("sendChatAwayMessage")) {
                this.jmiChatAway.setSelected(prefs.getSendChatAwayMessage());
            }
        }
    }

    private final void checkForUpdate(boolean bl) {
        if (bl || prefs.shouldCheckForUpdate(7)) {
            this.statusPanel.setText(XNap.tr("Checking for new version") + "...");
            UpdateDialog.showDialog(this, bl);
        }
    }

    public void doExit(boolean bl) {
        if (bl && !Dialogs.showCloseDialog(this)) {
            return;
        }
        prefs.setShowCmdlToolbar(this.acShowCmdlToolbar.isVisible());
        prefs.setShowMainToolbar(this.acShowMainToolbar.isVisible());
        this.ecbCmdl.writeHistoryFile(new File(CMD_HISTORY_FILENAME));
        this.searchPanel.savePrefs();
        this.transferPanel.savePrefs();
        this.apChat.savePrefs();
        this.apHotlist.savePrefs();
        this.libraryPanel.savePrefs();
        prefs.setWindowHeight(this.getBounds().getSize().height + prefs.getCorrectivePixels());
        prefs.setWindowWidth(this.getBounds().getSize().width);
        prefs.setWindowX(this.getBounds().getLocation().x);
        prefs.setWindowY(this.getBounds().getLocation().y);
        prefs.setEnabledGUIPlugins(GUIPluginManager.getInstance().disablePlugins());
        prefs.write();
        UserManager.getInstance().write();
        DownloadQueue.getInstance().stopAll();
        UploadQueue.getInstance().stopAll();
        this.dispose();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    public void doExit() {
        this.doExit(prefs.getShowCloseDialog());
    }

    public void doShowAbout() {
        AboutDialog.showDialog(this);
    }

    public void doShowPreferences() {
        PreferencesDialog.showDialog(this);
    }

    private final void updateLookAndFeel() {
        try {
            ThemeManager.setTheme(prefs.getTheme());
            UIManager.setLookAndFeel(prefs.getLookAndFeel());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setStatus(String string) {
        this.statusPanel.setText(string);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        AbstractAction[] abstractActionArray;
        Component component = this.pane.getSelectedComponent();
        while (this.jtbMain.getComponentCount() > this.tbCount) {
            this.jtbMain.remove(this.jtbMain.getComponentCount() - 1);
        }
        if (component instanceof JTabbedPane) {
            component = ((JTabbedPane)component).getSelectedComponent();
        } else if (component == this.apChat) {
            if (this.pane.getSelectedComponent() != this.apChat) {
                return;
            }
            component = this.apChat.getSelectedTab();
        }
        if (component instanceof ActionSupport && (abstractActionArray = ((ActionSupport)((Object)component)).getActions()) != null) {
            int n = 0;
            while (n < abstractActionArray.length) {
                if (abstractActionArray[n] != null) {
                    this.jtbMain.add(abstractActionArray[n]);
                } else {
                    this.jtbMain.addSeparator();
                }
                ++n;
            }
        }
        this.jtbMain.updateUI();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            GUINotifier.getGUIInstance().setGUIVisible(this, true);
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.commands = new AbstractCommand[]{new ExitCmd()};
        this.pluginStateMenuItemByPlugin = new Hashtable();
        this.pluginMenuByPlugin = new Hashtable();
        this.viewListener = new ViewActionListener();
        this.viewMap = new Hashtable();
        this.acPreferences = new PreferencesAction();
        this.chatIndex = 0;
    }

    public XNapFrame() {
        this.this();
        singleton = this;
        GUIPluginManager.getInstance();
        if (Updater.isZigaDllLoaded()) {
            this.wdi = new WindowsDesktopIndicator(this);
            this.wdi.load("xnap.ico", "XNap");
        }
        if (Updater.isMacOSX()) {
            try {
                Class<?> clazz = Class.forName("xnap.platform.macos.MacOSHandler");
                Method method = clazz.getMethod("register", null);
                method.invoke(null, null);
            }
            catch (Exception exception) {
                logger.warn("could not register mac os handler", exception);
            }
        }
        this.initialize();
        Updater.start();
        GUIPluginManager.getInstance().addStateListener(this);
        GUIPluginManager.getInstance().enablePlugins(prefs.getEnabledGUIPlugins());
        if (prefs.getAutoVersionCheck()) {
            this.checkForUpdate(false);
        }
    }

    static {
        Class clazz = class$xnap$gui$XNapFrame;
        if (clazz == null) {
            clazz = class$xnap$gui$XNapFrame = XNapFrame.class$("[Lxnap.gui.XNapFrame;", false);
        }
        logger = Logger.getLogger(clazz);
        singleton = null;
        prefs = Preferences.getInstance();
        focusExceptions = 0;
    }

    protected static class EmptyIcon
    implements Icon {
        private int size;

        public int getIconHeight() {
            return this.size;
        }

        public int getIconWidth() {
            return this.size;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public EmptyIcon(int n) {
            this.size = n;
        }
    }

    private class ChatAwayAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                prefs.setSendChatAwayMessage(jMenuItem.isSelected());
            }
        }

        public ChatAwayAction() {
            this.putValue("Name", XNap.tr("Away"));
            this.putValue("ShortDescription", XNap.tr("Send away message when people want to chat with me"));
        }
    }

    private class CmdlAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = XNapFrame.this.ecbCmdl.getText();
            Executer.parseCommand(string);
            XNapFrame.this.ecbCmdl.addDistinctItemAtTop(string);
            XNapFrame.this.ecbCmdl.setText("");
        }

        public CmdlAction() {
            this.putValue("Name", XNap.tr("Run"));
            this.putValue("SmallIcon", XNapFrame.getSmallIcon("exec.png"));
            this.putValue("ShortDescription", XNap.tr("Runs Command"));
            this.putValue("MnemonicKey", new Integer(82));
        }
    }

    private class InstallPluginsAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            PluginDialog.showDialog(XNapFrame.this);
        }

        public InstallPluginsAction() {
            this.putValue("Name", XNap.tr("Install") + "...");
            this.putValue("SmallIcon", XNapFrame.getIcon("configure.png"));
            this.putValue("ShortDescription", XNap.tr("Installs new plugins"));
        }
    }

    private class PreferencesAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            XNapFrame.this.doShowPreferences();
        }

        public PreferencesAction() {
            this.putValue("Name", XNap.tr("Preferences") + "...");
            this.putValue("SmallIcon", XNapFrame.getIcon("configure.png"));
            this.putValue("ShortDescription", XNap.tr("Shows preferences dialog"));
        }
    }

    private class PurgeHistoryAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            XNapFrame.this.searchPanel.purgeHistory();
            XNapFrame.this.libraryPanel.purgeHistory();
        }

        public PurgeHistoryAction() {
            this.putValue("Name", XNap.tr("Clear All Histories"));
            this.putValue("ShortDescription", XNap.tr("Clear all histories."));
        }
    }

    private class ShowToolbarAction
    extends AbstractAction {
        private JToolBar jtb;
        private boolean visible;

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                this.setVisible(jMenuItem.isSelected());
            }
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
            this.jtb.setVisible(this.visible);
        }

        public boolean isVisible() {
            return this.visible;
        }

        public ShowToolbarAction(JToolBar jToolBar, boolean bl) {
            this.jtb = jToolBar;
            this.putValue("Name", jToolBar.getName());
            this.putValue("ShortDescription", XNap.tr("Show or hide toolbar"));
            this.setVisible(bl);
        }
    }

    private class UpdateRepositoryAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Repository.getInstance().updateLater();
        }

        public UpdateRepositoryAction() {
            this.putValue("Name", XNap.tr("Update Library"));
            this.putValue("ShortDescription", XNap.tr("Updates the library"));
        }
    }

    private class UseSocksProxyAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                prefs.setUseSocksProxy(jMenuItem.isSelected());
                prefs.write();
            }
        }

        public UseSocksProxyAction() {
            this.putValue("Name", XNap.tr("Use Socks Proxy"));
            this.putValue("ShortDescription", XNap.tr("Enable socks proxy"));
        }
    }

    private class UseTabbedPaneAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                prefs.setUseTabbedPane(jMenuItem.isSelected());
                prefs.write();
                XNapFrame.this.pane.setUseTabbedPane(jMenuItem.isSelected());
            }
        }

        public UseTabbedPaneAction() {
            this.putValue("Name", XNap.tr("Use TabbedPane"));
            this.putValue("ShortDescription", XNap.tr("Use TabbedPane as main view"));
        }
    }

    private class UseTabbedTransferPaneAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                prefs.setUseTabbedTransferPane(jMenuItem.isSelected());
                prefs.write();
            }
        }

        public UseTabbedTransferPaneAction() {
            this.putValue("Name", XNap.tr("Use TabbedPane For Transfers"));
            this.putValue("ShortDescription", XNap.tr("Use TabbedPane as transfer view"));
        }
    }

    private class PluginActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            PluginManager.getInstance().setEnabled(actionEvent.getActionCommand(), jMenuItem.isSelected());
        }

        private PluginActionListener() {
        }
    }

    private class ViewActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            XNapFrame.this.pane.setSelectedComponent(actionEvent.getActionCommand());
        }

        private ViewActionListener() {
        }
    }

    private class LookAndFeelActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            prefs.setLookAndFeel(actionEvent.getActionCommand());
            prefs.write();
            Dialogs.showRestartNotification(XNapFrame.this);
        }

        private LookAndFeelActionListener() {
        }
    }

    private class WindowListener
    extends WindowAdapter {
        public void windowDeiconified(WindowEvent windowEvent) {
            if (XNapFrame.this.wdi != null) {
                XNapFrame.this.wdi.hide();
            }
        }

        public void windowIconified(WindowEvent windowEvent) {
            if (XNapFrame.this.wdi != null) {
                XNapFrame.this.wdi.show("XNap");
                XNapFrame.this.wdi.hideFrame();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            XNapFrame.this.doExit();
        }

        private WindowListener() {
        }
    }

    protected class ExitCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            XNapFrame.this.doExit();
            return true;
        }

        public ExitCmd() {
            this.putValue("cmd", new String[]{"exit", "quit", "q"});
            this.putValue("shortHelp", "Quits the application.");
        }
    }
}

