/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.prefs;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import xnap.XNap;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.GridBagHelper;
import xnap.gui.MultiLineLabel;
import xnap.gui.XNapFrame;
import xnap.plugin.GUIPluginManager;
import xnap.plugin.IGUIPlugin;
import xnap.plugin.INetworkPlugin;
import xnap.plugin.IPlugin;
import xnap.plugin.IViewerPlugin;
import xnap.plugin.PluginManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PluginPrefsPanel
extends AbstractPreferencesPanel {
    private JComboBox jcbCategories;
    private DefaultListModel dlmPlugins;
    private JList jlPlugins;
    private JCheckBox jcbEnabled;
    private JLabel jlIcon;
    private MultiLineLabel jlDescription;
    private JLabel jlVersion;
    Hashtable categories;

    public void initialize() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(XNap.tr("Installed", 1)));
        GridBagHelper.addLabel(jPanel, XNap.tr("Category"));
        this.jcbCategories = new JComboBox(new Vector(this.categories.keySet()));
        GridBagHelper.add((Container)jPanel, this.jcbCategories);
        GridBagHelper.addLabel(jPanel, XNap.tr("Plugin"));
        this.dlmPlugins = new DefaultListModel();
        this.jlPlugins = new JList(this.dlmPlugins);
        this.jlPlugins.setVisibleRowCount(4);
        JScrollPane jScrollPane = new JScrollPane(this.jlPlugins);
        GridBagHelper.add((Container)jPanel, jScrollPane);
        GridBagHelper.addLabel(jPanel, "");
        this.jcbEnabled = new JCheckBox(XNap.tr("Enabled"));
        this.jcbEnabled.addActionListener(new PluginEnabler());
        GridBagHelper.add((Container)jPanel, this.jcbEnabled);
        this.jlIcon = GridBagHelper.addLabel(jPanel, "");
        this.jlIcon.setHorizontalAlignment(0);
        this.jlIcon.setVerticalAlignment(0);
        this.jlDescription = new MultiLineLabel();
        GridBagHelper.add((Container)jPanel, this.jlDescription);
        GridBagHelper.addLabel(jPanel, "");
        this.jlVersion = new JLabel();
        GridBagHelper.add((Container)jPanel, this.jlVersion);
        this.jcbCategories.addActionListener(new PluginCategoryListener());
        this.jlPlugins.addListSelectionListener(new PluginListener());
        GridBagHelper.add((Container)this, jPanel);
        GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() {
    }

    public Icon getIcon() {
        return XNapFrame.getIcon("attach.png");
    }

    public String getTitle() {
        return XNap.tr("Plugins");
    }

    protected void updatePlugin() {
        IPlugin iPlugin = (IPlugin)this.jlPlugins.getSelectedValue();
        if (iPlugin != null) {
            this.jcbEnabled.setSelected(iPlugin.isEnabled());
            if (iPlugin instanceof IGUIPlugin) {
                this.jlIcon.setIcon(((IGUIPlugin)iPlugin).getIcon());
            }
            if (iPlugin instanceof IViewerPlugin) {
                this.jlIcon.setIcon(((IViewerPlugin)iPlugin).getIcon());
            }
            this.jlDescription.setText(iPlugin.getDescription());
            this.jlVersion.setText(XNap.tr("Version", 0, 1) + iPlugin.getVersion());
            this.jcbEnabled.setEnabled(true);
        } else {
            this.jcbEnabled.setSelected(false);
            this.jlIcon.setIcon(null);
            this.jlDescription.setText("");
            this.jlVersion.setText("");
            this.jcbEnabled.setEnabled(false);
        }
    }

    private final /* synthetic */ void this() {
        this.categories = new Hashtable();
    }

    public PluginPrefsPanel() {
        this.this();
        LinkedList<IPlugin> linkedList = new LinkedList<IPlugin>();
        LinkedList<IPlugin> linkedList2 = new LinkedList<IPlugin>();
        LinkedList<IPlugin> linkedList3 = new LinkedList<IPlugin>();
        IPlugin[] iPluginArray = PluginManager.getInstance().getPlugins();
        int n = 0;
        while (n < iPluginArray.length) {
            if (iPluginArray[n] instanceof INetworkPlugin) {
                linkedList.add(iPluginArray[n]);
            } else if (iPluginArray[n] instanceof IViewerPlugin) {
                linkedList2.add(iPluginArray[n]);
            } else {
                linkedList3.add(iPluginArray[n]);
            }
            ++n;
        }
        this.categories.put(XNap.tr("Network"), linkedList);
        this.categories.put(XNap.tr("Viewers"), linkedList2);
        this.categories.put(XNap.tr("Other"), linkedList3);
        this.initialize();
    }

    protected class PluginCategoryListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = PluginPrefsPanel.this.jcbCategories.getSelectedItem().toString();
            LinkedList linkedList = (LinkedList)PluginPrefsPanel.this.categories.get(string);
            PluginPrefsPanel.this.dlmPlugins.removeAllElements();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                PluginPrefsPanel.this.dlmPlugins.addElement(iterator.next());
            }
            PluginPrefsPanel.this.updatePlugin();
        }

        public PluginCategoryListener() {
            this.actionPerformed(null);
        }
    }

    protected class PluginListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            PluginPrefsPanel.this.updatePlugin();
        }

        public PluginListener() {
            this.valueChanged(null);
        }
    }

    protected class PluginEnabler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            IPlugin iPlugin = (IPlugin)PluginPrefsPanel.this.jlPlugins.getSelectedValue();
            if (iPlugin != null) {
                GUIPluginManager.getInstance().setEnabled(iPlugin, PluginPrefsPanel.this.jcbEnabled.isSelected());
            }
        }
    }
}

