/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import xnap.XNap;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.Column;
import xnap.gui.table.FilesizeCellRenderer;
import xnap.gui.table.LinkSpeedCellRenderer;
import xnap.gui.table.NumberCellRenderer;
import xnap.gui.table.ScoreCellRenderer;
import xnap.gui.table.StringCellRenderer;
import xnap.gui.table.TimeCellRenderer;
import xnap.gui.util.SwingSynchronizedCache;
import xnap.net.SearchResultContainer;
import xnap.util.EventVector;
import xnap.util.FileHelper;
import xnap.util.Preferences;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SearchTableModel
extends AbstractDynamicTableModel
implements Observer,
ListListener {
    public static final int FILENAME = 0;
    public static final int PATH = 1;
    public static final int FILESIZE = 2;
    public static final int BITRATE = 3;
    public static final int FREQUENCY = 4;
    public static final int LENGTH = 5;
    public static final int USER = 6;
    public static final int LINKSPEED = 7;
    public static final int PLUGIN = 8;
    public static final int STATUS = 9;
    public static final int SCORE = 10;
    public static final int TYPE = 11;
    protected Column[] columns;
    private ArrayList rows;
    private SwingSynchronizedCache cache;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    public SearchResultContainer get(int n) {
        return (SearchResultContainer)this.rows.get(this.mapToIndex(n));
    }

    public String getTableName() {
        return XNap.tr("Search Table");
    }

    public void setFilteredData(EventVector eventVector) {
        eventVector.addListListener(this.cache);
    }

    public void elementAdded(ListEvent listEvent) {
        if (listEvent.getElement() instanceof Observable) {
            Observable observable = (Observable)listEvent.getElement();
            observable.addObserver(this);
        }
        this.rows.add(listEvent.getElement());
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void elementRemoved(ListEvent listEvent) {
        if (listEvent.getID() == 3) {
            int n = this.rows.size();
            if (n > 0) {
                Iterator iterator = this.rows.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Observable)) continue;
                    Observable observable = (Observable)e;
                    observable.deleteObserver(this);
                }
                this.rows.clear();
                this.fireTableRowsDeleted(0, n - 1);
            }
        } else {
            int n = this.rows.indexOf(listEvent.getElement());
            if (n != -1) {
                if (listEvent.getElement() instanceof Observable) {
                    Observable observable = (Observable)listEvent.getElement();
                    observable.deleteObserver(this);
                }
                this.rows.remove(n);
                this.fireTableRowsDeleted(n, n);
            }
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object get(int n, int n2) {
        if (n >= this.rows.size()) {
            return null;
        }
        SearchResultContainer searchResultContainer = (SearchResultContainer)this.rows.get(n);
        if (searchResultContainer == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return searchResultContainer.getShortFilename();
            }
            case 2: {
                return new Long(searchResultContainer.getFilesize());
            }
            case 3: {
                return new Integer(searchResultContainer.getBitrate());
            }
            case 4: {
                return new Double((double)searchResultContainer.getFrequency() / 1000.0);
            }
            case 5: {
                return new Integer(searchResultContainer.getLength());
            }
            case 6: {
                return searchResultContainer.getUsername();
            }
            case 7: {
                return new Integer(searchResultContainer.getLinkSpeed());
            }
            case 10: {
                return new Integer(searchResultContainer.getScore());
            }
            case 1: {
                return searchResultContainer.getPath();
            }
            case 9: {
                return searchResultContainer.getStatus();
            }
            case 8: {
                return searchResultContainer.getPlugin();
            }
            case 11: {
                return FileHelper.extension(searchResultContainer.getShortFilename());
            }
        }
        return "";
    }

    public void update(Observable observable, Object object) {
        if (object instanceof SearchResultContainer) {
            SwingUtilities.invokeLater(new StatusChangeEventHandler(object));
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Column[] columnArray = new Column[12];
        String string = XNap.tr("Filename");
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = SearchTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[0] = new Column(string, clazz, new StringCellRenderer());
        String string2 = XNap.tr("Path");
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = SearchTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[1] = new Column(string2, clazz2, new StringCellRenderer());
        String string3 = XNap.tr("Filesize");
        Class clazz3 = class$java$lang$Long;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Long = SearchTableModel.class$("[Ljava.lang.Long;", false);
        }
        columnArray[2] = new Column(string3, clazz3, new FilesizeCellRenderer());
        String string4 = XNap.tr("Bitrate");
        Class clazz4 = class$java$lang$Integer;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Integer = SearchTableModel.class$("[Ljava.lang.Integer;", false);
        }
        columnArray[3] = new Column(string4, clazz4, new NumberCellRenderer());
        String string5 = XNap.tr("Frequency");
        Class clazz5 = class$java$lang$Double;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Double = SearchTableModel.class$("[Ljava.lang.Double;", false);
        }
        columnArray[4] = new Column(string5, clazz5, new NumberCellRenderer(1));
        String string6 = XNap.tr("Length");
        Class clazz6 = class$java$lang$Integer;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Integer = SearchTableModel.class$("[Ljava.lang.Integer;", false);
        }
        columnArray[5] = new Column(string6, clazz6, new TimeCellRenderer());
        String string7 = XNap.tr("User");
        Class clazz7 = class$java$lang$String;
        if (clazz7 == null) {
            clazz7 = class$java$lang$String = SearchTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[6] = new Column(string7, clazz7);
        String string8 = XNap.tr("Link Speed");
        Class clazz8 = class$java$lang$Integer;
        if (clazz8 == null) {
            clazz8 = class$java$lang$Integer = SearchTableModel.class$("[Ljava.lang.Integer;", false);
        }
        columnArray[7] = new Column(string8, clazz8, new LinkSpeedCellRenderer());
        String string9 = XNap.tr("Plugin");
        Class clazz9 = class$java$lang$String;
        if (clazz9 == null) {
            clazz9 = class$java$lang$String = SearchTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[8] = new Column(string9, clazz9);
        String string10 = XNap.tr("Status");
        Class clazz10 = class$java$lang$String;
        if (clazz10 == null) {
            clazz10 = class$java$lang$String = SearchTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[9] = new Column(string10, clazz10, new StringCellRenderer());
        String string11 = XNap.tr("Availability");
        Class clazz11 = class$java$lang$Integer;
        if (clazz11 == null) {
            clazz11 = class$java$lang$Integer = SearchTableModel.class$("[Ljava.lang.Integer;", false);
        }
        columnArray[10] = new Column(string11, clazz11, new ScoreCellRenderer());
        String string12 = XNap.tr("Type");
        Class clazz12 = class$java$lang$String;
        if (clazz12 == null) {
            clazz12 = class$java$lang$String = SearchTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[11] = new Column(string12, clazz12, new StringCellRenderer());
        this.columns = columnArray;
        this.rows = new ArrayList();
        this.cache = new SwingSynchronizedCache(this);
    }

    public SearchTableModel() {
        super("search", Preferences.getInstance());
        this.this();
        this.setColumns(this.columns);
    }

    protected SearchTableModel(String string, Preferences preferences) {
        super(string, preferences);
        this.this();
    }

    private class StatusChangeEventHandler
    implements Runnable {
        Object item;

        public void run() {
            int n = SearchTableModel.this.rows.indexOf(this.item);
            if (n != -1) {
                SearchTableModel.this.fireTableRowsUpdated(n, n);
            }
        }

        public StatusChangeEventHandler(Object object) {
            this.item = object;
        }
    }
}

