/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.gui.table;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.Column;
import xnap.gui.table.NumberCellRenderer;
import xnap.gui.table.StringCellRenderer;
import xnap.gui.util.SwingSynchronizedCache;
import xnap.net.event.StatusChangeEvent;
import xnap.net.event.StatusChangeListener;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.util.NapPreferences;
import xnap.util.EventVector;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ServerTableModel
extends AbstractDynamicTableModel
implements ListListener,
StatusChangeListener {
    public static final int HOST = 0;
    public static final int NETWORK = 1;
    public static final int LOCAL_PORT = 2;
    public static final int VERSION = 3;
    public static final int FILE_COUNT = 4;
    public static final int FILE_SIZE = 5;
    public static final int USER_COUNT = 6;
    public static final int STATUS = 7;
    public static final int IP = 8;
    protected Column[] columns;
    private ArrayList rows;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public void elementAdded(ListEvent listEvent) {
        Server server = (Server)listEvent.getElement();
        server.addStatusChangeListener(this);
        this.rows.add(server);
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void elementRemoved(ListEvent listEvent) {
        if (listEvent.getID() == 3) {
            int n = this.rows.size();
            if (n > 0) {
                Iterator iterator = this.rows.iterator();
                while (iterator.hasNext()) {
                    Server server = (Server)iterator.next();
                    server.removeStatusChangeListener(this);
                }
                this.rows.clear();
                this.fireTableRowsDeleted(0, n - 1);
            }
        } else {
            int n = this.rows.indexOf(listEvent.getElement());
            if (n != -1) {
                Server server = (Server)listEvent.getElement();
                server.removeStatusChangeListener(this);
                this.rows.remove(n);
                this.fireTableRowsDeleted(n, n);
            }
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Server get(int n) {
        return (Server)this.rows.get(this.mapToIndex(n));
    }

    public Object get(int n, int n2) {
        Server server = (Server)this.rows.get(n);
        switch (n2) {
            case 0: {
                String string = server.getHost() + ':' + server.getPort();
                return server.isRedirector() && server.getRedirectedHost() != null ? string + " -> " + server.getRedirectedHost() + ':' + server.getRedirectedPort() : string;
            }
            case 1: {
                return server.getNetwork();
            }
            case 2: {
                return new Integer(server.getLocalPort());
            }
            case 3: {
                return server.getVersion().toString();
            }
            case 4: {
                return new Integer(server.getFileCount());
            }
            case 5: {
                return new Integer(server.getFileSize());
            }
            case 6: {
                return new Integer(server.getUserCount());
            }
            case 7: {
                return server.getStatusText();
            }
            case 8: {
                return server.getIP();
            }
        }
        return null;
    }

    public String getTableName() {
        return Plugin.tr("Server Table");
    }

    public void statusChange(StatusChangeEvent statusChangeEvent) {
        SwingUtilities.invokeLater(new StatusChangeEventHandler(statusChangeEvent.getSource()));
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Column[] columnArray = new Column[9];
        String string = Plugin.tr("Server");
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = ServerTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[0] = new Column(string, clazz, new StringCellRenderer());
        String string2 = Plugin.tr("Network");
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = ServerTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[1] = new Column(string2, clazz2);
        String string3 = Plugin.tr("Local Port");
        Class clazz3 = class$java$lang$Integer;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Integer = ServerTableModel.class$("[Ljava.lang.Integer;", false);
        }
        columnArray[2] = new Column(string3, clazz3);
        String string4 = Plugin.tr("Version");
        Class clazz4 = class$java$lang$String;
        if (clazz4 == null) {
            clazz4 = class$java$lang$String = ServerTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[3] = new Column(string4, clazz4, new StringCellRenderer());
        String string5 = Plugin.tr("Files");
        Class clazz5 = class$java$lang$Integer;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Integer = ServerTableModel.class$("[Ljava.lang.Integer;", false);
        }
        columnArray[4] = new Column(string5, clazz5, new NumberCellRenderer());
        String string6 = Plugin.tr("Total (GB)");
        Class clazz6 = class$java$lang$Integer;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Integer = ServerTableModel.class$("[Ljava.lang.Integer;", false);
        }
        columnArray[5] = new Column(string6, clazz6, new NumberCellRenderer());
        String string7 = Plugin.tr("Users");
        Class clazz7 = class$java$lang$Integer;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Integer = ServerTableModel.class$("[Ljava.lang.Integer;", false);
        }
        columnArray[6] = new Column(string7, clazz7, new NumberCellRenderer());
        String string8 = Plugin.tr("Status");
        Class clazz8 = class$java$lang$String;
        if (clazz8 == null) {
            clazz8 = class$java$lang$String = ServerTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[7] = new Column(string8, clazz8, new StringCellRenderer());
        String string9 = Plugin.tr("IP Adress");
        Class clazz9 = class$java$lang$String;
        if (clazz9 == null) {
            clazz9 = class$java$lang$String = ServerTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[8] = new Column(string9, clazz9, new StringCellRenderer());
        this.columns = columnArray;
        this.rows = new ArrayList();
    }

    public ServerTableModel(EventVector eventVector) {
        super("server", NapPreferences.getInstance());
        this.this();
        SwingSynchronizedCache swingSynchronizedCache = new SwingSynchronizedCache(this);
        eventVector.addListListener(swingSynchronizedCache);
        this.setColumns(this.columns);
    }

    private class StatusChangeEventHandler
    implements Runnable {
        Object item;

        public void run() {
            int n = ServerTableModel.this.rows.indexOf(this.item);
            if (n != -1 && n < ServerTableModel.this.rows.size()) {
                ServerTableModel.this.fireTableRowsUpdated(n, n);
            }
        }

        public StatusChangeEventHandler(Object object) {
            this.item = object;
        }
    }
}

