/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import xnap.plugin.nap.net.IncomingSocket;
import xnap.util.QuotedStringTokenizer;

public class DownloadSocket
extends IncomingSocket {
    public String filename;
    public long filesize;
    public String nick;

    public boolean equals(Object object) {
        if (object != null && object instanceof DownloadSocket) {
            DownloadSocket downloadSocket = (DownloadSocket)object;
            boolean bl = false;
            if (this.nick.equals(downloadSocket.nick) && this.filename.equals(downloadSocket.filename) && this.filesize == downloadSocket.filesize) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public DownloadSocket(Socket socket, InputStream inputStream) throws IOException {
        super(socket, inputStream);
        byte[] byArray = new byte[2048];
        int n = inputStream.read(byArray);
        if (n > 0) {
            String string = new String(byArray, 0, n);
            QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string);
            if (quotedStringTokenizer.countTokens() < 3) {
                throw new IOException("invalid request: " + string);
            }
            this.nick = quotedStringTokenizer.nextToken();
            this.filename = quotedStringTokenizer.nextToken();
            try {
                this.filesize = Long.parseLong(quotedStringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("invalid request: " + string);
            }
        } else {
            throw new IOException("empty request");
        }
        logger.info("download response from " + this.nick + " for " + this.filename);
    }

    public DownloadSocket(String string, String string2, long l) {
        this.nick = string;
        this.filename = string2;
        this.filesize = l;
    }
}

