/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net.msg;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.msg.SendMessage;
import xnap.plugin.nap.net.msg.SendWorker;
import xnap.plugin.nap.net.msg.client.ClientMessage;
import xnap.plugin.nap.util.Connector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MessageSender {
    public static final int SEND_WORKER_COUNT = 3;
    protected static Logger logger;
    protected static MessageSender singleton;
    protected boolean died;
    protected LinkedList queue;
    protected HashSet lockedServers;
    protected LinkedList sendWorkers;
    static /* synthetic */ Class class$xnap$plugin$nap$net$msg$MessageSender;

    public static synchronized MessageSender getInstance() {
        if (singleton == null) {
            singleton = new MessageSender();
        }
        return singleton;
    }

    public static void ensureLiveness() {
        if (MessageSender.getInstance().lockedServers.size() >= MessageSender.getInstance().sendWorkers.size()) {
            MessageSender.getInstance().startNewSendWorker();
        }
    }

    public static void send(Server server, ClientMessage clientMessage, boolean bl) {
        MessageSender.getInstance().add(server, clientMessage, bl, true);
    }

    public static void send(ClientMessage clientMessage) {
        Object[] objectArray = Connector.getInstance().getConnectedServers().toArray();
        int n = 0;
        while (n < objectArray.length) {
            MessageSender.getInstance().add((Server)objectArray[n], clientMessage, true, true);
            ++n;
        }
    }

    public static void sendLater(Server server, ClientMessage clientMessage) {
        MessageSender.getInstance().add(server, clientMessage, true, false);
    }

    public static void sendPending(Server server) {
        MessageSender.getInstance().notifyServer(server);
    }

    public synchronized void add(Server server, ClientMessage clientMessage, boolean bl, boolean bl2) {
        if (bl) {
            this.queue.addLast(new SendMessage(server, clientMessage));
        } else {
            this.queue.addFirst(new SendMessage(server, clientMessage));
        }
        if (bl2) {
            this.notifyServer(server);
        }
    }

    public synchronized void failed(Server server) {
        logger.debug("removing all messages for: " + server);
        Iterator iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            SendMessage sendMessage = (SendMessage)iterator.next();
            if (sendMessage.server != server) continue;
            iterator.remove();
            if (sendMessage.msg.listener == null) continue;
            sendMessage.msg.listener.exceptionThrown(new IOException(Plugin.tr("Server disconnected")));
        }
    }

    public Stats getStats() {
        return new Stats();
    }

    public boolean hasDied() {
        return this.died;
    }

    public synchronized SendMessage next() {
        logger.debug("fetching next: send queue size: " + this.queue.size() + ", " + this.lockedServers.size() + " locked servers");
        Iterator iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            SendMessage sendMessage = (SendMessage)iterator.next();
            if (this.lockedServers.contains(sendMessage.server)) continue;
            iterator.remove();
            this.lockedServers.add(sendMessage.server);
            MessageSender.ensureLiveness();
            return sendMessage;
        }
        return null;
    }

    public synchronized void notifyServer(Server server) {
        if (!this.lockedServers.contains(server)) {
            this.notify();
        }
    }

    public synchronized void sent(SendMessage sendMessage) {
        this.lockedServers.remove(sendMessage.server);
    }

    public void start() {
        this.died = false;
        int n = 0;
        while (n < 3) {
            this.startNewSendWorker();
            ++n;
        }
    }

    public void startNewSendWorker() {
        String string = "SendWorker " + (this.sendWorkers.size() + 1);
        SendWorker sendWorker = new SendWorker(string, this);
        this.sendWorkers.add(sendWorker);
        logger.info(this.sendWorkers.size() + " SendWorkers running");
    }

    public synchronized void stop() {
        this.died = true;
        this.notifyAll();
        singleton = null;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.died = true;
        this.queue = new LinkedList();
        this.lockedServers = new HashSet();
        this.sendWorkers = new LinkedList();
    }

    protected MessageSender() {
        this.this();
    }

    static {
        Class clazz = class$xnap$plugin$nap$net$msg$MessageSender;
        if (clazz == null) {
            clazz = class$xnap$plugin$nap$net$msg$MessageSender = MessageSender.class$("[Lxnap.plugin.nap.net.msg.MessageSender;", false);
        }
        logger = Logger.getLogger(clazz);
    }

    public class Stats {
        public int sendQueueSize;
        public int busySendWorkerCount;
        public int sendWorkerCount;

        public Stats() {
            this.sendQueueSize = MessageSender.this.queue.size();
            this.busySendWorkerCount = MessageSender.this.lockedServers.size();
            this.sendWorkerCount = MessageSender.this.sendWorkers.size();
        }
    }
}

