/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.EditingTool;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Point;

public class CreateCameraTool
extends EditingTool {
    static int counter = 2;
    Point clickPoint;

    public CreateCameraTool(LayoutWindow fr) {
        super(fr);
        this.initButton("camera");
    }

    @Override
    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("createCameraTool.helpText"));
    }

    @Override
    public int whichClicks() {
        return 1;
    }

    @Override
    public String getToolTipText() {
        return Translate.text("createCameraTool.tipText");
    }

    @Override
    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
    }

    @Override
    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        Scene theScene = ((LayoutWindow)this.theWindow).getScene();
        Camera cam = view.getCamera();
        Vec3 orig = cam.convertScreenToWorld(e.getPoint(), view.getDistToPlane());
        Vec3 ydir = new Vec3(0.0, 1.0, 0.0);
        Vec3 zdir = new Vec3(0.0, 0.0, 1.0);
        ObjectInfo info = new ObjectInfo(new SceneCamera(), new CoordinateSystem(orig, zdir, ydir), "Camera " + counter++);
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        int[] sel = ((LayoutWindow)this.theWindow).getSelectedIndices();
        ((LayoutWindow)this.theWindow).addObject(info, undo);
        undo.addCommand(16, new Object[]{sel});
        this.theWindow.setUndoRecord(undo);
        ((LayoutWindow)this.theWindow).setSelection(theScene.getNumObjects() - 1);
        this.theWindow.updateImage();
    }
}

