/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.WireframeMesh;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.KeyPressedEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BComboBox;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Vector;

public class CreateCurveTool
extends EditingTool {
    static int counter = 1;
    private Vector<Vec3> clickPoint;
    private Vector<Float> smoothness;
    private int smoothing;
    private Curve theCurve;
    private CoordinateSystem coords;
    public static final int HANDLE_SIZE = 3;

    public CreateCurveTool(EditingWindow fr) {
        super(fr);
        this.initButton("interpCurve");
        this.smoothing = 3;
    }

    @Override
    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("createCurveTool.helpText"));
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.addToScene();
    }

    @Override
    public int whichClicks() {
        return 1;
    }

    @Override
    public String getToolTipText() {
        return Translate.text("createCurveTool.tipText");
    }

    @Override
    public boolean hilightSelection() {
        return this.clickPoint == null;
    }

    @Override
    public void drawOverlay(ViewerCanvas view) {
        Camera cam = view.getCamera();
        if (this.clickPoint == null) {
            return;
        }
        if (this.theCurve != null) {
            int i;
            Mat4 trans = cam.getWorldToScreen().times(this.coords.fromLocal());
            WireframeMesh mesh = this.theCurve.getWireframeMesh();
            Point[] p = new Point[mesh.vert.length];
            for (i = 0; i < p.length; ++i) {
                Vec2 v = trans.timesXY(mesh.vert[i]);
                p[i] = new Point((int)v.x, (int)v.y);
            }
            for (i = 0; i < mesh.from.length; ++i) {
                view.drawLine(p[mesh.from[i]], p[mesh.to[i]], ViewerCanvas.lineColor);
            }
        }
        if (this.clickPoint.isEmpty()) {
            return;
        }
        int lastPoint = this.clickPoint.size() - 1;
        Mat4 cameraWorldToScreen = cam.getWorldToScreen();
        for (int listIndex = 0; listIndex < this.clickPoint.size(); ++listIndex) {
            Vec2 screenPos = cameraWorldToScreen.timesXY(this.clickPoint.get(listIndex));
            Color handleColor = listIndex == lastPoint ? ViewerCanvas.highlightColor : ViewerCanvas.disabledColor;
            view.drawBox((int)screenPos.x - 1, (int)screenPos.y - 1, 3, 3, handleColor);
        }
    }

    @Override
    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.clickPoint == null) {
            this.clickPoint = new Vector();
            this.smoothness = new Vector();
            view.repaint();
        } else {
            Vec3 pos = this.clickPoint.lastElement();
            Vec2 screenPos = view.getCamera().getWorldToScreen().timesXY(pos);
            view.drawDraggedShape(new Line2D.Float(new Point2D.Double(screenPos.x, screenPos.y), e.getPoint()));
        }
    }

    @Override
    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.clickPoint.isEmpty()) {
            return;
        }
        Point dragPoint = e.getPoint();
        Vec3 pos = this.clickPoint.lastElement();
        Vec2 screenPos = view.getCamera().getWorldToScreen().timesXY(pos);
        view.drawDraggedShape(new Line2D.Float(new Point2D.Double(screenPos.x, screenPos.y), dragPoint));
    }

    @Override
    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (e.getClickCount() != 2) {
            this.clickPoint.addElement(cam.convertScreenToWorld(dragPoint, view.getDistToPlane()));
            this.smoothness.addElement(Float.valueOf(e.isShiftDown() ? 0.0f : 1.0f));
        }
        if (this.clickPoint.size() > 1) {
            int i;
            Vec3[] vertex = new Vec3[this.clickPoint.size()];
            float[] s = new float[this.clickPoint.size()];
            Vec3 orig = new Vec3();
            for (i = 0; i < vertex.length; ++i) {
                vertex[i] = this.clickPoint.elementAt(i);
                s[i] = this.smoothness.elementAt(i).floatValue();
                orig = orig.plus(vertex[i]);
            }
            orig = orig.times(1.0 / (double)vertex.length);
            Vec3 ydir = cam.getViewToWorld().timesDirection(Vec3.vy());
            Vec3 zdir = cam.getViewToWorld().timesDirection(new Vec3(0.0, 0.0, -1.0));
            this.coords = new CoordinateSystem(orig, zdir, ydir);
            if (view.getSnapToGrid()) {
                double spacing = view.getGridSpacing() / (double)view.getSnapToSubdivisions();
                Vec3 offset = this.coords.toLocal().times(vertex[0]);
                offset.x = Math.IEEEremainder(offset.x, spacing);
                offset.y = Math.IEEEremainder(offset.y, spacing);
                offset.z = Math.IEEEremainder(offset.z, spacing);
                this.coords.fromLocal().transformDirection(offset);
                this.coords.setOrigin(orig.plus(offset));
            }
            for (i = 0; i < vertex.length; ++i) {
                vertex[i] = this.coords.toLocal().times(vertex[i]);
            }
            this.theCurve = new Curve(vertex, s, this.smoothing, false);
            if (e.getClickCount() == 2) {
                this.theCurve.setClosed(e.isControlDown());
                this.addToScene();
                return;
            }
            cam.setObjectTransform(this.coords.fromLocal());
        }
        this.theWindow.updateImage();
    }

    @Override
    public void keyPressed(KeyPressedEvent e, ViewerCanvas view) {
        if (e.getKeyCode() == 10 && this.theCurve != null) {
            this.theCurve.setClosed(e.isControlDown());
            this.addToScene();
            e.consume();
        }
    }

    private void addToScene() {
        boolean addCurve;
        boolean bl = addCurve = this.theCurve != null;
        if (addCurve) {
            ObjectInfo info = new ObjectInfo(this.theCurve, this.coords, "Curve " + counter++);
            info.addTrack(new PositionTrack(info), 0);
            info.addTrack(new RotationTrack(info), 1);
            UndoRecord undo = new UndoRecord(this.theWindow, false);
            int[] sel = ((LayoutWindow)this.theWindow).getSelectedIndices();
            ((LayoutWindow)this.theWindow).addObject(info, undo);
            undo.addCommand(16, new Object[]{sel});
            this.theWindow.setUndoRecord(undo);
            ((LayoutWindow)this.theWindow).setSelection(this.theWindow.getScene().getNumObjects() - 1);
        }
        this.clickPoint = null;
        this.smoothness = null;
        this.theCurve = null;
        this.coords = null;
        if (addCurve) {
            this.theWindow.updateImage();
        }
    }

    @Override
    public void iconDoubleClicked() {
        BComboBox smoothingChoice = new BComboBox(new String[]{Translate.text("Interpolating"), Translate.text("Approximating")});
        if (this.smoothing == 2) {
            smoothingChoice.setSelectedIndex(0);
        } else {
            smoothingChoice.setSelectedIndex(1);
        }
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, Translate.text("selectCurveSmoothing"), new Widget[]{smoothingChoice}, new String[]{Translate.text("Smoothing Method")});
        if (!dlg.clickedOk()) {
            return;
        }
        this.smoothing = smoothingChoice.getSelectedIndex() == 0 ? 2 : 3;
    }
}

