/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.LayoutWindow;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.UIUtilities;
import buoy.event.CommandEvent;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import java.io.File;
import java.util.ArrayList;
import java.util.prefs.Preferences;

public class RecentFiles {
    private static final int MAX_RECENT = 10;

    public static void createMenu(BMenu menu) {
        menu.removeAll();
        Preferences pref = Preferences.userNodeForPackage(RecentFiles.class);
        String[] recent = pref.get("recentFiles", "").split(File.pathSeparator);
        for (int i = 0; i < recent.length; ++i) {
            final File file = new File(recent[i]);
            BMenuItem item = new BMenuItem(file.getName());
            menu.add(item);
            item.addEventLink(CommandEvent.class, new Object(){

                void processEvent(CommandEvent ev) {
                    ArtOfIllusion.openScene(file, UIUtilities.findFrame(ev.getWidget()));
                }
            });
        }
    }

    public static void addRecentFile(File file) {
        String newPath = file.getAbsolutePath();
        Preferences pref = Preferences.userNodeForPackage(RecentFiles.class);
        String[] recent = pref.get("recentFiles", "").split(File.pathSeparator);
        ArrayList<String> newFiles = new ArrayList<String>();
        newFiles.add(newPath);
        for (int i = 0; i < recent.length && newFiles.size() < 10; ++i) {
            if (newPath.equals(recent[i])) continue;
            newFiles.add(recent[i]);
        }
        StringBuilder fileList = new StringBuilder();
        for (int i = 0; i < newFiles.size(); ++i) {
            if (i > 0) {
                fileList.append(File.pathSeparator);
            }
            fileList.append((String)newFiles.get(i));
        }
        pref.put("recentFiles", fileList.toString());
        for (EditingWindow window : ArtOfIllusion.getWindows()) {
            if (!(window instanceof LayoutWindow)) continue;
            RecentFiles.createMenu(((LayoutWindow)window).recentFilesMenu);
        }
    }
}

