/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.LayoutWindow;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.MoveScaleRotateMeshTool;
import artofillusion.MoveViewTool;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleMeshTool;
import artofillusion.SkewMeshTool;
import artofillusion.SplineMeshViewer;
import artofillusion.TaperMeshTool;
import artofillusion.TextureParameter;
import artofillusion.ThickenMeshTool;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.animation.SkeletonTool;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.GenericTool;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueSlider;
import buoy.event.CommandEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.BStandardDialog;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;

public class SplineMeshEditorWindow
extends MeshEditorWindow
implements EditingWindow {
    private ToolPalette modes;
    private BMenu editMenu;
    private BMenu meshMenu;
    private BMenu skeletonMenu;
    private BMenuItem[] editMenuItem;
    private BMenuItem[] meshMenuItem;
    private BMenuItem[] skeletonMenuItem;
    private BCheckBoxMenuItem[] smoothItem;
    private BCheckBoxMenuItem[] closedItem;
    private Runnable onClose;
    private int[] selectionDistance;
    private int maxDistance;
    private int selectMode;
    private int lastSelectedJoint;
    private boolean topology;
    boolean[] selected;
    private TextureParameter jointWeightParam;

    public SplineMeshEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Runnable onClose, boolean allowTopology) {
        super(parent, title, obj);
        this.onClose = onClose;
        this.topology = allowTopology;
        FormContainer content = new FormContainer(new double[]{0.0, 1.0}, new double[]{1.0, 0.0, 0.0});
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.helpText = new BLabel();
        content.add(this.helpText, 0, 1, 2, 1);
        content.add(this.viewsContainer, 1, 0);
        RowContainer buttons = new RowContainer();
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "doCancel"));
        content.add(buttons, 0, 2, 2, 1, new LayoutInfo());
        FormContainer toolsContainer = new FormContainer(new double[]{1.0}, new double[]{1.0, 0.0});
        toolsContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.NORTH, LayoutInfo.BOTH));
        content.add(toolsContainer, 0, 0);
        this.tools = new ToolPalette(1, 9, this);
        toolsContainer.add(this.tools, 0, 0);
        this.defaultTool = new ReshapeMeshTool(this, this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new ScaleMeshTool(this, this));
        this.tools.addTool(new RotateMeshTool(this, this, false));
        this.tools.addTool(new SkewMeshTool(this, this));
        this.tools.addTool(new TaperMeshTool(this, this));
        this.tools.addTool(new ThickenMeshTool(this, this));
        MoveScaleRotateMeshTool compoundTool = new MoveScaleRotateMeshTool(this, this);
        this.tools.addTool(compoundTool);
        if (ArtOfIllusion.getPreferences().getUseCompoundMeshTool()) {
            this.defaultTool = compoundTool;
        }
        this.tools.addTool(new SkeletonTool(this, true));
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.setDefaultTool(this.defaultTool);
        this.tools.selectTool(this.defaultTool);
        for (int i = 0; i < this.theView.length; ++i) {
            MeshViewer view = (MeshViewer)this.theView[i];
            view.setMetaTool(metaTool);
            view.setAltTool(altTool);
            view.setScene(parent.getScene(), obj);
            view.setFreehandSelection(lastFreehand);
        }
        this.modes = new ToolPalette(1, 2);
        toolsContainer.add(this.modes, 0, 1);
        this.modes.addTool(new GenericTool(this, "point", Translate.text("pointSelectionModeTool.tipText")));
        this.modes.addTool(new GenericTool(this, "curve", Translate.text("curveSelectionModeTool.tipText")));
        this.setSelectionMode(this.modes.getSelection());
        this.createEditMenu();
        this.createMeshMenu((SplineMesh)obj.getObject());
        this.createSkeletonMenu((SplineMesh)obj.getObject());
        this.createViewMenu();
        this.recursivelyAddListeners(this);
        UIUtilities.applyDefaultFont(content);
        UIUtilities.applyDefaultBackground(content);
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension windowDim = new Dimension(screenBounds.width * 3 / 4, screenBounds.height * 3 / 4);
        this.setBounds(new Rectangle((screenBounds.width - windowDim.width) / 2, (screenBounds.height - windowDim.height) / 2, windowDim.width, windowDim.height));
        this.tools.requestFocus();
        this.selected = new boolean[((Mesh)((Object)this.objInfo.getObject())).getVertices().length];
        this.findSelectionDistance();
        this.addExtraParameters();
        this.updateMenus();
    }

    void createEditMenu() {
        this.editMenu = Translate.menu("edit");
        this.menubar.add(this.editMenu);
        this.editMenuItem = new BMenuItem[4];
        this.undoItem = Translate.menuItem("undo", this, "undoCommand");
        this.editMenu.add(this.undoItem);
        this.redoItem = Translate.menuItem("redo", this, "redoCommand");
        this.editMenu.add(this.redoItem);
        this.editMenu.addSeparator();
        this.editMenuItem[0] = Translate.menuItem("extendSelection", this, "extendSelectionCommand");
        this.editMenu.add(this.editMenuItem[0]);
        this.editMenuItem[1] = Translate.menuItem("invertSelection", this, "invertSelectionCommand");
        this.editMenu.add(this.editMenuItem[1]);
        this.editMenu.add(Translate.menuItem("selectAll", this, "selectAllCommand"));
        this.editMenuItem[2] = Translate.menuItem("deselectAll", this, "deselectAllCommand");
        this.editMenu.add(this.editMenuItem[2]);
        this.editMenu.addSeparator();
        this.editMenuItem[3] = Translate.checkboxMenuItem("freehandSelection", this, "freehandModeChanged", false);
        this.editMenu.add(this.editMenuItem[3]);
        this.editMenu.add(Translate.menuItem("meshTension", this, "setTensionCommand"));
    }

    void createMeshMenu(SplineMesh obj) {
        this.meshMenu = Translate.menu("mesh");
        this.menubar.add(this.meshMenu);
        this.meshMenuItem = new BMenuItem[8];
        this.meshMenuItem[0] = Translate.menuItem("deleteCurves", this, "deleteCommand");
        if (this.topology) {
            this.meshMenu.add(this.meshMenuItem[0]);
        }
        this.meshMenuItem[1] = Translate.menuItem("subdivide", this, "subdivideCommand");
        if (this.topology) {
            this.meshMenu.add(this.meshMenuItem[1]);
        }
        this.meshMenuItem[2] = Translate.menuItem("editPoints", this, "setPointsCommand");
        this.meshMenu.add(this.meshMenuItem[2]);
        this.meshMenuItem[3] = Translate.menuItem("transformPoints", this, "transformPointsCommand");
        this.meshMenu.add(this.meshMenuItem[3]);
        this.meshMenuItem[4] = Translate.menuItem("randomize", this, "randomizeCommand");
        this.meshMenu.add(this.meshMenuItem[4]);
        this.meshMenuItem[5] = Translate.menuItem("parameters", this, "setParametersCommand");
        this.meshMenu.add(this.meshMenuItem[5]);
        this.meshMenu.add(Translate.menuItem("centerMesh", this, "centerCommand"));
        this.meshMenuItem[6] = Translate.menuItem("extractCurve", this, "extractCurveCommand");
        this.meshMenu.add(this.meshMenuItem[6]);
        this.meshMenu.addSeparator();
        this.meshMenuItem[7] = Translate.menuItem("smoothness", this, "setSmoothnessCommand");
        this.meshMenu.add(this.meshMenuItem[7]);
        BMenu smoothMenu = Translate.menu("smoothingMethod");
        this.meshMenu.add(smoothMenu);
        this.smoothItem = new BCheckBoxMenuItem[2];
        this.smoothItem[0] = Translate.checkboxMenuItem("interpolating", this, "smoothingChanged", obj.getSmoothingMethod() == 2);
        smoothMenu.add(this.smoothItem[0]);
        this.smoothItem[1] = Translate.checkboxMenuItem("approximating", this, "smoothingChanged", obj.getSmoothingMethod() == 3);
        smoothMenu.add(this.smoothItem[1]);
        BMenu closedMenu = Translate.menu("closed");
        if (this.topology) {
            this.meshMenu.add(closedMenu);
        }
        this.closedItem = new BCheckBoxMenuItem[4];
        this.closedItem[0] = Translate.checkboxMenuItem("udirection", this, "closedTypeChanged", obj.isUClosed() && !obj.isVClosed());
        closedMenu.add(this.closedItem[0]);
        this.closedItem[1] = Translate.checkboxMenuItem("vdirection", this, "closedTypeChanged", !obj.isUClosed() && obj.isVClosed());
        closedMenu.add(this.closedItem[1]);
        this.closedItem[2] = Translate.checkboxMenuItem("both", this, "closedTypeChanged", obj.isUClosed() && obj.isVClosed());
        closedMenu.add(this.closedItem[2]);
        this.closedItem[3] = Translate.checkboxMenuItem("neither", this, "closedTypeChanged", !obj.isUClosed() && !obj.isVClosed());
        closedMenu.add(this.closedItem[3]);
        if (this.topology) {
            this.meshMenu.add(Translate.menuItem("invertNormals", this, "reverseNormalsCommand"));
        }
    }

    void createSkeletonMenu(SplineMesh obj) {
        this.skeletonMenu = Translate.menu("skeleton");
        this.menubar.add(this.skeletonMenu);
        this.skeletonMenuItem = new BMenuItem[7];
        this.skeletonMenuItem[0] = Translate.menuItem("editBone", this, "editJointCommand");
        this.skeletonMenu.add(this.skeletonMenuItem[0]);
        this.skeletonMenuItem[1] = Translate.menuItem("deleteBone", this, "deleteJointCommand");
        this.skeletonMenu.add(this.skeletonMenuItem[1]);
        this.skeletonMenuItem[2] = Translate.menuItem("setParentBone", this, "setJointParentCommand");
        this.skeletonMenu.add(this.skeletonMenuItem[2]);
        this.skeletonMenuItem[3] = Translate.menuItem("importSkeleton", this, "importSkeletonCommand");
        this.skeletonMenu.add(this.skeletonMenuItem[3]);
        this.skeletonMenu.addSeparator();
        this.skeletonMenuItem[4] = Translate.menuItem("bindSkeleton", this, "bindSkeletonCommand");
        this.skeletonMenu.add(this.skeletonMenuItem[4]);
        this.skeletonMenuItem[5] = Translate.menuItem("unbindSkeleton", this, "unbindSkeletonCommand");
        this.skeletonMenu.add(this.skeletonMenuItem[5]);
        this.skeletonMenuItem[6] = Translate.checkboxMenuItem("detachSkeleton", this, "skeletonDetachedChanged", false);
        this.skeletonMenu.add(this.skeletonMenuItem[6]);
    }

    @Override
    public ObjectInfo getObject() {
        return this.objInfo;
    }

    public void setObject(Object3D obj) {
        this.objInfo.setObject(obj);
        this.objInfo.clearCachedMeshes();
    }

    @Override
    public void setSelectionMode(int mode) {
        boolean[] newSel;
        SplineMesh mesh = (SplineMesh)this.getObject().getObject();
        MeshVertex[] vert = mesh.getVertices();
        int usize = mesh.getUSize();
        int vsize = mesh.getVSize();
        if (mode == this.selectMode) {
            return;
        }
        if (mode == 0) {
            int j;
            int i;
            newSel = new boolean[vert.length];
            for (i = 0; i < usize; ++i) {
                if (!this.selected[i]) continue;
                for (j = 0; j < vsize; ++j) {
                    newSel[i + j * usize] = true;
                }
            }
            for (i = 0; i < vsize; ++i) {
                if (!this.selected[i + usize]) continue;
                for (j = 0; j < usize; ++j) {
                    newSel[j + i * usize] = true;
                }
            }
        } else if (mode == 1) {
            newSel = new boolean[usize + vsize];
            int i = 0;
            while (i < newSel.length) {
                newSel[i++] = true;
            }
            for (i = 0; i < usize; ++i) {
                for (int j = 0; j < vsize; ++j) {
                    if (this.selected[i + j * usize]) continue;
                    newSel[j + usize] = false;
                    newSel[i] = false;
                }
            }
        } else {
            return;
        }
        this.selectMode = mode;
        this.setSelection(newSel);
        if (this.modes.getSelection() != mode) {
            this.modes.selectTool(this.modes.getTool(mode));
        }
    }

    @Override
    public int getSelectionMode() {
        return this.selectMode;
    }

    @Override
    public boolean[] getSelection() {
        return this.selected;
    }

    @Override
    public void setSelection(boolean[] sel) {
        this.selected = sel;
        this.findSelectionDistance();
        this.updateMenus();
        for (ViewerCanvas view : this.theView) {
            view.repaint();
        }
        this.repaint();
    }

    @Override
    public int[] getSelectionDistance() {
        if (this.maxDistance != this.getTensionDistance()) {
            this.findSelectionDistance();
        }
        return this.selectionDistance;
    }

    void findSelectionDistance() {
        int j;
        int i;
        SplineMesh mesh = (SplineMesh)this.getObject().getObject();
        int usize = mesh.getUSize();
        int vsize = mesh.getVSize();
        boolean uclosed = mesh.isUClosed();
        boolean vclosed = mesh.isVClosed();
        int[] dist = new int[mesh.getVertices().length];
        this.maxDistance = this.getTensionDistance();
        if (this.selectMode == 0) {
            for (i = 0; i < dist.length; ++i) {
                dist[i] = this.selected[i] ? 0 : -1;
            }
        } else {
            for (i = 0; i < usize; ++i) {
                for (j = 0; j < vsize; ++j) {
                    dist[i + j * usize] = this.selected[i] || this.selected[j + usize] ? 0 : -1;
                }
            }
        }
        for (i = 0; i < this.maxDistance; ++i) {
            for (j = 0; j < usize; ++j) {
                for (int k = 0; k < vsize; ++k) {
                    if (dist[j + k * usize] != -1) continue;
                    if (j == 0) {
                        if (uclosed && dist[usize - 1 + k * usize] == i) {
                            dist[j + k * usize] = i + 1;
                        }
                    } else if (dist[j - 1 + k * usize] == i) {
                        dist[j + k * usize] = i + 1;
                    }
                    if (j == usize - 1) {
                        if (uclosed && dist[k * usize] == i) {
                            dist[j + k * usize] = i + 1;
                        }
                    } else if (dist[j + 1 + k * usize] == i) {
                        dist[j + k * usize] = i + 1;
                    }
                    if (k == 0) {
                        if (vclosed && dist[j + (vsize - 1) * usize] == i) {
                            dist[j + k * usize] = i + 1;
                        }
                    } else if (dist[j + (k - 1) * usize] == i) {
                        dist[j + k * usize] = i + 1;
                    }
                    if (k == vsize - 1) {
                        if (!vclosed || dist[j] != i) continue;
                        dist[j + k * usize] = i + 1;
                        continue;
                    }
                    if (dist[j + (k + 1) * usize] != i) continue;
                    dist[j + k * usize] = i + 1;
                }
            }
        }
        this.selectionDistance = dist;
    }

    @Override
    public void setMesh(Mesh mesh) {
        SplineMesh obj = (SplineMesh)mesh;
        this.setObject(obj);
        for (int i = 0; i < this.theView.length; ++i) {
            if (this.selectMode == 0 && this.selected.length != obj.getVertices().length) {
                this.selected = new boolean[obj.getVertices().length];
            }
            if (this.selectMode == 1 && this.selected.length != obj.getUSize() + obj.getVSize()) {
                this.selected = new boolean[obj.getUSize() + obj.getVSize()];
            }
            ((SplineMeshViewer)this.theView[i]).visible = new boolean[obj.getVertices().length];
        }
        this.updateJointWeightParam();
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
    }

    @Override
    public void setTool(EditingTool tool) {
        if (tool instanceof GenericTool) {
            if (this.selectMode == this.modes.getSelection()) {
                return;
            }
            if (this.undoItem != null) {
                this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, this.selectMode, this.selected}));
            }
            this.setSelectionMode(this.modes.getSelection());
            this.theView[this.currentView].getCurrentTool().activate();
        } else {
            for (int i = 0; i < this.theView.length; ++i) {
                this.theView[i].setTool(tool);
            }
            this.currentTool = tool;
        }
    }

    @Override
    public void updateImage() {
        if (this.lastSelectedJoint != ((MeshViewer)this.theView[this.currentView]).getSelectedJoint()) {
            this.updateJointWeightParam();
        }
        super.updateImage();
    }

    @Override
    public void updateMenus() {
        int i;
        super.updateMenus();
        SplineMesh theMesh = (SplineMesh)this.objInfo.getObject();
        boolean curvemode = this.selectMode == 1;
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        int count = 0;
        for (i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            ++count;
        }
        if (count > 0) {
            this.editMenuItem[0].setEnabled(true);
            this.editMenuItem[1].setEnabled(true);
            this.editMenuItem[2].setEnabled(true);
            this.meshMenuItem[0].setEnabled(curvemode);
            this.meshMenuItem[1].setEnabled(curvemode);
            this.meshMenuItem[2].setEnabled(true);
            this.meshMenuItem[3].setEnabled(true);
            this.meshMenuItem[4].setEnabled(true);
            this.meshMenuItem[5].setEnabled(true);
            this.meshMenuItem[6].setEnabled(curvemode && count == 1);
            this.meshMenuItem[7].setEnabled(curvemode);
        } else {
            this.editMenuItem[0].setEnabled(false);
            this.editMenuItem[1].setEnabled(false);
            this.editMenuItem[2].setEnabled(false);
            for (i = 0; i < this.meshMenuItem.length; ++i) {
                this.meshMenuItem[i].setEnabled(false);
            }
        }
        Skeleton s = theMesh.getSkeleton();
        Joint selJoint = s.getJoint(view.getSelectedJoint());
        this.skeletonMenuItem[0].setEnabled(selJoint != null);
        this.skeletonMenuItem[1].setEnabled(selJoint != null && selJoint.children.length == 0);
        this.skeletonMenuItem[2].setEnabled(selJoint != null);
        this.skeletonMenuItem[4].setEnabled(count > 0);
        this.skeletonMenuItem[5].setEnabled(selJoint != null);
        boolean[] selected = this.getSelection();
        boolean enable = view.getSelectedJoint() > 0;
        for (int i2 = 0; i2 < selected.length; ++i2) {
            enable = selected[i2] ? true : enable;
        }
        this.fitToSelItem.setEnabled(enable);
    }

    private void addExtraParameters() {
        if (this.jointWeightParam != null) {
            return;
        }
        this.jointWeightParam = new TextureParameter(this, "Joint Weight", 0.0, 1.0, 0.0);
        SplineMesh mesh = (SplineMesh)this.getObject().getObject();
        TextureParameter[] params = mesh.getParameters();
        TextureParameter[] newparams = new TextureParameter[params.length + 1];
        ParameterValue[] values = mesh.getParameterValues();
        ParameterValue[] newvalues = new ParameterValue[values.length + 1];
        for (int i = 0; i < params.length; ++i) {
            newparams[i] = params[i];
            newvalues[i] = values[i];
        }
        newparams[params.length] = this.jointWeightParam;
        newvalues[values.length] = new VertexParameterValue(mesh, this.jointWeightParam);
        mesh.setParameters(newparams);
        mesh.setParameterValues(newvalues);
        this.getObject().clearCachedMeshes();
        this.updateJointWeightParam();
    }

    public void removeExtraParameters() {
        if (this.jointWeightParam == null) {
            return;
        }
        this.jointWeightParam = null;
        SplineMesh mesh = (SplineMesh)this.getObject().getObject();
        TextureParameter[] params = mesh.getParameters();
        TextureParameter[] newparams = new TextureParameter[params.length - 1];
        ParameterValue[] values = mesh.getParameterValues();
        ParameterValue[] newvalues = new ParameterValue[values.length - 1];
        for (int i = 0; i < newparams.length; ++i) {
            newparams[i] = params[i];
            newvalues[i] = values[i];
        }
        mesh.setParameters(newparams);
        mesh.setParameterValues(newvalues);
        this.getObject().clearCachedMeshes();
    }

    private void updateJointWeightParam() {
        MeshVertex[] vert = ((SplineMesh)this.getObject().getObject()).getVertices();
        double[] jointWeight = new double[vert.length];
        int selJointId = ((MeshViewer)this.theView[this.currentView]).getSelectedJoint();
        Joint selJoint = this.getObject().getSkeleton().getJoint(selJointId);
        for (int i = 0; i < jointWeight.length; ++i) {
            Joint vertJoint = this.getObject().getSkeleton().getJoint(vert[i].ikJoint);
            jointWeight[i] = selJoint == null ? 0.0 : (vert[i].ikJoint == selJointId ? (selJoint.parent == null ? 1.0 : vert[i].ikWeight) : (vertJoint != null && vertJoint.parent == selJoint ? 1.0 - vert[i].ikWeight : 0.0));
        }
        VertexParameterValue value = (VertexParameterValue)this.getObject().getObject().getParameterValue(this.jointWeightParam);
        value.setValue(jointWeight);
        this.getObject().getObject().setParameterValues(this.getObject().getObject().getParameterValues());
        this.lastSelectedJoint = selJointId;
        this.objInfo.clearCachedMeshes();
    }

    @Override
    public TextureParameter getJointWeightParam() {
        return this.jointWeightParam;
    }

    @Override
    protected void doOk() {
        SplineMesh theMesh = (SplineMesh)this.objInfo.getObject();
        if (((SplineMesh)this.oldMesh).getMaterial() != null) {
            if (!theMesh.isClosed()) {
                String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
                BStandardDialog dlg = new BStandardDialog("", UIUtilities.breakString(Translate.text("surfaceNoLongerClosed")), BStandardDialog.WARNING);
                int choice = dlg.showOptionDialog(this, options, options[0]);
                if (choice == 1) {
                    return;
                }
                theMesh.setMaterial(null, null);
            } else {
                theMesh.setMaterial(((SplineMesh)this.oldMesh).getMaterial(), ((SplineMesh)this.oldMesh).getMaterialMapping());
            }
        }
        this.removeExtraParameters();
        this.oldMesh.copyObject(theMesh);
        this.oldMesh = null;
        this.dispose();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    @Override
    protected void doCancel() {
        this.oldMesh = null;
        this.dispose();
    }

    private void freehandModeChanged() {
        this.setFreehand(((BCheckBoxMenuItem)this.editMenuItem[3]).getState());
    }

    private void smoothingChanged(CommandEvent ev) {
        Widget source = ev.getWidget();
        for (int i = 0; i < this.smoothItem.length; ++i) {
            if (source != this.smoothItem[i]) continue;
            this.setSmoothingMethod(i + 2);
        }
    }

    private void closedTypeChanged(CommandEvent ev) {
        Widget source = ev.getWidget();
        for (int i = 0; i < this.closedItem.length; ++i) {
            if (source != this.closedItem[i]) continue;
            this.setClosed(i);
        }
    }

    private void skeletonDetachedChanged() {
        for (int i = 0; i < this.theView.length; ++i) {
            ((SplineMeshViewer)this.theView[i]).setSkeletonDetached(((BCheckBoxMenuItem)this.skeletonMenuItem[6]).getState());
        }
    }

    @Override
    public void bindSkeletonCommand() {
        super.bindSkeletonCommand();
        this.updateJointWeightParam();
        this.updateImage();
    }

    @Override
    public void unbindSkeletonCommand() {
        super.unbindSkeletonCommand();
        this.updateJointWeightParam();
        this.updateImage();
    }

    @Override
    public void setPointsCommand() {
        super.setPointsCommand();
        this.updateJointWeightParam();
        this.updateImage();
    }

    public void selectAllCommand() {
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, this.selectMode, this.selected.clone()}));
        for (int i = 0; i < this.selected.length; ++i) {
            this.selected[i] = true;
        }
        this.setSelection(this.selected);
    }

    public void deselectAllCommand() {
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, this.selectMode, this.selected.clone()}));
        for (int i = 0; i < this.selected.length; ++i) {
            this.selected[i] = false;
        }
        this.setSelection(this.selected);
    }

    public void extendSelectionCommand() {
        SplineMesh theMesh = (SplineMesh)this.objInfo.getObject();
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, this.selectMode, this.selected.clone()}));
        if (this.selectMode == 0) {
            int oldDist = this.tensionDistance;
            this.tensionDistance = 1;
            int[] dist = this.getSelectionDistance();
            boolean[] selected = new boolean[dist.length];
            this.tensionDistance = oldDist;
            for (int i = 0; i < dist.length; ++i) {
                selected[i] = dist[i] == 0 || dist[i] == 1;
            }
            this.setSelection(selected);
        } else {
            int i;
            boolean[] oldSelection = this.selected;
            boolean[] newSelection = new boolean[oldSelection.length];
            int usize = theMesh.getUSize();
            int vsize = theMesh.getVSize();
            for (i = 0; i < usize - 1; ++i) {
                if (!oldSelection[i] && !oldSelection[i + 1]) continue;
                newSelection[i + 1] = true;
                newSelection[i] = true;
            }
            if (theMesh.isUClosed() && (oldSelection[0] || oldSelection[usize - 1])) {
                newSelection[usize - 1] = true;
                newSelection[0] = true;
            }
            for (i = 0; i < vsize - 1; ++i) {
                if (!oldSelection[usize + i] && !oldSelection[usize + i + 1]) continue;
                newSelection[usize + i + 1] = true;
                newSelection[usize + i] = true;
            }
            if (theMesh.isVClosed() && (oldSelection[usize] || oldSelection[usize + vsize - 1])) {
                newSelection[usize + vsize - 1] = true;
                newSelection[usize] = true;
            }
            this.setSelection(newSelection);
        }
    }

    public void invertSelectionCommand() {
        boolean[] newSel = new boolean[this.selected.length];
        for (int i = 0; i < newSel.length; ++i) {
            newSel[i] = !this.selected[i];
        }
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, this.selectMode, this.selected}));
        this.setSelection(newSel);
    }

    @Override
    public void deleteCommand() {
        int i;
        if (!this.topology) {
            return;
        }
        int unum = 0;
        int vnum = 0;
        SplineMesh theMesh = (SplineMesh)this.objInfo.getObject();
        float[] us = theMesh.getUSmoothness();
        float[] vs = theMesh.getVSmoothness();
        MeshVertex[] vt = theMesh.getVertices();
        int usize = theMesh.getUSize();
        int vsize = theMesh.getVSize();
        if (this.selectMode != 1) {
            return;
        }
        for (i = 0; i < usize; ++i) {
            if (!this.selected[i]) continue;
            ++unum;
        }
        for (i = 0; i < vsize; ++i) {
            if (!this.selected[i + usize]) continue;
            ++vnum;
        }
        if (unum == 0 && vnum == 0) {
            return;
        }
        if (usize - unum < 2 || vsize - vnum < 2) {
            new BStandardDialog("", Translate.text("curveNeeds2Points"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        if (theMesh.isUClosed() && usize - unum < 3 || theMesh.isVClosed() && vsize - vnum < 3) {
            new BStandardDialog("", Translate.text("curveNeeds3Points"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        MeshVertex[][] v = new MeshVertex[usize - unum][vsize - vnum];
        float[] newus = new float[usize - unum];
        float[] newvs = new float[vsize - vnum];
        int j = 0;
        for (i = 0; i < usize; ++i) {
            if (this.selected[i]) continue;
            int m = 0;
            for (int k = 0; k < vsize; ++k) {
                if (this.selected[k + usize]) continue;
                newvs[m] = vs[k];
                v[j][m++] = vt[i + k * usize];
            }
            newus[j++] = us[i];
        }
        theMesh.setShape(v, newus, newvs);
        this.setMesh(theMesh);
        this.updateImage();
    }

    void subdivideCommand() {
        double[] val;
        int k;
        int j;
        int i;
        int numParam;
        SplineMesh theMesh = (SplineMesh)this.objInfo.getObject();
        MeshVertex[] vt = theMesh.getVertices();
        float[] us = theMesh.getUSmoothness();
        float[] vs = theMesh.getVSmoothness();
        int usplitcount = 0;
        int vsplitcount = 0;
        int usize = theMesh.getUSize();
        int vsize = theMesh.getVSize();
        int n = numParam = theMesh.getParameters() == null ? 0 : theMesh.getParameters().length;
        if (this.selectMode != 1) {
            return;
        }
        for (i = 0; !this.selected[i] && i < this.selected.length; ++i) {
        }
        if (i == this.selected.length) {
            return;
        }
        boolean[] splitu = theMesh.isUClosed() ? new boolean[usize] : new boolean[usize - 1];
        for (i = 0; i < splitu.length; ++i) {
            if (!this.selected[i] || !this.selected[(i + 1) % usize]) continue;
            splitu[i] = true;
            ++usplitcount;
        }
        boolean[] splitv = theMesh.isVClosed() ? new boolean[vsize] : new boolean[vsize - 1];
        for (i = 0; i < splitv.length; ++i) {
            if (!this.selected[i + usize] || !this.selected[(i + 1) % vsize + usize]) continue;
            splitv[i] = true;
            ++vsplitcount;
        }
        float[] newus = new float[usize + usplitcount];
        float[] newvs = new float[vsize + vsplitcount];
        boolean[] newsel = new boolean[this.selected.length + usplitcount + vsplitcount];
        MeshVertex[][] v = new MeshVertex[vsize][usize];
        for (i = 0; i < usize; ++i) {
            for (j = 0; j < vsize; ++j) {
                v[j][i] = vt[i + j * usize];
            }
        }
        MeshVertex[][] newv = new MeshVertex[vsize][usize + usplitcount];
        double[][][] param = new double[vsize][usize][numParam];
        for (k = 0; k < numParam; ++k) {
            if (!(theMesh.getParameterValues()[k] instanceof VertexParameterValue)) continue;
            val = ((VertexParameterValue)theMesh.getParameterValues()[k]).getValue();
            for (i = 0; i < usize; ++i) {
                for (j = 0; j < vsize; ++j) {
                    param[j][i][k] = val[i + usize * j];
                }
            }
        }
        double[][][] newparam = new double[vsize][usize + usplitcount][numParam];
        this.splitOneAxis(v, newv, us, newus, splitu, param, newparam, theMesh.isUClosed());
        v = new MeshVertex[usize + usplitcount][vsize];
        for (i = 0; i < v.length; ++i) {
            for (j = 0; j < v[i].length; ++j) {
                v[i][j] = newv[j][i];
            }
        }
        newv = new MeshVertex[usize + usplitcount][vsize + vsplitcount];
        param = new double[usize + usplitcount][vsize][numParam];
        for (i = 0; i < param.length; ++i) {
            for (j = 0; j < param[i].length; ++j) {
                for (k = 0; k < param[i][j].length; ++k) {
                    param[i][j][k] = newparam[j][i][k];
                }
            }
        }
        newparam = new double[usize + usplitcount][vsize + vsplitcount][numParam];
        this.splitOneAxis(v, newv, vs, newvs, splitv, param, newparam, theMesh.isVClosed());
        j = 0;
        for (i = 0; i < usize; ++i) {
            if (this.selected[i]) {
                newsel[j] = true;
            }
            if (i < splitu.length && splitu[i]) {
                newsel[++j] = true;
            }
            ++j;
        }
        j = 0;
        for (i = 0; i < vsize; ++i) {
            if (this.selected[i + usize]) {
                newsel[j + usize + usplitcount] = true;
            }
            if (i < splitv.length && splitv[i]) {
                newsel[++j + usize + usplitcount] = true;
            }
            ++j;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.setShape(newv, newus, newvs);
        for (k = 0; k < numParam; ++k) {
            if (!(theMesh.getParameterValues()[k] instanceof VertexParameterValue)) continue;
            val = new double[newus.length * newvs.length];
            for (i = 0; i < newus.length; ++i) {
                for (j = 0; j < newvs.length; ++j) {
                    val[i + newus.length * j] = newparam[i][j][k];
                }
            }
            theMesh.setParameterValue(theMesh.getParameters()[k], new VertexParameterValue(val));
        }
        this.setMesh(theMesh);
        this.setSelection(newsel);
    }

    private void splitOneAxis(MeshVertex[][] v, MeshVertex[][] newv, float[] s, float[] news, boolean[] split, double[][][] param, double[][][] newparam, boolean closed) {
        int m;
        int k;
        int i;
        SplineMesh theMesh = (SplineMesh)this.objInfo.getObject();
        int method = theMesh.getSmoothingMethod();
        int numParam = param[0][0].length;
        double[] paramTemp = new double[numParam];
        int j = 0;
        for (i = 0; i < split.length; ++i) {
            int p1 = i - 1;
            if (p1 < 0) {
                p1 = closed ? v[0].length - 1 : 0;
            }
            int p3 = i < v[0].length - 1 ? i + 1 : (closed ? 0 : v[0].length - 1);
            if ((split[i] || split[p1]) && method == 3) {
                for (k = 0; k < v.length; ++k) {
                    newv[k][j] = SplineMesh.calcApproxPoint(v[k], s, param[k], paramTemp, p1, i, p3);
                    for (m = 0; m < numParam; ++m) {
                        newparam[k][j][m] = paramTemp[m];
                    }
                }
            } else {
                for (k = 0; k < v.length; ++k) {
                    newv[k][j] = v[k][i];
                    for (m = 0; m < numParam; ++m) {
                        newparam[k][j][m] = param[k][i][m];
                    }
                }
            }
            news[j] = split[i] || split[p1] ? Math.min(s[i] * 2.0f, 1.0f) : s[i];
            if (!split[i]) {
                ++j;
                continue;
            }
            if (method == 0) {
                for (k = 0; k < v.length; ++k) {
                    newv[k][j + 1] = MeshVertex.blend(v[k][i], v[k][p3], 0.5, 0.5);
                    for (m = 0; m < numParam; ++m) {
                        newparam[k][j + 1][m] = 0.5 * (param[k][i][m] + param[k][p3][m]);
                    }
                }
            } else if (method == 2) {
                int p4 = i < v[0].length - 2 ? i + 2 : (closed ? (i + 2) % v[0].length : v[0].length - 1);
                for (k = 0; k < v.length; ++k) {
                    newv[k][j + 1] = SplineMesh.calcInterpPoint(v[k], s, param[k], paramTemp, p1, i, p3, p4);
                    for (m = 0; m < numParam; ++m) {
                        newparam[k][j + 1][m] = paramTemp[m];
                    }
                }
            } else {
                for (k = 0; k < v.length; ++k) {
                    newv[k][j + 1] = MeshVertex.blend(v[k][i], v[k][p3], 0.5, 0.5);
                    for (m = 0; m < numParam; ++m) {
                        newparam[k][j + 1][m] = 0.5 * (param[k][i][m] + param[k][p3][m]);
                    }
                }
            }
            news[j + 1] = 1.0f;
            j += 2;
        }
        if (!closed) {
            for (k = 0; k < v.length; ++k) {
                newv[k][0] = v[k][0];
                newv[k][j] = v[k][i];
                for (m = 0; m < numParam; ++m) {
                    newparam[k][0][m] = param[k][0][m];
                    newparam[k][j][m] = param[k][i][m];
                }
            }
            news[j] = s[i];
        }
    }

    void extractCurveCommand() {
        String name;
        WidgetContainer parent;
        Vec3[] v;
        boolean closed;
        int which;
        SplineMesh theMesh = (SplineMesh)this.objInfo.getObject();
        MeshVertex[] vt = theMesh.getVertices();
        int usize = theMesh.getUSize();
        int vsize = theMesh.getVSize();
        if (this.selectMode != 1) {
            return;
        }
        for (which = 0; which < this.selected.length && !this.selected[which]; ++which) {
        }
        if (which == this.selected.length) {
            return;
        }
        if (which < usize) {
            closed = theMesh.isVClosed();
            v = new Vec3[vsize];
        } else {
            closed = theMesh.isUClosed();
            v = new Vec3[usize];
        }
        float[] smoothness = new float[v.length];
        float[] usmoothness = theMesh.getUSmoothness();
        float[] vsmoothness = theMesh.getVSmoothness();
        for (int i = 0; i < v.length; ++i) {
            if (which < usize) {
                v[i] = vt[which + i * usize].r;
                smoothness[i] = vsmoothness[i];
                continue;
            }
            v[i] = vt[(which - usize) * usize + i].r;
            smoothness[i] = usmoothness[i];
        }
        Curve cv = new Curve(v, smoothness, theMesh.getSmoothingMethod(), closed);
        for (parent = this.parentWindow.getFrame(); parent != null && !(parent instanceof LayoutWindow); parent = parent.getParent()) {
        }
        if (parent != null && (name = new BStandardDialog("", Translate.text("extractedCurveName"), BStandardDialog.QUESTION).showInputDialog(this, null, "Extracted Curve")) != null) {
            ((LayoutWindow)parent).addObject(cv, ((MeshViewer)this.theView[this.currentView]).thisObjectInScene.getCoords().duplicate(), name, null);
            ((LayoutWindow)parent).updateImage();
        }
    }

    void setSmoothnessCommand() {
        int i;
        final SplineMesh theMesh = (SplineMesh)this.objInfo.getObject();
        SplineMesh oldMesh = (SplineMesh)theMesh.duplicate();
        final float[] usmoothness = theMesh.getUSmoothness();
        final float[] vsmoothness = theMesh.getVSmoothness();
        if (this.selectMode != 1) {
            return;
        }
        for (i = 0; i < this.selected.length && !this.selected[i]; ++i) {
        }
        if (i == this.selected.length) {
            return;
        }
        float value = i < theMesh.getUSize() ? usmoothness[i] : vsmoothness[i - theMesh.getUSize()];
        value = 0.001f * (float)Math.round(value * 1000.0f);
        final ValueSlider smoothness = new ValueSlider(0.0, 1.0, 100, value);
        smoothness.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                float s = (float)smoothness.getValue();
                for (int i = 0; i < SplineMeshEditorWindow.this.selected.length; ++i) {
                    if (!SplineMeshEditorWindow.this.selected[i]) continue;
                    if (i < theMesh.getUSize()) {
                        usmoothness[i] = s;
                        continue;
                    }
                    vsmoothness[i - theMesh.getUSize()] = s;
                }
                theMesh.setSmoothness(usmoothness, vsmoothness);
                SplineMeshEditorWindow.this.objectChanged();
                SplineMeshEditorWindow.this.updateImage();
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("setCurveSmoothness"), new Widget[]{smoothness}, new String[]{Translate.text("Smoothness")});
        if (dlg.clickedOk()) {
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, oldMesh}));
        } else {
            theMesh.copyObject(oldMesh);
            this.objectChanged();
            this.updateImage();
        }
    }

    void reverseNormalsCommand() {
        SplineMesh theMesh = (SplineMesh)this.objInfo.getObject();
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.reverseOrientation();
        this.objectChanged();
        this.updateImage();
    }

    void setSmoothingMethod(int method) {
        SplineMesh theMesh = (SplineMesh)this.objInfo.getObject();
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        for (int i = 0; i < this.smoothItem.length; ++i) {
            this.smoothItem[i].setState(false);
        }
        this.smoothItem[method - 2].setState(true);
        theMesh.setSmoothingMethod(method);
        this.objectChanged();
        this.updateImage();
    }

    void setClosed(int item) {
        SplineMesh theMesh = (SplineMesh)this.objInfo.getObject();
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        for (int i = 0; i < this.closedItem.length; ++i) {
            this.closedItem[i].setState(i == item);
        }
        theMesh.setClosed(item == 0 || item == 2, item == 1 || item == 2);
        this.setMesh(theMesh);
        this.updateImage();
    }

    @Override
    public void adjustDeltas(Vec3[] delta) {
        int i;
        int[] dist = this.getSelectionDistance();
        int[] count = new int[delta.length];
        SplineMesh theMesh = (SplineMesh)this.objInfo.getObject();
        int maxDistance = this.getTensionDistance();
        int usize = theMesh.getUSize();
        int vsize = theMesh.getVSize();
        double tension = this.getMeshTension();
        double[] scale = new double[maxDistance + 1];
        for (i = 0; i < delta.length; ++i) {
            if (dist[i] == 0) continue;
            delta[i].set(0.0, 0.0, 0.0);
        }
        for (i = 0; i < maxDistance; ++i) {
            int j;
            for (j = 0; j < count.length; ++j) {
                count[j] = 0;
            }
            for (j = 0; j < usize; ++j) {
                for (int k = 0; k < vsize; ++k) {
                    if (dist[j + k * usize] != i) continue;
                    if (j == 0) {
                        if (theMesh.isUClosed() && dist[usize - 1 + k * usize] == i + 1) {
                            int n = usize - 1 + k * usize;
                            count[n] = count[n] + 1;
                            delta[usize - 1 + k * usize].add(delta[j + k * usize]);
                        }
                    } else if (dist[j - 1 + k * usize] == i + 1) {
                        int n = j - 1 + k * usize;
                        count[n] = count[n] + 1;
                        delta[j - 1 + k * usize].add(delta[j + k * usize]);
                    }
                    if (j == usize - 1) {
                        if (theMesh.isUClosed() && dist[k * usize] == i + 1) {
                            int n = k * usize;
                            count[n] = count[n] + 1;
                            delta[k * usize].add(delta[j + k * usize]);
                        }
                    } else if (dist[j + 1 + k * usize] == i + 1) {
                        int n = j + 1 + k * usize;
                        count[n] = count[n] + 1;
                        delta[j + 1 + k * usize].add(delta[j + k * usize]);
                    }
                    if (k == 0) {
                        if (theMesh.isVClosed() && dist[j + (vsize - 1) * usize] == i + 1) {
                            int n = j + (vsize - 1) * usize;
                            count[n] = count[n] + 1;
                            delta[j + (vsize - 1) * usize].add(delta[j + k * usize]);
                        }
                    } else if (dist[j + (k - 1) * usize] == i + 1) {
                        int n = j + (k - 1) * usize;
                        count[n] = count[n] + 1;
                        delta[j + (k - 1) * usize].add(delta[j + k * usize]);
                    }
                    if (k == vsize - 1) {
                        if (!theMesh.isVClosed() || dist[j] != i + 1) continue;
                        dist[j + k * usize] = i + 1;
                        int n = j;
                        count[n] = count[n] + 1;
                        delta[j].add(delta[j + k * usize]);
                        continue;
                    }
                    if (dist[j + (k + 1) * usize] != i + 1) continue;
                    int n = j + (k + 1) * usize;
                    count[n] = count[n] + 1;
                    delta[j + (k + 1) * usize].add(delta[j + k * usize]);
                }
            }
            for (j = 0; j < count.length; ++j) {
                if (count[j] <= 1) continue;
                delta[j].scale(1.0 / (double)count[j]);
            }
        }
        for (i = 0; i < scale.length; ++i) {
            scale[i] = Math.pow(((double)(maxDistance - i) + 1.0) / ((double)maxDistance + 1.0), tension);
        }
        for (i = 0; i < delta.length; ++i) {
            if (dist[i] <= 0) continue;
            delta[i].scale(scale[dist[i]]);
        }
    }
}

