/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.UndoRecord;
import java.util.LinkedList;

public class UndoStack {
    private final LinkedList<UndoRecord> undoList = new LinkedList();
    private final LinkedList<UndoRecord> redoList = new LinkedList();

    public boolean canUndo() {
        return this.undoList.size() > 0;
    }

    public boolean canRedo() {
        return this.redoList.size() > 0;
    }

    public void addRecord(UndoRecord record) {
        int levels = ArtOfIllusion.getPreferences().getUndoLevels();
        if (levels < 1) {
            levels = 1;
        }
        while (this.undoList.size() >= levels) {
            this.undoList.removeFirst();
        }
        this.undoList.add(record);
        this.redoList.clear();
        record.cacheToDisk();
    }

    public void executeUndo() {
        if (this.undoList.isEmpty()) {
            return;
        }
        UndoRecord record = this.undoList.removeLast();
        this.redoList.add(record.execute());
    }

    public void executeRedo() {
        if (this.redoList.isEmpty()) {
            return;
        }
        UndoRecord record = this.redoList.removeLast();
        this.undoList.add(record.execute());
    }
}

