/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.SVD;
import artofillusion.math.Vec3;
import java.util.Vector;

public class IKSolver {
    private Skeleton skeleton;
    private Joint[] joint;
    private int[] behavior;
    private int[][] downstream;
    private boolean[] forbid;
    private boolean[] forbidTwist;
    private Vec3[] originalPos;
    private int[][] dofIndex;
    private int[] jointBase;
    private int numDOF;
    private int numNonFloating;
    private static final int FREE = 0;
    private static final int FIXED = 1;
    private static final int TARGET = 2;
    private static final int FLOATING = 3;

    public IKSolver(Skeleton s, boolean[] locked, boolean[] moving) {
        int i;
        this.skeleton = s;
        this.joint = s.getJoints();
        this.findDownstreamJoints();
        this.findJointBehaviors(locked, moving);
        this.findForbiddenDOF();
        this.originalPos = new Vec3[this.joint.length];
        for (i = 0; i < this.originalPos.length; ++i) {
            this.originalPos[i] = this.joint[i].coords.getOrigin();
        }
        this.dofIndex = new int[this.joint.length][];
        for (i = 0; i < this.joint.length; ++i) {
            int n;
            int n2;
            int n3;
            int n4;
            Joint j = this.joint[i];
            if (j.parent == null) {
                if (this.forbid[i]) continue;
                this.dofIndex[i] = new int[]{this.numDOF++, this.numDOF++, this.numDOF++};
                continue;
            }
            this.dofIndex[i] = new int[4];
            int[] nArray = this.dofIndex[i];
            if (j.length.fixed || this.forbid[i]) {
                n4 = -1;
            } else {
                int n5 = this.numDOF;
                n4 = n5;
                this.numDOF = n5 + 1;
            }
            nArray[0] = n4;
            int[] nArray2 = this.dofIndex[i];
            if (j.angle1.fixed || this.forbid[i]) {
                n3 = -1;
            } else {
                int n6 = this.numDOF;
                n3 = n6;
                this.numDOF = n6 + 1;
            }
            nArray2[1] = n3;
            int[] nArray3 = this.dofIndex[i];
            if (j.angle2.fixed || this.forbid[i]) {
                n2 = -1;
            } else {
                int n7 = this.numDOF;
                n2 = n7;
                this.numDOF = n7 + 1;
            }
            nArray3[2] = n2;
            int[] nArray4 = this.dofIndex[i];
            if (j.twist.fixed || this.forbidTwist[i]) {
                n = -1;
            } else {
                int n8 = this.numDOF;
                n = n8;
                this.numDOF = n8 + 1;
            }
            nArray4[3] = n;
        }
        this.jointBase = new int[this.joint.length];
        for (i = 0; i < this.joint.length; ++i) {
            if (this.behavior[i] == 3) continue;
            this.jointBase[i] = this.numNonFloating * 3;
            ++this.numNonFloating;
        }
    }

    private void findJointBehaviors(boolean[] locked, boolean[] moving) {
        int i;
        int i2;
        this.behavior = new int[locked.length];
        for (i2 = 0; i2 < this.behavior.length; ++i2) {
            this.behavior[i2] = moving[i2] ? 2 : 1;
        }
        for (i2 = 0; i2 < moving.length; ++i2) {
            if (!moving[i2]) continue;
            this.tagFreeJoints(i2, locked);
        }
        boolean[] isFloating = new boolean[this.joint.length];
        for (i = 0; i < this.joint.length; ++i) {
            int k;
            if (this.behavior[i] != 0) continue;
            for (k = 0; k < this.downstream[i].length && this.behavior[this.downstream[i][k]] == 0; ++k) {
            }
            if (k == this.downstream[i].length) {
                isFloating[i] = true;
                continue;
            }
            Joint j = this.joint[i];
            Joint parent = this.joint[i].parent;
            while (parent != null && this.behavior[this.skeleton.findJointIndex(parent.id)] == 0) {
                parent = parent.parent;
            }
            if (parent != null) continue;
            isFloating[i] = true;
        }
        for (i = 0; i < isFloating.length; ++i) {
            if (!isFloating[i]) continue;
            this.behavior[i] = 3;
        }
    }

    private void tagFreeJoints(int index, boolean[] locked) {
        int parentIndex;
        if (this.behavior[index] == 1) {
            this.behavior[index] = 0;
        }
        Joint j = this.joint[index];
        if (j.parent != null && this.behavior[parentIndex = this.skeleton.findJointIndex(j.parent.id)] == 1 && !locked[parentIndex]) {
            this.tagFreeJoints(parentIndex, locked);
        }
        for (int i = 0; i < j.children.length; ++i) {
            int childIndex = this.skeleton.findJointIndex(j.children[i].id);
            if (this.behavior[childIndex] != 1 || locked[childIndex]) continue;
            this.tagFreeJoints(childIndex, locked);
        }
    }

    private void findDownstreamJoints() {
        this.downstream = new int[this.joint.length][];
        for (int i = 0; i < this.joint.length; ++i) {
            Vector<Joint> v = new Vector<Joint>();
            this.addDownstreamJoints(v, this.joint[i]);
            this.downstream[i] = new int[v.size()];
            for (int k = 0; k < this.downstream[i].length; ++k) {
                this.downstream[i][k] = this.skeleton.findJointIndex(v.get((int)k).id);
            }
        }
    }

    private void addDownstreamJoints(Vector<Joint> v, Joint j) {
        v.add(j);
        for (Joint child : j.children) {
            this.addDownstreamJoints(v, child);
        }
    }

    private void findForbiddenDOF() {
        this.forbid = new boolean[this.joint.length];
        this.forbidTwist = new boolean[this.joint.length];
        block0: for (int i = 0; i < this.joint.length; ++i) {
            if (this.behavior[i] != 1 || this.joint[i].parent != null && this.behavior[this.skeleton.findJointIndex(this.joint[i].parent.id)] != 1) continue;
            if (this.joint[i].parent == null || this.joint[i].parent.parent == null || this.behavior[this.skeleton.findJointIndex(this.joint[i].parent.parent.id)] == 1) {
                this.forbid[i] = true;
            }
            for (int j = 0; j < this.joint[i].children.length; ++j) {
                if (this.behavior[this.skeleton.findJointIndex(this.joint[i].children[j].id)] != 1) continue;
                this.forbidTwist[i] = true;
                continue block0;
            }
        }
    }

    private double[] calcForces(Vec3[] target, double[] prevForce) {
        int i;
        double[] dofScale = new double[this.numDOF];
        for (int i2 = 0; i2 < this.joint.length; ++i2) {
            Joint j = this.joint[i2];
            if (j.parent == null) continue;
            if (this.dofIndex[i2][0] > -1) {
                dofScale[this.dofIndex[i2][0]] = j.length.getForceScale(prevForce[this.dofIndex[i2][0]]);
            }
            if (this.dofIndex[i2][1] > -1) {
                dofScale[this.dofIndex[i2][1]] = j.angle1.getForceScale(prevForce[this.dofIndex[i2][1]]);
            }
            if (this.dofIndex[i2][2] > -1) {
                dofScale[this.dofIndex[i2][2]] = j.angle2.getForceScale(prevForce[this.dofIndex[i2][2]]);
            }
            if (this.dofIndex[i2][3] <= -1) continue;
            dofScale[this.dofIndex[i2][3]] = j.twist.getForceScale(prevForce[this.dofIndex[i2][3]]);
        }
        double[][] matrix = new double[this.numNonFloating * 3][this.numDOF];
        Vec3 temp = new Vec3();
        for (int i3 = 0; i3 < this.joint.length; ++i3) {
            Joint j = this.joint[i3];
            if (j.parent == null) {
                if (this.forbid[i3]) continue;
                if (this.behavior[i3] != 3) {
                    matrix[this.jointBase[i3]][this.dofIndex[i3][0]] = 1.0;
                    matrix[this.jointBase[i3] + 1][this.dofIndex[i3][1]] = 1.0;
                    matrix[this.jointBase[i3] + 2][this.dofIndex[i3][2]] = 1.0;
                }
                for (int k = 0; k < this.downstream[i3].length; ++k) {
                    int index = this.downstream[i3][k];
                    if (this.behavior[index] == 3) continue;
                    matrix[this.jointBase[index]][this.dofIndex[i3][0]] = 1.0;
                    matrix[this.jointBase[index] + 1][this.dofIndex[i3][1]] = 1.0;
                    matrix[this.jointBase[index] + 2][this.dofIndex[i3][2]] = 1.0;
                }
                continue;
            }
            Vec3 zdir = j.coords.getZDirection();
            CoordinateSystem parentCoords = j.parent.coords;
            double c1 = Math.cos(j.angle1.pos * Math.PI / 180.0);
            double s1 = Math.sin(j.angle1.pos * Math.PI / 180.0);
            double c2 = Math.cos(j.angle2.pos * Math.PI / 180.0);
            double s2 = Math.sin(j.angle2.pos * Math.PI / 180.0);
            double ct = Math.cos(j.twist.pos * Math.PI / 180.0);
            double st = Math.sin(j.twist.pos * Math.PI / 180.0);
            for (int k = 0; k < this.downstream[i3].length; ++k) {
                int index = this.downstream[i3][k];
                if (this.behavior[index] == 3) continue;
                int base = this.jointBase[index];
                Vec3 r = this.joint[index].coords.getOrigin().minus(parentCoords.getOrigin());
                r = parentCoords.toLocal().timesDirection(r);
                r = j.getInverseTransform().timesDirection(r);
                if (!j.length.fixed && !this.forbid[i3] && dofScale[this.dofIndex[i3][0]] > 0.0) {
                    temp = zdir.times(1.0 / dofScale[this.dofIndex[i3][0]]);
                    matrix[base][this.dofIndex[i3][0]] = temp.x;
                    matrix[base + 1][this.dofIndex[i3][0]] = temp.y;
                    matrix[base + 2][this.dofIndex[i3][0]] = temp.z;
                }
                if (!j.angle1.fixed && !this.forbid[i3] && dofScale[this.dofIndex[i3][1]] > 0.0) {
                    temp = new Vec3(c1 * s2 * st * r.x + c1 * s2 * ct * r.y - s1 * s2 * r.z, -s1 * st * r.x - s1 * ct * r.y - c1 * r.z, c1 * c2 * st * r.x + c1 * c2 * ct * r.y - s1 * c2 * r.z);
                    parentCoords.fromLocal().transformDirection(temp);
                    temp.scale(1.0 / dofScale[this.dofIndex[i3][1]]);
                    matrix[base][this.dofIndex[i3][1]] = temp.x;
                    matrix[base + 1][this.dofIndex[i3][1]] = temp.y;
                    matrix[base + 2][this.dofIndex[i3][1]] = temp.z;
                }
                if (!j.angle2.fixed && !this.forbid[i3] && dofScale[this.dofIndex[i3][2]] > 0.0) {
                    temp = new Vec3((s1 * c2 * st - s2 * ct) * r.x + (s1 * c2 * ct + s2 * st) * r.y + c1 * c2 * r.z, 0.0, -(c2 * ct + s1 * s2 * st) * r.x + (c2 * st - s1 * s2 * ct) * r.y - c1 * s2 * r.z);
                    parentCoords.fromLocal().transformDirection(temp);
                    temp.scale(1.0 / dofScale[this.dofIndex[i3][2]]);
                    matrix[base][this.dofIndex[i3][2]] = temp.x;
                    matrix[base + 1][this.dofIndex[i3][2]] = temp.y;
                    matrix[base + 2][this.dofIndex[i3][2]] = temp.z;
                }
                if (j.twist.fixed || this.forbidTwist[i3] || !(dofScale[this.dofIndex[i3][3]] > 0.0)) continue;
                temp = new Vec3((s1 * s2 * ct - c2 * st) * r.x - (c2 * ct + s1 * s2 * st) * r.y, c1 * ct * r.x - c1 * st * r.y, (s1 * c2 * ct + s2 * st) * r.x + (s2 * ct - s1 * c2 * st) * r.y);
                parentCoords.fromLocal().transformDirection(temp);
                temp.scale(1.0 / dofScale[this.dofIndex[i3][3]]);
                matrix[base][this.dofIndex[i3][3]] = temp.x;
                matrix[base + 1][this.dofIndex[i3][3]] = temp.y;
                matrix[base + 2][this.dofIndex[i3][3]] = temp.z;
            }
        }
        double[] rhs = new double[Math.max(this.numDOF, this.numNonFloating * 3)];
        for (i = 0; i < this.joint.length; ++i) {
            if (target[i] == null) continue;
            Vec3 pos = this.joint[i].coords.getOrigin();
            rhs[this.jointBase[i]] = target[i].x - pos.x;
            rhs[this.jointBase[i] + 1] = target[i].y - pos.y;
            rhs[this.jointBase[i] + 2] = target[i].z - pos.z;
        }
        SVD.solve(matrix, rhs, 0.01);
        for (i = 0; i < this.joint.length; ++i) {
            Joint j = this.joint[i];
            if (j.parent == null) continue;
            if (this.dofIndex[i][0] > -1) {
                rhs[this.dofIndex[i][0]] = j.length.getClippedForce(rhs[this.dofIndex[i][0]] * dofScale[this.dofIndex[i][0]]);
            }
            if (this.dofIndex[i][1] > -1) {
                rhs[this.dofIndex[i][1]] = j.angle1.getClippedForce(rhs[this.dofIndex[i][1]] * dofScale[this.dofIndex[i][1]] * 180.0 / Math.PI);
            }
            if (this.dofIndex[i][2] > -1) {
                rhs[this.dofIndex[i][2]] = j.angle2.getClippedForce(rhs[this.dofIndex[i][2]] * dofScale[this.dofIndex[i][2]] * 180.0 / Math.PI);
            }
            if (this.dofIndex[i][3] <= -1) continue;
            rhs[this.dofIndex[i][3]] = j.twist.getClippedForce(rhs[this.dofIndex[i][3]] * dofScale[this.dofIndex[i][3]] * 180.0 / Math.PI);
        }
        return rhs;
    }

    private void step(double[] force, double scale) {
        int i;
        for (i = 0; i < this.joint.length; ++i) {
            Joint j = this.joint[i];
            if (j.parent == null) continue;
            if (this.dofIndex[i][0] > -1) {
                j.length.set(j.length.pos + force[this.dofIndex[i][0]] * scale);
            }
            if (this.dofIndex[i][1] > -1) {
                j.angle1.set(j.angle1.pos + force[this.dofIndex[i][1]] * scale);
            }
            if (this.dofIndex[i][2] > -1) {
                j.angle2.set(j.angle2.pos + force[this.dofIndex[i][2]] * scale);
            }
            if (this.dofIndex[i][3] <= -1) continue;
            j.twist.set(j.twist.pos + force[this.dofIndex[i][3]] * scale);
        }
        for (i = 0; i < this.joint.length; ++i) {
            if (this.joint[i].parent != null) continue;
            if (!this.forbid[i]) {
                CoordinateSystem c = this.joint[i].coords;
                c.setOrigin(c.getOrigin().plus(new Vec3(force[this.dofIndex[i][0]] * scale, force[this.dofIndex[i][1]] * scale, force[this.dofIndex[i][2]] * scale)));
            }
            this.joint[i].recalcCoords(true);
        }
    }

    public boolean solve(Vec3[] target, int maxSteps) {
        int count;
        Skeleton prevSkeleton = this.skeleton.duplicate();
        Joint[] prevJoint = prevSkeleton.getJoints();
        Vec3[] currentTarget = new Vec3[target.length];
        double maxDist = 0.0;
        for (int i = 0; i < this.joint.length; ++i) {
            double dist;
            if (this.behavior[i] != 2 || !((dist = target[i].minus(this.originalPos[i]).length()) > maxDist)) continue;
            maxDist = dist;
        }
        double scale = 0.1;
        double[] prevForce = new double[this.numDOF];
        for (count = 0; count < maxSteps && scale * maxDist > 1.0E-4; ++count) {
            for (int i = 0; i < this.joint.length; ++i) {
                if (this.behavior[i] == 1) {
                    currentTarget[i] = this.originalPos[i];
                    continue;
                }
                if (this.behavior[i] != 2) continue;
                Vec3 pos = prevJoint[i].coords.getOrigin();
                currentTarget[i] = pos.plus(target[i].minus(pos).times(scale));
            }
            Skeleton currentSkeleton = prevSkeleton.duplicate();
            this.joint = currentSkeleton.getJoints();
            double[] force = this.calcForces(currentTarget, prevForce);
            double numerator = 0.0;
            double denominator = 0.0;
            for (int i = 0; i < this.numDOF; ++i) {
                double prod = force[i] * prevForce[i];
                numerator += prod;
                denominator += prod > 0.0 ? prod : -prod;
            }
            double stepSize = 1.0 + 0.5 * (denominator > 0.0 ? numerator / denominator : 0.0);
            this.step(force, stepSize);
            boolean error = false;
            boolean done = true;
            double fixedTol = 1.0E-6;
            double targetTol = 1.0E-8 * scale * scale;
            for (int i = 0; i < this.joint.length; ++i) {
                double oldDist;
                double distMoved2 = this.joint[i].coords.getOrigin().minus(prevJoint[i].coords.getOrigin()).length2();
                if (this.behavior[i] == 1) {
                    double newDist2 = this.joint[i].coords.getOrigin().minus(this.originalPos[i]).length2();
                    double oldDist2 = prevJoint[i].coords.getOrigin().minus(this.originalPos[i]).length2();
                    if (newDist2 > fixedTol) {
                        error = true;
                    }
                }
                if (this.behavior[i] != 2 || !(distMoved2 > targetTol)) continue;
                double newDist = this.joint[i].coords.getOrigin().minus(target[i]).length();
                if (newDist > (oldDist = prevJoint[i].coords.getOrigin().minus(target[i]).length())) {
                    error = true;
                    continue;
                }
                if (!(oldDist - newDist > 0.001 * oldDist * scale)) continue;
                done = false;
            }
            if (error) {
                scale *= 0.5;
                continue;
            }
            prevSkeleton = currentSkeleton;
            prevJoint = this.joint;
            prevForce = force;
            scale = scale < 0.5 ? 2.0 * scale : 1.0;
            if (error || !done) continue;
            break;
        }
        this.skeleton.copy(prevSkeleton);
        return count < maxSteps;
    }
}

