/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.ObjectRefTreeElement;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.TreeList;
import artofillusion.ui.UIUtilities;
import buoy.widget.BButton;
import buoy.widget.BLabel;
import buoy.widget.BScrollPane;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Dimension;

public class ObjectRefSelector
extends RowContainer {
    private final BLabel nameLabel;
    private BButton setButton;
    private ObjectRef ref;
    private LayoutWindow window;
    private String prompt;
    private ObjectInfo exclude;

    public ObjectRefSelector(ObjectRef obj, LayoutWindow win, String prompt, ObjectInfo exclude) {
        this.ref = obj.duplicate();
        this.window = win;
        this.prompt = prompt;
        this.exclude = exclude;
        this.setButton = Translate.button("set", this, "buttonPressed");
        this.add(this.setButton);
        this.nameLabel = new BLabel(obj.toString()){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                if (dim.width < 150) {
                    dim.width = 150;
                }
                return dim;
            }
        };
        this.add(this.nameLabel);
    }

    public ObjectRef getSelection() {
        return this.ref;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.setButton.setEnabled(enable);
        this.nameLabel.setEnabled(enable);
    }

    private void buttonPressed() {
        TreeList tree = new TreeList(this.window);
        Scene sc = this.window.getScene();
        tree.setUpdateEnabled(false);
        for (ObjectInfo info : sc.getObjects()) {
            if (info.getParent() != null) continue;
            tree.addElement(new ObjectRefTreeElement(new ObjectRef(info), null, tree, this.exclude));
        }
        tree.setUpdateEnabled(true);
        tree.setPreferredSize(new Dimension(250, 100));
        tree.setAllowMultiple(false);
        tree.setBackground(Color.white);
        tree.setSelected(this.ref, true);
        tree.expandToShowObject(this.ref);
        BScrollPane p = new BScrollPane(tree){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(150, 200);
            }
        };
        p.setForceWidth(true);
        p.setForceHeight(true);
        ComponentsDialog dlg = new ComponentsDialog(UIUtilities.findWindow(this), this.prompt, new Widget[]{p}, new String[]{null});
        if (!dlg.clickedOk()) {
            return;
        }
        Object[] sel = tree.getSelectedObjects();
        this.ref = sel.length > 0 ? (ObjectRef)sel[0] : new ObjectRef();
        this.nameLabel.setText(this.ref.toString());
    }
}

