/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.animation.Track;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeList;
import java.util.Vector;

public class TrackTreeElement
extends TreeElement {
    Track theTrack;

    public TrackTreeElement(Track tr, TreeElement parent, TreeList tree) {
        this.theTrack = tr;
        this.parent = parent;
        this.tree = tree;
        this.children = new Vector();
        Track[] subtracks = tr.getSubtracks();
        for (int i = 0; i < subtracks.length; ++i) {
            this.children.add(new TrackTreeElement(subtracks[i], this, tree));
        }
    }

    @Override
    public String getLabel() {
        return this.theTrack.getName();
    }

    @Override
    public boolean canAcceptAsParent(TreeElement el) {
        if (el == null) {
            return false;
        }
        return this.theTrack.canAcceptAsParent(el.getObject());
    }

    @Override
    public void addChild(TreeElement el, int position) {
        this.children.add(position, el);
        ((TrackTreeElement)el).parent = this;
    }

    @Override
    public void removeChild(Object object) {
    }

    @Override
    public Object getObject() {
        return this.theTrack;
    }

    @Override
    public boolean isGray() {
        return !this.theTrack.isEnabled();
    }
}

