/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.animation.distortion.Distortion;
import artofillusion.math.FastRandom;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.ConstantParameterValue;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.FaceVertexParameterValue;
import artofillusion.texture.ParameterValue;
import java.util.Random;

public class ShatterDistortion
extends Distortion {
    private double time;
    private double size;
    private double speed;
    private double randomness;
    private double gravity;
    private double spin;
    private double disappear;
    private int gravityAxis;
    private Mat4 gravityDirTransform;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;

    public ShatterDistortion(double time, double size, double speed, double randomness, double gravity, double spin, double disappear, int gravityAxis, Mat4 gravityDirTransform) {
        this.time = time;
        this.size = size;
        this.speed = speed;
        this.randomness = randomness;
        this.gravity = gravity;
        this.spin = spin;
        this.disappear = disappear;
        this.gravityAxis = gravityAxis;
        this.gravityDirTransform = gravityDirTransform;
    }

    @Override
    public boolean isIdenticalTo(Distortion d) {
        if (!(d instanceof ShatterDistortion)) {
            return false;
        }
        ShatterDistortion s = (ShatterDistortion)d;
        if (this.previous != null && !this.previous.isIdenticalTo(s.previous)) {
            return false;
        }
        if (this.previous == null && s.previous != null) {
            return false;
        }
        if (this.time != s.time || this.size != s.size || this.speed != s.speed || this.randomness != s.randomness || this.gravity != s.gravity || this.spin != s.spin || this.disappear != s.disappear || this.gravityAxis != s.gravityAxis) {
            return false;
        }
        if (this.gravityDirTransform == s.gravityDirTransform) {
            return true;
        }
        return this.gravityDirTransform != null && this.gravityDirTransform.equals(s.gravityDirTransform);
    }

    @Override
    public Distortion duplicate() {
        ShatterDistortion d = new ShatterDistortion(this.time, this.size, this.speed, this.randomness, this.gravity, this.spin, this.disappear, this.gravityAxis, this.gravityDirTransform);
        if (this.previous != null) {
            d.previous = this.previous.duplicate();
        }
        return d;
    }

    @Override
    public Mesh transform(Mesh obj) {
        if (this.previous != null) {
            obj = this.previous.transform(obj);
        }
        TriangleMesh mesh = obj instanceof TriangleMesh ? (TriangleMesh)obj : ((Object3D)((Object)obj)).convertToTriangleMesh(this.size);
        mesh = mesh.subdivideToLimit(this.size);
        TriangleMesh.Vertex[] vert = (TriangleMesh.Vertex[])mesh.getVertices();
        TriangleMesh.Face[] face = mesh.getFaces();
        double dist = this.speed * this.time;
        Vec3 center = new Vec3();
        Vec3 disp = new Vec3();
        FastRandom rand = new FastRandom(0L);
        int[] seed = null;
        if (this.disappear > 0.0) {
            boolean[] visible = new boolean[face.length];
            int num = 0;
            for (int i = 0; i < visible.length; ++i) {
                if (!(this.disappear * rand.nextDouble() > this.time)) continue;
                visible[i] = true;
                ++num;
            }
            TriangleMesh.Face[] shownface = new TriangleMesh.Face[num];
            seed = new int[num];
            num = 0;
            for (int i = 0; i < visible.length; ++i) {
                if (!visible[i]) continue;
                seed[num] = i;
                shownface[num++] = face[i];
            }
            face = shownface;
        } else {
            seed = new int[face.length];
            for (int i = 0; i < seed.length; ++i) {
                seed[i] = i;
            }
        }
        TriangleMesh.Vertex[] newvert = new TriangleMesh.Vertex[face.length * 3];
        int[][] newface = new int[face.length][];
        Vec3 gravityDisp = this.gravityAxis == 0 ? new Vec3(-0.5 * this.gravity * this.time * this.time, 0.0, 0.0) : (this.gravityAxis == 1 ? new Vec3(0.0, -0.5 * this.gravity * this.time * this.time, 0.0) : new Vec3(0.0, 0.0, -0.5 * this.gravity * this.time * this.time));
        if (this.gravityDirTransform != null) {
            this.gravityDirTransform.transformDirection(gravityDisp);
        }
        double third = 0.3333333333333333;
        for (int i = 0; i < face.length; ++i) {
            ((Random)rand).setSeed(seed[i]);
            TriangleMesh triangleMesh = mesh;
            triangleMesh.getClass();
            newvert[i * 3] = new TriangleMesh.Vertex(triangleMesh, vert[face[i].v1]);
            TriangleMesh triangleMesh2 = mesh;
            triangleMesh2.getClass();
            newvert[i * 3 + 1] = new TriangleMesh.Vertex(triangleMesh2, vert[face[i].v2]);
            TriangleMesh triangleMesh3 = mesh;
            triangleMesh3.getClass();
            newvert[i * 3 + 2] = new TriangleMesh.Vertex(triangleMesh3, vert[face[i].v3]);
            Vec3 v1 = newvert[i * 3].r;
            Vec3 v2 = newvert[i * 3 + 1].r;
            Vec3 v3 = newvert[i * 3 + 2].r;
            newface[i] = new int[]{i * 3, i * 3 + 1, i * 3 + 2};
            center.set(third * (v1.x + v2.x + v3.x), third * (v1.y + v2.y + v3.y), third * (v1.z + v2.z + v3.z));
            if (this.spin != 0.0) {
                Vec3 spinAxis = new Vec3(rand.nextDouble(), rand.nextDouble(), rand.nextDouble());
                spinAxis.normalize();
                Mat4 rotate = Mat4.axisRotation(spinAxis, this.time * this.spin * rand.nextDouble());
                v1.subtract(center);
                rotate.transformDirection(v1);
                v1.add(center);
                v2.subtract(center);
                rotate.transformDirection(v2);
                v2.add(center);
                v3.subtract(center);
                rotate.transformDirection(v3);
                v3.add(center);
            }
            disp.set(center.x + this.randomness * (rand.nextDouble() - 0.5), center.y + this.randomness * (rand.nextDouble() - 0.5), center.z + this.randomness * (rand.nextDouble() - 0.5));
            disp.normalize();
            if (this.randomness != 0.0) {
                disp.scale(1.0 - this.randomness);
                disp.x += this.randomness * (rand.nextDouble() - 0.5);
                disp.y += this.randomness * (rand.nextDouble() - 0.5);
                disp.z += this.randomness * (rand.nextDouble() - 0.5);
            }
            disp.scale(dist);
            disp.add(gravityDisp);
            v1.add(disp);
            v2.add(disp);
            v3.add(disp);
        }
        mesh.setShape(newvert, newface);
        ParameterValue[] param = mesh.getParameterValues();
        for (int i = 0; i < param.length; ++i) {
            if (param[i] instanceof ConstantParameterValue || param[i] instanceof FaceParameterValue) continue;
            double[][] value = new double[face.length][3];
            for (int j = 0; j < face.length; ++j) {
                value[j][0] = param[i].getValue(j, face[j].v1, face[j].v2, face[j].v3, 1.0, 0.0, 0.0);
                value[j][1] = param[i].getValue(j, face[j].v1, face[j].v2, face[j].v3, 0.0, 1.0, 0.0);
                value[j][2] = param[i].getValue(j, face[j].v1, face[j].v2, face[j].v3, 0.0, 0.0, 1.0);
            }
            param[i] = new FaceVertexParameterValue(value);
        }
        mesh.setParameterValues(param);
        return mesh;
    }
}

