/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.ArtOfIllusion;
import artofillusion.image.ComplexImage;
import artofillusion.image.HDRImage;
import artofillusion.math.RGBColor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class HDREncoder {
    public static void writeImage(ComplexImage img, OutputStream out) throws IOException {
        int rows = img.getHeight();
        int cols = img.getWidth();
        RGBColor color = new RGBColor();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
        boolean hasAlpha = img.hasFloatData(8);
        pw.print("#?RADIANCE\n");
        pw.print("# Generated by Art of Illusion " + ArtOfIllusion.getVersion() + "\n");
        pw.print("FORMAT=32-bit_rle_rgbe\n");
        pw.print("\n");
        pw.print("-Y " + rows + " +X " + cols + "\n");
        pw.flush();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                float red = img.getPixelComponent(j, i, 4);
                float green = img.getPixelComponent(j, i, 2);
                float blue = img.getPixelComponent(j, i, 1);
                if (hasAlpha) {
                    float alpha = img.getPixelComponent(j, i, 8);
                    red *= alpha;
                    green *= alpha;
                    blue *= alpha;
                }
                color.setRGB(red, green, blue);
                int ergb = color.getERGB();
                out.write(ergb >> 16 & 0xFF);
                out.write(ergb >> 8 & 0xFF);
                out.write(ergb & 0xFF);
                out.write(ergb >> 24 & 0xFF);
            }
        }
        out.flush();
    }

    public static void writeImage(HDRImage img, OutputStream out) throws IOException {
        int rows = img.getHeight();
        int cols = img.getWidth();
        byte[][] bytes = img.getBytes();
        RGBColor color = new RGBColor();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
        pw.print("#?RADIANCE\n");
        pw.print("# Saved by Art of Illusion " + ArtOfIllusion.getVersion() + "\n");
        pw.print("FORMAT=32-bit_rle_rgbe\n");
        pw.print("\n");
        pw.print("-Y " + rows + " +X " + cols + "\n");
        pw.flush();
        int pixels = rows * cols;
        for (int p = 0; p < pixels; ++p) {
            out.write(bytes[0][p]);
            out.write(bytes[1][p]);
            out.write(bytes[2][p]);
            out.write(bytes[3][p]);
        }
        out.flush();
    }
}

