/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.ArtOfIllusion;
import artofillusion.Scene;
import artofillusion.image.ExternalImage;
import artofillusion.image.ImageDetailsDialog;
import artofillusion.image.ImageMap;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ImageFileChooser;
import artofillusion.ui.ThemeManager;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.KeyPressedEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.RepaintEvent;
import buoy.event.WindowClosingEvent;
import buoy.event.WindowResizedEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BDialog;
import buoy.widget.BFileChooser;
import buoy.widget.BLabel;
import buoy.widget.BScrollBar;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.ColumnContainer;
import buoy.widget.CustomWidget;
import buoy.widget.FormContainer;
import buoy.widget.GridContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.widget.WindowWidget;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JViewport;
import javax.swing.Timer;

public class ImagesDialog
extends BDialog {
    private Scene theScene;
    private WindowWidget parent;
    private int selection;
    private int dialogHeight;
    private int dialogWidth;
    private int frameWidth;
    private int cOff = 0;
    private BScrollPane sp;
    private ImagesCanvas ic;
    private BButton[] b;
    private Color selectedColor;
    private int previewSize = 100;
    private int canvasWidth = 5;
    private LayoutInfo fillTight;
    private LayoutInfo fillLoose;
    private LayoutInfo fillLowRight;
    private ImageMap selectedImage;
    private Timer timer;

    public ImagesDialog(WindowWidget fr, Scene sc, ImageMap selected) {
        super(fr, "Images", true);
        this.selectedImage = selected;
        this.parent = fr;
        this.theScene = sc;
        this.selectedColor = ThemeManager.getSelectedColorSet().viewerHighlight;
        BorderContainer content = new BorderContainer();
        ColumnContainer buttonContainer = new ColumnContainer();
        ColumnContainer buttonArea = new ColumnContainer();
        GridContainer buttonGridUp = new GridContainer(3, 2);
        GridContainer buttonGridLow = new GridContainer(3, 1);
        this.setContent(content);
        this.selection = 0;
        while (this.selection < sc.getNumImages() && sc.getImage(this.selection) != selected) {
            ++this.selection;
        }
        if (this.selection == sc.getNumImages()) {
            this.selection = -1;
        }
        this.sp = new BScrollPane(BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_ALWAYS);
        this.ic = new ImagesCanvas(this.canvasWidth);
        this.sp.setContent(this.ic);
        content.add(this.sp, BorderContainer.CENTER);
        content.add(buttonContainer, BorderContainer.SOUTH);
        buttonContainer.add(buttonArea, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 0, 0, 0), null));
        buttonArea.add(buttonGridUp, new LayoutInfo(LayoutInfo.SOUTH, LayoutInfo.NONE, new Insets(10, 0, 0, 0), null));
        buttonArea.add(buttonGridLow, new LayoutInfo(LayoutInfo.NORTH, LayoutInfo.NONE, new Insets(0, 0, 10, 0), null));
        this.b = new BButton[9];
        this.fillTight = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH);
        this.fillLoose = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(2, 2, 2, 2), new Dimension(0, 0));
        this.b[0] = Translate.button("load", "...", this, "doLoad");
        buttonGridUp.add(this.b[0], 0, 0, this.fillLoose);
        this.b[1] = Translate.button("link", "...", this, "doLink");
        buttonGridUp.add(this.b[1], 0, 1, this.fillLoose);
        this.b[2] = Translate.button("details", "...", this, "openDetailsDialog");
        buttonGridUp.add(this.b[2], 1, 0, this.fillLoose);
        this.b[3] = Translate.button("refresh", this, "doRefresh");
        buttonGridUp.add(this.b[3], 1, 1, this.fillLoose);
        this.b[4] = Translate.button("delete", "...", this, "doDelete");
        buttonGridUp.add(this.b[4], 2, 0, this.fillLoose);
        this.b[5] = Translate.button("purge", "...", this, "purge");
        buttonGridUp.add(this.b[5], 2, 1, this.fillLoose);
        this.b[6] = Translate.button("selectNone", this, "doSelectNone");
        buttonGridLow.add(this.b[6], 0, 0, this.fillLoose);
        this.b[7] = Translate.button("ok", this, "close");
        buttonGridLow.add(this.b[7], 1, 0, this.fillLoose);
        this.b[8] = Translate.button("cancel", this, "cancel");
        buttonGridLow.add(this.b[8], 2, 0, this.fillLoose);
        this.hilightButtons();
        this.sp.setPreferredViewSize(new Dimension(this.ic.getGridWidth() * this.canvasWidth, this.ic.getGridHeight() * 4));
        this.pack();
        this.dialogWidth = this.getBounds().width;
        this.dialogHeight = this.getBounds().height;
        this.setResizable(true);
        this.addAsListener(this);
        this.addEventLink(WindowClosingEvent.class, (Object)this, "cancel");
        this.addEventLink(WindowResizedEvent.class, (Object)this, "resize");
        this.ic.scrollToSelection();
        this.ic.imagesChanged();
        UIUtilities.centerDialog(this, fr);
        this.setVisible(true);
    }

    public BufferedImage iconBackground(int size, int sqSize, int midShade, int difference) {
        Color bgColor1 = new Color(midShade - difference, midShade - difference, midShade - difference);
        Color bgColor2 = new Color(midShade + difference, midShade + difference, midShade + difference);
        int rgb1 = bgColor1.getRGB();
        int rgb2 = bgColor2.getRGB();
        int sq2 = sqSize * 2;
        BufferedImage checkers = new BufferedImage(size, size, 1);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                if (x % sq2 < sqSize && y % sq2 < sqSize || x % sq2 >= sqSize && y % sq2 >= sqSize) {
                    checkers.setRGB(x, y, rgb1);
                    continue;
                }
                checkers.setRGB(x, y, rgb2);
            }
        }
        return checkers;
    }

    public ImageMap getSelection() {
        if (this.selection < 0) {
            return null;
        }
        return this.theScene.getImage(this.selection);
    }

    private void hilightButtons() {
        this.b[2].setEnabled(this.selection >= 0);
        boolean exts = false;
        for (int i = 0; i < this.theScene.getNumImages(); ++i) {
            if (!(this.theScene.getImage(i) instanceof ExternalImage)) continue;
            exts = true;
        }
        this.b[3].setEnabled(exts);
        this.b[4].setEnabled(this.selection >= 0);
        this.b[5].setEnabled(this.theScene.getNumImages() > 0);
        this.b[6].setEnabled(this.selection >= 0);
    }

    private void doRefresh() {
        for (int i = 0; i < this.theScene.getNumImages(); ++i) {
            ImageMap imap = this.theScene.getImage(i);
            if (!(imap instanceof ExternalImage)) continue;
            ((ExternalImage)imap).refreshImage();
        }
        this.ic.imagesChanged();
        this.hilightButtons();
    }

    private void doLink() {
        ImageFileChooser fc = new ImageFileChooser(Translate.text("selectImageToLink"));
        fc.setMultipleSelectionEnabled(true);
        if (!((BFileChooser)fc).showDialog(this)) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (File file : files) {
            try {
                this.theScene.addImage(new ExternalImage(file, this.theScene));
            }
            catch (Exception ex) {
                this.setCursor(Cursor.getDefaultCursor());
                new BStandardDialog("", Translate.text("errorLoadingImage", (Object)file.getName()), BStandardDialog.ERROR).showMessageDialog(this);
                ex.printStackTrace();
                return;
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.selection = this.theScene.getNumImages() - 1;
        this.ic.imagesChanged();
        this.hilightButtons();
        this.setModified();
    }

    private void doLoad() {
        ImageFileChooser fc = new ImageFileChooser(Translate.text("selectImagesToLoad"));
        fc.setMultipleSelectionEnabled(true);
        if (!((BFileChooser)fc).showDialog(this)) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (File file : files) {
            try {
                this.theScene.addImage(ImageMap.loadImage(file));
            }
            catch (Exception ex) {
                new BStandardDialog("", Translate.text("errorLoadingImage", (Object)file.getName()), BStandardDialog.ERROR).showMessageDialog(this);
                ex.printStackTrace();
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.selection = this.theScene.getNumImages() - 1;
        this.ic.imagesChanged();
        this.hilightButtons();
        this.setModified();
    }

    private void doDelete() {
        String question;
        BStandardDialog dlg;
        String[] options = new String[]{Translate.text("Yes"), Translate.text("No")};
        String name = this.theScene.getImage(this.selection).getName();
        if (name.equals("")) {
            name = Translate.text("unNamed");
        }
        if ((dlg = new BStandardDialog(null, question = Translate.text("deleteSelectedImage") + ", \"" + name + "\" ?", BStandardDialog.QUESTION)).showOptionDialog(this, options, options[1]) == 1) {
            return;
        }
        boolean success = this.theScene.removeImage(this.selection);
        if (!success) {
            new BStandardDialog(null, UIUtilities.breakString(Translate.text("imageInUse")), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        this.selection = -1;
        this.ic.imagesChanged();
        this.hilightButtons();
        this.setModified();
    }

    private void purge() {
        new PurgeDialog(true);
        this.ic.imagesChanged();
        this.hilightButtons();
    }

    private void doSelectNone() {
        this.selection = -1;
        this.ic.imagesChanged();
        this.hilightButtons();
    }

    private void resize(WindowResizedEvent e) {
        if (this.dialogWidth == this.getBounds().width && this.dialogHeight == this.getBounds().height) {
            return;
        }
        this.dialogWidth = this.getBounds().width;
        this.dialogHeight = this.getBounds().height;
        this.ic.resized();
    }

    private void openDetailsDialog() {
        File oldFile = this.getSelection().getFile();
        new ImageDetailsDialog((WindowWidget)this, this.theScene, this.getSelection());
        this.ic.imagesChanged();
        this.ic.scrollToSelection();
        if (this.getSelection().getFile() != oldFile) {
            this.setModified();
        }
    }

    private Image loadIcon(String iconName) {
        try {
            return ImageIO.read(ExternalImage.class.getResource("/artofillusion/image/icons/" + iconName));
        }
        catch (IOException e) {
            System.out.println(e);
            return null;
        }
    }

    private void close() {
        this.dispose();
        this.removeAsListener(this);
    }

    private void cancel() {
        this.selection = 0;
        while (this.selection < this.theScene.getNumImages() && this.theScene.getImage(this.selection) != this.selectedImage) {
            ++this.selection;
        }
        this.dispose();
        this.removeAsListener(this);
    }

    private void setModified() {
        if (this.parent instanceof EditingWindow) {
            ((EditingWindow)((Object)this.parent)).setModified();
        }
    }

    private void keyPressed(KeyPressedEvent ev) {
        int code = ev.getKeyCode();
        if (code == 27) {
            this.cancel();
        }
        if (code == 10) {
            this.close();
        }
        if (code == 37) {
            this.selection = this.selection < 0 ? this.theScene.getNumImages() - 1 : Math.max(this.selection - 1, 0);
        } else if (code == 39) {
            this.selection = Math.min(this.selection + 1, this.theScene.getNumImages() - 1);
        } else if (code == 38) {
            if (this.selection < 0) {
                this.selection = this.theScene.getNumImages() - 1;
            } else if (this.selection > this.canvasWidth - 1) {
                this.selection -= this.canvasWidth;
            }
        } else if (code == 40) {
            this.selection = this.selection < 0 ? 0 : Math.min(this.selection + this.canvasWidth, this.theScene.getNumImages() - 1);
        }
        this.ic.imagesChanged();
        this.hilightButtons();
    }

    private void addAsListener(Widget w) {
        w.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        if (w instanceof WidgetContainer) {
            Iterator<Widget> iter = ((WidgetContainer)w).getChildren().iterator();
            while (iter.hasNext()) {
                this.addAsListener(iter.next());
            }
        }
    }

    private void removeAsListener(Widget w) {
        w.removeEventLink(KeyPressedEvent.class, this);
        if (w instanceof WidgetContainer) {
            Iterator<Widget> iter = ((WidgetContainer)w).getChildren().iterator();
            while (iter.hasNext()) {
                this.removeAsListener(iter.next());
            }
        }
    }

    private class PurgeDialog
    extends BDialog {
        private ColumnContainer content;
        private BButton purgeButton;
        private BButton okButton;
        private BButton cancelButton;
        private BButton selectAllButton;
        private BButton selectNoneButton;
        private LayoutInfo thumb;
        private LayoutInfo text;
        private LayoutInfo box;
        private ArrayList<ImageMap> unusedImages;
        private BCheckBox[] removeBox;

        PurgeDialog(boolean intent) {
            super(ImagesDialog.this, "Purge Images", true);
            this.thumb = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(1, 15, 1, 1), null);
            this.text = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(1, 1, 1, 1), null);
            this.box = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(1, 1, 1, 15), null);
            this.content = new ColumnContainer();
            ColumnContainer buttonArea = new ColumnContainer();
            GridContainer buttonsUp = new GridContainer(3, 1);
            GridContainer buttonsLow = new GridContainer(2, 1);
            BLabel header = Translate.label("purgeHeader");
            header.setFont(header.getFont().deriveFont(1));
            this.selectNoneButton = Translate.button("selectNone", this, "selectNone");
            buttonsUp.add(this.selectNoneButton, 0, 0, ImagesDialog.this.fillLoose);
            this.selectAllButton = Translate.button("selectAll", this, "selectAll");
            buttonsUp.add(this.selectAllButton, 1, 0, ImagesDialog.this.fillLoose);
            this.purgeButton = Translate.button("purge", this, "deleteAndReturn");
            buttonsUp.add(this.purgeButton, 2, 0, ImagesDialog.this.fillLoose);
            this.cancelButton = Translate.button("cancel", this, "close");
            buttonsLow.add(this.cancelButton, 1, 0, ImagesDialog.this.fillLoose);
            this.okButton = Translate.button("ok", this, "deleteAndClose");
            buttonsLow.add(this.okButton, 0, 0, ImagesDialog.this.fillLoose);
            this.content.add(header, new LayoutInfo(LayoutInfo.SOUTH, LayoutInfo.NONE, new Insets(15, 5, 15, 5), null));
            this.addUnusedImagesTable(intent);
            this.content.add(buttonArea, new LayoutInfo(LayoutInfo.SOUTH, LayoutInfo.NONE, new Insets(0, 0, 0, 0), null));
            buttonArea.add(buttonsUp, new LayoutInfo(LayoutInfo.SOUTH, LayoutInfo.NONE, new Insets(10, 0, 0, 0), null));
            buttonArea.add(buttonsLow, new LayoutInfo(LayoutInfo.NORTH, LayoutInfo.NONE, new Insets(0, 0, 0, 0), null));
            this.setContent(this.content);
            this.pack();
            this.setResizable(false);
            this.addAsListener(this);
            this.addEventLink(WindowClosingEvent.class, (Object)this, "close");
            this.setVisible(true);
        }

        private void addUnusedImagesTable(boolean intent) {
            int u;
            this.unusedImages = new ArrayList();
            Color textBG = new Color(223, 223, 223);
            for (int i = 0; i < ImagesDialog.this.theScene.getNumImages(); ++i) {
                ImageMap im = ImagesDialog.this.theScene.getImage(i);
                boolean unused = true;
                for (int t = 0; t < ImagesDialog.this.theScene.getNumTextures(); ++t) {
                    if (!ImagesDialog.this.theScene.getTexture(t).usesImage(im)) continue;
                    unused = false;
                }
                if (!unused) continue;
                this.unusedImages.add(im);
            }
            FormContainer unusedTable = new FormContainer(3, this.unusedImages.size());
            unusedTable.setColumnWeight(1, 10.0);
            this.removeBox = new BCheckBox[this.unusedImages.size()];
            int nameTagWidth = 0;
            Font f = new BButton().getFont();
            FontMetrics fm = new BufferedImage(1, 1, 1).createGraphics().getFontMetrics(f);
            for (u = 0; u < this.unusedImages.size(); ++u) {
                nameTagWidth = fm.stringWidth(this.unusedImages.get(u).getName());
            }
            nameTagWidth = Math.max(nameTagWidth + 20, 200);
            if (this.unusedImages.size() > 0) {
                for (u = 0; u < this.unusedImages.size(); ++u) {
                    this.removeBox[u] = new BCheckBox("", intent);
                    String imageName = this.unusedImages.get(u).getName();
                    if (imageName.isEmpty()) {
                        imageName = Translate.text("unNamed");
                    }
                    BufferedImage bg = ImagesDialog.this.iconBackground(40, 4, 207, 8);
                    Image prev = this.unusedImages.get(u).getPreview(40);
                    BufferedImage nameTag = new BufferedImage(nameTagWidth, 40, 1);
                    Graphics2D gp = bg.createGraphics();
                    gp.drawImage(prev, (40 - prev.getWidth(null)) / 2, (40 - prev.getHeight(null)) / 2, this.getComponent());
                    BLabel imageLabel = new BLabel(new ImageIcon(bg));
                    Graphics2D gn = nameTag.createGraphics();
                    gn.setColor(textBG);
                    gn.fillRect(0, 0, nameTagWidth, 40);
                    gn.setColor(Color.black);
                    gn.setFont(f);
                    gn.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                    gn.drawString(imageName, 8, 25);
                    BLabel nameLabel = new BLabel(new ImageIcon(nameTag), BLabel.WEST);
                    unusedTable.add(imageLabel, 0, u, this.thumb);
                    unusedTable.add(nameLabel, 1, u, this.text);
                    unusedTable.add(this.removeBox[u], 2, u, this.box);
                }
                int scrollerW = unusedTable.getPreferredSize().width;
                int scrollerH = this.unusedImages.size() > 16 ? 504 : 42 * this.unusedImages.size();
                BScrollPane unusedScroller = new BScrollPane(BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_AS_NEEDED);
                unusedScroller.setPreferredViewSize(new Dimension(scrollerW, scrollerH));
                unusedScroller.getVerticalScrollBar().setBlockIncrement(42);
                unusedScroller.getVerticalScrollBar().setUnitIncrement(42);
                unusedScroller.setContent(unusedTable);
                this.content.add(unusedScroller);
            } else {
                String noPurge = Translate.text("allImagesInUse");
                int textWidth = fm.stringWidth(noPurge);
                int tagWidth = Math.max(textWidth + 20, 200);
                int tOff = (tagWidth - textWidth) / 2;
                BufferedImage nameTag = new BufferedImage(tagWidth, 40, 1);
                Graphics2D gn = nameTag.createGraphics();
                gn.setColor(textBG);
                gn.fillRect(0, 0, tagWidth, 40);
                gn.setColor(Color.black);
                gn.setFont(f);
                gn.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                gn.drawString(noPurge, tOff, 25);
                BLabel noPurgeLabel = new BLabel(new ImageIcon(nameTag), BLabel.CENTER);
                this.content.add(noPurgeLabel);
            }
        }

        private void selectAll() {
            for (BCheckBox b : this.removeBox) {
                b.setState(true);
            }
        }

        private void selectNone() {
            for (BCheckBox b : this.removeBox) {
                b.setState(false);
            }
        }

        private void deleteAndReturn() {
            int count = 0;
            for (int r = 0; r < this.removeBox.length; ++r) {
                if (!this.removeBox[r].getState()) continue;
                ++count;
            }
            if (count > 0 && this.confirmRemoval(count)) {
                this.deleteSelectedImages();
                ImagesDialog.this.ic.imagesChanged();
                this.dispose();
                new PurgeDialog(false);
            }
        }

        private void deleteAndClose() {
            int count = 0;
            for (int r = 0; r < this.removeBox.length; ++r) {
                if (!this.removeBox[r].getState()) continue;
                ++count;
            }
            if (count > 0 && this.confirmRemoval(count)) {
                this.deleteSelectedImages();
                this.close();
            }
            this.close();
        }

        private boolean confirmRemoval(int count) {
            String title = Translate.text("confirmTitle");
            String warning = Translate.text("purgeWarning", (Object)count);
            BStandardDialog confirm = new BStandardDialog(title, warning, BStandardDialog.QUESTION);
            String[] options = new String[]{Translate.text("Yes"), Translate.text("No")};
            return confirm.showOptionDialog(this, options, options[1]) == 0;
        }

        private void deleteSelectedImages() {
            for (int d = 0; d < this.unusedImages.size(); ++d) {
                if (!this.removeBox[d].getState()) continue;
                for (int i = 0; i < ImagesDialog.this.theScene.getNumImages(); ++i) {
                    if (ImagesDialog.this.theScene.getImage(i) != this.unusedImages.get(d)) continue;
                    ImagesDialog.this.theScene.removeImage(i);
                    if (ImagesDialog.this.selection > i) {
                        ImagesDialog.this.selection--;
                        continue;
                    }
                    if (ImagesDialog.this.selection != i) continue;
                    ImagesDialog.this.selection = -1;
                }
            }
            ImagesDialog.this.setModified();
        }

        private void close() {
            this.dispose();
            this.removeAsListener(this);
        }

        private void keyPressed(KeyPressedEvent ev) {
            int code = ev.getKeyCode();
            if (code == 27) {
                this.close();
            }
            if (code == 10) {
                this.deleteAndClose();
            }
        }

        private void addAsListener(Widget w) {
            w.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
            if (w instanceof WidgetContainer) {
                Iterator<Widget> iter = ((WidgetContainer)w).getChildren().iterator();
                while (iter.hasNext()) {
                    this.addAsListener(iter.next());
                }
            }
        }

        private void removeAsListener(Widget w) {
            w.removeEventLink(KeyPressedEvent.class, this);
            if (w instanceof WidgetContainer) {
                Iterator<Widget> iter = ((WidgetContainer)w).getChildren().iterator();
                while (iter.hasNext()) {
                    this.removeAsListener(iter.next());
                }
            }
        }
    }

    private class ImagesCanvas
    extends CustomWidget {
        private int w;
        private int h;
        private int gridw;
        private int gridh;
        private int iconSize;
        private int lastIconSize = -1;
        private int textSize;
        private int step;
        private int steps;
        private int scrollIncrement;
        private int scrollFinalValue;
        private Color textBGColor = new Color(95, 95, 127, 191);
        private Color textColor = new Color(223, 223, 127, 255);
        private Color canvasColor = new Color(223, 223, 223);
        private Color frameColor = new Color(175, 175, 175);
        private Image linkedIcon;
        private Image linkBrokenIcon;
        private Image inUseIcon;
        private Image linkedIconTMP;
        private Image linkBrokenIconTMP;
        private Image inUseIconTMP;
        private ImageMap currentImage;
        private JViewport vp = ImagesDialog.access$000(ImagesDialog.this).getComponent().getViewport();
        private Font templateFont = new BLabel().getFont();
        private Timer timer = new Timer(16, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BScrollBar bar = ImagesDialog.this.sp.getVerticalScrollBar();
                if (ImagesCanvas.this.scrollIncrement < 0 && bar.getValue() + ImagesCanvas.this.scrollIncrement <= ImagesCanvas.this.scrollFinalValue || ImagesCanvas.this.scrollIncrement > 0 && bar.getValue() + ImagesCanvas.this.scrollIncrement >= ImagesCanvas.this.scrollFinalValue) {
                    ImagesCanvas.this.timer.stop();
                    bar.setValue(ImagesCanvas.this.scrollFinalValue);
                } else {
                    bar.setValue(bar.getValue() + ImagesCanvas.this.scrollIncrement);
                    ImagesCanvas.this.step++;
                    ImagesCanvas.this.timer.restart();
                }
            }
        });

        public ImagesCanvas(int width) {
            this.w = width;
            this.gridw = ImagesDialog.this.previewSize + 10;
            this.gridh = ImagesDialog.this.previewSize + 10;
            ImagesDialog.this.sp.getVerticalScrollBar().setUnitIncrement(this.gridh / 10);
            this.addEventLink(RepaintEvent.class, (Object)this, "paint");
            this.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
            this.timer.setCoalesce(false);
        }

        public void imagesChanged() {
            this.h = Math.max((ImagesDialog.this.theScene.getNumImages() - 1) / this.w + 1, 4);
            this.setPreferredSize(new Dimension(this.w * this.gridw, Math.max(this.h * this.gridh, this.vp.getExtentSize().height)));
            ImagesDialog.this.sp.layoutChildren();
            this.scrollToSelection();
            this.repaint();
        }

        public void resized() {
            int vw = ((ImagesDialog)ImagesDialog.this).sp.getViewSize().width;
            ImagesDialog.this.previewSize = Math.min(Math.max(vw / 5 - 10, 50), 256);
            this.gridw = ImagesDialog.this.previewSize + 10;
            this.gridh = ImagesDialog.this.previewSize + 10;
            ImagesDialog.this.cOff = Math.max(0, (vw - (ImagesDialog.this.previewSize + 10) * 5) / 2);
            this.setPreferredSize(new Dimension(this.w * this.gridw, Math.max(this.h * this.gridh, this.vp.getExtentSize().height)));
            ImagesDialog.this.sp.getVerticalScrollBar().setUnitIncrement(this.gridh / 10);
            ImagesDialog.this.sp.layoutChildren();
            this.scrollToSelection();
            this.repaint();
        }

        public int getGridWidth() {
            return this.gridw;
        }

        public int getGridHeight() {
            return this.gridh;
        }

        public void scrollToSelection() {
            this.timer.stop();
            if (ImagesDialog.this.selection < 0) {
                return;
            }
            int selUp = ImagesDialog.this.selection / this.w * this.gridh;
            int selLow = selUp + this.gridh;
            int vpUp = this.vp.getViewPosition().y;
            int vpLow = vpUp + this.vp.getExtentSize().height;
            int move = Math.min(Math.max(0, selLow - vpLow), selUp - vpUp);
            double scrollTime = 1.0 * (1.0 - 1.0 / (1.0 + Math.abs((double)move) / (double)this.gridh * 0.1));
            double incs = scrollTime * ArtOfIllusion.getPreferences().getAnimationFrameRate();
            this.scrollIncrement = (int)((double)move / incs);
            this.scrollFinalValue = ImagesDialog.this.sp.getVerticalScrollBar().getValue() + move;
            this.step = 1;
            this.timer.restart();
        }

        private void paint(RepaintEvent ev) {
            Graphics2D g = ev.getGraphics();
            Font textFont = this.templateFont.deriveFont((float)(ImagesDialog.this.previewSize / 40 + 7));
            this.textSize = Math.round(textFont.getSize2D());
            this.iconSize = this.textSize + 21 + ImagesDialog.this.previewSize / 50;
            if (this.iconSize != this.lastIconSize) {
                this.inUseIcon = ImagesDialog.this.loadIcon("in_use.png").getScaledInstance(this.iconSize, this.iconSize, 4);
                this.linkedIcon = ImagesDialog.this.loadIcon("linked.png").getScaledInstance(this.iconSize, this.iconSize, 4);
                this.linkBrokenIcon = ImagesDialog.this.loadIcon("link_broken.png").getScaledInstance(this.iconSize, this.iconSize, 4);
                this.lastIconSize = this.iconSize;
            }
            g.setColor(this.canvasColor);
            g.fill(new Rectangle(0, this.vp.getViewPosition().y, this.vp.getExtentSize().width, this.vp.getExtentSize().height));
            int scrollY = this.vp.getViewPosition().y;
            int scrollH = this.vp.getExtentSize().height;
            BufferedImage bgImage = ImagesDialog.this.iconBackground(ImagesDialog.this.previewSize, 5, 207, 12);
            int head = Math.max(scrollY / this.gridh * this.w - 1, 0);
            int tail = Math.min(ImagesDialog.this.theScene.getNumImages(), (scrollY + scrollH) / this.gridh * this.w + this.w + 1);
            boolean inUse = false;
            for (int i = head; i < tail; ++i) {
                int x = i % this.w * this.gridw + ImagesDialog.this.cOff;
                int y = i / this.w * this.gridh;
                g.setColor(this.frameColor);
                g.fillRect(x + 1, y + 1, this.gridw - 2, this.gridh - 2);
                g.drawImage((Image)bgImage, i % this.w * this.gridw + 5 + ImagesDialog.this.cOff, i / this.w * this.gridh + 5, this.getComponent());
                this.currentImage = ImagesDialog.this.theScene.getImage(i);
                this.smoothPaint(g, i);
                x = i % this.w * this.gridw + ImagesDialog.this.cOff;
                y = i / this.w * this.gridh;
                if (ImagesDialog.this.selection == i) {
                    x = ImagesDialog.this.selection % this.w * this.gridw + ImagesDialog.this.cOff;
                    y = ImagesDialog.this.selection / this.w * this.gridh;
                    g.setColor(ImagesDialog.this.selectedColor);
                    g.drawRect(x + 1, y + 1, this.gridw - 3, this.gridh - 3);
                    g.drawRect(x + 2, y + 2, this.gridw - 5, this.gridh - 5);
                    g.drawRect(x + 3, y + 3, this.gridw - 7, this.gridh - 7);
                    g.drawRect(x + 4, y + 4, this.gridw - 9, this.gridh - 9);
                }
                this.drawName(g, textFont, i);
                if (this.currentImage instanceof ExternalImage) {
                    if (((ExternalImage)this.currentImage).isConnected()) {
                        g.drawImage(this.linkedIcon, i % this.w * this.gridw + 1 + ImagesDialog.this.cOff, i / this.w * this.gridh + 9 + ImagesDialog.this.previewSize - this.iconSize, this.getComponent());
                    } else {
                        g.drawImage(this.linkBrokenIcon, i % this.w * this.gridw + 1 + ImagesDialog.this.cOff, i / this.w * this.gridh + 9 + ImagesDialog.this.previewSize - this.iconSize, this.getComponent());
                    }
                }
                for (int t = 0; t < ImagesDialog.this.theScene.getNumTextures(); ++t) {
                    if (!ImagesDialog.this.theScene.getTexture(t).usesImage(this.currentImage)) continue;
                    inUse = true;
                }
                if (inUse) {
                    g.drawImage(this.inUseIcon, i % this.w * this.gridw + 9 + ImagesDialog.this.cOff + ImagesDialog.this.previewSize - this.iconSize, i / this.w * this.gridh + 9 + ImagesDialog.this.previewSize - this.iconSize, this.getComponent());
                }
                inUse = false;
            }
        }

        private void smoothPaint(Graphics2D g, int i) {
            Image pim = this.currentImage.getPreview(ImagesDialog.this.previewSize);
            if (pim == null) {
                return;
            }
            int xOff = (ImagesDialog.this.previewSize - pim.getWidth(null)) / 2;
            int yOff = (ImagesDialog.this.previewSize - pim.getHeight(null)) / 2;
            g.drawImage(pim, i % this.w * this.gridw + 5 + xOff + ImagesDialog.this.cOff, i / this.w * this.gridh + 5 + yOff, this.getComponent());
        }

        private void drawName(Graphics2D g, Font f, int i) {
            String name = ImagesDialog.this.theScene.getImage(i).getName();
            if (name.isEmpty()) {
                name = Translate.text("unNamed");
            }
            BufferedImage textStripe = new BufferedImage(ImagesDialog.this.previewSize, this.textSize + 5, 2);
            Graphics2D gt = textStripe.createGraphics();
            gt.setColor(this.textBGColor);
            gt.fill(new Rectangle(0, 0, ImagesDialog.this.previewSize, this.textSize + 5));
            gt.setColor(this.textColor);
            gt.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            gt.setFont(f);
            gt.drawString(name, this.iconSize * 4 / 5, this.textSize + 1);
            g.drawImage((Image)textStripe, i % this.w * this.gridw + 5 + ImagesDialog.this.cOff, i / this.w * this.gridh + ImagesDialog.this.previewSize - this.textSize - 2, null);
        }

        private void mouseClicked(MouseClickedEvent ev) {
            Point p = ev.getPoint();
            int i = (p.x - ImagesDialog.this.cOff) / this.gridw;
            int j = p.y / this.gridh;
            if (ImagesDialog.this.cOff - p.x < 0 && i < 5 && i + j * this.w < ImagesDialog.this.theScene.getNumImages()) {
                ImagesDialog.this.selection = i + j * this.w;
                this.scrollToSelection();
            } else {
                ImagesDialog.this.selection = -1;
            }
            this.repaint();
            ImagesDialog.this.hilightButtons();
            if (ev.getClickCount() > 1) {
                ImagesDialog.this.openDetailsDialog();
            }
        }
    }
}

