/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.ArtOfIllusion;
import artofillusion.image.ImageMap;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;

public class SVGImage
extends ImageMap {
    private final byte[] xml;
    private SVGDiagram svg;
    private SoftReference<BufferedImage> preview;
    private HashMap<TileKey, SoftReference<int[]>> tiles;
    private float[] average;
    private float aspectRatio;
    private int previewSize = 0;
    private static final float SCALE = 0.003921569f;
    private static final int TILE_SIZE = 64;

    public SVGImage(File file) throws IOException, InterruptedException, SVGException {
        this.xml = ArtOfIllusion.loadFile(file).getBytes("UTF-8");
        this.setDataCreated(file);
        this.initialize();
    }

    private void initialize() throws SVGException {
        int i;
        SVGUniverse universe = new SVGUniverse();
        URI uri = universe.loadSVG((Reader)new InputStreamReader(new ByteArrayInputStream(this.xml)), "image");
        this.svg = universe.getDiagram(uri);
        this.svg.setIgnoringClipHeuristic(true);
        this.tiles = new HashMap();
        this.aspectRatio = this.svg.getWidth() / this.svg.getHeight();
        BufferedImage pim = this.createPreview(256);
        this.average = new float[4];
        int w = pim.getWidth();
        int h = pim.getHeight();
        for (i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                int argb = pim.getRGB(i, j);
                this.average[0] = this.average[0] + (float)(argb & 0xFF);
                this.average[1] = this.average[1] + (float)(argb >> 8 & 0xFF);
                this.average[2] = this.average[2] + (float)(argb >> 16 & 0xFF);
                this.average[3] = this.average[3] + (float)(argb >> 24 & 0xFF);
            }
        }
        i = 0;
        while (i < 4) {
            int n = i++;
            this.average[n] = this.average[n] / (255.0f * (float)w * (float)h);
        }
        this.average[3] = 1.0f - this.average[3];
        this.preview = new SoftReference<Object>(null);
    }

    private BufferedImage createPreview(int size) throws SVGException {
        float aspectRatio = this.svg.getWidth() / this.svg.getHeight();
        int previewWidth = Math.max(Math.min(size, Math.round((float)size * aspectRatio)), 1);
        int previewHeight = Math.max(Math.min(size, Math.round((float)size / aspectRatio)), 1);
        BufferedImage bi = new BufferedImage(previewWidth, previewHeight, 2);
        Graphics2D g = bi.createGraphics();
        g.setClip(0, 0, (int)this.svg.getWidth(), (int)this.svg.getHeight());
        g.setTransform(new AffineTransform((float)previewWidth / this.svg.getWidth(), 0.0f, 0.0f, (float)previewHeight / this.svg.getHeight(), 0.0f, 0.0f));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.svg.render(g);
        g.dispose();
        this.previewSize = size;
        return bi;
    }

    private BufferedImage createImage(int x, int y, int scale) throws SVGException {
        BufferedImage image = new BufferedImage(64, 64, 2);
        Graphics2D g = image.createGraphics();
        g.setClip(0, 0, (int)this.svg.getWidth(), (int)this.svg.getHeight());
        g.setTransform(new AffineTransform((float)scale / this.svg.getWidth(), 0.0f, 0.0f, (float)(-scale) / this.svg.getHeight(), -x, scale - y));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.svg.render(g);
        g.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getTile(int x, int y, int scale) {
        TileKey key = new TileKey();
        key.x = x;
        key.y = y;
        key.scale = scale;
        int[] tile = null;
        SVGImage sVGImage = this;
        synchronized (sVGImage) {
            SoftReference<int[]> ref = this.tiles.get(key);
            if (ref != null) {
                tile = ref.get();
            }
            if (tile == null) {
                try {
                    BufferedImage image = this.createImage(x, y, scale);
                    tile = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                }
                catch (SVGException ex) {
                    ex.printStackTrace();
                    tile = new int[4096];
                }
                this.tiles.put(key.clone(), new SoftReference<int[]>(tile));
            }
        }
        return tile;
    }

    public byte[] getXML() {
        return this.xml;
    }

    @Override
    public int getWidth() {
        return (int)this.svg.getWidth();
    }

    @Override
    public int getHeight() {
        return (int)this.svg.getHeight();
    }

    @Override
    public float getAspectRatio() {
        return this.aspectRatio;
    }

    @Override
    public String getType() {
        return "SVG";
    }

    @Override
    public int getComponentCount() {
        return 4;
    }

    private void getPixels(int x, int y, int scale, boolean wrapx, boolean wrapy, int[] values) {
        int[] tile2;
        int[] tile3;
        int[] tile4;
        int dx = x & 0x3F;
        int dy = y & 0x3F;
        int basex = x - dx;
        int basey = y - dy;
        int dx2 = x + 1 & 0x3F;
        int dy2 = y + 1 & 0x3F;
        int basex2 = x + 1 - dx2;
        int basey2 = y + 1 - dy2;
        if (x == scale - 1) {
            if (wrapx) {
                dx2 = 0;
                basex2 = 0;
            } else {
                dx2 = dx;
                basex2 = basex;
            }
        }
        if (y == scale - 1) {
            if (wrapy) {
                dy2 = 0;
                basey2 = 0;
            } else {
                dy2 = dy;
                basey2 = basey;
            }
        }
        int[] tile1 = this.getTile(basex, basey, scale);
        if (basex == basex2 && basey == basey2) {
            tile4 = tile1;
            tile2 = tile3 = tile1;
        } else {
            tile2 = this.getTile(basex2, basey, scale);
            tile3 = this.getTile(basex, basey2, scale);
            tile4 = this.getTile(basex2, basey2, scale);
        }
        values[0] = tile1[dx + dy * 64];
        values[1] = tile2[dx2 + dy * 64];
        values[2] = tile3[dx + dy2 * 64];
        values[3] = tile4[dx2 + dy2 * 64];
    }

    @Override
    public float getComponent(int component, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        double size;
        double d = size = xsize > ysize ? xsize : ysize;
        if (size >= 1.0) {
            return this.average[component];
        }
        int shift = component * 8;
        double invsize = 1.0 / size;
        int scale = 2;
        while ((double)scale < invsize) {
            scale *= 2;
        }
        int[] values = new int[4];
        float scaledx = (float)(x * (double)scale);
        float scaledy = (float)(y * (double)scale);
        this.getPixels((int)scaledx, (int)scaledy, scale, wrapx, wrapy, values);
        float scaleFract = 1.0f - (float)((double)scale - invsize) / (0.5f * (float)scale);
        float xfract = scaledx - (float)((int)scaledx);
        float yfract = scaledy - (float)((int)scaledy);
        this.getPixels((int)scaledx, (int)scaledy, scale, wrapx, wrapy, values);
        float result = scaleFract * 0.003921569f * ((1.0f - xfract) * (1.0f - yfract) * (float)(values[0] >> shift & 0xFF) + xfract * (1.0f - yfract) * (float)(values[1] >> shift & 0xFF) + (1.0f - xfract) * yfract * (float)(values[2] >> shift & 0xFF) + xfract * yfract * (float)(values[3] >> shift & 0xFF));
        scaledx = (float)(0.5 * x * (double)scale);
        scaledy = (float)(0.5 * y * (double)scale);
        this.getPixels((int)scaledx, (int)scaledy, scale / 2, wrapx, wrapy, values);
        scaleFract = 1.0f - scaleFract;
        xfract = scaledx - (float)((int)scaledx);
        yfract = scaledy - (float)((int)scaledy);
        result += scaleFract * 0.003921569f * ((1.0f - xfract) * (1.0f - yfract) * (float)(values[0] >> shift & 0xFF) + xfract * (1.0f - yfract) * (float)(values[1] >> shift & 0xFF) + (1.0f - xfract) * yfract * (float)(values[2] >> shift & 0xFF) + xfract * yfract * (float)(values[3] >> shift & 0xFF));
        if (component == 3) {
            result = 1.0f - result;
        }
        return result;
    }

    @Override
    public float getAverageComponent(int component) {
        return this.average[component];
    }

    @Override
    public void getColor(RGBColor theColor, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        double size;
        double d = size = xsize > ysize ? xsize : ysize;
        if (size >= 1.0) {
            theColor.setRGB(this.average[0], this.average[1], this.average[2]);
            return;
        }
        double invsize = 1.0 / size;
        int scale = 2;
        while ((double)scale < invsize) {
            scale *= 2;
        }
        int[] values = new int[4];
        float scaledx = (float)(x * (double)scale);
        float scaledy = (float)(y * (double)scale);
        this.getPixels((int)scaledx, (int)scaledy, scale, wrapx, wrapy, values);
        float scaleFract = 1.0f - (float)(((double)scale - invsize) / (double)(0.5f * (float)scale));
        float xfract = scaledx - (float)((int)scaledx);
        float yfract = scaledy - (float)((int)scaledy);
        this.getPixels((int)scaledx, (int)scaledy, scale, wrapx, wrapy, values);
        theColor.setRGB(scaleFract * 0.003921569f * ((1.0f - xfract) * (1.0f - yfract) * (float)(values[0] >> 16 & 0xFF) + xfract * (1.0f - yfract) * (float)(values[1] >> 16 & 0xFF) + (1.0f - xfract) * yfract * (float)(values[2] >> 16 & 0xFF) + xfract * yfract * (float)(values[3] >> 16 & 0xFF)), scaleFract * 0.003921569f * ((1.0f - xfract) * (1.0f - yfract) * (float)(values[0] >> 8 & 0xFF) + xfract * (1.0f - yfract) * (float)(values[1] >> 8 & 0xFF) + (1.0f - xfract) * yfract * (float)(values[2] >> 8 & 0xFF) + xfract * yfract * (float)(values[3] >> 8 & 0xFF)), scaleFract * 0.003921569f * ((1.0f - xfract) * (1.0f - yfract) * (float)(values[0] & 0xFF) + xfract * (1.0f - yfract) * (float)(values[1] & 0xFF) + (1.0f - xfract) * yfract * (float)(values[2] & 0xFF) + xfract * yfract * (float)(values[3] & 0xFF)));
        scaledx = (float)(0.5 * x * (double)scale);
        scaledy = (float)(0.5 * y * (double)scale);
        this.getPixels((int)scaledx, (int)scaledy, scale / 2, wrapx, wrapy, values);
        scaleFract = 1.0f - scaleFract;
        xfract = scaledx - (float)((int)scaledx);
        yfract = scaledy - (float)((int)scaledy);
        theColor.add(scaleFract * 0.003921569f * ((1.0f - xfract) * (1.0f - yfract) * (float)(values[0] >> 16 & 0xFF) + xfract * (1.0f - yfract) * (float)(values[1] >> 16 & 0xFF) + (1.0f - xfract) * yfract * (float)(values[2] >> 16 & 0xFF) + xfract * yfract * (float)(values[3] >> 16 & 0xFF)), scaleFract * 0.003921569f * ((1.0f - xfract) * (1.0f - yfract) * (float)(values[0] >> 8 & 0xFF) + xfract * (1.0f - yfract) * (float)(values[1] >> 8 & 0xFF) + (1.0f - xfract) * yfract * (float)(values[2] >> 8 & 0xFF) + xfract * yfract * (float)(values[3] >> 8 & 0xFF)), scaleFract * 0.003921569f * ((1.0f - xfract) * (1.0f - yfract) * (float)(values[0] & 0xFF) + xfract * (1.0f - yfract) * (float)(values[1] & 0xFF) + (1.0f - xfract) * yfract * (float)(values[2] & 0xFF) + xfract * yfract * (float)(values[3] & 0xFF)));
    }

    @Override
    public void getGradient(Vec2 grad, int component, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        double size;
        double d = size = xsize > ysize ? xsize : ysize;
        if (size >= 1.0) {
            grad.set(0.0, 0.0);
            return;
        }
        int shift = component * 8;
        double invsize = 1.0 / size;
        int scale = 2;
        while ((double)scale < invsize) {
            scale *= 2;
        }
        int[] values = new int[4];
        float scaledx = (float)(x * (double)scale);
        float scaledy = (float)(y * (double)scale);
        this.getPixels((int)scaledx, (int)scaledy, scale, wrapx, wrapy, values);
        float scaleFract = 1.0f - (float)((double)scale - invsize) / (0.5f * (float)scale);
        float xfract = scaledx - (float)((int)scaledx);
        float yfract = scaledy - (float)((int)scaledy);
        this.getPixels((int)scaledx, (int)scaledy, scale, wrapx, wrapy, values);
        grad.set(scaleFract * (float)scale * 0.003921569f * ((1.0f - yfract) * (float)(values[1] >> shift & 0xFF) - (float)(values[0] >> shift & 0xFF) + yfract * (float)(values[3] >> shift & 0xFF) - (float)(values[2] >> shift & 0xFF)), scaleFract * (float)scale * 0.003921569f * ((1.0f - xfract) * (float)(values[2] >> shift & 0xFF) - (float)(values[0] >> shift & 0xFF) + xfract * (float)(values[3] >> shift & 0xFF) - (float)(values[1] >> shift & 0xFF)));
        scaledx = (float)(0.5 * x * (double)scale);
        scaledy = (float)(0.5 * y * (double)scale);
        this.getPixels((int)scaledx, (int)scaledy, scale / 2, wrapx, wrapy, values);
        scaleFract = 1.0f - scaleFract;
        xfract = scaledx - (float)((int)scaledx);
        yfract = scaledy - (float)((int)scaledy);
        grad.x += (double)(scaleFract * (float)scale * 0.003921569f * ((1.0f - yfract) * (float)(values[1] >> shift & 0xFF) - (float)(values[0] >> shift & 0xFF) + yfract * (float)(values[3] >> shift & 0xFF) - (float)(values[2] >> shift & 0xFF)));
        grad.y += (double)(scaleFract * (float)scale * 0.003921569f * ((1.0f - xfract) * (float)(values[2] >> shift & 0xFF) - (float)(values[0] >> shift & 0xFF) + xfract * (float)(values[3] >> shift & 0xFF) - (float)(values[1] >> shift & 0xFF)));
        if (component == 3) {
            grad.x = -grad.x;
            grad.y = -grad.y;
        }
    }

    @Override
    public Image getPreview() {
        return this.getPreview(50);
    }

    @Override
    public Image getPreview(int size) {
        Image pim = this.preview.get();
        try {
            if (size == this.previewSize && pim != null) {
                return pim;
            }
            pim = this.createPreview(size);
            this.preview = new SoftReference<Image>(pim);
            return pim;
        }
        catch (SVGException se) {
            System.out.println((Object)se);
            return pim;
        }
    }

    public SVGImage(DataInputStream in) throws IOException, SVGException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("Illegal version for SVGImage");
        }
        if (version == 0) {
            this.xml = new byte[in.readInt()];
            in.readFully(this.xml);
            this.initialize();
        } else {
            this.xml = new byte[in.readInt()];
            in.readFully(this.xml);
            this.imageName = in.readUTF();
            this.userCreated = in.readUTF();
            long milliC = in.readLong();
            this.zoneCreated = in.readUTF();
            this.userEdited = in.readUTF();
            long milliE = in.readLong();
            this.zoneEdited = in.readUTF();
            if (milliC > Long.MIN_VALUE) {
                this.dateCreated = new Date(milliC);
            }
            if (milliE > Long.MIN_VALUE) {
                this.dateEdited = new Date(milliE);
            }
            this.initialize();
        }
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeShort(1);
        out.writeInt(this.xml.length);
        out.write(this.xml);
        out.writeUTF(this.imageName);
        out.writeUTF(this.userCreated);
        if (this.dateCreated == null) {
            out.writeLong(Long.MIN_VALUE);
        } else {
            out.writeLong(this.dateCreated.getTime());
        }
        out.writeUTF(this.zoneCreated);
        out.writeUTF(this.userEdited);
        if (this.dateEdited == null) {
            out.writeLong(Long.MIN_VALUE);
        } else {
            out.writeLong(this.dateEdited.getTime());
        }
        out.writeUTF(this.zoneEdited);
    }

    private static class TileKey
    implements Cloneable {
        public int x;
        public int y;
        public int scale;

        private TileKey() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof TileKey)) {
                return false;
            }
            TileKey other = (TileKey)o;
            return other.x == this.x && other.y == this.y && other.scale == this.scale;
        }

        public int hashCode() {
            return this.x + (this.y << 10) + (this.scale << 20);
        }

        public TileKey clone() {
            TileKey copy = new TileKey();
            copy.x = this.x;
            copy.y = this.y;
            copy.scale = this.scale;
            return copy;
        }
    }
}

