/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.math;

import artofillusion.RenderingTriangle;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import java.awt.Point;

public class TriangleMath {
    private TriangleMath() {
    }

    public static Vec3 triangleCross(Vec3 A, Vec3 B, Vec3 C) {
        return B.minus(A).cross(C.minus(A));
    }

    public static Vec3 triangleCross(RenderingTriangle t) {
        return TriangleMath.triangleCross(t.theMesh.vert[t.v1], t.theMesh.vert[t.v2], t.theMesh.vert[t.v3]);
    }

    public static Vec3 triangleNormal(Vec3 A, Vec3 B, Vec3 C) {
        Vec3 n = TriangleMath.triangleCross(A, B, C);
        n.normalize();
        return n;
    }

    public static Vec3 triangleNormal(RenderingTriangle t) {
        return TriangleMath.triangleNormal(t.theMesh.vert[t.v1], t.theMesh.vert[t.v2], t.theMesh.vert[t.v3]);
    }

    public static double triangleArea(Vec3 A, Vec3 B, Vec3 C) {
        return TriangleMath.triangleCross(A, B, C).length() * 0.5;
    }

    public static double triangleArea(RenderingTriangle t) {
        return TriangleMath.triangleArea(t.theMesh.vert[t.v1], t.theMesh.vert[t.v2], t.theMesh.vert[t.v3]);
    }

    public static Vec3 triangleCenter(Vec3 A, Vec3 B, Vec3 C) {
        return A.plus(B).plus(C).times(0.3333333333333333);
    }

    public static Vec3 triangleCenter(RenderingTriangle t) {
        return TriangleMath.triangleCenter(t.theMesh.vert[t.v1], t.theMesh.vert[t.v2], t.theMesh.vert[t.v3]);
    }

    public static double[] baryCoordinates(Vec3 A, Vec3 B, Vec3 C, Vec3 p) {
        double[] bary = new double[3];
        Vec3 triCross = TriangleMath.triangleCross(A, B, C);
        double tcl = triCross.length();
        bary[0] = TriangleMath.triangleCross(p, B, C).dot(triCross) / tcl / 6.0;
        bary[1] = TriangleMath.triangleCross(p, C, A).dot(triCross) / tcl / 6.0;
        bary[2] = TriangleMath.triangleCross(p, A, B).dot(triCross) / tcl / 6.0;
        return bary;
    }

    public static double[] baryCoordinates(RenderingTriangle t, Vec3 p) {
        return TriangleMath.baryCoordinates(t.theMesh.vert[t.v1], t.theMesh.vert[t.v2], t.theMesh.vert[t.v3], p);
    }

    public static Vec3 interpolate(Vec3 A, Vec3 B, Vec3 C, double[] bary) {
        return A.times(bary[0]).plus(B.times(bary[1])).plus(C.times(bary[3]));
    }

    public static Vec3 interpolate(RenderingTriangle t, double[] bary) {
        return TriangleMath.interpolate(t.theMesh.vert[t.v1], t.theMesh.vert[t.v2], t.theMesh.vert[t.v3], bary);
    }

    public static Vec3 project(Vec3 A, Vec3 B, Vec3 C, Vec3 p) {
        double[] bary = new double[3];
        bary = TriangleMath.baryCoordinates(A, B, C, p);
        return TriangleMath.interpolate(A, B, C, bary);
    }

    public static double triangleArea(Vec2 A, Vec2 B, Vec2 C) {
        return B.minus(A).cross(C.minus(A)) * 0.5;
    }

    public static double triangleArea(Vec2[] t) {
        return TriangleMath.triangleArea(t[0], t[1], t[2]);
    }

    public static double[] baryCoordinates(Vec2 A, Vec2 B, Vec2 C, Vec2 p) {
        double[] bary = new double[3];
        double wholeArea = TriangleMath.triangleArea(A, B, C);
        bary[0] = TriangleMath.triangleArea(p, B, C) / wholeArea;
        bary[1] = TriangleMath.triangleArea(p, C, A) / wholeArea;
        bary[2] = TriangleMath.triangleArea(p, A, B) / wholeArea;
        return bary;
    }

    public static double[] baryCoordinates(Vec2[] t, Vec2 p) {
        return TriangleMath.baryCoordinates(t[0], t[1], t[2], p);
    }

    public static double[] baryCoordinates(Vec2[] t, Point p) {
        return TriangleMath.baryCoordinates(t[0], t[1], t[2], new Vec2(p.x, p.y));
    }
}

