/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.math;

import artofillusion.math.Vec2;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Vec3 {
    public double x;
    public double y;
    public double z;

    public Vec3() {
    }

    public Vec3(double xval, double yval, double zval) {
        this.x = xval;
        this.y = yval;
        this.z = zval;
    }

    public Vec3(Vec3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public final void set(double xval, double yval, double zval) {
        this.x = xval;
        this.y = yval;
        this.z = zval;
    }

    public final void set(Vec3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public final double dot(Vec3 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public final Vec3 cross(Vec3 v) {
        return new Vec3(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public final Vec3 plus(Vec3 v) {
        return new Vec3(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public final Vec3 minus(Vec3 v) {
        return new Vec3(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public final Vec3 times(double d) {
        return new Vec3(this.x * d, this.y * d, this.z * d);
    }

    public final boolean equals(Object o) {
        if (o instanceof Vec3) {
            Vec3 v = (Vec3)o;
            return v.x == this.x && v.y == this.y && v.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits((float)this.x);
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final double length2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final void add(Vec3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public final void subtract(Vec3 v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public final void multiply(Vec3 v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
    }

    public final void scale(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public final void normalize() {
        double len = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (len > 0.0) {
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
    }

    public final Vec3 unit() {
        double len = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (len > 0.0) {
            return new Vec3(this.x / len, this.y / len, this.z / len);
        }
        return new Vec3();
    }

    public final double distance(Vec3 v) {
        return Math.sqrt((v.x - this.x) * (v.x - this.x) + (v.y - this.y) * (v.y - this.y) + (v.z - this.z) * (v.z - this.z));
    }

    public final double distance2(Vec3 v) {
        return (v.x - this.x) * (v.x - this.x) + (v.y - this.y) * (v.y - this.y) + (v.z - this.z) * (v.z - this.z);
    }

    public final Vec2 dropAxis(int which) {
        if (which == 0) {
            return new Vec2(this.y, this.z);
        }
        if (which == 1) {
            return new Vec2(this.x, this.z);
        }
        return new Vec2(this.x, this.y);
    }

    public String toString() {
        return "Vec3: " + this.x + ", " + this.y + ", " + this.z;
    }

    public static Vec3 vx() {
        return new Vec3(1.0, 0.0, 0.0);
    }

    public static Vec3 vy() {
        return new Vec3(0.0, 1.0, 0.0);
    }

    public static Vec3 vz() {
        return new Vec3(0.0, 0.0, 1.0);
    }

    public Vec3(DataInputStream in) throws IOException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
    }
}

