/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.ArtOfIllusion;
import artofillusion.RenderingMesh;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Skeleton;
import artofillusion.animation.TextureTrack;
import artofillusion.animation.Track;
import artofillusion.animation.distortion.Distortion;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectWrapper;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import java.lang.ref.SoftReference;
import java.util.HashMap;

public class ObjectInfo {
    public Object3D object;
    public CoordinateSystem coords;
    public String name;
    public boolean visible;
    public boolean selected;
    public boolean parentSelected;
    public ObjectInfo parent;
    public ObjectInfo[] children;
    public Track[] tracks;
    public Keyframe pose;
    public int id;
    private boolean locked;
    private Distortion distortion;
    private Distortion prevDistortion;
    private SoftReference<RenderingMesh> cachedMesh;
    private SoftReference<WireframeMesh> cachedWire;
    private BoundingBox cachedBounds;
    private boolean lastPreviewWasWireframe;

    public ObjectInfo(Object3D obj, CoordinateSystem c, String name) {
        this.setObject(obj);
        this.setCoords(c);
        this.setName(name);
        this.setVisible(true);
        this.children = new ObjectInfo[0];
        this.setId(-1);
    }

    public ObjectInfo duplicate() {
        return this.duplicate(this.getObject());
    }

    public ObjectInfo duplicate(Object3D obj) {
        ObjectInfo info = new ObjectInfo(obj, this.getCoords().duplicate(), this.getName());
        info.setVisible(this.isVisible());
        info.setLocked(this.isLocked());
        info.setId(this.id);
        if (this.getTracks() != null) {
            info.tracks = new Track[this.getTracks().length];
            for (int i = 0; i < this.getTracks().length; ++i) {
                info.getTracks()[i] = this.getTracks()[i].duplicate(info);
            }
        }
        if (this.distortion != null) {
            info.distortion = this.distortion.duplicate();
        }
        return info;
    }

    public static ObjectInfo[] duplicateAll(ObjectInfo[] info) {
        int i;
        ObjectInfo[] newobj = new ObjectInfo[info.length];
        HashMap<ObjectInfo, ObjectInfo> objectMap = new HashMap<ObjectInfo, ObjectInfo>();
        for (i = 0; i < newobj.length; ++i) {
            newobj[i] = info[i].duplicate(info[i].getObject().duplicate());
            objectMap.put(info[i], newobj[i]);
        }
        for (i = 0; i < info.length; ++i) {
            for (int k = info[i].getChildren().length - 1; k >= 0; --k) {
                int j;
                for (j = 0; j < info.length && info[j] != info[i].getChildren()[k]; ++j) {
                }
                if (j >= info.length) continue;
                newobj[i].addChild(newobj[j], 0);
            }
        }
        for (i = 0; i < newobj.length; ++i) {
            if (newobj[i].tracks == null) continue;
            for (int j = 0; j < newobj[i].tracks.length; ++j) {
                newobj[i].tracks[j].updateObjectReferences(objectMap);
            }
        }
        return newobj;
    }

    public void copyInfo(ObjectInfo info) {
        this.setObject(info.getObject());
        this.getCoords().copyCoords(info.getCoords());
        this.setName(info.name);
        this.setVisible(info.visible);
        this.setLocked(info.locked);
        this.setId(info.id);
        this.cachedMesh = info.cachedMesh;
        this.cachedWire = info.cachedWire;
        this.cachedBounds = info.cachedBounds;
        if (info.getTracks() == null) {
            this.tracks = null;
        } else {
            this.tracks = new Track[info.getTracks().length];
            for (int i = 0; i < this.getTracks().length; ++i) {
                this.getTracks()[i] = info.getTracks()[i].duplicate(this);
            }
        }
        this.distortion = info.distortion == null ? null : info.distortion.duplicate();
        this.prevDistortion = info.prevDistortion == null ? null : info.prevDistortion.duplicate();
    }

    public void addChild(ObjectInfo info, int position) {
        int i;
        ObjectInfo[] newChildren = new ObjectInfo[this.getChildren().length + 1];
        for (i = 0; i < position; ++i) {
            newChildren[i] = this.getChildren()[i];
        }
        newChildren[position] = info;
        while (i < this.getChildren().length) {
            newChildren[i + 1] = this.getChildren()[i];
            ++i;
        }
        this.children = newChildren;
        info.setParent(this);
    }

    public void removeChild(ObjectInfo info) {
        for (int i = 0; i < this.getChildren().length; ++i) {
            if (this.getChildren()[i] != info) continue;
            this.removeChild(i);
            return;
        }
    }

    public void removeChild(int which) {
        int i;
        ObjectInfo[] newChildren = new ObjectInfo[this.getChildren().length - 1];
        this.getChildren()[which].setParent(null);
        for (i = 0; i < which; ++i) {
            newChildren[i] = this.getChildren()[i];
        }
        ++i;
        while (i < this.getChildren().length) {
            newChildren[i - 1] = this.getChildren()[i];
            ++i;
        }
        this.children = newChildren;
    }

    public void addTrack(Track tr, int position) {
        int i;
        if (this.getTracks() == null) {
            this.tracks = new Track[]{tr};
            return;
        }
        Track[] newTracks = new Track[this.getTracks().length + 1];
        for (i = 0; i < position; ++i) {
            newTracks[i] = this.getTracks()[i];
        }
        newTracks[position] = tr;
        while (i < this.getTracks().length) {
            newTracks[i + 1] = this.getTracks()[i];
            ++i;
        }
        this.tracks = newTracks;
    }

    public void removeTrack(Track tr) {
        for (int i = 0; i < this.getTracks().length; ++i) {
            if (this.getTracks()[i] != tr) continue;
            this.removeTrack(i);
            return;
        }
    }

    public void removeTrack(int which) {
        int i;
        Track[] newTracks = new Track[this.getTracks().length - 1];
        for (i = 0; i < which; ++i) {
            newTracks[i] = this.getTracks()[i];
        }
        ++i;
        while (i < this.getTracks().length) {
            newTracks[i - 1] = this.getTracks()[i];
            ++i;
        }
        this.tracks = newTracks;
    }

    public void setTexture(Texture tex, TextureMapping map) {
        this.getObject().setTexture(tex, map);
        this.clearCachedMeshes();
        if (this.getTracks() != null) {
            for (int i = 0; i < this.getTracks().length; ++i) {
                if (!(this.getTracks()[i] instanceof TextureTrack)) continue;
                ((TextureTrack)this.getTracks()[i]).parametersChanged();
            }
        }
    }

    public void setMaterial(Material mat, MaterialMapping map) {
        this.getObject().setMaterial(mat, map);
        this.clearCachedMeshes();
    }

    public void clearDistortion() {
        this.distortion = null;
    }

    public void addDistortion(Distortion d) {
        d.setPreviousDistortion(this.distortion);
        this.distortion = d;
    }

    public Distortion getDistortion() {
        return this.distortion;
    }

    public boolean isDistorted() {
        return this.distortion != null;
    }

    public void setDistortion(Distortion d) {
        this.distortion = d;
    }

    private void checkDistortionChanged() {
        if (this.prevDistortion == this.distortion || this.distortion != null && this.distortion.isIdenticalTo(this.prevDistortion)) {
            return;
        }
        this.prevDistortion = this.distortion;
        this.clearCachedMeshes();
    }

    public Object3D getDistortedObject(double tol) {
        if (this.distortion == null) {
            return this.getObject();
        }
        Object3D obj = this.getObject();
        while (obj instanceof ObjectWrapper) {
            obj = ((ObjectWrapper)obj).getWrappedObject();
        }
        if (!(obj instanceof Mesh) && this.getObject().canConvertToTriangleMesh() != 0) {
            obj = obj.convertToTriangleMesh(tol);
        }
        if (obj instanceof Mesh) {
            obj = (Object3D)((Object)this.distortion.transform((Mesh)((Object)obj)));
        }
        return obj;
    }

    public RenderingMesh getRenderingMesh(double tol) {
        return this.getDistortedObject(tol).getRenderingMesh(tol, false, this);
    }

    public RenderingMesh getPreviewMesh() {
        this.checkDistortionChanged();
        RenderingMesh cached = null;
        if (this.cachedMesh != null) {
            cached = this.cachedMesh.get();
        }
        if (cached == null) {
            if (this.getPose() != null && !this.getPose().equals(this.getObject().getPoseKeyframe())) {
                this.getObject().applyPoseKeyframe(this.getPose());
            }
            double tol = ArtOfIllusion.getPreferences().getInteractiveSurfaceError();
            Object3D obj = this.getDistortedObject(tol);
            cached = obj.getRenderingMesh(tol, true, this);
            this.cachedMesh = new SoftReference<RenderingMesh>(cached);
            if (this.cachedBounds == null) {
                this.cachedBounds = obj.getBounds();
            }
        }
        this.lastPreviewWasWireframe = false;
        return cached;
    }

    public WireframeMesh getWireframePreview() {
        this.checkDistortionChanged();
        WireframeMesh cached = null;
        if (this.cachedWire != null) {
            cached = this.cachedWire.get();
        }
        if (cached == null) {
            if (this.getPose() != null && !this.getPose().equals(this.getObject().getPoseKeyframe())) {
                this.getObject().applyPoseKeyframe(this.getPose());
            }
            double tol = ArtOfIllusion.getPreferences().getInteractiveSurfaceError();
            Object3D obj = this.getDistortedObject(tol);
            cached = obj.getWireframeMesh();
            this.cachedWire = new SoftReference<WireframeMesh>(cached);
            if (this.cachedBounds == null) {
                this.cachedBounds = obj.getBounds();
            }
        }
        this.lastPreviewWasWireframe = true;
        return cached;
    }

    public BoundingBox getBounds() {
        this.checkDistortionChanged();
        if (this.cachedBounds == null) {
            if (this.getPose() != null && !this.getPose().equals(this.getObject().getPoseKeyframe())) {
                this.getObject().applyPoseKeyframe(this.getPose());
            }
            double tol = ArtOfIllusion.getPreferences().getInteractiveSurfaceError();
            Object3D obj = this.getDistortedObject(tol);
            this.cachedBounds = obj.getBounds();
            Object3D realObject = this.getObject();
            while (realObject instanceof ObjectWrapper) {
                realObject = ((ObjectWrapper)realObject).getWrappedObject();
            }
            if (!(realObject instanceof ObjectCollection)) {
                if (this.lastPreviewWasWireframe && this.cachedWire == null) {
                    this.cachedWire = new SoftReference<WireframeMesh>(obj.getWireframeMesh());
                } else if (!this.lastPreviewWasWireframe && this.cachedMesh == null) {
                    this.cachedMesh = new SoftReference<RenderingMesh>(obj.getRenderingMesh(tol, true, this));
                }
            }
        }
        return this.cachedBounds;
    }

    public void clearCachedMeshes() {
        this.cachedMesh = null;
        this.cachedWire = null;
        this.cachedBounds = null;
    }

    public Skeleton getSkeleton() {
        return this.getObject().getSkeleton();
    }

    public Object3D getObject() {
        return this.object;
    }

    public void setObject(Object3D object) {
        this.object = object;
    }

    public CoordinateSystem getCoords() {
        return this.coords;
    }

    public void setCoords(CoordinateSystem coords) {
        this.coords = coords;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public ObjectInfo getParent() {
        return this.parent;
    }

    public void setParent(ObjectInfo parent) {
        this.parent = parent;
    }

    public Keyframe getPose() {
        return this.pose;
    }

    public void setPose(Keyframe pose) {
        this.pose = pose;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ObjectInfo[] getChildren() {
        return this.children;
    }

    public Track[] getTracks() {
        return this.tracks;
    }
}

