/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.ArtOfIllusion;
import artofillusion.MeshViewer;
import artofillusion.Property;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.TubeEditorWindow;
import artofillusion.TubeViewer;
import artofillusion.ViewerCanvas;
import artofillusion.WireframeMesh;
import artofillusion.animation.Actor;
import artofillusion.animation.Keyframe;
import artofillusion.animation.MeshGesture;
import artofillusion.animation.Skeleton;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.Translate;
import buoy.widget.RowContainer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Vector;

public class Tube
extends Curve {
    private double[] thickness;
    private int endsStyle;
    private RenderingMesh cachedMesh;
    public static final int OPEN_ENDS = 0;
    public static final int CLOSED_ENDS = 1;
    public static final int FLAT_ENDS = 2;
    private static final int MAX_SUBDIVISIONS = 20;
    private static final Property[] PROPERTIES = new Property[]{new Property(Translate.text("menu.smoothingMethod"), new Object[]{Translate.text("menu.none"), Translate.text("menu.interpolating"), Translate.text("menu.approximating")}, Translate.text("menu.shading")), new Property(Translate.text("menu.endsStyle"), new Object[]{Translate.text("menu.openEnds"), Translate.text("menu.closedEnds"), Translate.text("menu.flatEnds")}, Translate.text("menu.openEnds"))};

    public Tube(Vec3[] v, float[] smoothness, double[] thickness, int smoothingMethod, int endsStyle) {
        super(v, smoothness, smoothingMethod, endsStyle == 1);
        this.thickness = thickness;
        this.endsStyle = endsStyle;
    }

    public Tube(MeshVertex[] v, float[] smoothness, double[] thickness, int smoothingMethod, int endsStyle) {
        super(new Vec3[v.length], smoothness, smoothingMethod, endsStyle == 1);
        for (int i = 0; i < this.vertex.length; ++i) {
            this.vertex[i] = new MeshVertex(v[i]);
        }
        this.thickness = thickness;
        this.endsStyle = endsStyle;
    }

    public Tube(Curve c, double[] thickness, int endsStyle) {
        super(new Vec3[c.vertex.length], c.smoothness, c.smoothingMethod, endsStyle == 1);
        for (int i = 0; i < this.vertex.length; ++i) {
            this.vertex[i].r = new Vec3(c.vertex[i].r);
        }
        this.thickness = thickness;
        this.endsStyle = endsStyle;
    }

    public Tube(Vec3[] v, double thickness, int smoothingMethod, int endsStyle) {
        super(v, new float[v.length], smoothingMethod, endsStyle == 1);
        this.thickness = new double[v.length];
        this.endsStyle = endsStyle;
        for (int i = 0; i < v.length; ++i) {
            this.smoothness[i] = 1.0f;
            this.thickness[i] = thickness;
        }
    }

    @Override
    public Object3D duplicate() {
        Curve c = (Curve)super.duplicate();
        double[] t = new double[this.thickness.length];
        System.arraycopy(this.thickness, 0, t, 0, t.length);
        Tube tube = new Tube(c, t, this.endsStyle);
        tube.copyTextureAndMaterial(this);
        return tube;
    }

    @Override
    public void copyObject(Object3D obj) {
        Tube t = (Tube)obj;
        super.copyObject(t);
        this.thickness = new double[t.thickness.length];
        System.arraycopy(t.thickness, 0, this.thickness, 0, this.thickness.length);
        this.endsStyle = t.endsStyle;
        this.copyTextureAndMaterial(obj);
    }

    public double[] getThickness() {
        return this.thickness;
    }

    public void setThickness(double[] thickness) {
        this.thickness = thickness;
        this.clearCachedMesh();
    }

    public void setShape(MeshVertex[] v, float[] smoothness, double[] thickness) {
        this.vertex = v;
        this.thickness = thickness;
        this.smoothness = smoothness;
        this.clearCachedMesh();
    }

    public int getEndsStyle() {
        return this.endsStyle;
    }

    public void setEndsStyle(int style) {
        this.endsStyle = style;
        this.closed = style == 1;
        this.clearCachedMesh();
    }

    @Override
    public boolean isClosed() {
        return this.endsStyle != 0 || this.thickness[0] == 0.0 && this.thickness[this.thickness.length - 1] == 0.0;
    }

    @Override
    public void setClosed(boolean isClosed) {
        super.setClosed(isClosed);
        if (isClosed) {
            this.endsStyle = 1;
        } else if (this.endsStyle == 1) {
            this.endsStyle = 0;
        }
    }

    @Override
    protected void clearCachedMesh() {
        super.clearCachedMesh();
        this.cachedMesh = null;
    }

    public Tube subdivideTube(double tol) {
        if (this.vertex.length < 3) {
            return this;
        }
        if (this.smoothingMethod == 2) {
            return this.subdivideTubeInterp(tol);
        }
        if (this.smoothingMethod == 3) {
            return this.subdivideTubeApprox(tol);
        }
        return this;
    }

    private Tube subdivideTubeApprox(double tol) {
        int count;
        int j;
        int i;
        Tube t = this;
        int numParam = this.texParam == null ? 0 : this.texParam.length;
        double[] paramTemp = new double[numParam];
        double tol2 = tol * tol;
        double[][] param = new double[t.vertex.length][numParam];
        for (i = 0; i < numParam; ++i) {
            if (!(this.paramValue[i] instanceof VertexParameterValue)) continue;
            double[] val = ((VertexParameterValue)this.paramValue[i]).getValue();
            for (j = 0; j < val.length; ++j) {
                param[j][i] = val[j];
            }
        }
        boolean[] refine = new boolean[t.vertex.length];
        if (t.closed) {
            for (i = 0; i < refine.length; ++i) {
                refine[i] = true;
            }
            count = refine.length;
        } else {
            for (i = 1; i < refine.length - 1; ++i) {
                refine[i] = true;
            }
            count = refine.length - 1;
        }
        int iterations = 0;
        do {
            int len = t.vertex.length;
            MeshVertex[] newvert = new MeshVertex[len + count];
            float[] news = new float[len + count];
            double[] newt = new double[len + count];
            double[][] newparam = new double[len + count][numParam];
            boolean[] newrefine = new boolean[len + count];
            i = 0;
            for (j = 0; j < len; ++j) {
                int k;
                int p1 = j - 1;
                if (p1 < 0) {
                    p1 = t.closed ? len - 1 : 0;
                }
                int p2 = j;
                int p3 = j + 1;
                if (p3 >= len) {
                    int n = p3 = t.closed ? p3 - len : len - 1;
                }
                if (!refine[j]) {
                    newvert[i] = t.vertex[j];
                    newt[i] = t.thickness[j];
                    news[i] = t.smoothness[j];
                    newparam[i] = param[j];
                } else {
                    newvert[i] = SplineMesh.calcApproxPoint(t.vertex, t.smoothness, param, paramTemp, p1, p2, p3);
                    newt[i] = Tube.calcApproxThickness(t.thickness, t.smoothness, p1, p2, p3);
                    news[i] = t.smoothness[j] * 2.0f;
                    if (news[i] > 1.0f) {
                        news[i] = 1.0f;
                    }
                    for (k = 0; k < numParam; ++k) {
                        newparam[i][k] = paramTemp[k];
                    }
                }
                ++i;
                if (!refine[p2] && !refine[p3]) continue;
                newvert[i] = MeshVertex.blend(t.vertex[p2], t.vertex[p3], 0.5, 0.5);
                newt[i] = 0.5 * (t.thickness[p2] + t.thickness[p3]);
                news[i] = 1.0f;
                for (k = 0; k < numParam; ++k) {
                    newparam[i][k] = 0.5 * (param[p2][k] + param[p3][k]);
                }
                if (newvert[i - 1].r.distance2(t.vertex[j].r) > tol2 && newvert[i].r.distance2(newvert[i - 1].r) > tol2 && (i < 2 || newvert[i - 1].r.distance2(newvert[i - 2].r) > tol2)) {
                    newrefine[i - 1] = true;
                    newrefine[i] = true;
                    if (i > 1) {
                        newrefine[i - 2] = true;
                    }
                }
                ++i;
            }
            count = 0;
            for (j = 0; j < newrefine.length - 1; ++j) {
                if (!newrefine[j] && !newrefine[j + 1]) continue;
                ++count;
            }
            if (t.closed && (newrefine[newrefine.length - 1] || newrefine[0])) {
                ++count;
            }
            t = new Tube(newvert, news, newt, t.smoothingMethod, t.endsStyle);
            param = newparam;
            refine = newrefine;
        } while (count > 0 && ++iterations < 20);
        t.copyTextureAndMaterial(this);
        for (i = 0; i < numParam; ++i) {
            if (!(this.paramValue[i] instanceof VertexParameterValue)) continue;
            double[] val = new double[t.vertex.length];
            for (j = 0; j < val.length; ++j) {
                val[j] = param[j][i];
            }
            t.paramValue[i] = new VertexParameterValue(val);
        }
        return t;
    }

    private Tube subdivideTubeInterp(double tol) {
        int j;
        int i;
        Tube t = this;
        int numParam = this.texParam == null ? 0 : this.texParam.length;
        double[] paramTemp = new double[numParam];
        double tol2 = tol * tol;
        double[][] param = new double[t.vertex.length][numParam];
        for (i = 0; i < numParam; ++i) {
            if (!(this.paramValue[i] instanceof VertexParameterValue)) continue;
            double[] val = ((VertexParameterValue)this.paramValue[i]).getValue();
            for (j = 0; j < val.length; ++j) {
                param[j][i] = val[j];
            }
        }
        boolean[] refine = t.closed ? new boolean[t.vertex.length] : new boolean[t.vertex.length - 1];
        for (i = 0; i < refine.length; ++i) {
            refine[i] = true;
        }
        int count = refine.length;
        int iterations = 0;
        do {
            int len = t.vertex.length;
            MeshVertex[] newvert = new MeshVertex[len + count];
            float[] news = new float[len + count];
            double[] newt = new double[len + count];
            double[][] newparam = new double[len + count][numParam];
            boolean[] newrefine = new boolean[len + count];
            i = 0;
            for (j = 0; j < len; ++j) {
                Vec3 temp;
                int p4;
                newvert[i] = t.vertex[j];
                newt[i] = t.thickness[j];
                news[i] = t.smoothness[j] * 2.0f;
                if (news[i] > 1.0f) {
                    news[i] = 1.0f;
                }
                newparam[i] = param[j];
                ++i;
                if (j >= refine.length || !refine[j]) continue;
                int p1 = j - 1;
                if (p1 < 0) {
                    p1 = t.closed ? len - 1 : 0;
                }
                int p2 = j;
                int p3 = j + 1;
                if (p3 >= len) {
                    int n = p3 = t.closed ? p3 - len : len - 1;
                }
                if ((p4 = j + 2) >= len) {
                    p4 = t.closed ? p4 - len : len - 1;
                }
                newvert[i] = SplineMesh.calcInterpPoint(t.vertex, t.smoothness, param, paramTemp, p1, p2, p3, p4);
                newt[i] = Tube.calcInterpThickness(t.thickness, t.smoothness, p1, p2, p3, p4);
                news[i] = 1.0f;
                for (int k = 0; k < numParam; ++k) {
                    newparam[i][k] = paramTemp[k];
                }
                if (newvert[i].r.distance2(t.vertex[p2].r) > tol2 && newvert[i].r.distance2(t.vertex[p3].r) > tol2 && (temp = t.vertex[p2].r.plus(t.vertex[p3].r).times(0.5)).distance2(newvert[i].r) > tol2) {
                    newrefine[i] = true;
                    if (i > 0) {
                        newrefine[i - 1] = true;
                    }
                }
                ++i;
            }
            count = 0;
            for (j = 0; j < newrefine.length; ++j) {
                if (!newrefine[j]) continue;
                ++count;
            }
            t = new Tube(newvert, news, newt, t.smoothingMethod, t.endsStyle);
            param = newparam;
            refine = newrefine;
        } while (count > 0 && ++iterations < 20);
        t.copyTextureAndMaterial(this);
        for (i = 0; i < numParam; ++i) {
            if (!(this.paramValue[i] instanceof VertexParameterValue)) continue;
            double[] val = new double[t.vertex.length];
            for (j = 0; j < val.length; ++j) {
                val[j] = param[j][i];
            }
            t.paramValue[i] = new VertexParameterValue(val);
        }
        return t;
    }

    public static double calcInterpThickness(double[] t, float[] s, int i, int j, int k, int m) {
        double w1 = -0.0625 * (double)s[j];
        double w2 = 0.5 - w1;
        double w4 = -0.0625 * (double)s[k];
        double w3 = 0.5 - w4;
        return w1 * t[i] + w2 * t[j] + w3 * t[k] + w4 * t[m];
    }

    public static double calcApproxThickness(double[] t, float[] s, int i, int j, int k) {
        double w1 = 0.125 * (double)s[j];
        double w2 = 1.0 - 2.0 * w1;
        return w1 * t[i] + w2 * t[j] + w1 * t[k];
    }

    @Override
    public boolean canSetTexture() {
        return true;
    }

    @Override
    public int canConvertToTriangleMesh() {
        return 2;
    }

    @Override
    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        if (interactive && this.cachedMesh != null) {
            return this.cachedMesh;
        }
        Vector<MeshVertex> vert = new Vector<MeshVertex>();
        Vector<Vec3> norm = new Vector<Vec3>();
        Vector<int[]> face = new Vector<int[]>();
        Vector param = new Vector();
        this.subdivideSurface(tol, vert, norm, face, param);
        Vec3[] v = new Vec3[vert.size()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = vert.get((int)i).r;
        }
        Vec3[] n = norm.toArray(new Vec3[vert.size()]);
        int numnorm = norm.size();
        RenderingTriangle[] tri = new RenderingTriangle[face.size()];
        for (int i = 0; i < tri.length; ++i) {
            int[] f = face.get(i);
            tri[i] = f[0] >= numnorm || f[1] >= numnorm || f[2] >= numnorm ? this.texMapping.mapTriangle(f[0], f[1], f[2], numnorm, numnorm, numnorm, v) : this.texMapping.mapTriangle(f[0], f[1], f[2], f[0], f[1], f[2], v);
        }
        RenderingMesh rend = new RenderingMesh(v, n, tri, this.texMapping, this.matMapping);
        if (this.paramValue != null) {
            ParameterValue[] tubeParamValue = new ParameterValue[this.paramValue.length];
            for (int i = 0; i < this.paramValue.length; ++i) {
                if (this.paramValue[i] instanceof VertexParameterValue) {
                    double[] val = new double[v.length];
                    for (int j = 0; j < val.length; ++j) {
                        val[j] = ((double[])param.elementAt(j))[i];
                    }
                    tubeParamValue[i] = new VertexParameterValue(val);
                    continue;
                }
                tubeParamValue[i] = this.paramValue[i];
            }
            rend.setParameters(tubeParamValue);
        }
        if (interactive) {
            this.cachedMesh = rend;
        }
        return rend;
    }

    @Override
    public void setTexture(Texture tex, TextureMapping mapping) {
        super.setTexture(tex, mapping);
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    @Override
    public void setMaterial(Material mat, MaterialMapping map) {
        super.setMaterial(mat, map);
        this.cachedMesh = null;
    }

    @Override
    public WireframeMesh getWireframeMesh() {
        if (this.cachedWire != null) {
            return this.cachedWire;
        }
        this.cachedWire = this.convertToTriangleMesh(ArtOfIllusion.getPreferences().getInteractiveSurfaceError()).getWireframeMesh();
        return this.cachedWire;
    }

    @Override
    public TriangleMesh convertToTriangleMesh(double tol) {
        Vector<MeshVertex> vert = new Vector<MeshVertex>();
        Vector<Vec3> norm = new Vector<Vec3>();
        Vector<int[]> face = new Vector<int[]>();
        Vector param = new Vector();
        this.subdivideSurface(tol, vert, norm, face, param);
        Vec3[] v = new Vec3[vert.size()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = vert.get((int)i).r;
        }
        Vec3[] n = norm.toArray(new Vec3[vert.size()]);
        int[][] f = (int[][])face.toArray((T[])new int[face.size()][]);
        int numnorm = norm.size();
        TriangleMesh mesh = new TriangleMesh(v, f);
        mesh.copyTextureAndMaterial(this);
        if (this.paramValue != null) {
            ParameterValue[] tubeParamValue = new ParameterValue[this.paramValue.length];
            for (int i = 0; i < this.paramValue.length; ++i) {
                if (this.paramValue[i] instanceof VertexParameterValue) {
                    double[] val = new double[v.length];
                    for (int j = 0; j < val.length; ++j) {
                        val[j] = ((double[])param.elementAt(j))[i];
                    }
                    tubeParamValue[i] = new VertexParameterValue(val);
                    continue;
                }
                tubeParamValue[i] = this.paramValue[i];
            }
            mesh.setParameterValues(tubeParamValue);
        }
        TriangleMesh.Edge[] ed = mesh.getEdges();
        TriangleMesh.Face[] fc = mesh.getFaces();
        for (int i = 0; i < fc.length; ++i) {
            if (fc[i].v1 >= numnorm) {
                ed[fc[i].e2].smoothness = 0.0f;
            }
            if (fc[i].v2 >= numnorm) {
                ed[fc[i].e3].smoothness = 0.0f;
            }
            if (fc[i].v3 < numnorm) continue;
            ed[fc[i].e1].smoothness = 0.0f;
        }
        return mesh;
    }

    private void subdivideSurface(double tol, Vector<MeshVertex> vert, Vector<Vec3> norm, Vector<int[]> face, Vector param) {
        int j;
        int k;
        int k2;
        int i;
        Tube t = this.subdivideTube(tol);
        Vec3[] pathv = new Vec3[t.vertex.length];
        for (int i2 = 0; i2 < pathv.length; ++i2) {
            pathv[i2] = t.vertex[i2].r;
        }
        int numParam = this.texParam == null ? 0 : this.texParam.length;
        double[][] tubeParamVal = new double[t.vertex.length][numParam];
        for (int i3 = 0; i3 < numParam; ++i3) {
            if (t.paramValue[i3] instanceof VertexParameterValue) {
                double[] val = ((VertexParameterValue)t.paramValue[i3]).getValue();
                for (int j2 = 0; j2 < tubeParamVal.length; ++j2) {
                    tubeParamVal[j2][i3] = val[j2];
                }
                continue;
            }
            double val = t.paramValue[i3].getAverageValue();
            for (int j3 = 0; j3 < tubeParamVal.length; ++j3) {
                tubeParamVal[j3][i3] = val;
            }
        }
        double max = 0.0;
        for (int i4 = 0; i4 < t.thickness.length; ++i4) {
            if (!(t.thickness[i4] > max)) continue;
            max = t.thickness[i4];
        }
        double r = 0.7 * max;
        int n = 0;
        if (r > tol) {
            n = (int)Math.ceil(Math.PI / Math.acos(1.0 - tol / r));
        }
        if (n < 3) {
            n = 3;
        }
        Vec3[] subdiv = new Curve(pathv, t.smoothness, t.getSmoothingMethod(), t.closed).subdivideCurve().getVertexPositions();
        Vec3[] xdir = new Vec3[subdiv.length];
        Vec3[] zdir = new Vec3[subdiv.length];
        Vec3[] updir = new Vec3[subdiv.length];
        xdir[0] = t.closed ? subdiv[1].minus(subdiv[subdiv.length - 1]) : subdiv[1].minus(subdiv[0]);
        xdir[0].normalize();
        zdir[0] = Math.abs(xdir[0].y) > Math.abs(xdir[0].z) ? xdir[0].cross(Vec3.vz()) : xdir[0].cross(Vec3.vy());
        zdir[0].normalize();
        updir[0] = xdir[0].cross(zdir[0]);
        double zfrac1 = xdir[0].dot(zdir[0]);
        double zfrac2 = Math.sqrt(1.0 - zfrac1 * zfrac1);
        Vec3 dir1 = zdir[0].minus(xdir[0].times(zfrac1));
        dir1.normalize();
        double upfrac1 = xdir[0].dot(updir[0]);
        double upfrac2 = Math.sqrt(1.0 - upfrac1 * upfrac1);
        Vec3 dir2 = updir[0].minus(xdir[0].times(upfrac1));
        dir2.normalize();
        for (int i5 = 1; i5 < subdiv.length; ++i5) {
            xdir[i5] = i5 == subdiv.length - 1 ? (t.closed ? subdiv[0].minus(subdiv[subdiv.length - 2]) : subdiv[subdiv.length - 1].minus(subdiv[subdiv.length - 2])) : subdiv[i5 + 1].minus(subdiv[i5 - 1]);
            xdir[i5].normalize();
            dir1 = dir1.minus(xdir[i5].times(xdir[i5].dot(dir1)));
            dir1.normalize();
            dir2 = dir2.minus(xdir[i5].times(xdir[i5].dot(dir2)));
            dir2.normalize();
            zdir[i5] = xdir[i5].times(zfrac1).plus(dir1.times(zfrac2));
            updir[i5] = xdir[i5].cross(zdir[i5]);
            updir[i5].normalize();
        }
        double dtheta = Math.PI * 2 / (double)n;
        double theta = 0.0;
        for (i = 0; i < pathv.length; ++i) {
            k2 = pathv.length == subdiv.length ? i : 2 * i;
            Vec3 orig = pathv[i];
            Vec3 z = zdir[k2];
            Vec3 up = updir[k2];
            r = 0.5 * t.thickness[i];
            for (int j4 = 0; j4 < n; ++j4) {
                double sin = Math.sin(theta);
                double cos = Math.cos(theta);
                Vec3 normal = new Vec3(cos * z.x + sin * up.x, cos * z.y + sin * up.y, cos * z.z + sin * up.z);
                norm.add(normal);
                MeshVertex mv = new MeshVertex(new Vec3(orig.x + r * normal.x, orig.y + r * normal.y, orig.z + r * normal.z));
                vert.add(mv);
                param.add(tubeParamVal[i]);
                theta += dtheta;
            }
        }
        for (i = 0; i < pathv.length - 1; ++i) {
            k2 = i * n;
            for (int j5 = 0; j5 < n - 1; ++j5) {
                face.add(new int[]{k2 + j5, k2 + j5 + 1, k2 + j5 + n});
                face.add(new int[]{k2 + j5 + 1, k2 + j5 + n + 1, k2 + j5 + n});
            }
            face.add(new int[]{k2 + n - 1, k2, k2 + n + n - 1});
            face.add(new int[]{k2, k2 + n, k2 + n + n - 1});
        }
        if (this.endsStyle == 1) {
            k = (pathv.length - 1) * n;
            j = 0;
            while (j < n - 1) {
                face.add(new int[]{k + j, k + j + 1, j});
                face.add(new int[]{k + j + 1, j + 1, j++});
            }
            face.add(new int[]{k + n - 1, k, n - 1});
            face.add(new int[]{k, 0, n - 1});
        } else if (this.endsStyle == 2) {
            k = vert.size();
            vert.add(new MeshVertex(t.vertex[0]));
            vert.add(new MeshVertex(t.vertex[t.vertex.length - 1]));
            param.add(tubeParamVal[0]);
            param.add(tubeParamVal[t.vertex.length - 1]);
            int i6 = 0;
            while (i6 < n - 1) {
                face.add(new int[]{i6 + 1, i6++, k});
            }
            int[] nArray = new int[]{0, n - 1, k++};
            face.add(nArray);
            j = n * (pathv.length - 1);
            for (int i7 = 0; i7 < n - 1; ++i7) {
                face.add(new int[]{j + i7, j + i7 + 1, k});
            }
            face.add(new int[]{j + n - 1, j, k});
        }
    }

    @Override
    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        TubeEditorWindow ed = new TubeEditorWindow(parent, "Tube object '" + info.getName() + "'", info, cb, true);
        ed.setVisible(true);
    }

    @Override
    public void editGesture(EditingWindow parent, ObjectInfo info, Runnable cb, ObjectInfo realObject) {
        TubeEditorWindow ed = new TubeEditorWindow(parent, "Gesture '" + info.getName() + "'", info, cb, false);
        ViewerCanvas[] views = ed.getAllViews();
        for (int i = 0; i < views.length; ++i) {
            ((MeshViewer)views[i]).setScene(parent.getScene(), realObject);
        }
        ed.setVisible(true);
    }

    @Override
    public MeshViewer createMeshViewer(MeshEditController controller, RowContainer options) {
        return new TubeViewer(controller, options);
    }

    public Tube(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        int i;
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.thickness = new double[this.vertex.length];
        if (version == 0) {
            for (i = 0; i < this.paramValue.length; ++i) {
                this.paramValue[i] = new VertexParameterValue(new double[this.vertex.length]);
            }
        }
        for (i = 0; i < this.vertex.length; ++i) {
            this.thickness[i] = in.readDouble();
            if (version != 0) continue;
            for (int j = 0; j < this.paramValue.length; ++j) {
                ((VertexParameterValue)this.paramValue[j]).getValue()[i] = in.readDouble();
            }
        }
        this.endsStyle = in.readInt();
    }

    @Override
    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(1);
        for (int i = 0; i < this.thickness.length; ++i) {
            out.writeDouble(this.thickness[i]);
        }
        out.writeInt(this.endsStyle);
    }

    @Override
    public Property[] getProperties() {
        return (Property[])PROPERTIES.clone();
    }

    @Override
    public Object getPropertyValue(int index) {
        if (index == 1) {
            return PROPERTIES[index].getAllowedValues()[this.endsStyle];
        }
        return super.getPropertyValue(index);
    }

    @Override
    public void setPropertyValue(int index, Object value) {
        if (index == 1) {
            Object[] values = PROPERTIES[1].getAllowedValues();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equals(value)) continue;
                this.setEndsStyle(i);
            }
        } else {
            super.setPropertyValue(index, value);
        }
    }

    @Override
    public Keyframe getPoseKeyframe() {
        return new TubeKeyframe(this);
    }

    @Override
    public void applyPoseKeyframe(Keyframe k) {
        TubeKeyframe key = (TubeKeyframe)k;
        for (int i = 0; i < this.vertex.length; ++i) {
            this.vertex[i].r.set(key.vertPos[i]);
            this.smoothness[i] = key.vertSmoothness[i];
            this.thickness[i] = key.vertThickness[i];
        }
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    @Override
    public boolean canConvertToActor() {
        return true;
    }

    @Override
    public Object3D getPosableObject() {
        Tube m = (Tube)this.duplicate();
        return new Actor(m);
    }

    public static class TubeKeyframe
    extends MeshGesture {
        Vec3[] vertPos;
        float[] vertSmoothness;
        double[] vertThickness;
        Tube tube;

        public TubeKeyframe(Tube tube) {
            this.tube = tube;
            this.vertPos = new Vec3[tube.vertex.length];
            this.vertSmoothness = new float[tube.vertex.length];
            this.vertThickness = new double[tube.vertex.length];
            for (int i = 0; i < this.vertPos.length; ++i) {
                this.vertPos[i] = new Vec3(tube.vertex[i].r);
                this.vertSmoothness[i] = tube.smoothness[i];
                this.vertThickness[i] = tube.thickness[i];
            }
        }

        private TubeKeyframe() {
        }

        @Override
        protected Mesh getMesh() {
            return this.tube;
        }

        @Override
        protected Vec3[] getVertexPositions() {
            return this.vertPos;
        }

        @Override
        protected void setVertexPositions(Vec3[] pos) {
            this.vertPos = pos;
        }

        @Override
        public Skeleton getSkeleton() {
            return null;
        }

        @Override
        public void setSkeleton(Skeleton s) {
        }

        @Override
        public Keyframe duplicate() {
            return this.duplicate(this.tube);
        }

        @Override
        public Keyframe duplicate(Object owner) {
            TubeKeyframe k = new TubeKeyframe();
            k.tube = owner instanceof Tube ? (Tube)owner : (Tube)((ObjectInfo)owner).getObject();
            k.vertPos = new Vec3[this.vertPos.length];
            k.vertSmoothness = new float[this.vertSmoothness.length];
            k.vertThickness = new double[this.vertThickness.length];
            for (int i = 0; i < this.vertPos.length; ++i) {
                k.vertPos[i] = new Vec3(this.vertPos[i]);
                k.vertSmoothness[i] = this.vertSmoothness[i];
                k.vertThickness[i] = this.vertThickness[i];
            }
            return k;
        }

        @Override
        public double[] getGraphValues() {
            return new double[0];
        }

        @Override
        public void setGraphValues(double[] values) {
        }

        @Override
        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            return null;
        }

        @Override
        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            return null;
        }

        @Override
        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            return null;
        }

        @Override
        public void blendSurface(MeshGesture average, MeshGesture[] p, double[] weight) {
            int i;
            super.blendSurface(average, p, weight);
            TubeKeyframe avg = (TubeKeyframe)average;
            for (i = 0; i < weight.length; ++i) {
                int j;
                TubeKeyframe key = (TubeKeyframe)p[i];
                for (j = 0; j < this.vertSmoothness.length; ++j) {
                    int n = j;
                    avg.vertSmoothness[n] = avg.vertSmoothness[n] + (float)(weight[i] * (double)(key.vertSmoothness[j] - this.vertSmoothness[j]));
                }
                for (j = 0; j < this.vertThickness.length; ++j) {
                    int n = j;
                    avg.vertThickness[n] = avg.vertThickness[n] + (double)((float)(weight[i] * (key.vertThickness[j] - this.vertThickness[j])));
                }
            }
            for (i = 0; i < this.vertSmoothness.length; ++i) {
                if ((double)avg.vertSmoothness[i] < 0.0) {
                    avg.vertSmoothness[i] = 0.0f;
                }
                if ((double)avg.vertSmoothness[i] > 1.0) {
                    avg.vertSmoothness[i] = 1.0f;
                }
                if (!(avg.vertThickness[i] < 0.0)) continue;
                avg.vertThickness[i] = 0.0;
            }
        }

        @Override
        public boolean equals(Keyframe k) {
            if (!(k instanceof TubeKeyframe)) {
                return false;
            }
            TubeKeyframe key = (TubeKeyframe)k;
            for (int i = 0; i < this.vertPos.length; ++i) {
                if (!this.vertPos[i].equals(key.vertPos[i])) {
                    return false;
                }
                if (this.vertSmoothness[i] != key.vertSmoothness[i]) {
                    return false;
                }
                if (this.vertThickness[i] == key.vertThickness[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public void textureChanged(TextureParameter[] oldParams, TextureParameter[] newParams) {
        }

        @Override
        public ParameterValue getTextureParameter(TextureParameter p) {
            return null;
        }

        @Override
        public void setTextureParameter(TextureParameter p, ParameterValue value) {
        }

        @Override
        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeShort(0);
            out.writeInt(this.vertPos.length);
            for (int i = 0; i < this.vertPos.length; ++i) {
                this.vertPos[i].writeToFile(out);
                out.writeFloat(this.vertSmoothness[i]);
                out.writeDouble(this.vertThickness[i]);
            }
        }

        public TubeKeyframe(DataInputStream in, Object parent) throws IOException, InvalidObjectException {
            this();
            short version = in.readShort();
            if (version != 0) {
                throw new InvalidObjectException("");
            }
            this.tube = (Tube)parent;
            int numVert = in.readInt();
            this.vertPos = new Vec3[numVert];
            this.vertSmoothness = new float[numVert];
            this.vertThickness = new double[numVert];
            for (int i = 0; i < numVert; ++i) {
                this.vertPos[i] = new Vec3(in);
                this.vertSmoothness[i] = in.readFloat();
                this.vertThickness[i] = in.readDouble();
            }
        }
    }
}

