/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.FastMath;
import artofillusion.math.SVD;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProceduralModule;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueChecker;
import artofillusion.ui.ValueField;
import buoy.event.KeyPressedEvent;
import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.CustomWidget;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.NumberFormat;

public class FunctionModule
extends ProceduralModule {
    private boolean repeat;
    private boolean valueOk;
    private boolean errorOk;
    private boolean gradOk;
    private double[] x = new double[]{0.0, 1.0};
    private double[] y = new double[]{0.0, 1.0};
    private double value;
    private double error;
    private double deriv;
    private double lastBlur;
    private double[] a0;
    private double[] a1;
    private double[] a2;
    private double[] a3;
    private double[] b;
    private short shape = 0;
    private Vec3 gradient;
    public static final short LINEAR = 0;
    public static final short SMOOTH_INTERPOLATE = 1;

    public FunctionModule(Point position) {
        super("", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Input", "(0"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Output"})}, position);
        this.calcCoefficients();
        this.gradient = new Vec3();
    }

    public double[] getX() {
        return this.x;
    }

    public double[] getY() {
        return this.y;
    }

    public void setFunction(double[] x, double[] y) {
        this.x = x;
        this.y = y;
        this.calcCoefficients();
    }

    public boolean getRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
        this.calcCoefficients();
    }

    public short getMethod() {
        return this.shape;
    }

    public void setMethod(short method) {
        this.shape = method;
        this.calcCoefficients();
    }

    @Override
    public void init(PointInfo p) {
        this.gradOk = false;
        this.errorOk = false;
        this.valueOk = false;
    }

    private double calcValue(double value) {
        int i;
        if (value <= 0.0 || value >= 1.0) {
            if (this.repeat) {
                value -= (double)FastMath.floor(value);
            } else {
                if (value <= 0.0) {
                    return this.y[0];
                }
                return this.y[this.y.length - 1];
            }
        }
        for (i = 1; i < this.x.length && value > this.x[i]; ++i) {
        }
        --i;
        if (this.shape == 1) {
            return this.a0[i] + value * (2.0 * this.a1[i] + value * (3.0 * this.a2[i] + value * 4.0 * this.a3[i]));
        }
        return this.a0[i] + value * 2.0 * this.a1[i];
    }

    private double integral(double valueIn) {
        int i;
        double result;
        double vf;
        if (this.repeat) {
            double vi = FastMath.floor(valueIn);
            vf = valueIn - vi;
            result = vi * this.b[this.b.length - 1];
        } else {
            if (valueIn <= 0.0) {
                return valueIn * this.y[0];
            }
            if (valueIn >= 1.0) {
                return this.b[this.b.length - 1] + (valueIn - 1.0) * this.y[this.y.length - 1];
            }
            vf = (float)valueIn;
            result = 0.0;
        }
        if (vf == 0.0) {
            return result;
        }
        for (i = 1; i < this.x.length && vf > this.x[i]; ++i) {
        }
        result = this.shape == 1 ? (result += this.b[i] + vf * (this.a0[i] + vf * (this.a1[i] + vf * (this.a2[i] + vf * this.a3[i])))) : (result += this.b[--i] + vf * (this.a0[i] + vf * this.a1[i]));
        return result;
    }

    private void calcCoefficients() {
        int i;
        this.a0 = new double[this.x.length - 1];
        this.a1 = new double[this.x.length - 1];
        this.a2 = new double[this.x.length - 1];
        this.a3 = new double[this.x.length - 1];
        this.b = new double[this.x.length];
        if (this.shape == 0) {
            int i2;
            for (i2 = 0; i2 < this.a0.length; ++i2) {
                double dx = this.x[i2 + 1] - this.x[i2];
                if (dx == 0.0) continue;
                this.a1[i2] = (this.y[i2 + 1] - this.y[i2]) / dx;
                this.a0[i2] = this.y[i2] - this.a1[i2] * this.x[i2];
                int n = i2;
                this.a1[n] = this.a1[n] * 0.5;
                this.b[i2 + 1] = this.b[i2] + this.x[i2 + 1] * (this.a0[i2] + this.x[i2 + 1] * this.a1[i2]) - this.x[i2] * (this.a0[i2] + this.x[i2] * this.a1[i2]);
            }
            for (i2 = 1; i2 < this.b.length - 1; ++i2) {
                int n = i2;
                this.b[n] = this.b[n] - this.x[i2] * (this.a0[i2] + this.x[i2] * this.a1[i2]);
            }
            return;
        }
        double[][] m = new double[4][4];
        double[] a = new double[4];
        double[] deriv = new double[this.x.length];
        for (i = 1; i < this.x.length - 1; ++i) {
            if (this.x[i - 1] == this.x[i + 1]) continue;
            deriv[i] = (this.y[i + 1] - this.y[i - 1]) / (this.x[i + 1] - this.x[i]);
        }
        if (this.repeat) {
            double d = (this.y[1] - this.y[this.y.length - 2]) / (1.0 + this.x[1] - this.x[this.x.length - 2]);
            deriv[this.x.length - 1] = d;
            deriv[0] = d;
        }
        for (i = 0; i < this.a0.length; ++i) {
            m[0][0] = 0.0;
            m[0][1] = 1.0;
            m[0][2] = 2.0 * this.x[i];
            m[0][3] = 3.0 * this.x[i] * this.x[i];
            a[0] = deriv[i];
            m[1][0] = 1.0;
            m[1][1] = this.x[i];
            m[1][2] = this.x[i] * this.x[i];
            m[1][3] = this.x[i] * this.x[i] * this.x[i];
            a[1] = this.y[i];
            m[2][0] = 1.0;
            m[2][1] = this.x[i + 1];
            m[2][2] = this.x[i + 1] * this.x[i + 1];
            m[2][3] = this.x[i + 1] * this.x[i + 1] * this.x[i + 1];
            a[2] = this.y[i + 1];
            m[3][0] = 0.0;
            m[3][1] = 1.0;
            m[3][2] = 2.0 * this.x[i + 1];
            m[3][3] = 3.0 * this.x[i + 1] * this.x[i + 1];
            a[3] = deriv[i + 1];
            SVD.solve(m, a);
            this.a0[i] = a[0];
            this.a1[i] = 0.5 * a[1];
            this.a2[i] = a[2] / 3.0;
            this.a3[i] = 0.25 * a[3];
            this.b[i + 1] = this.b[i] + this.x[i + 1] * (this.a0[i] + this.x[i + 1] * (this.a1[i] + this.x[i + 1] * (this.a2[i] + this.x[i + 1] * this.a3[i]))) - this.x[i] * (this.a0[i] + this.x[i] * (this.a1[i] + this.x[i] * (this.a2[i] + this.x[i] * this.a3[i])));
        }
        for (i = 1; i < this.b.length - 1; ++i) {
            int n = i;
            this.b[n] = this.b[n] - this.x[i] * (this.a0[i] + this.x[i] * (this.a1[i] + this.x[i] * (this.a2[i] + this.x[i] * this.a3[i])));
        }
    }

    @Override
    public double getAverageValue(int which, double blur) {
        double errorIn;
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.lastBlur = blur;
        this.valueOk = true;
        double valueIn = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double d = errorIn = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        if (errorIn == 0.0) {
            this.value = this.calcValue(valueIn);
            this.error = 0.0;
            this.errorOk = true;
            return this.value;
        }
        this.value = (this.integral(valueIn + errorIn) - this.integral(valueIn - errorIn)) / (2.0 * errorIn);
        return this.value;
    }

    @Override
    public double getValueError(int which, double blur) {
        int i;
        if (this.errorOk && blur == this.lastBlur) {
            return this.error;
        }
        this.lastBlur = blur;
        this.errorOk = true;
        if (this.linkFrom[0] == null) {
            this.gradient.set(0.0, 0.0, 0.0);
            this.error = 0.0;
            this.gradOk = true;
            return 0.0;
        }
        double valueIn = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        if (valueIn <= 0.0 || valueIn >= 1.0) {
            if (!this.repeat) {
                this.gradient.set(0.0, 0.0, 0.0);
                this.error = 0.0;
                this.gradOk = true;
                return 0.0;
            }
            valueIn -= (double)FastMath.floor(valueIn);
        }
        for (i = 1; i < this.x.length && valueIn > this.x[i]; ++i) {
        }
        this.error = this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        this.deriv = this.shape == 1 ? 2.0 * this.a1[i] + valueIn * (6.0 * this.a2[i] + valueIn * 12.0 * this.a3[i]) : 2.0 * this.a1[--i];
        this.error *= Math.abs(this.deriv);
        return this.error;
    }

    @Override
    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (!this.errorOk || blur != this.lastBlur) {
            this.getValueError(which, blur);
        }
        if (this.gradOk && blur == this.lastBlur) {
            grad.set(this.gradient);
            return;
        }
        if (this.linkFrom[0] == null) {
            this.gradient.set(0.0, 0.0, 0.0);
            grad.set(0.0, 0.0, 0.0);
            this.gradOk = true;
            return;
        }
        this.lastBlur = blur;
        this.gradOk = true;
        this.linkFrom[0].getValueGradient(this.linkFromIndex[0], this.gradient, blur);
        this.gradient.scale(this.deriv);
        grad.set(this.gradient);
    }

    @Override
    public void calcSize() {
        this.bounds.width = 50;
        this.bounds.height = 35;
    }

    @Override
    protected void drawContents(Graphics2D g) {
        int i;
        Rectangle r = new Rectangle(this.bounds.x + 5, this.bounds.y + 5, this.bounds.width - 10, this.bounds.height - 10);
        double miny = Double.MAX_VALUE;
        double maxy = -1.7976931348623157E308;
        for (i = 0; i < this.y.length; ++i) {
            if (this.y[i] < miny) {
                miny = this.y[i];
            }
            if (!(this.y[i] > maxy)) continue;
            maxy = this.y[i];
        }
        g.setColor(Color.white);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        if (this.shape == 1) {
            int lastx = (int)((double)r.x + this.x[0] * (double)r.width);
            int lasty = (int)((double)r.y + (maxy - this.y[0]) * (double)r.height / (maxy - miny));
            for (int i2 = 0; i2 < this.x.length - 1; ++i2) {
                double dx = this.x[i2 + 1] - this.x[i2];
                int nextx = 0;
                int nexty = 0;
                if (dx == 0.0) {
                    nextx = (int)((double)r.x + this.x[i2 + 1] * (double)r.width);
                    nexty = (int)((double)r.y + (maxy - this.y[i2 + 1]) * (double)r.height / (maxy - miny));
                } else {
                    for (int j = 1; j < 8; ++j) {
                        double xf = this.x[i2] + (double)j * 0.125 * dx;
                        double yf = this.calcValue(xf);
                        nextx = (int)((double)r.x + xf * (double)r.width);
                        nexty = (int)((double)r.y + (maxy - yf) * (double)r.height / (maxy - miny));
                        g.drawLine(lastx, lasty, nextx, nexty);
                        lastx = nextx;
                        lasty = nexty;
                    }
                }
                g.drawLine(lastx, lasty, nextx, nexty);
                lastx = nextx;
                lasty = nexty;
            }
            return;
        }
        for (i = 0; i < this.x.length - 1; ++i) {
            int x1 = (int)((double)r.x + this.x[i] * (double)r.width);
            int y1 = (int)((double)r.y + (maxy - this.y[i]) * (double)r.height / (maxy - miny));
            int x2 = (int)((double)r.x + this.x[i + 1] * (double)r.width);
            int y2 = (int)((double)r.y + (maxy - this.y[i + 1]) * (double)r.height / (maxy - miny));
            g.drawLine(x1, y1, x2, y2);
        }
    }

    @Override
    public Module duplicate() {
        FunctionModule mod = new FunctionModule(new Point(this.bounds.x, this.bounds.y));
        mod.repeat = this.repeat;
        mod.shape = this.shape;
        mod.x = new double[this.x.length];
        mod.y = new double[this.y.length];
        for (int i = 0; i < this.x.length; ++i) {
            mod.x[i] = this.x[i];
            mod.y[i] = this.y[i];
        }
        mod.calcCoefficients();
        return mod;
    }

    @Override
    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeInt(this.x.length);
        for (int i = 0; i < this.x.length; ++i) {
            out.writeDouble(this.x[i]);
            out.writeDouble(this.y[i]);
        }
        out.writeBoolean(this.repeat);
        out.writeShort(this.shape);
    }

    @Override
    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        int num = in.readInt();
        this.x = new double[num];
        this.y = new double[num];
        for (int i = 0; i < this.x.length; ++i) {
            this.x[i] = in.readDouble();
            this.y[i] = in.readDouble();
        }
        this.repeat = in.readBoolean();
        this.shape = in.readShort();
        this.calcCoefficients();
    }

    @Override
    public boolean edit(ProcedureEditor editor, Scene theScene) {
        EditingDialog dlg = new EditingDialog(editor);
        return dlg.clickedOk;
    }

    static /* synthetic */ double[] access$202(FunctionModule x0, double[] x1) {
        x0.x = x1;
        return x1;
    }

    static /* synthetic */ double[] access$302(FunctionModule x0, double[] x1) {
        x0.y = x1;
        return x1;
    }

    private class EditingDialog
    extends BDialog {
        ProcedureEditor editor;
        CustomWidget canvas;
        ValueField xField;
        ValueField yField;
        BCheckBox repeatBox;
        BCheckBox smoothBox;
        BButton deleteButton;
        Point clickPoint;
        Point[] handlePos;
        Rectangle graphBounds;
        FontMetrics fm;
        NumberFormat hFormat;
        NumberFormat vFormat;
        int selected;
        boolean clickedOk;
        boolean fixRange;
        double miny;
        double maxy;
        double labelstep;
        static final int HANDLE_SIZE = 5;

        public EditingDialog(ProcedureEditor editor) {
            super(editor.getParentFrame(), "Function", true);
            this.editor = editor;
            FormContainer content = new FormContainer(1, 5);
            this.setContent(BOutline.createEmptyBorder(content, UIUtilities.getStandardDialogInsets()));
            content.add(Translate.label("functionModuleInstructions"), 0, 0);
            this.canvas = new CustomWidget();
            content.add(this.canvas, 0, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
            this.canvas.setPreferredSize(new Dimension(200, 150));
            this.canvas.setBackground(Color.white);
            this.canvas.addEventLink(RepaintEvent.class, (Object)this, "paintCanvas");
            this.canvas.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
            this.canvas.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
            this.canvas.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
            this.canvas.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
            this.graphBounds = new Rectangle();
            RowContainer row = new RowContainer();
            content.add(row, 0, 2);
            row.add(new BLabel("X:"));
            this.xField = new ValueField(Double.NaN, 0);
            row.add(this.xField);
            this.xField.setValueChecker(new ValueChecker(){

                @Override
                public boolean isValid(double val) {
                    return val >= 0.0 && val <= 1.0;
                }
            });
            row.add(new BLabel("Y:"));
            this.yField = new ValueField(Double.NaN, 0);
            row.add(this.yField);
            this.xField.addEventLink(ValueChangedEvent.class, (Object)this, "textChanged");
            this.yField.addEventLink(ValueChangedEvent.class, (Object)this, "textChanged");
            row.add(Translate.button("add", this, "doAdd"));
            this.deleteButton = Translate.button("delete", this, "doDelete");
            row.add(this.deleteButton);
            RowContainer checkboxRow = new RowContainer();
            content.add(checkboxRow, 0, 3);
            this.repeatBox = new BCheckBox(Translate.text("functionIsPeriodic"), FunctionModule.this.repeat);
            checkboxRow.add(this.repeatBox);
            this.smoothBox = new BCheckBox(Translate.text("smoothCurve"), FunctionModule.this.shape == 1);
            checkboxRow.add(this.smoothBox);
            this.repeatBox.addEventLink(ValueChangedEvent.class, (Object)this, "functionChanged");
            this.smoothBox.addEventLink(ValueChangedEvent.class, (Object)this, "functionChanged");
            RowContainer buttons = new RowContainer();
            content.add(buttons, 0, 4);
            buttons.add(Translate.button("ok", this, "doOk"));
            buttons.add(Translate.button("cancel", this, "dispose"));
            this.hFormat = NumberFormat.getInstance();
            this.vFormat = NumberFormat.getInstance();
            this.hFormat.setMaximumFractionDigits(1);
            this.findRange();
            this.adjustComponents();
            this.handlePos = new Point[FunctionModule.this.x.length];
            for (int i = 0; i < FunctionModule.this.x.length; ++i) {
                ((FunctionModule)FunctionModule.this).x[i] = FunctionModule.this.x[i];
                ((FunctionModule)FunctionModule.this).y[i] = FunctionModule.this.y[i];
                this.handlePos[i] = new Point(0, 0);
            }
            this.pack();
            UIUtilities.centerDialog(this, editor.getParentFrame());
            this.fm = this.canvas.getComponent().getFontMetrics(this.canvas.getFont());
            this.setVisible(true);
        }

        private void adjustComponents() {
            this.xField.setValue(FunctionModule.this.x[this.selected]);
            this.yField.setValue(FunctionModule.this.y[this.selected]);
            boolean movable = this.selected > 0 && this.selected < FunctionModule.this.x.length - 1;
            this.xField.setEnabled(movable);
            this.deleteButton.setEnabled(movable);
        }

        private void findRange() {
            if (this.fixRange) {
                return;
            }
            this.miny = Double.MAX_VALUE;
            this.maxy = -1.7976931348623157E308;
            for (int i = 0; i < FunctionModule.this.y.length; ++i) {
                if (FunctionModule.this.y[i] < this.miny) {
                    this.miny = FunctionModule.this.y[i];
                }
                if (!(FunctionModule.this.y[i] > this.maxy)) continue;
                this.maxy = FunctionModule.this.y[i];
            }
            if (this.miny == this.maxy) {
                this.miny = FastMath.floor(this.miny);
                this.maxy = this.miny + 1.0;
            }
            int decimals = FastMath.floor(Math.log(this.maxy - this.miny) / Math.log(10.0));
            this.labelstep = FastMath.pow(10.0, decimals);
            this.vFormat.setMaximumFractionDigits(decimals < 0 ? -decimals : 1);
        }

        private void positionHandles(Rectangle r) {
            for (int i = 0; i < FunctionModule.this.x.length; ++i) {
                this.handlePos[i].x = (int)((double)r.x + FunctionModule.this.x[i] * (double)r.width);
                this.handlePos[i].y = (int)((double)r.y + (this.maxy - FunctionModule.this.y[i]) * (double)r.height / (this.maxy - this.miny));
            }
        }

        private void paintAxes(Graphics2D g) {
            String label;
            double pos;
            int maxWidth = 0;
            int fontHeight = this.fm.getHeight();
            Rectangle bounds = this.canvas.getBounds();
            this.graphBounds.y = 2;
            this.graphBounds.height = bounds.height - 5 - fontHeight - 5;
            g.setColor(Color.black);
            for (pos = this.labelstep * Math.ceil(this.miny / this.labelstep); pos <= this.maxy; pos += this.labelstep) {
                label = this.vFormat.format(pos);
                int w = this.fm.stringWidth(label);
                if (w > maxWidth) {
                    maxWidth = w;
                }
                g.drawString(label, 0, this.graphBounds.y + (int)((this.maxy - pos) * (double)this.graphBounds.height / (this.maxy - this.miny)) + fontHeight / 2);
            }
            this.graphBounds.x = maxWidth + 5;
            this.graphBounds.width = bounds.width - maxWidth - 5 - 2;
            for (pos = this.labelstep * Math.ceil(this.miny / this.labelstep); pos <= this.maxy; pos += this.labelstep) {
                int v = this.graphBounds.y + (int)((this.maxy - pos) * (double)this.graphBounds.height / (this.maxy - this.miny));
                g.drawLine(this.graphBounds.x - 3, v, this.graphBounds.x, v);
            }
            for (int i = 0; i < 10; ++i) {
                label = this.hFormat.format(0.1 * (double)i);
                int h = this.graphBounds.x + i * this.graphBounds.width / 10;
                g.drawLine(h, this.graphBounds.y + this.graphBounds.height, h, this.graphBounds.y + this.graphBounds.height + 3);
                g.drawString(label, h - this.fm.stringWidth(label) / 2, bounds.height);
            }
            g.drawLine(this.graphBounds.x, 0, this.graphBounds.x, this.graphBounds.y + this.graphBounds.height);
            g.drawLine(this.graphBounds.x, this.graphBounds.y + this.graphBounds.height, this.graphBounds.x + this.graphBounds.width, this.graphBounds.y + this.graphBounds.height);
            this.positionHandles(this.graphBounds);
        }

        private void paintCanvas(RepaintEvent ev) {
            int i;
            Graphics2D g = ev.getGraphics();
            this.paintAxes(g);
            g.setColor(Color.black);
            if (this.smoothBox.getState()) {
                int lastx = this.handlePos[0].x;
                int lasty = this.handlePos[0].y;
                for (int i2 = 0; i2 < this.handlePos.length - 1; ++i2) {
                    double dx = FunctionModule.this.x[i2 + 1] - FunctionModule.this.x[i2];
                    if (dx == 0.0) {
                        g.drawLine(lastx, lasty, this.handlePos[i2 + 1].x, this.handlePos[i2 + 1].y);
                        lastx = this.handlePos[i2 + 1].x;
                        lasty = this.handlePos[i2 + 1].y;
                        continue;
                    }
                    for (int j = 1; j < 8; ++j) {
                        double xf = FunctionModule.this.x[i2] + (double)j * 0.125 * dx;
                        double yf = FunctionModule.this.calcValue(xf);
                        int nextx = (int)((double)this.graphBounds.x + xf * (double)this.graphBounds.width);
                        int nexty = (int)((double)this.graphBounds.y + (this.maxy - yf) * (double)this.graphBounds.height / (this.maxy - this.miny));
                        g.drawLine(lastx, lasty, nextx, nexty);
                        lastx = nextx;
                        lasty = nexty;
                    }
                    g.drawLine(lastx, lasty, this.handlePos[i2 + 1].x, this.handlePos[i2 + 1].y);
                    lastx = this.handlePos[i2 + 1].x;
                    lasty = this.handlePos[i2 + 1].y;
                }
            } else {
                for (i = 0; i < this.handlePos.length - 1; ++i) {
                    g.drawLine(this.handlePos[i].x, this.handlePos[i].y, this.handlePos[i + 1].x, this.handlePos[i + 1].y);
                }
            }
            for (i = 0; i < this.handlePos.length; ++i) {
                if (this.selected == i) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(Color.black);
                }
                g.fillRect(this.handlePos[i].x - 2, this.handlePos[i].y - 2, 5, 5);
            }
        }

        private void addHandle(double where, double val) {
            int i;
            double[] newx = new double[FunctionModule.this.x.length + 1];
            double[] newy = new double[FunctionModule.this.y.length + 1];
            for (i = 0; i < FunctionModule.this.x.length && FunctionModule.this.x[i] < where; ++i) {
                newx[i] = FunctionModule.this.x[i];
                newy[i] = FunctionModule.this.y[i];
            }
            newx[i] = where;
            newy[i] = val;
            this.selected = i;
            while (i < FunctionModule.this.x.length) {
                newx[i + 1] = FunctionModule.this.x[i];
                newy[i + 1] = FunctionModule.this.y[i];
                ++i;
            }
            FunctionModule.access$202(FunctionModule.this, newx);
            FunctionModule.access$302(FunctionModule.this, newy);
            this.handlePos = new Point[FunctionModule.this.x.length];
            for (i = 0; i < this.handlePos.length; ++i) {
                this.handlePos[i] = new Point(0, 0);
            }
            FunctionModule.this.calcCoefficients();
            this.adjustComponents();
            this.findRange();
            this.positionHandles(this.graphBounds);
            this.canvas.repaint();
            this.editor.updatePreview();
        }

        private void doDelete() {
            int i;
            if (this.selected == 0 || this.selected == FunctionModule.this.x.length - 1) {
                return;
            }
            double[] newx = new double[FunctionModule.this.x.length - 1];
            double[] newy = new double[FunctionModule.this.y.length - 1];
            for (i = 0; i < FunctionModule.this.x.length - 1; ++i) {
                if (i < this.selected) {
                    newx[i] = FunctionModule.this.x[i];
                    newy[i] = FunctionModule.this.y[i];
                    continue;
                }
                newx[i] = FunctionModule.this.x[i + 1];
                newy[i] = FunctionModule.this.y[i + 1];
            }
            this.selected = 0;
            FunctionModule.access$202(FunctionModule.this, newx);
            FunctionModule.access$302(FunctionModule.this, newy);
            this.handlePos = new Point[FunctionModule.this.x.length];
            for (i = 0; i < this.handlePos.length; ++i) {
                this.handlePos[i] = new Point(0, 0);
            }
            FunctionModule.this.calcCoefficients();
            this.adjustComponents();
            this.findRange();
            this.positionHandles(this.graphBounds);
            this.canvas.repaint();
            this.editor.updatePreview();
        }

        private void doAdd() {
            this.addHandle(0.5, FunctionModule.this.calcValue(0.5));
        }

        private void doOk() {
            this.clickedOk = true;
            this.dispose();
        }

        private void keyPressed(KeyPressedEvent ev) {
            if (ev.getKeyCode() == 10) {
                this.doOk();
            }
            if (ev.getKeyCode() == 27) {
                this.dispose();
            }
            if (ev.getSource() != this.canvas) {
                return;
            }
            if (ev.getKeyCode() == 8 || ev.getKeyCode() == 127) {
                this.doDelete();
            }
        }

        private void mousePressed(MousePressedEvent ev) {
            this.fixRange = true;
            this.clickPoint = ev.getPoint();
            this.canvas.requestFocus();
            if (ev.isControlDown()) {
                double h = (double)(this.clickPoint.x - this.graphBounds.x) / ((double)this.graphBounds.width - 1.0);
                double v = (double)(this.graphBounds.height - this.clickPoint.y + this.graphBounds.y) / ((double)this.graphBounds.height - 1.0);
                v = v * (this.maxy - this.miny) + this.miny;
                this.addHandle(0.001 * (double)((int)(1000.0 * h)), 0.001 * (double)((int)(1000.0 * v)));
                return;
            }
            for (int i = 0; i < this.handlePos.length; ++i) {
                int xh = this.handlePos[i].x;
                int yh = this.handlePos[i].y;
                if (this.clickPoint.x < xh - 2 || this.clickPoint.x > xh + 2 || this.clickPoint.y < yh - 2 || this.clickPoint.y > yh + 2) continue;
                this.selected = i;
                this.adjustComponents();
                this.canvas.repaint();
                return;
            }
            this.clickPoint = null;
        }

        private void mouseDragged(MouseDraggedEvent ev) {
            Point tempPos;
            double temp;
            if (this.clickPoint == null) {
                return;
            }
            Point pos = ev.getPoint();
            this.handlePos[this.selected].x = pos.x;
            double newx = ((double)pos.x - (double)this.graphBounds.x) / ((double)this.graphBounds.width - 1.0);
            double newy = (double)(this.graphBounds.height - pos.y + this.graphBounds.y) / ((double)this.graphBounds.height - 1.0);
            newy = newy * (this.maxy - this.miny) + this.miny;
            if (newx < 0.0) {
                newx = 0.0;
            }
            if (newx > 1.0) {
                newx = 1.0;
            }
            if (newy < this.miny) {
                newy = this.miny;
            }
            if (newy > this.maxy) {
                newy = this.maxy;
            }
            ((FunctionModule)FunctionModule.this).y[this.selected] = 0.001 * (double)((int)(1000.0 * newy));
            if (this.selected == 0 || this.selected == FunctionModule.this.x.length - 1) {
                FunctionModule.this.calcCoefficients();
                this.adjustComponents();
                this.canvas.repaint();
                return;
            }
            ((FunctionModule)FunctionModule.this).x[this.selected] = 0.001 * (double)((int)(1000.0 * newx));
            while (FunctionModule.this.x[this.selected] < FunctionModule.this.x[this.selected - 1]) {
                temp = FunctionModule.this.x[this.selected];
                ((FunctionModule)FunctionModule.this).x[this.selected] = FunctionModule.this.x[this.selected - 1];
                ((FunctionModule)FunctionModule.this).x[this.selected - 1] = temp;
                temp = FunctionModule.this.y[this.selected];
                ((FunctionModule)FunctionModule.this).y[this.selected] = FunctionModule.this.y[this.selected - 1];
                ((FunctionModule)FunctionModule.this).y[this.selected - 1] = temp;
                tempPos = this.handlePos[this.selected];
                this.handlePos[this.selected] = this.handlePos[this.selected - 1];
                this.handlePos[this.selected - 1] = tempPos;
                --this.selected;
            }
            while (FunctionModule.this.x[this.selected] > FunctionModule.this.x[this.selected + 1]) {
                temp = FunctionModule.this.x[this.selected];
                ((FunctionModule)FunctionModule.this).x[this.selected] = FunctionModule.this.x[this.selected + 1];
                ((FunctionModule)FunctionModule.this).x[this.selected + 1] = temp;
                temp = FunctionModule.this.y[this.selected];
                ((FunctionModule)FunctionModule.this).y[this.selected] = FunctionModule.this.y[this.selected + 1];
                ((FunctionModule)FunctionModule.this).y[this.selected + 1] = temp;
                tempPos = this.handlePos[this.selected];
                this.handlePos[this.selected] = this.handlePos[this.selected + 1];
                this.handlePos[this.selected + 1] = tempPos;
                ++this.selected;
            }
            FunctionModule.this.calcCoefficients();
            this.adjustComponents();
            this.canvas.repaint();
        }

        private void mouseReleased(MouseReleasedEvent ev) {
            this.clickPoint = null;
            FunctionModule.this.calcCoefficients();
            this.fixRange = false;
            this.findRange();
            this.positionHandles(this.graphBounds);
            this.canvas.repaint();
            this.editor.updatePreview();
        }

        private void textChanged() {
            Point tempPos;
            double temp;
            ((FunctionModule)FunctionModule.this).x[this.selected] = this.xField.getValue();
            ((FunctionModule)FunctionModule.this).y[this.selected] = this.yField.getValue();
            while (this.selected > 0 && FunctionModule.this.x[this.selected] < FunctionModule.this.x[this.selected - 1]) {
                temp = FunctionModule.this.x[this.selected];
                ((FunctionModule)FunctionModule.this).x[this.selected] = FunctionModule.this.x[this.selected - 1];
                ((FunctionModule)FunctionModule.this).x[this.selected - 1] = temp;
                temp = FunctionModule.this.y[this.selected];
                ((FunctionModule)FunctionModule.this).y[this.selected] = FunctionModule.this.y[this.selected - 1];
                ((FunctionModule)FunctionModule.this).y[this.selected - 1] = temp;
                tempPos = this.handlePos[this.selected];
                this.handlePos[this.selected] = this.handlePos[this.selected - 1];
                this.handlePos[this.selected - 1] = tempPos;
                --this.selected;
            }
            while (this.selected < FunctionModule.this.x.length - 1 && FunctionModule.this.x[this.selected] > FunctionModule.this.x[this.selected + 1]) {
                temp = FunctionModule.this.x[this.selected];
                ((FunctionModule)FunctionModule.this).x[this.selected] = FunctionModule.this.x[this.selected + 1];
                ((FunctionModule)FunctionModule.this).x[this.selected + 1] = temp;
                temp = FunctionModule.this.y[this.selected];
                ((FunctionModule)FunctionModule.this).y[this.selected] = FunctionModule.this.y[this.selected + 1];
                ((FunctionModule)FunctionModule.this).y[this.selected + 1] = temp;
                tempPos = this.handlePos[this.selected];
                this.handlePos[this.selected] = this.handlePos[this.selected + 1];
                this.handlePos[this.selected + 1] = tempPos;
                ++this.selected;
            }
            this.functionChanged();
        }

        private void functionChanged() {
            FunctionModule.this.repeat = this.repeatBox.getState();
            FunctionModule.this.shape = this.smoothBox.getState() ? (short)1 : 0;
            FunctionModule.this.calcCoefficients();
            if (!this.fixRange) {
                this.findRange();
                this.positionHandles(this.graphBounds);
            }
            this.canvas.repaint();
            this.editor.updatePreview();
        }
    }
}

