/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProceduralModule;
import artofillusion.ui.Translate;
import java.awt.Point;

public class PolarModule
extends ProceduralModule {
    double[] value = new double[2];
    double[] error = new double[2];
    double lastBlur;
    boolean[] valueOk = new boolean[2];
    Vec3[] gradient = new Vec3[]{new Vec3(), new Vec3()};
    Vec3 tempVec1 = new Vec3();
    Vec3 tempVec2 = new Vec3();
    PointInfo point;

    public PolarModule(Point position) {
        super(Translate.text("menu.polarModule"), new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"R"}), new IOPort(0, 1, 3, new String[]{"Theta"})}, position);
    }

    @Override
    public void init(PointInfo p) {
        this.point = p;
        this.valueOk[1] = false;
        this.valueOk[0] = false;
    }

    @Override
    public double getAverageValue(int which, double blur) {
        double yerror;
        double y;
        double xerror;
        double x;
        if (this.valueOk[which] && blur == this.lastBlur) {
            return this.value[which];
        }
        this.lastBlur = blur;
        if (this.linkFrom[0] == null) {
            x = this.point.x;
            xerror = 0.5 * this.point.xsize + blur;
            this.tempVec1.set(1.0, 0.0, 0.0);
        } else {
            x = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
            xerror = this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
            this.linkFrom[0].getValueGradient(this.linkFromIndex[0], this.tempVec1, blur);
        }
        if (this.linkFrom[1] == null) {
            y = this.point.y;
            yerror = 0.5 * this.point.ysize + blur;
            this.tempVec2.set(0.0, 1.0, 0.0);
        } else {
            y = this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
            yerror = this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
            this.linkFrom[1].getValueGradient(this.linkFromIndex[1], this.tempVec2, blur);
        }
        if (!this.valueOk[0]) {
            this.value[0] = Math.sqrt(x * x + y * y);
            if (this.value[0] == 0.0) {
                this.gradient[0].set(0.0, 0.0, 0.0);
                this.error[0] = Math.sqrt(xerror * xerror + yerror * yerror);
            } else {
                this.gradient[0].set(x * this.tempVec1.x + y * this.tempVec2.x, x * this.tempVec1.y + y * this.tempVec2.y, x * this.tempVec1.z + y * this.tempVec2.z);
                this.gradient[0].scale(1.0 / this.value[0]);
                this.error[0] = (Math.abs(x * xerror) + Math.abs(y * yerror)) / this.value[0];
            }
            this.valueOk[0] = true;
        }
        if (which == 1) {
            this.value[1] = Math.atan2(y, x);
            this.gradient[1].set(-y * this.tempVec1.x + x * this.tempVec2.x, -y * this.tempVec1.y + x * this.tempVec2.y, -y * this.tempVec1.z + x * this.tempVec2.z);
            double inv = 1.0 / (this.value[0] * this.value[0]);
            this.gradient[1].scale(inv);
            this.error[1] = 1.5 * (Math.abs(y * xerror) + Math.abs(x * yerror)) * inv;
            this.valueOk[1] = true;
        }
        return this.value[which];
    }

    @Override
    public double getValueError(int which, double blur) {
        if (!this.valueOk[which] || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        return this.error[which];
    }

    @Override
    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (!this.valueOk[which] || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        grad.set(this.gradient[which]);
    }
}

