/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.image.ImageMap;
import artofillusion.object.Object3D;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import buoy.widget.BFrame;
import buoy.widget.WindowWidget;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Texture {
    protected String name;
    protected int id = nextID++;
    private static int nextID;
    public static final int DIFFUSE_COLOR_COMPONENT = 0;
    public static final int SPECULAR_COLOR_COMPONENT = 1;
    public static final int TRANSPARENT_COLOR_COMPONENT = 2;
    public static final int HILIGHT_COLOR_COMPONENT = 3;
    public static final int EMISSIVE_COLOR_COMPONENT = 4;
    public static final int BUMP_COMPONENT = 5;
    public static final int DISPLACEMENT_COMPONENT = 6;

    public static String getTypeName() {
        return "";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract boolean hasComponent(int var1);

    public TextureParameter[] getParameters() {
        return new TextureParameter[0];
    }

    public boolean usesImage(ImageMap image) {
        return false;
    }

    public int getID() {
        return this.id;
    }

    public void assignNewID() {
        this.id = nextID++;
    }

    public void setID(int newid) {
        this.id = newid;
    }

    public abstract void getAverageSpec(TextureSpec var1, double var2, double[] var4);

    public abstract TextureMapping getDefaultMapping(Object3D var1);

    public abstract Texture duplicate();

    public void edit(WindowWidget parent, Scene sc) {
    }

    @Deprecated
    public void edit(BFrame fr, Scene sc) {
        this.edit((WindowWidget)fr, sc);
    }

    public abstract void writeToFile(DataOutputStream var1, Scene var2) throws IOException;
}

