/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.TextureParameter;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureSpec;
import buoy.widget.Widget;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class TextureMapping {
    private boolean twoSided = true;
    private boolean applyToFront = true;
    public static final short FRONT_AND_BACK = 0;
    public static final short FRONT_ONLY = 1;
    public static final short BACK_ONLY = 2;

    public abstract void writeToFile(DataOutputStream var1) throws IOException;

    public abstract Texture getTexture();

    public abstract Object3D getObject();

    public static String getName() {
        return "";
    }

    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        return null;
    }

    public void setParameters(RenderingTriangle tri, double[] p1, double[] p2, double[] p3, RenderingMesh mesh) {
    }

    public abstract void getTextureSpec(Vec3 var1, TextureSpec var2, double var3, double var5, double var7, double[] var9);

    public abstract void getTransparency(Vec3 var1, RGBColor var2, double var3, double var5, double var7, double[] var9);

    public abstract double getDisplacement(Vec3 var1, double var2, double var4, double[] var6);

    public abstract TextureMapping duplicate();

    public abstract TextureMapping duplicate(Object3D var1, Texture var2);

    public abstract void copy(TextureMapping var1);

    public TextureParameter[] getParameters() {
        return this.getTexture().getParameters();
    }

    public short appliesTo() {
        if (this.twoSided) {
            return 0;
        }
        return this.applyToFront ? (short)1 : 2;
    }

    public final boolean appliesToFace(boolean front) {
        return this.twoSided || front == this.applyToFront;
    }

    public void setAppliesTo(short whichFaces) {
        if (whichFaces == 0) {
            this.twoSided = true;
        } else {
            this.twoSided = false;
            this.applyToFront = whichFaces == 1;
        }
    }

    public abstract Widget getEditingPanel(Object3D var1, MaterialPreviewer var2);
}

