/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import buoy.event.ValueChangedEvent;
import buoy.widget.BSlider;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;

public class ValueSlider
extends WidgetContainer {
    BTextField field;
    BSlider slider;
    double value;
    double min;
    double max;
    int increments;
    boolean forceInt;

    public ValueSlider(double min, double max, int increments, double value) {
        this.component = new JPanel(null);
        this.value = value;
        this.min = min;
        this.max = max;
        this.increments = increments;
        this.field = new BTextField(5);
        this.slider = new BSlider((int)((value - min) * (double)increments / (max - min)), 0, increments + 1, BSlider.HORIZONTAL);
        this.setText();
        this.field.addEventLink(ValueChangedEvent.class, (Object)this, "textChanged");
        this.slider.addEventLink(ValueChangedEvent.class, (Object)this, "sliderChanged");
        this.slider.setEnabled(!Double.isNaN(value));
        ((JPanel)this.component).add(this.field.getComponent());
        ((JPanel)this.component).add(this.slider.getComponent());
        this.setAsParent(this.field);
        this.setAsParent(this.slider);
    }

    public void setForceInteger(boolean force) {
        this.forceInt = force;
    }

    private void sliderChanged(ValueChangedEvent ev) {
        double newvalue = (double)this.slider.getValue() * (this.max - this.min) / (double)this.increments + this.min;
        if (newvalue < this.min) {
            newvalue = this.min;
        }
        if (newvalue > this.max) {
            newvalue = this.max;
        }
        if (newvalue == this.value) {
            return;
        }
        this.value = newvalue;
        this.setText();
        this.field.getComponent().setForeground(Color.black);
        this.dispatchEvent(new ValueChangedEvent(this, ev.isInProgress()));
    }

    public void textChanged(ValueChangedEvent ev) {
        double val;
        try {
            val = new Double(this.field.getText());
        }
        catch (NumberFormatException ex) {
            this.field.getComponent().setForeground(Color.red);
            return;
        }
        if (val < this.min || val > this.max) {
            this.field.getComponent().setForeground(Color.red);
        } else if (this.forceInt && val != Math.floor(val)) {
            this.field.getComponent().setForeground(Color.red);
        } else {
            this.value = val;
            this.field.getComponent().setForeground(Color.black);
            this.slider.setValue((int)((this.value - this.min) * (double)this.increments / (this.max - this.min)));
            this.slider.setEnabled(true);
            this.dispatchEvent(new ValueChangedEvent(this, ev.isInProgress()));
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double val) {
        this.value = val;
        this.slider.setValue((int)((val - this.min) * (double)this.increments / (this.max - this.min)));
        this.setText();
    }

    public double getMinimumValue() {
        return this.min;
    }

    public void setMinimumValue(double min) {
        this.min = min;
    }

    public double getMaximumValue() {
        return this.max;
    }

    public void setMaximumValue(double max) {
        this.max = max;
    }

    private void setText() {
        String text;
        if (Double.isNaN(this.value)) {
            text = "";
        } else if (this.value == 0.0 || this.value == -0.0) {
            text = "0.0";
        } else {
            int digits = (int)Math.floor(Math.log(Math.abs(this.value)) / Math.log(10.0));
            double scale = Math.pow(10.0, digits < 0 ? (double)(2 - digits) : 3.0);
            text = Double.toString((double)Math.round(this.value * scale) / scale);
        }
        if (!text.equals(this.field.getText())) {
            this.field.setText(text);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.field.setEnabled(enabled);
        this.slider.setEnabled(enabled && !Double.isNaN(this.value));
        super.setEnabled(enabled);
    }

    @Override
    public int getChildCount() {
        return 2;
    }

    public Collection getChildren() {
        ArrayList<Widget> children = new ArrayList<Widget>(2);
        children.add(this.field);
        children.add(this.slider);
        return children;
    }

    @Override
    public void layoutChildren() {
        Dimension size = this.component.getSize();
        Dimension textPref = this.field.getPreferredSize();
        Dimension scrollPref = this.slider.getPreferredSize();
        this.field.getComponent().setBounds(new Rectangle(0, (size.height - textPref.height) / 2, textPref.width, textPref.height));
        int scrollx = textPref.width + 5;
        this.slider.getComponent().setBounds(new Rectangle(scrollx, (size.height - scrollPref.height) / 2, size.width - scrollx, scrollPref.height));
    }

    @Override
    public synchronized void remove(Widget widget) {
    }

    @Override
    public synchronized void removeAll() {
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim1 = this.field.getMinimumSize();
        Dimension dim2 = this.slider.getMinimumSize();
        return new Dimension(dim1.width + dim2.width + 5, Math.max(dim1.height, dim2.height));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim1 = this.field.getPreferredSize();
        Dimension dim2 = this.slider.getPreferredSize();
        return new Dimension(dim1.width + dim2.width + 5, Math.max(dim1.height, dim2.height));
    }
}

