/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.view;

import artofillusion.Camera;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.ViewerCanvas;
import artofillusion.WireframeMesh;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.texture.TextureSpec;
import artofillusion.view.CanvasDrawer;
import artofillusion.view.FlatVertexShader;
import artofillusion.view.VertexShader;
import buoy.event.RepaintEvent;
import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.image.PixelGrabber;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;

public class GLCanvasDrawer
implements CanvasDrawer {
    private ViewerCanvas view;
    private GLJPanel canvas;
    private GL2 gl;
    private Rectangle bounds;
    private Mat4 lastObjectTransform;
    private Color lastColor;
    private double minDepth;
    private double maxDepth;
    private boolean depthEnabled;
    private boolean lightingEnabled;
    private boolean cullingEnabled;
    private FloatBuffer vertBuffer;
    private FloatBuffer normBuffer;
    private Shape draggedShape;
    private GLImage template;
    private WeakHashMap<Image, GLTexture> textureMap = new WeakHashMap();
    private ReferenceQueue textureCleanupQueue = new ReferenceQueue();
    private HashSet<TextureReference> textureReferences = new HashSet();
    private static final float COLOR_SCALE = 0.003921569f;
    private static HashMap<String, SoftReference<GLImage>> textImageMap = new HashMap();
    private static WeakHashMap<Image, SoftReference<GLImage>> imageMap = new WeakHashMap();
    private static Color lastTextColor;
    private static int imageRenderMode;
    private static boolean useTextureRectangle;

    public GLCanvasDrawer(ViewerCanvas view) {
        this.view = view;
        GLCapabilities caps = new GLCapabilities(GLProfile.get((String)"GL2"));
        this.canvas = new GLJPanel((GLCapabilitiesImmutable)caps);
        this.canvas.addGLEventListener((GLEventListener)new CanvasListener());
    }

    public Component getGLCanvas() {
        return this.canvas;
    }

    @Override
    public void setTemplateImage(Image im) {
        if (im == null) {
            this.template = null;
            return;
        }
        try {
            this.template = new GLImage(im);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawDraggedShape(Shape shape) {
        this.draggedShape = shape;
        this.canvas.display();
    }

    private void prepareView3D(Camera camera) {
        double scale;
        if (camera.getObjectToView() == this.lastObjectTransform) {
            return;
        }
        this.lastObjectTransform = camera.getObjectToView();
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        if (this.view.isPerspective()) {
            scale = -1.0 / camera.getViewToScreen().m11 * camera.getDistToScreen() / 20.0;
            this.gl.glFrustum(-0.5 * (double)this.bounds.width * scale, 0.5 * (double)this.bounds.width * scale, -0.5 * (double)this.bounds.height * scale, 0.5 * (double)this.bounds.height * scale, this.minDepth, this.maxDepth);
        } else {
            scale = -1.0 / camera.getViewToScreen().m11;
            this.gl.glOrtho(-0.5 * (double)this.bounds.width * scale, 0.5 * (double)this.bounds.width * scale, -0.5 * (double)this.bounds.height * scale, 0.5 * (double)this.bounds.height * scale, this.minDepth, this.maxDepth);
        }
        Mat4 toView = this.lastObjectTransform;
        this.gl.glMatrixMode(5888);
        this.gl.glLoadMatrixd(new double[]{-toView.m11, toView.m21, -toView.m31, toView.m41, -toView.m12, toView.m22, -toView.m32, toView.m42, -toView.m13, toView.m23, -toView.m33, toView.m43, -toView.m14, toView.m24, -toView.m34, toView.m44}, 0);
    }

    private void prepareView2D() {
        if (this.lastObjectTransform == null) {
            return;
        }
        this.lastObjectTransform = null;
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        if (this.view.isPerspective()) {
            this.gl.glFrustum(0.0, (double)this.bounds.width, 0.0, (double)this.bounds.height, this.minDepth, this.maxDepth);
        } else {
            this.gl.glOrtho(0.0, (double)this.bounds.width, 0.0, (double)this.bounds.height, this.minDepth, this.maxDepth);
        }
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
    }

    private void prepareDepthTest(boolean depthTest) {
        if (depthTest != this.depthEnabled) {
            this.depthEnabled = depthTest;
            if (this.depthEnabled) {
                this.gl.glEnable(2929);
            } else {
                this.gl.glDisable(2929);
            }
        }
    }

    private void prepareSolidColor(Color color) {
        if (this.lastColor == color) {
            return;
        }
        if (this.lightingEnabled) {
            this.lightingEnabled = false;
            this.gl.glDisable(2896);
        }
        this.lastColor = color;
        this.gl.glColor3f((float)color.getRed() * 0.003921569f, (float)color.getGreen() * 0.003921569f, (float)color.getBlue() * 0.003921569f);
    }

    private void prepareShading(boolean lighting) {
        if (this.lightingEnabled != lighting) {
            this.lightingEnabled = lighting;
            if (lighting) {
                this.gl.glEnable(2896);
            } else {
                this.gl.glDisable(2896);
            }
        }
        this.lastColor = null;
    }

    private void prepareCulling(boolean hideBackfaces) {
        if (this.cullingEnabled == hideBackfaces) {
            return;
        }
        this.cullingEnabled = hideBackfaces;
        if (this.cullingEnabled) {
            this.gl.glEnable(2884);
        } else {
            this.gl.glDisable(2884);
        }
    }

    private void prepareBuffers(int requiredSize) {
        if (this.vertBuffer == null || this.vertBuffer.capacity() < requiredSize) {
            this.vertBuffer = Buffers.newDirectFloatBuffer((int)requiredSize);
            this.normBuffer = Buffers.newDirectFloatBuffer((int)requiredSize);
            this.gl.glVertexPointer(3, 5126, 0, (Buffer)this.vertBuffer);
            this.gl.glNormalPointer(5126, 0, (Buffer)this.normBuffer);
            this.gl.glColorPointer(3, 5126, 0, (Buffer)this.normBuffer);
        }
    }

    @Override
    public void drawBorder() {
        this.prepareView2D();
        this.prepareDepthTest(false);
        this.prepareSolidColor(Color.black);
        double d = -(this.minDepth + 0.001);
        double scale = this.view.isPerspective() ? -d / this.minDepth : 1.0;
        this.gl.glBegin(3);
        this.gl.glVertex3d(0.0, 0.0, d);
        this.gl.glVertex3d((double)(this.bounds.width - 1) * scale, 0.0, d);
        this.gl.glVertex3d((double)(this.bounds.width - 1) * scale, (double)(this.bounds.height - 1) * scale, d);
        this.gl.glVertex3d(0.0, (double)(this.bounds.height - 1) * scale, d);
        this.gl.glVertex3d(0.0, 0.0, d);
        this.gl.glEnd();
        if (this.view.getDrawFocus()) {
            this.prepareSolidColor(ViewerCanvas.lineColor);
            this.gl.glBegin(3);
            this.gl.glVertex3d(scale, scale, d);
            this.gl.glVertex3d((double)(this.bounds.width - 2) * scale, scale, d);
            this.gl.glVertex3d((double)(this.bounds.width - 2) * scale, (double)(this.bounds.height - 2) * scale, d);
            this.gl.glVertex3d(scale, (double)(this.bounds.height - 2) * scale, d);
            this.gl.glVertex3d(scale, scale, d);
            this.gl.glEnd();
        }
    }

    @Override
    public void drawHRule(int y, Color color) {
        this.prepareView2D();
        this.prepareDepthTest(false);
        this.prepareSolidColor(color);
        double d = -(this.minDepth + 0.001);
        double scale = this.view.isPerspective() ? -d / this.minDepth : 1.0;
        this.gl.glBegin(1);
        this.gl.glVertex3d(0.0, (double)(this.bounds.height - y) * scale, d);
        this.gl.glVertex3d((double)this.bounds.width * scale, (double)(this.bounds.height - y) * scale, d);
        this.gl.glEnd();
    }

    @Override
    public void drawVRule(int x, Color color) {
        this.prepareView2D();
        this.prepareDepthTest(false);
        this.prepareSolidColor(color);
        double d = -(this.minDepth + 0.001);
        double scale = this.view.isPerspective() ? -d / this.minDepth : 1.0;
        this.gl.glBegin(1);
        this.gl.glVertex3d((double)x * scale, 0.0, d);
        this.gl.glVertex3d((double)x * scale, (double)this.bounds.height * scale, d);
        this.gl.glEnd();
    }

    @Override
    public void drawBox(int x, int y, int width, int height, Color color) {
        this.prepareView2D();
        this.prepareDepthTest(false);
        this.prepareSolidColor(color);
        float y1 = this.bounds.height - y;
        double d = -(this.minDepth + 0.001);
        double scale = this.view.isPerspective() ? -d / this.minDepth : 1.0;
        this.gl.glBegin(7);
        this.gl.glVertex3d((double)x * scale, (double)y1 * scale, d);
        this.gl.glVertex3d((double)x * scale, (double)(y1 - (float)height) * scale, d);
        this.gl.glVertex3d((double)(x + width) * scale, (double)(y1 - (float)height) * scale, d);
        this.gl.glVertex3d((double)(x + width) * scale, (double)y1 * scale, d);
        this.gl.glEnd();
    }

    @Override
    public void drawBoxes(List<Rectangle> box, Color color) {
        this.prepareView2D();
        this.prepareDepthTest(false);
        this.prepareSolidColor(color);
        this.prepareBuffers(box.size() * 12);
        this.vertBuffer.clear();
        float d = (float)(-(this.minDepth + 0.001));
        for (Rectangle r : box) {
            float y1 = this.bounds.height - r.y;
            float scale = (float)(this.view.isPerspective() ? (double)(-d) / this.minDepth : 1.0);
            this.vertBuffer.put((float)r.x * scale);
            this.vertBuffer.put(y1 * scale);
            this.vertBuffer.put(d);
            this.vertBuffer.put((float)r.x * scale);
            this.vertBuffer.put((y1 - (float)r.height) * scale);
            this.vertBuffer.put(d);
            this.vertBuffer.put((float)(r.x + r.width) * scale);
            this.vertBuffer.put((y1 - (float)r.height) * scale);
            this.vertBuffer.put(d);
            this.vertBuffer.put((float)(r.x + r.width) * scale);
            this.vertBuffer.put(y1 * scale);
            this.vertBuffer.put(d);
        }
        this.gl.glDrawArrays(7, 0, box.size() * 4);
    }

    @Override
    public void renderBox(int x, int y, int width, int height, double depth, Color color) {
        this.prepareView2D();
        this.prepareDepthTest(true);
        this.prepareSolidColor(color);
        float y1 = this.bounds.height - y;
        float d = (float)(-depth);
        this.gl.glBegin(7);
        float scale = (float)(this.view.isPerspective() ? depth / this.minDepth : 1.0);
        this.gl.glVertex3f((float)x * scale, y1 * scale, d);
        this.gl.glVertex3f((float)x * scale, (y1 - (float)height) * scale, d);
        this.gl.glVertex3f((float)(x + width) * scale, (y1 - (float)height) * scale, d);
        this.gl.glVertex3f((float)(x + width) * scale, y1 * scale, d);
        this.gl.glEnd();
    }

    @Override
    public void renderBoxes(List<Rectangle> box, List<Double> depth, Color color) {
        this.prepareView2D();
        this.prepareDepthTest(true);
        this.prepareSolidColor(color);
        this.prepareBuffers(box.size() * 12);
        this.vertBuffer.clear();
        for (int i = 0; i < box.size(); ++i) {
            Rectangle r = box.get(i);
            float y1 = this.bounds.height - r.y;
            float d = -depth.get(i).floatValue();
            float scale = (float)(this.view.isPerspective() ? (double)(-d) / this.minDepth : 1.0);
            this.vertBuffer.put((float)r.x * scale);
            this.vertBuffer.put(y1 * scale);
            this.vertBuffer.put(d);
            this.vertBuffer.put((float)r.x * scale);
            this.vertBuffer.put((y1 - (float)r.height) * scale);
            this.vertBuffer.put(d);
            this.vertBuffer.put((float)(r.x + r.width) * scale);
            this.vertBuffer.put((y1 - (float)r.height) * scale);
            this.vertBuffer.put(d);
            this.vertBuffer.put((float)(r.x + r.width) * scale);
            this.vertBuffer.put(y1 * scale);
            this.vertBuffer.put(d);
        }
        this.gl.glDrawArrays(7, 0, box.size() * 4);
    }

    @Override
    public void drawLine(Point p1, Point p2, Color color) {
        this.prepareView2D();
        this.prepareDepthTest(false);
        this.prepareSolidColor(color);
        double d = -(this.minDepth + 0.001);
        double scale = this.view.isPerspective() ? -d / this.minDepth : 1.0;
        this.gl.glBegin(1);
        this.gl.glVertex3d((double)p1.x * scale, (double)(this.bounds.height - p1.y) * scale, d);
        this.gl.glVertex3d((double)p2.x * scale, (double)(this.bounds.height - p2.y) * scale, d);
        this.gl.glEnd();
    }

    @Override
    public void renderLine(Vec3 p1, Vec3 p2, Camera cam, Color color) {
        this.prepareView3D(cam);
        this.prepareDepthTest(true);
        this.prepareSolidColor(color);
        this.gl.glBegin(1);
        this.gl.glVertex3d(p1.x, p1.y, p1.z);
        this.gl.glVertex3d(p2.x, p2.y, p2.z);
        this.gl.glEnd();
    }

    @Override
    public void renderLine(Vec2 p1, double zf1, Vec2 p2, double zf2, Camera cam, Color color) {
        this.prepareView2D();
        this.prepareDepthTest(true);
        this.prepareSolidColor(color);
        this.gl.glBegin(1);
        if (this.view.isPerspective()) {
            double scale1 = zf1 / this.minDepth;
            double scale2 = zf2 / this.minDepth;
            this.gl.glVertex3d(p1.x * scale1, ((double)this.bounds.height - p1.y) * scale1, -zf1);
            this.gl.glVertex3d(p2.x * scale2, ((double)this.bounds.height - p2.y) * scale2, -zf2);
        } else {
            this.gl.glVertex3d(p1.x, (double)this.bounds.height - p1.y, -zf1);
            this.gl.glVertex3d(p2.x, (double)this.bounds.height - p2.y, -zf2);
        }
        this.gl.glEnd();
    }

    @Override
    public void renderWireframe(WireframeMesh mesh, Camera cam, Color color) {
        this.prepareView3D(cam);
        this.prepareDepthTest(true);
        this.prepareSolidColor(color);
        this.prepareBuffers(mesh.vert.length * 3);
        this.vertBuffer.clear();
        for (int i = 0; i < mesh.vert.length; ++i) {
            Vec3 v = mesh.vert[i];
            this.vertBuffer.put((float)v.x);
            this.vertBuffer.put((float)v.y);
            this.vertBuffer.put((float)v.z);
        }
        int[] vertexIndices = new int[mesh.from.length * 2];
        int j = 0;
        for (int i = 0; i < mesh.from.length; ++i) {
            vertexIndices[j++] = mesh.from[i];
            vertexIndices[j++] = mesh.to[i];
        }
        this.gl.glDrawElements(1, vertexIndices.length, 5125, (Buffer)IntBuffer.wrap(vertexIndices));
    }

    @Override
    public void renderMeshTransparent(RenderingMesh mesh, VertexShader shader, Camera cam, Vec3 viewDir, boolean[] hideFace) {
        boolean invertColor;
        this.prepareView3D(cam);
        this.prepareDepthTest(false);
        this.prepareCulling(false);
        this.prepareShading(false);
        boolean bl = invertColor = ViewerCanvas.backgroundColor.getGreen() > 127;
        if (invertColor) {
            this.gl.glBlendFunc(0, 769);
        } else {
            this.gl.glBlendFunc(1, 1);
        }
        this.gl.glEnable(3042);
        this.gl.glBegin(4);
        RGBColor faceColor = new RGBColor();
        for (int i = 0; i < mesh.triangle.length; ++i) {
            if (hideFace != null && hideFace[i]) continue;
            RenderingTriangle tri = mesh.triangle[i];
            Vec3 vert1 = mesh.vert[tri.v1];
            Vec3 vert2 = mesh.vert[tri.v2];
            Vec3 vert3 = mesh.vert[tri.v3];
            double dot = (float)viewDir.dot(mesh.faceNorm[i]);
            shader.getColor(i, 0, faceColor);
            if (invertColor) {
                faceColor.setRGB(1.0f - faceColor.getRed(), 1.0f - faceColor.getGreen(), 1.0f - faceColor.getBlue());
            }
            faceColor.scale(1.0 - (double)0.8f * Math.abs(dot));
            this.gl.glColor3f(faceColor.getRed(), faceColor.getGreen(), faceColor.getBlue());
            this.gl.glVertex3d(vert1.x, vert1.y, vert1.z);
            this.gl.glVertex3d(vert2.x, vert2.y, vert2.z);
            this.gl.glVertex3d(vert3.x, vert3.y, vert3.z);
        }
        this.gl.glEnd();
        this.gl.glDisable(3042);
    }

    @Override
    public void renderMesh(RenderingMesh mesh, VertexShader shader, Camera cam, boolean closed, boolean[] hideFace) {
        this.prepareView3D(cam);
        this.prepareDepthTest(true);
        this.prepareCulling(closed && hideFace == null);
        boolean uniform = shader.isUniformTexture();
        if (uniform) {
            this.prepareShading(true);
            TextureSpec spec = new TextureSpec();
            shader.getTextureSpec(spec);
            this.gl.glMaterialfv(1032, 5634, FloatBuffer.wrap(new float[]{spec.diffuse.getRed(), spec.diffuse.getGreen(), spec.diffuse.getBlue(), 1.0f}));
            this.gl.glMaterialfv(1032, 4610, FloatBuffer.wrap(new float[]{spec.hilight.getRed(), spec.hilight.getGreen(), spec.hilight.getBlue(), 1.0f}));
            this.gl.glMaterialfv(1032, 5632, FloatBuffer.wrap(new float[]{spec.emissive.getRed(), spec.emissive.getGreen(), spec.emissive.getBlue(), 1.0f}));
            this.gl.glMaterialf(1032, 5633, (float)((1.0 - spec.roughness) * 127.0 + 1.0));
            int[] vertexIndices = null;
            boolean flat = shader instanceof FlatVertexShader;
            if (hideFace == null && !flat) {
                vertexIndices = mesh.getVertexIndices();
            }
            if (vertexIndices != null) {
                Vec3 v;
                int i;
                this.prepareBuffers(mesh.vert.length * 3);
                this.vertBuffer.clear();
                this.normBuffer.clear();
                for (i = 0; i < mesh.vert.length; ++i) {
                    v = mesh.vert[i];
                    this.vertBuffer.put((float)v.x);
                    this.vertBuffer.put((float)v.y);
                    this.vertBuffer.put((float)v.z);
                }
                for (i = 0; i < mesh.norm.length; ++i) {
                    v = mesh.norm[i];
                    this.normBuffer.put((float)v.x);
                    this.normBuffer.put((float)v.y);
                    this.normBuffer.put((float)v.z);
                }
                this.gl.glDrawElements(4, vertexIndices.length, 5125, (Buffer)IntBuffer.wrap(vertexIndices));
            } else {
                this.prepareBuffers(mesh.triangle.length * 9);
                this.vertBuffer.clear();
                this.normBuffer.clear();
                int faceCount = 0;
                for (int i = 0; i < mesh.triangle.length; ++i) {
                    if (hideFace != null && hideFace[i]) continue;
                    ++faceCount;
                    RenderingTriangle tri = mesh.triangle[i];
                    Vec3 v = mesh.vert[tri.v1];
                    this.vertBuffer.put((float)v.x);
                    this.vertBuffer.put((float)v.y);
                    this.vertBuffer.put((float)v.z);
                    v = mesh.vert[tri.v2];
                    this.vertBuffer.put((float)v.x);
                    this.vertBuffer.put((float)v.y);
                    this.vertBuffer.put((float)v.z);
                    v = mesh.vert[tri.v3];
                    this.vertBuffer.put((float)v.x);
                    this.vertBuffer.put((float)v.y);
                    this.vertBuffer.put((float)v.z);
                    if (flat) {
                        v = mesh.faceNorm[i];
                        this.normBuffer.put((float)v.x);
                        this.normBuffer.put((float)v.y);
                        this.normBuffer.put((float)v.z);
                        this.normBuffer.put((float)v.x);
                        this.normBuffer.put((float)v.y);
                        this.normBuffer.put((float)v.z);
                        this.normBuffer.put((float)v.x);
                        this.normBuffer.put((float)v.y);
                        this.normBuffer.put((float)v.z);
                        continue;
                    }
                    v = mesh.norm[tri.n1];
                    this.normBuffer.put((float)v.x);
                    this.normBuffer.put((float)v.y);
                    this.normBuffer.put((float)v.z);
                    v = mesh.norm[tri.n2];
                    this.normBuffer.put((float)v.x);
                    this.normBuffer.put((float)v.y);
                    this.normBuffer.put((float)v.z);
                    v = mesh.norm[tri.n3];
                    this.normBuffer.put((float)v.x);
                    this.normBuffer.put((float)v.y);
                    this.normBuffer.put((float)v.z);
                }
                this.gl.glDrawArrays(4, 0, faceCount * 3);
            }
        } else {
            this.prepareShading(false);
            this.prepareBuffers(mesh.triangle.length * 9);
            this.vertBuffer.clear();
            this.normBuffer.clear();
            int faceCount = 0;
            RGBColor surfaceColor = new RGBColor();
            for (int i = 0; i < mesh.triangle.length; ++i) {
                if (hideFace != null && hideFace[i]) continue;
                ++faceCount;
                RenderingTriangle tri = mesh.triangle[i];
                Vec3 v = mesh.vert[tri.v1];
                this.vertBuffer.put((float)v.x);
                this.vertBuffer.put((float)v.y);
                this.vertBuffer.put((float)v.z);
                v = mesh.vert[tri.v2];
                this.vertBuffer.put((float)v.x);
                this.vertBuffer.put((float)v.y);
                this.vertBuffer.put((float)v.z);
                v = mesh.vert[tri.v3];
                this.vertBuffer.put((float)v.x);
                this.vertBuffer.put((float)v.y);
                this.vertBuffer.put((float)v.z);
                shader.getColor(i, 0, surfaceColor);
                this.normBuffer.put(surfaceColor.getRed());
                this.normBuffer.put(surfaceColor.getGreen());
                this.normBuffer.put(surfaceColor.getBlue());
                if (shader.isUniformFace(i)) {
                    this.normBuffer.put(surfaceColor.getRed());
                    this.normBuffer.put(surfaceColor.getGreen());
                    this.normBuffer.put(surfaceColor.getBlue());
                    this.normBuffer.put(surfaceColor.getRed());
                    this.normBuffer.put(surfaceColor.getGreen());
                    this.normBuffer.put(surfaceColor.getBlue());
                    continue;
                }
                shader.getColor(i, 1, surfaceColor);
                this.normBuffer.put(surfaceColor.getRed());
                this.normBuffer.put(surfaceColor.getGreen());
                this.normBuffer.put(surfaceColor.getBlue());
                shader.getColor(i, 2, surfaceColor);
                this.normBuffer.put(surfaceColor.getRed());
                this.normBuffer.put(surfaceColor.getGreen());
                this.normBuffer.put(surfaceColor.getBlue());
            }
            this.gl.glDisableClientState(32885);
            this.gl.glEnableClientState(32886);
            this.gl.glDrawArrays(4, 0, faceCount * 3);
            this.gl.glDisableClientState(32886);
            this.gl.glEnableClientState(32885);
            this.gl.glEnd();
        }
    }

    @Override
    public void drawString(String text, int x, int y, Color color) {
        GLImage image;
        if (color != lastTextColor) {
            textImageMap.clear();
            lastTextColor = color;
        }
        Font font = this.view.getComponent().getFont();
        FontMetrics fm = this.view.getComponent().getFontMetrics(font);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        SoftReference<GLImage> ref = textImageMap.get(text);
        GLImage gLImage = image = ref == null ? null : ref.get();
        if (image == null) {
            int width = fm.stringWidth(text);
            int height = ascent + descent;
            Image im = this.view.getComponent().createImage(width, height);
            Graphics g = im.getGraphics();
            g.setColor(ViewerCanvas.backgroundColor);
            g.fillRect(0, 0, width, height);
            g.setColor(color);
            g.setFont(font);
            g.drawString(text, 0, ascent);
            g.dispose();
            try {
                image = new GLImage(im);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                return;
            }
            textImageMap.put(text, new SoftReference<GLImage>(image));
        }
        this.drawImage(image, x, y - ascent);
    }

    @Override
    public void drawImage(Image image, int x, int y) {
        try {
            this.drawImage(this.getCachedImage(image, false), x, y);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void renderImage(Image image, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4, Camera camera) {
        GLTexture record;
        try {
            record = this.getCachedTexture(image);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return;
        }
        this.prepareView3D(camera);
        this.prepareDepthTest(true);
        this.prepareCulling(false);
        this.prepareShading(false);
        double width = useTextureRectangle ? (double)record.width : 1.0;
        double height = useTextureRectangle ? (double)record.height : 1.0;
        this.gl.glEnable(imageRenderMode);
        this.gl.glBindTexture(imageRenderMode, record.getTextureId());
        this.gl.glBegin(7);
        this.gl.glVertex3d(p1.x, p1.y, p1.z);
        this.gl.glTexCoord2d(width, 0.0);
        this.gl.glVertex3d(p2.x, p2.y, p2.z);
        this.gl.glTexCoord2d(width, height);
        this.gl.glVertex3d(p3.x, p3.y, p3.z);
        this.gl.glTexCoord2d(0.0, height);
        this.gl.glVertex3d(p4.x, p4.y, p4.z);
        this.gl.glTexCoord2d(0.0, 0.0);
        this.gl.glEnd();
        this.gl.glDisable(imageRenderMode);
    }

    @Override
    public void imageChanged(Image image) {
        imageMap.remove(image);
    }

    private GLImage getCachedImage(Image image, boolean texture) throws InterruptedException {
        GLImage record = null;
        SoftReference<GLImage> ref = imageMap.get(image);
        if (ref != null) {
            record = ref.get();
        }
        if (record == null) {
            Image sourceImage = image;
            if (texture && !useTextureRectangle) {
                int width = image.getWidth(null);
                int height = image.getHeight(null);
                int newWidth = (int)Math.pow(2.0, Math.ceil(Math.log(width) / Math.log(2.0)));
                int newHeight = (int)Math.pow(2.0, Math.ceil(Math.log(height) / Math.log(2.0)));
                if (newWidth != width || newHeight != height) {
                    sourceImage = image.getScaledInstance(newWidth, newHeight, 4);
                    MediaTracker mt = new MediaTracker((Component)this.canvas);
                    mt.addImage(sourceImage, 0);
                    mt.waitForID(0);
                }
            }
            record = new GLImage(sourceImage);
            imageMap.put(image, new SoftReference<GLImage>(record));
        }
        return record;
    }

    private GLTexture getCachedTexture(Image image) throws InterruptedException {
        GLTexture record = this.textureMap.get(image);
        if (record == null) {
            record = new GLTexture(image);
            this.textureMap.put(image, record);
        }
        return record;
    }

    private void drawImage(GLImage image, int x, int y) {
        this.prepareView2D();
        this.prepareDepthTest(false);
        this.gl.glEnable(3008);
        double d = -(this.minDepth + 0.001);
        this.gl.glRasterPos3d((double)x, (double)Math.max(0, this.bounds.height - image.height - y), d);
        this.gl.glDrawPixels(image.width, image.height, 6408, 5121, (Buffer)image.data);
        this.gl.glDisable(3008);
    }

    @Override
    public void drawShape(Shape shape, Color color) {
        this.drawShape(shape, color, 3);
    }

    @Override
    public void fillShape(Shape shape, Color color) {
        this.drawShape(shape, color, 9);
    }

    public void drawShape(Shape shape, Color color, int mode) {
        this.prepareView2D();
        this.prepareDepthTest(false);
        this.prepareSolidColor(color);
        Point lastMove = null;
        PathIterator path = shape.getPathIterator(null);
        float[] coords = new float[6];
        double d = -(this.minDepth + 0.001);
        double scale = this.view.isPerspective() ? -d / this.minDepth : 1.0;
        this.gl.glBegin(mode);
        while (!path.isDone()) {
            int type = path.currentSegment(coords);
            if (type == 0) {
                this.gl.glEnd();
                this.gl.glBegin(mode);
                lastMove = new Point((int)coords[0], (int)coords[1]);
                this.gl.glVertex3d((double)lastMove.x * scale, (double)(this.bounds.height - lastMove.y) * scale, d);
            } else if (type == 1) {
                this.gl.glVertex3d((double)coords[0] * scale, (double)((float)this.bounds.height - coords[1]) * scale, d);
            } else if (type == 4) {
                this.gl.glVertex3d((double)lastMove.x * scale, (double)(this.bounds.height - lastMove.y) * scale, d);
            }
            path.next();
        }
        this.gl.glEnd();
    }

    static {
        imageRenderMode = -1;
    }

    private class TextureReference
    extends PhantomReference<GLTexture> {
        private int textureId;

        TextureReference(GLTexture texture) {
            super(texture, GLCanvasDrawer.this.textureCleanupQueue);
            this.textureId = texture.getTextureId();
        }
    }

    private class GLTexture {
        public int width;
        public int height;
        private int[] textureId;

        public GLTexture(Image image) throws InterruptedException {
            GLImage glImage = GLCanvasDrawer.this.getCachedImage(image, true);
            this.width = glImage.width;
            this.height = glImage.height;
            this.textureId = new int[1];
            GLCanvasDrawer.this.gl.glGenTextures(1, this.textureId, 0);
            GLCanvasDrawer.this.gl.glBindTexture(imageRenderMode, this.textureId[0]);
            GLCanvasDrawer.this.gl.glPixelStorei(3317, 1);
            GLCanvasDrawer.this.gl.glTexParameteri(imageRenderMode, 10242, 10496);
            GLCanvasDrawer.this.gl.glTexParameteri(imageRenderMode, 10243, 10496);
            GLCanvasDrawer.this.gl.glTexParameteri(imageRenderMode, 10240, 9728);
            GLCanvasDrawer.this.gl.glTexParameteri(imageRenderMode, 10241, 9728);
            GLCanvasDrawer.this.gl.glTexEnvf(8960, 8704, 8449.0f);
            GLCanvasDrawer.this.gl.glTexImage2D(imageRenderMode, 0, 6408, this.width, this.height, 0, 6408, 5121, (Buffer)glImage.data);
            GLCanvasDrawer.this.textureReferences.add(new TextureReference(this));
        }

        public int getTextureId() {
            return this.textureId[0];
        }
    }

    private static class GLImage {
        public ByteBuffer data;
        public int width;
        public int height;

        public GLImage(Image image) throws InterruptedException {
            this.width = image.getWidth(null);
            this.height = image.getHeight(null);
            PixelGrabber pg = new PixelGrabber(image, 0, 0, -1, -1, true);
            pg.grabPixels();
            int[] templatePixel = (int[])pg.getPixels();
            byte[] dataArray = new byte[templatePixel.length * 4];
            int pos = 0;
            for (int row = 0; row < this.height; ++row) {
                for (int col = 0; col < this.width; ++col) {
                    int argb = templatePixel[this.width * (this.height - row - 1) + col];
                    dataArray[pos++] = (byte)(argb >> 16);
                    dataArray[pos++] = (byte)(argb >> 8);
                    dataArray[pos++] = (byte)argb;
                    dataArray[pos++] = (byte)(argb >> 24);
                }
            }
            this.data = ByteBuffer.wrap(dataArray);
        }
    }

    private class CanvasListener
    implements GLEventListener {
        private CanvasListener() {
        }

        public void init(GLAutoDrawable drawable) {
            GL2 gl = (GL2)drawable.getGL();
            gl.glShadeModel(7425);
            gl.glLightfv(16384, 4611, FloatBuffer.wrap(new float[]{0.0f, 0.0f, 1.0f, 0.0f}));
            gl.glLightfv(16384, 4609, FloatBuffer.wrap(new float[]{0.8f, 0.8f, 0.8f, 1.0f}));
            gl.glEnable(16384);
            gl.glLightModelfv(2899, FloatBuffer.wrap(new float[]{0.1f, 0.1f, 0.1f, 1.0f}));
            gl.glLightModeli(2898, 1);
            gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
            gl.glEnableClientState(32884);
            gl.glEnableClientState(32885);
            gl.glAlphaFunc(516, 0.0f);
            if (imageRenderMode == -1) {
                if (gl.glGetString(7939).contains("GL_EXT_texture_rectangle")) {
                    imageRenderMode = 34037;
                    useTextureRectangle = true;
                } else {
                    imageRenderMode = 3553;
                    useTextureRectangle = false;
                }
            }
        }

        public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        }

        public void display(GLAutoDrawable drawable) {
            Reference ref;
            GLCanvasDrawer.this.view.prepareCameraForRendering();
            GLCanvasDrawer.this.gl = (GL2)drawable.getGL();
            Color background = ViewerCanvas.backgroundColor;
            GLCanvasDrawer.this.gl.glClearColor((float)background.getRed() / 255.0f, (float)background.getGreen() / 255.0f, (float)background.getBlue() / 255.0f, 0.0f);
            GLCanvasDrawer.this.gl.glClear(16640);
            GLCanvasDrawer.this.bounds = GLCanvasDrawer.this.canvas.getBounds();
            GLCanvasDrawer.this.gl.glEnable(2929);
            GLCanvasDrawer.this.depthEnabled = true;
            GLCanvasDrawer.this.lastObjectTransform = Mat4.identity();
            GLCanvasDrawer.this.lastColor = new Color(0);
            double[] depthRange = GLCanvasDrawer.this.view.estimateDepthRange();
            if (GLCanvasDrawer.this.view.getShowGrid() && GLCanvasDrawer.this.view.isPerspective()) {
                double maxGridSize = 10.0 * Math.sqrt(2.0);
                double gridCenterDist = GLCanvasDrawer.this.view.getCamera().getWorldToView().times(new Vec3()).length();
                depthRange[0] = Math.min(depthRange[0], gridCenterDist - maxGridSize);
                depthRange[1] = Math.max(depthRange[1], gridCenterDist + maxGridSize);
            }
            if (GLCanvasDrawer.this.view.isPerspective()) {
                GLCanvasDrawer.this.minDepth = GLCanvasDrawer.this.view.getCamera().getDistToScreen() / 20.0;
            } else {
                GLCanvasDrawer.this.minDepth = Math.min(-0.01, depthRange[0]);
            }
            GLCanvasDrawer.this.minDepth = GLCanvasDrawer.this.minDepth - 0.01;
            GLCanvasDrawer.this.maxDepth = depthRange[1] + 0.01;
            if (GLCanvasDrawer.this.view.getTemplateShown()) {
                GLCanvasDrawer.this.drawImage(GLCanvasDrawer.this.template, 0, 0);
            }
            GLCanvasDrawer.this.gl.glClear(256);
            GLCanvasDrawer.this.view.updateImage();
            GLCanvasDrawer.this.view.getCurrentTool().drawOverlay(GLCanvasDrawer.this.view);
            if (GLCanvasDrawer.this.draggedShape != null) {
                GLCanvasDrawer.this.drawShape(GLCanvasDrawer.this.draggedShape, ViewerCanvas.lineColor);
            }
            GLCanvasDrawer.this.draggedShape = null;
            while ((ref = GLCanvasDrawer.this.textureCleanupQueue.poll()) != null) {
                GLCanvasDrawer.this.gl.glDeleteTextures(1, new int[]{((TextureReference)ref).textureId}, 0);
                GLCanvasDrawer.this.textureReferences.remove(ref);
            }
            GLCanvasDrawer.this.view.dispatchEvent(new RepaintEvent(GLCanvasDrawer.this.view, null));
        }

        public void displayChanged(GLAutoDrawable drawable, boolean arg1, boolean arg2) {
        }

        public void dispose(GLAutoDrawable drawable) {
        }
    }
}

