/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.view;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.math.FastMath;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.texture.ConstantParameterValue;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformMapping;
import artofillusion.texture.VertexParameterValue;
import artofillusion.view.SmoothVertexShader;
import artofillusion.view.VertexShader;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.WeakHashMap;

public class TexturedVertexShader
implements VertexShader {
    private TextureSpec spec;
    private RenderingMesh mesh;
    private Vec3 viewDir;
    private RGBColor diffuse;
    private RGBColor emissive;
    private RGBColor hilight;
    private double time;
    private double[] roughnessCache;
    private float[] diffuseCache;
    private float[] emissiveCache;
    private float[] hilightCache;
    private boolean cachePerFace;
    private int textureID;
    private static final WeakHashMap<RenderingMesh, SoftReference<TexturedVertexShader>> cachedShaderMap = new WeakHashMap();

    public TexturedVertexShader(RenderingMesh mesh, Object3D object, double time, Vec3 viewDir) {
        this.mesh = mesh;
        this.time = time;
        this.viewDir = viewDir;
        this.spec = new TextureSpec();
        this.diffuse = new RGBColor();
        this.emissive = new RGBColor();
        this.hilight = new RGBColor();
        this.textureID = mesh.mapping.getTexture().getID();
        ParameterValue[] value = object.getParameterValues();
        for (int i = 0; i < value.length; ++i) {
            if (value[i] instanceof ConstantParameterValue || value[i] instanceof VertexParameterValue) continue;
            this.cachePerFace = true;
            return;
        }
    }

    public VertexShader optimize() {
        TexturedVertexShader shader;
        if (this.mesh.mapping instanceof UniformMapping && !this.mesh.mapping.getTexture().hasComponent(3)) {
            this.mesh.mapping.getTexture().getAverageSpec(this.spec, this.time, null);
            RGBColor color = new RGBColor((double)(this.spec.diffuse.getRed() + this.spec.emissive.getRed()) + 0.5 * (double)this.spec.specular.getRed(), (double)(this.spec.diffuse.getGreen() + this.spec.emissive.getGreen()) + 0.5 * (double)this.spec.specular.getGreen(), (double)(this.spec.diffuse.getBlue() + this.spec.emissive.getBlue()) + 0.5 * (double)this.spec.specular.getBlue());
            color.clip();
            return new SmoothVertexShader(this.mesh, color, this.viewDir);
        }
        SoftReference<TexturedVertexShader> ref = cachedShaderMap.get(this.mesh);
        if (ref != null && (shader = ref.get()) != null && shader.textureID == this.textureID) {
            shader.viewDir = this.viewDir;
            return shader;
        }
        cachedShaderMap.put(this.mesh, new SoftReference<TexturedVertexShader>(this));
        return this;
    }

    @Override
    public void getColor(int face, int vertex, RGBColor color) {
        double roughness;
        double dot;
        RenderingTriangle tri;
        if (this.cachePerFace) {
            if (this.diffuseCache == null) {
                this.diffuseCache = new float[9 * this.mesh.triangle.length];
                this.emissiveCache = new float[9 * this.mesh.triangle.length];
                this.hilightCache = new float[9 * this.mesh.triangle.length];
                this.roughnessCache = new double[9 * this.mesh.triangle.length];
                Arrays.fill(this.roughnessCache, -1.0);
            }
            tri = this.mesh.triangle[face];
            switch (vertex) {
                case 0: {
                    dot = this.viewDir.dot(this.mesh.norm[tri.n1]);
                    if (this.roughnessCache[3 * face] != -1.0) break;
                    tri.getTextureSpec(this.spec, -dot, 1.0, 0.0, 0.0, 0.1, this.time);
                    break;
                }
                case 1: {
                    dot = this.viewDir.dot(this.mesh.norm[tri.n2]);
                    if (this.roughnessCache[3 * face + 1] != -1.0) break;
                    tri.getTextureSpec(this.spec, -dot, 0.0, 1.0, 0.0, 0.1, this.time);
                    break;
                }
                default: {
                    dot = this.viewDir.dot(this.mesh.norm[tri.n3]);
                    if (this.roughnessCache[3 * face + 2] != -1.0) break;
                    tri.getTextureSpec(this.spec, -dot, 0.0, 0.0, 1.0, 0.1, this.time);
                }
            }
            int cacheIndex = 9 * face + 3 * vertex;
            if (this.roughnessCache[3 * face + vertex] == -1.0) {
                this.diffuseCache[cacheIndex] = this.spec.diffuse.getRed();
                this.diffuseCache[cacheIndex + 1] = this.spec.diffuse.getGreen();
                this.diffuseCache[cacheIndex + 2] = this.spec.diffuse.getBlue();
                this.emissiveCache[cacheIndex] = this.spec.emissive.getRed();
                this.emissiveCache[cacheIndex + 1] = this.spec.emissive.getGreen();
                this.emissiveCache[cacheIndex + 2] = this.spec.emissive.getBlue();
                this.hilightCache[cacheIndex] = this.spec.hilight.getRed();
                this.hilightCache[cacheIndex + 1] = this.spec.hilight.getGreen();
                this.hilightCache[cacheIndex + 2] = this.spec.hilight.getBlue();
                this.roughnessCache[3 * face + vertex] = this.spec.roughness;
            }
            this.diffuse.setRGB(this.diffuseCache[cacheIndex], this.diffuseCache[cacheIndex + 1], this.diffuseCache[cacheIndex + 2]);
            this.emissive.setRGB(this.emissiveCache[cacheIndex], this.emissiveCache[cacheIndex + 1], this.emissiveCache[cacheIndex + 2]);
            this.hilight.setRGB(this.hilightCache[cacheIndex], this.hilightCache[cacheIndex + 1], this.hilightCache[cacheIndex + 2]);
            roughness = this.roughnessCache[3 * face + vertex];
        } else {
            int vert;
            if (this.diffuseCache == null) {
                this.diffuseCache = new float[3 * this.mesh.vert.length];
                this.emissiveCache = new float[3 * this.mesh.vert.length];
                this.hilightCache = new float[3 * this.mesh.vert.length];
                this.roughnessCache = new double[this.mesh.vert.length];
                Arrays.fill(this.roughnessCache, -1.0);
            }
            tri = this.mesh.triangle[face];
            switch (vertex) {
                case 0: {
                    vert = tri.v1;
                    dot = this.viewDir.dot(this.mesh.norm[tri.n1]);
                    if (this.roughnessCache[vert] != -1.0) break;
                    tri.getTextureSpec(this.spec, -dot, 1.0, 0.0, 0.0, 0.1, this.time);
                    break;
                }
                case 1: {
                    vert = tri.v2;
                    dot = this.viewDir.dot(this.mesh.norm[tri.n2]);
                    if (this.roughnessCache[vert] != -1.0) break;
                    tri.getTextureSpec(this.spec, -dot, 0.0, 1.0, 0.0, 0.1, this.time);
                    break;
                }
                default: {
                    vert = tri.v3;
                    dot = this.viewDir.dot(this.mesh.norm[tri.n3]);
                    if (this.roughnessCache[vert] != -1.0) break;
                    tri.getTextureSpec(this.spec, -dot, 0.0, 0.0, 1.0, 0.1, this.time);
                }
            }
            if (this.roughnessCache[vert] == -1.0) {
                this.diffuseCache[3 * vert] = this.spec.diffuse.getRed();
                this.diffuseCache[3 * vert + 1] = this.spec.diffuse.getGreen();
                this.diffuseCache[3 * vert + 2] = this.spec.diffuse.getBlue();
                this.emissiveCache[3 * vert] = this.spec.emissive.getRed();
                this.emissiveCache[3 * vert + 1] = this.spec.emissive.getGreen();
                this.emissiveCache[3 * vert + 2] = this.spec.emissive.getBlue();
                this.hilightCache[3 * vert] = this.spec.hilight.getRed();
                this.hilightCache[3 * vert + 1] = this.spec.hilight.getGreen();
                this.hilightCache[3 * vert + 2] = this.spec.hilight.getBlue();
                this.roughnessCache[vert] = this.spec.roughness;
            }
            this.diffuse.setRGB(this.diffuseCache[3 * vert], this.diffuseCache[3 * vert + 1], this.diffuseCache[3 * vert + 2]);
            this.emissive.setRGB(this.emissiveCache[3 * vert], this.emissiveCache[3 * vert + 1], this.emissiveCache[3 * vert + 2]);
            this.hilight.setRGB(this.hilightCache[3 * vert], this.hilightCache[3 * vert + 1], this.hilightCache[3 * vert + 2]);
            roughness = this.roughnessCache[vert];
        }
        double absDot = dot > 0.0 ? dot : -dot;
        color.setRGB((double)this.diffuse.getRed() * absDot + (double)this.emissive.getRed(), (double)this.diffuse.getGreen() * absDot + (double)this.emissive.getGreen(), (double)this.diffuse.getBlue() * absDot + (double)this.emissive.getBlue());
        if ((double)(this.hilight.getRed() + this.hilight.getGreen() + this.hilight.getBlue()) > 0.0) {
            float intensity = (float)FastMath.pow(absDot, (int)((1.0 - roughness) * 128.0) + 1);
            color.add(this.hilight.getRed() * intensity, this.hilight.getGreen() * intensity, this.hilight.getBlue() * intensity);
        }
        color.clip();
    }

    @Override
    public boolean isUniformFace(int face) {
        return false;
    }

    @Override
    public boolean isUniformTexture() {
        return this.mesh.mapping instanceof UniformMapping;
    }

    @Override
    public void getTextureSpec(TextureSpec spec) {
        this.mesh.mapping.getTexture().getAverageSpec(spec, this.time, null);
    }

    public static void clearCachedShaders(RenderingMesh mesh) {
        cachedShaderMap.remove(mesh);
    }
}

