/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.view;

import artofillusion.ArtOfIllusion;
import artofillusion.Camera;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class ViewAnimation {
    EditingWindow window;
    boolean animate = ArtOfIllusion.getPreferences().getUseViewAnimations();
    double maxDuration = ArtOfIllusion.getPreferences().getMaxAnimationDuration();
    double displayFrq = ArtOfIllusion.getPreferences().getAnimationFrameRate();
    double interval = 1.0 / this.displayFrq;
    int timerInterval = (int)(this.interval * 1000.0);
    int steps = 0;
    int step = 1;
    CoordinateSystem startCoords;
    CoordinateSystem endCoords;
    CoordinateSystem aniCoords;
    Vec3 endRotationCenter;
    Vec3 rotStart;
    Vec3 rotAni;
    Vec3 aniZ;
    Vec3 aniOrigin;
    ViewerCanvas view;
    Camera camera;
    ObjectInfo boundCamera;
    double[] startAngles;
    double[] endAngles;
    double startDist;
    double endDist;
    double aniDist;
    double distanceFactor;
    double moveDist;
    double startWeightLin;
    double endWeightLin;
    double startWeightExp;
    double endWeightExp;
    double angleX;
    double angleY;
    double angleZ;
    double angleMax;
    double startScale;
    double endScale;
    double scalingFactor;
    double startAngle;
    double endAngle;
    double angleStep;
    double aniAngle;
    double timeRot;
    double timeScale;
    double timeDist;
    double timeMove;
    double timeAni;
    double endDistToScreen;
    double refDistToScreen;
    double refDistToPlane;
    double refTangent;
    double rotSlope = 1.5;
    double moveSlope = 1.5;
    double scaleSlope = 0.1;
    double distSlope = 0.1;
    double perspSlope = 3.0;
    int endOrientation;
    int endNavigation;
    long msStart;
    long msEnd;
    long ms1st = 0L;
    long msLast;
    long msLatest;
    boolean endPerspective;
    boolean changingPerspective;
    boolean animatingMove;
    boolean endShowGrid;
    int viewH;
    int viewW;
    private Timer timer = new Timer(this.timerInterval, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ViewAnimation.this.step >= ViewAnimation.this.steps) {
                ViewAnimation.this.endAnimation();
            } else if (ViewAnimation.this.changingPerspective) {
                ViewAnimation.this.perspectiveStep();
            } else {
                ViewAnimation.this.animationStep();
            }
        }
    });

    public ViewAnimation(EditingWindow win, ViewerCanvas v) {
        this.window = win;
        this.view = v;
        this.viewH = this.view.getBounds().height;
        this.viewW = this.view.getBounds().width;
        this.timer.setCoalesce(false);
    }

    public boolean changingPerspective() {
        return this.changingPerspective;
    }

    public boolean animatingMove() {
        return this.animatingMove;
    }

    public void start(boolean nextPerspective) {
        if (this.changingPerspective) {
            return;
        }
        this.camera = this.view.getCamera();
        this.endPerspective = nextPerspective;
        this.endRotationCenter = this.view.getRotationCenter();
        this.endOrientation = this.view.getOrientation();
        this.endNavigation = this.view.getNavigationMode();
        this.endDistToScreen = this.camera.getDistToScreen();
        this.refDistToScreen = this.camera.getDistToScreen();
        this.refDistToPlane = this.view.getDistToPlane();
        this.endCoords = this.camera.getCameraCoordinates().duplicate();
        this.endScale = nextPerspective ? 100.0 : 100.0 * this.refDistToScreen / this.refDistToPlane;
        this.checkPreferences();
        if (!this.animate) {
            this.endAnimation();
            return;
        }
        this.endShowGrid = this.view.getShowGrid();
        this.view.setShowGrid(false);
        this.refDistToPlane = this.refDistToPlane;
        this.startCoords = this.camera.getCameraCoordinates().duplicate();
        this.aniCoords = this.camera.getCameraCoordinates().duplicate();
        double sinComp = (double)this.view.getBounds().height / 2.0 / 100.0;
        double cosComp = this.refDistToScreen;
        double halfViewAngle = Math.atan2(sinComp, cosComp);
        double timePersp = 0.0;
        this.refTangent = cosComp / sinComp;
        if (nextPerspective) {
            this.startAngle = 1.5707963267948966;
            this.endAngle = 1.5707963267948966 - halfViewAngle;
        } else {
            this.endAngle = 1.5707963267948966;
            this.startAngle = 1.5707963267948966 - halfViewAngle;
        }
        if (this.endAngle == this.startAngle) {
            return;
        }
        timePersp = this.maxDuration * Math.pow(halfViewAngle / Math.PI / 2.0, 1.0 / this.perspSlope);
        this.steps = (int)(timePersp / this.interval);
        this.angleStep = (this.endAngle - this.startAngle) / (double)this.steps;
        this.step = 1;
        this.changingPerspective = true;
        this.boundCamera = this.view.getBoundCamera();
        this.timer.restart();
    }

    private void perspectiveStep() {
        this.aniAngle = this.startAngle + (double)this.step * this.angleStep;
        this.distanceFactor = Math.tan(this.aniAngle) / this.refTangent;
        this.aniDist = this.refDistToPlane * this.distanceFactor;
        this.aniOrigin = this.endRotationCenter.plus(this.aniCoords.getZDirection().times(-this.aniDist));
        this.aniCoords.setOrigin(this.aniOrigin);
        this.camera.setCameraCoordinates(this.aniCoords);
        this.view.setDistToPlane(this.aniDist);
        this.camera.setDistToScreen(this.refDistToScreen * this.distanceFactor);
        if (this.step == 1) {
            this.view.preparePerspectiveAnimation();
        }
        this.view.repaint();
        ++this.step;
    }

    public void start(CoordinateSystem endCoords, Vec3 endRotationCenter, double endScale, int endOrientation, int nextNavigation) {
        if (this.changingPerspective) {
            return;
        }
        this.endCoords = endCoords;
        this.endRotationCenter = endRotationCenter;
        this.endScale = endScale;
        this.endOrientation = endOrientation;
        this.endPerspective = nextNavigation > 1 ? true : this.view.isPerspectiveSwitch();
        this.endNavigation = nextNavigation;
        this.endShowGrid = this.view.getShowGrid();
        this.camera = this.view.getCamera();
        this.endDistToScreen = this.camera.getDistToScreen();
        this.checkPreferences();
        if (!this.animate) {
            this.endAnimation();
            return;
        }
        if (!this.animatingMove) {
            this.startCoords = this.camera.getCameraCoordinates().duplicate();
        }
        this.aniCoords = this.camera.getCameraCoordinates().duplicate();
        this.rotStart = this.view.getRotationCenter();
        this.startScale = this.view.getScale();
        this.startAngles = this.startCoords.getRotationAngles();
        this.endAngles = endCoords.getRotationAngles();
        this.startDist = this.startCoords.getOrigin().minus(this.rotStart).length();
        this.endDist = endCoords.getOrigin().minus(endRotationCenter).length();
        if (this.noMove()) {
            this.endAnimation();
            return;
        }
        this.aniDist = this.startDist;
        this.moveDist = endRotationCenter.minus(this.rotStart).length();
        this.step = 1;
        if (this.startAngles[0] == 90.0 && this.startAngles[1] == 0.0 && this.startAngles[2] == 180.0) {
            this.startAngles[1] = 180.0;
            this.startAngles[2] = 0.0;
        }
        if (this.endAngles[0] == 90.0 && this.endAngles[1] == 0.0 && this.endAngles[2] == 180.0) {
            this.endAngles[1] = 180.0;
            this.endAngles[2] = 0.0;
        }
        if (this.endAngles[0] - this.startAngles[0] < -180.0) {
            this.endAngles[0] = this.endAngles[0] + 360.0;
        }
        if (this.endAngles[1] - this.startAngles[1] < -180.0) {
            this.endAngles[1] = this.endAngles[1] + 360.0;
        }
        if (this.endAngles[2] - this.startAngles[2] < -180.0) {
            this.endAngles[2] = this.endAngles[2] + 360.0;
        }
        if (this.endAngles[0] - this.startAngles[0] > 180.0) {
            this.endAngles[0] = this.endAngles[0] - 360.0;
        }
        if (this.endAngles[1] - this.startAngles[1] > 180.0) {
            this.endAngles[1] = this.endAngles[1] - 360.0;
        }
        if (this.endAngles[2] - this.startAngles[2] > 180.0) {
            this.endAngles[2] = this.endAngles[2] - 360.0;
        }
        this.angleMax = Math.abs(this.endAngles[0] - this.startAngles[0]);
        if (Math.abs(this.endAngles[1] - this.startAngles[1]) > this.angleMax) {
            this.angleMax = Math.abs(this.endAngles[1] - this.startAngles[1]);
        }
        if (Math.abs(this.endAngles[2] - this.startAngles[2]) > this.angleMax) {
            this.angleMax = Math.abs(this.endAngles[2] - this.startAngles[2]);
        }
        this.timeRot = this.maxDuration * (1.0 - 1.0 / (1.0 + this.angleMax / 180.0 * this.rotSlope));
        this.timeScale = 0.0;
        if (endScale > this.startScale) {
            this.timeScale = this.maxDuration * (1.0 - this.startScale / (this.startScale + this.scaleSlope * (endScale - this.startScale)));
        }
        if (this.startScale > endScale) {
            this.timeScale = this.maxDuration * (1.0 - endScale / (endScale + this.scaleSlope * (this.startScale - endScale)));
        }
        this.timeDist = 0.0;
        if (this.endDist > this.startDist) {
            this.timeDist = this.maxDuration * (1.0 - this.startDist / (this.startDist + this.distSlope * (this.endDist - this.startDist)));
        }
        if (this.startDist > this.endDist) {
            this.timeDist = this.maxDuration * (1.0 - this.endDist / (this.endDist + this.distSlope * (this.startDist - this.endDist)));
        }
        this.timeMove = 0.0;
        if (this.view.isPerspective()) {
            double pixS = this.moveDist * 2000.0 / this.startDist;
            double pixE = this.moveDist * 2000.0 / this.endDist;
            double pixA = pixS + pixE;
            this.timeMove = this.maxDuration * (1.0 - 1.0 / (1.0 + pixA / 3200.0 * this.moveSlope));
        } else {
            double pixS = this.moveDist * this.startScale;
            double pixE = this.moveDist * endScale;
            double pixA = pixS + pixE;
            this.timeMove = this.maxDuration * (1.0 - 1.0 / (1.0 + pixA / 3200.0 * this.moveSlope));
        }
        this.timeAni = 0.0;
        if (this.timeAni < this.timeRot) {
            this.timeAni = this.timeRot;
        }
        if (this.timeAni < this.timeScale) {
            this.timeAni = this.timeScale;
        }
        if (this.timeAni < this.timeDist) {
            this.timeAni = this.timeDist;
        }
        if (this.timeAni < this.timeMove) {
            this.timeAni = this.timeMove;
        }
        if (this.timeAni == 0.0) {
            this.endAnimation();
            return;
        }
        this.steps = (int)(this.timeAni / this.interval);
        this.scalingFactor = Math.pow(endScale / this.startScale, 1.0 / (double)this.steps);
        this.distanceFactor = Math.pow(this.endDist / this.startDist, 1.0 / (double)this.steps);
        if (endOrientation != this.view.getOrientation()) {
            this.view.setOrientation(Integer.MAX_VALUE);
            this.view.viewChanged(false);
        }
        this.boundCamera = this.view.getBoundCamera();
        this.animatingMove = true;
        this.timer.restart();
    }

    private void animationStep() {
        this.startWeightLin = (double)(this.steps - this.step) / (double)this.steps;
        this.endWeightLin = (double)this.step / (double)this.steps;
        if (this.view.isPerspective()) {
            if (this.distanceFactor == 1.0 || this.steps <= 1) {
                this.startWeightExp = this.startWeightLin;
                this.endWeightExp = this.endWeightLin;
            } else {
                this.startWeightExp = (Math.pow(1.0 / this.distanceFactor, this.steps - this.step) - 1.0) / (1.0 / Math.pow(this.distanceFactor, this.steps) - 1.0);
                this.endWeightExp = 1.0 - this.startWeightExp;
            }
        } else if (this.scalingFactor == 1.0 || this.steps <= 1) {
            this.startWeightExp = this.startWeightLin;
            this.endWeightExp = this.endWeightLin;
        } else {
            this.startWeightExp = (Math.pow(this.scalingFactor, this.steps - this.step) - 1.0) / (Math.pow(this.scalingFactor, this.steps) - 1.0);
            this.endWeightExp = 1.0 - this.startWeightExp;
        }
        this.aniDist *= this.distanceFactor;
        this.rotAni = this.rotStart.times(this.startWeightExp).plus(this.endRotationCenter.times(this.endWeightExp));
        this.angleX = this.startAngles[0] * this.startWeightLin + this.endAngles[0] * this.endWeightLin;
        this.angleY = this.startAngles[1] * this.startWeightLin + this.endAngles[1] * this.endWeightLin;
        this.angleZ = this.startAngles[2] * this.startWeightLin + this.endAngles[2] * this.endWeightLin;
        this.aniCoords.setOrientation(this.angleX, this.angleY, this.angleZ);
        this.aniZ = this.aniCoords.getZDirection();
        this.aniZ.normalize();
        this.aniOrigin = this.rotAni.plus(this.aniZ.times(-this.aniDist));
        this.aniCoords.setOrigin(this.aniOrigin);
        this.camera.setCameraCoordinates(this.aniCoords);
        this.view.setScale(this.view.getScale() * this.scalingFactor);
        this.view.repaint();
        ++this.step;
    }

    private void endAnimation() {
        this.timer.stop();
        this.camera.setCameraCoordinates(this.endCoords);
        this.camera.setDistToScreen(this.endDistToScreen);
        this.view.setScale(this.endScale);
        this.view.setRotationCenter(this.endRotationCenter);
        this.view.setDistToPlane(this.endCoords.getOrigin().minus(this.endRotationCenter).length());
        this.view.setShowGrid(this.endShowGrid);
        this.view.finishAnimation(this.endOrientation, this.endPerspective, this.endNavigation);
        if (this.boundCamera != null) {
            this.updateBoundCamera();
        } else {
            this.view.viewChanged(false);
            this.view.repaint();
        }
        this.changingPerspective = false;
        this.animatingMove = false;
    }

    private boolean noMove() {
        if (!this.rotStart.equals(this.endRotationCenter)) {
            return false;
        }
        if (!this.startCoords.getOrigin().equals(this.endCoords.getOrigin())) {
            return false;
        }
        if (this.startAngles[0] != this.endAngles[0]) {
            return false;
        }
        if (this.startAngles[1] != this.endAngles[1]) {
            return false;
        }
        if (this.startAngles[2] != this.endAngles[2]) {
            return false;
        }
        if (this.startScale != this.endScale) {
            return false;
        }
        return this.view.getOrientation() == this.endOrientation;
    }

    private void checkPreferences() {
        this.animate = ArtOfIllusion.getPreferences().getUseViewAnimations();
    }

    private void updateBoundCamera() {
        if (this.window != null) {
            if (this.boundCamera != null) {
                this.boundCamera.getCoords().copyCoords(this.view.getCamera().getCameraCoordinates());
                UndoRecord undo = new UndoRecord(this.window, false, 1, new Object[]{this.boundCamera.getCoords(), this.startCoords});
                this.moveChildren(this.boundCamera, this.boundCamera.getCoords().fromLocal().times(this.startCoords.toLocal()), undo);
                this.window.setUndoRecord(undo);
            }
            this.window.updateImage();
        }
        this.view.viewChanged(false);
    }

    private void moveChildren(ObjectInfo parent, Mat4 transform, UndoRecord undo) {
        for (int i = 0; i < parent.getChildren().length; ++i) {
            CoordinateSystem coords = parent.getChildren()[i].getCoords();
            CoordinateSystem oldCoords = coords.duplicate();
            coords.transformCoordinates(transform);
            undo.addCommand(1, new Object[]{coords, oldCoords});
            this.moveChildren(parent.getChildren()[i], transform, undo);
        }
    }
}

