/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import artofillusion.spmanager.SPMTranslate;
import artofillusion.spmanager.SPManagerFrame;
import artofillusion.spmanager.StringEncrypter;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import buoy.widget.BPasswordField;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class SPMParameters {
    private static Vector repositories;
    private static int current;
    private static String repoList;
    private static HashMap filters;
    private static boolean useProxy;
    private static String proxyHost;
    private static String proxyPort;
    private static String username;
    private static String password;
    private static boolean changed;
    private StringEncrypter se;
    private URL repListURL;
    private boolean useCache;
    public static final int DEFAULT = 0;
    public static final int ENABLE = 1;
    public static final int MARK = 2;
    public static final int CONFIRM = 3;
    public static final int DISABLE = 4;
    public static final int HIDE = 5;
    public static final int LAST_FILTER = 6;
    public static final int FILTER_MODULO = 6;
    public static final String[] FILTER_NAMES;

    public SPMParameters() {
        repositories = new Vector();
        repositories.add("http://aoisp.sourceforge.net/AoIRepository/");
        filters = new HashMap();
        filters.put("beta", "mark");
        filters.put("earlyAccess", "confirm");
        filters.put("experimental", "hide");
        proxyHost = "";
        proxyPort = "";
        username = "";
        password = "";
        current = 0;
        useProxy = false;
        this.useCache = true;
        this.se = null;
        this.loadPropertiesFile();
        this.initHttp();
    }

    private void loadPropertiesFile() {
        File f = new File(System.getProperty("user.home"), ".spmanagerprefs");
        if (!f.exists()) {
            this.savePropertiesFile();
            return;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            Properties props = new Properties();
            props.load(in);
            this.parseProperties(props);
            ((InputStream)in).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void getRepositoriesList(boolean forceUpdate) {
        if (forceUpdate) {
            new Thread(){

                public void run() {
                    SPMParameters.this.getThreadedRepositoriesList(true);
                }
            }.start();
        } else {
            new Thread(){

                public void run() {
                    SPMParameters.this.getThreadedRepositoriesList(false);
                }
            }.start();
        }
    }

    /*
     * Exception decompiling
     */
    private void getThreadedRepositoriesList(boolean forceUpdate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 18[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void savePropertiesFile() {
        File f = new File(System.getProperty("user.home"), ".spmanagerprefs");
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            Properties props = this.newProperties();
            props.store(out, "Scripts & Plugins Manager Preferences File");
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void parseProperties(Properties p) {
        int i = 0;
        String s = null;
        repositories.clear();
        current = 0;
        while (i != -1) {
            s = p.getProperty("URL_" + i);
            if (s == null) {
                i = -1;
                continue;
            }
            s.trim();
            if (s.endsWith("/")) {
                s = s.substring(0, s.length() - 1);
            }
            repositories.add(s);
            ++i;
        }
        s = p.getProperty("default", "0");
        try {
            current = Integer.parseInt(s);
            if (current > repositories.size()) {
                current = 0;
            }
        }
        catch (Exception e) {
            current = 0;
            System.out.println("SPManager : Wrong default URL index in properties file.");
        }
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            s = (String)entry.getKey();
            if (!s.startsWith("FILTER_")) continue;
            filters.put(s.substring("FILTER_".length()), (String)entry.getValue());
        }
        if (filters.size() == 0) {
            filters.put("beta", "mark");
            filters.put("earlyAccess", "confirm");
            filters.put("experimental", "hide");
        }
        proxyHost = p.getProperty("proxyHost", "");
        proxyPort = p.getProperty("proxyPort", "");
        username = p.getProperty("username", "");
        password = p.getProperty("password", "");
        if (!password.equals("")) {
            if (this.se == null) {
                this.se = new StringEncrypter("SPMan8ger");
            }
            password = this.se.decrypt(password);
        }
        s = p.getProperty("useProxy", "false");
        try {
            useProxy = Boolean.valueOf(s);
        }
        catch (Exception e) {
            useProxy = false;
            System.out.println("SPManager : Invalid use of proxy setting in properties file: useProxy=" + s);
        }
        this.useCache = Boolean.valueOf(p.getProperty("usecache", "true"));
    }

    private Properties newProperties() {
        Properties p = new Properties();
        for (int i = 0; i < repositories.size(); ++i) {
            p.setProperty("URL_" + i, (String)repositories.elementAt(i));
        }
        p.setProperty("default", String.valueOf(current));
        for (Map.Entry entry : filters.entrySet()) {
            p.setProperty("FILTER_" + entry.getKey(), (String)entry.getValue());
        }
        p.setProperty("proxyHost", proxyHost);
        p.setProperty("proxyPort", proxyPort);
        p.setProperty("username", username);
        String pwd = "";
        if (!password.equals("")) {
            if (this.se == null) {
                this.se = new StringEncrypter("SPMan8ger");
            }
            pwd = this.se.encrypt(password);
        }
        p.setProperty("password", pwd);
        p.setProperty("useProxy", String.valueOf(useProxy));
        p.setProperty("usecache", String.valueOf(this.useCache));
        return p;
    }

    public void setURLs(String[] urls, int selectedIndex) {
        repositories.clear();
        for (int i = 0; i < urls.length; ++i) {
            repositories.add(urls[i]);
        }
        current = selectedIndex;
        this.savePropertiesFile();
    }

    public String[] getRepositories() {
        String[] s = new String[repositories.size()];
        for (int i = 0; i < repositories.size(); ++i) {
            s[i] = new String((String)repositories.elementAt(i));
        }
        return s;
    }

    public URL getCurrentRepository() {
        URL url = null;
        try {
            url = new URL((String)repositories.elementAt(current));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url;
    }

    public void setCurrentRepository(int c) {
        current = c;
    }

    public int getCurrentRepositoryIndex() {
        if (current < 0) {
            this.getRepositoriesList(false);
        }
        return current;
    }

    public HashMap getFilters() {
        return filters;
    }

    public int getFilter(String name) {
        return SPMParameters.getFilterType((String)filters.get(name));
    }

    public String getFilterString(String name) {
        return (String)filters.get(name);
    }

    public static int getFilterType(String val) {
        if (val == null || val.length() == 0) {
            return 0;
        }
        for (int i = 0; i < FILTER_NAMES.length; ++i) {
            if (!val.equals(FILTER_NAMES[i])) continue;
            return i % 6;
        }
        return 0;
    }

    public static String getFilterType(int type) {
        if (type < 0) {
            return FILTER_NAMES[0];
        }
        return FILTER_NAMES[type % 6];
    }

    public void addFilter(String name, String value) {
        filters.put(name, value);
    }

    public void addFilter(String name, int type) {
        filters.put(name, SPMParameters.getFilterType(type));
    }

    public boolean useProxy() {
        return useProxy;
    }

    public String getProxyHost() {
        return proxyHost;
    }

    public String getProxyPort() {
        return proxyPort;
    }

    public String getUsername() {
        return username;
    }

    public String getPassword() {
        return password;
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void setProxyParameters(boolean up, String ph, String pp, String usr, String pwd) {
        useProxy = up;
        proxyHost = ph;
        proxyPort = pp;
        username = usr;
        password = pwd;
        this.initHttp();
        this.savePropertiesFile();
    }

    public void setChanged(boolean ch) {
        changed = ch;
        if (changed) {
            this.savePropertiesFile();
        }
    }

    public boolean hasChanged() {
        return changed;
    }

    public void initHttp() {
        if (!useProxy) {
            System.getProperties().remove("http.proxyHost");
            System.getProperties().remove("http.proxyPort");
            Authenticator.setDefault(null);
        } else {
            System.setProperty("http.proxyHost", proxyHost);
            System.setProperty("http.proxyPort", proxyPort);
            if (username == null || username.length() == 0) {
                Authenticator.setDefault(new FirewallAuthenticator(null));
            } else {
                PasswordAuthentication pw = new PasswordAuthentication(username, password.toCharArray());
                Authenticator.setDefault(new FirewallAuthenticator(pw));
            }
        }
    }

    static {
        FILTER_NAMES = new String[]{SPMTranslate.text("filtDefault"), SPMTranslate.text("filtEnable"), SPMTranslate.text("filtMark"), SPMTranslate.text("filtConfirm"), SPMTranslate.text("filtDisable"), SPMTranslate.text("filtHide"), "default", "enable", "mark", "confirm", "disable", "hide"};
    }

    static class FirewallAuthenticator
    extends Authenticator {
        PasswordAuthentication pw;

        public FirewallAuthenticator(PasswordAuthentication pw) {
            this.pw = pw;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.pw == null) {
                BTextField nameField = new BTextField();
                BPasswordField pwField = new BPasswordField();
                ComponentsDialog dlg = new ComponentsDialog((WindowWidget)SPManagerFrame.getInstance(), "SPManager:Authentication", new Widget[]{nameField, pwField}, new String[]{Translate.text("SPManager:name"), Translate.text("SPManager.password")});
                if (dlg.clickedOk()) {
                    this.pw = new PasswordAuthentication(nameField.getText(), pwField.getText().toCharArray());
                }
            }
            return this.pw;
        }
    }
}

