/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.LayoutWindow;
import artofillusion.object.Curve;
import artofillusion.object.ObjectInfo;
import artofillusion.tools.ArraySpec;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BRadioButton;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RadioButtonGroup;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Insets;
import java.util.Vector;

public class ArrayDialog
extends BDialog {
    private LayoutWindow window;
    private ArraySpec spec;
    private Vector<ObjectInfo> curvesVector;
    private BButton okButton;
    private BButton cancelButton;
    private BLabel linearCopiesLabel;
    private BLabel stepXLabel;
    private BLabel stepYLabel;
    private BLabel stepZLabel;
    private BRadioButton curveCopiesBox;
    private BRadioButton curveStepBox;
    private BRadioButton linearBox;
    private BRadioButton curveBox;
    private BCheckBox intervalXBox;
    private BCheckBox intervalYBox;
    private BCheckBox intervalZBox;
    private BCheckBox orientationBox;
    private BCheckBox useOrientationBox;
    private BCheckBox useOriginBox;
    private BCheckBox duplicateBox;
    private BCheckBox groupBox;
    private BCheckBox liveBox;
    private BCheckBox deepBox;
    private BComboBox curveChoice;
    private ValueField linearCopiesField;
    private ValueField stepXField;
    private ValueField stepYField;
    private ValueField stepZField;
    private ValueField curveCopiesField;
    private ValueField curveStepField;
    private RadioButtonGroup methodGroup;
    private RadioButtonGroup modeGroup;

    public ArrayDialog(LayoutWindow window) {
        super((WindowWidget)window, "Array", true);
        this.window = window;
        this.spec = new ArraySpec(window);
        this.curvesVector = new Vector(10, 10);
        for (ObjectInfo obj : window.getScene().getAllObjects()) {
            if (!(obj.getObject() instanceof Curve)) continue;
            this.curvesVector.add(obj);
        }
        this.methodGroup = new RadioButtonGroup();
        this.modeGroup = new RadioButtonGroup();
        ColumnContainer content = new ColumnContainer();
        this.setContent((Widget)BOutline.createEmptyBorder((Widget)content, (int)UIUtilities.getStandardDialogInsets()));
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 0, 15, 0), null));
        content.add((Widget)new BLabel("Create Array of Selected Objects:"), new LayoutInfo());
        content.add(this.createLinearPanel());
        content.add(this.createCurvePanel());
        content.add(this.createOptionsPanel());
        content.add(this.createFinishPanel());
        if (this.curvesVector.size() <= 0) {
            this.curveBox.setEnabled(false);
        }
        this.updateSpec();
        this.pack();
        UIUtilities.centerDialog((BDialog)this, (WindowWidget)window);
        this.setVisible(true);
    }

    private Widget createLinearPanel() {
        FormContainer panel = new FormContainer(4, 4);
        panel.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null));
        this.linearBox = new BRadioButton("Linear:", this.spec.method == 0, this.methodGroup);
        panel.add((Widget)this.linearBox, 0, 0);
        this.linearBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.linearCopiesLabel = new BLabel("Number of Copies");
        panel.add((Widget)this.linearCopiesLabel, 1, 0);
        this.linearCopiesField = new ValueField((float)this.spec.linearCopies, 7, 4);
        panel.add((Widget)this.linearCopiesField, 2, 0);
        this.linearCopiesField.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.stepXLabel = new BLabel("Step X:");
        panel.add((Widget)this.stepXLabel, 1, 1);
        this.stepXField = new ValueField(this.spec.stepX, 0, 4);
        panel.add((Widget)this.stepXField, 2, 1);
        this.stepXField.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.intervalXBox = new BCheckBox("Times X Size", this.spec.intervalX);
        panel.add((Widget)this.intervalXBox, 3, 1);
        this.intervalXBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.stepYLabel = new BLabel("Step Y:");
        panel.add((Widget)this.stepYLabel, 1, 2);
        this.stepYField = new ValueField(this.spec.stepY, 0, 4);
        panel.add((Widget)this.stepYField, 2, 2);
        this.stepYField.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.intervalYBox = new BCheckBox("Times Y Size", this.spec.intervalY);
        panel.add((Widget)this.intervalYBox, 3, 2);
        this.intervalYBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.stepZLabel = new BLabel("Step Z:");
        panel.add((Widget)this.stepZLabel, 1, 3);
        this.stepZField = new ValueField(this.spec.stepZ, 0, 4);
        panel.add((Widget)this.stepZField, 2, 3);
        this.stepZField.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.intervalZBox = new BCheckBox("Times Z Size", this.spec.intervalZ);
        panel.add((Widget)this.intervalZBox, 3, 3);
        this.intervalZBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        return panel;
    }

    private Widget createCurvePanel() {
        FormContainer panel = new FormContainer(3, 6);
        panel.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null));
        this.curveBox = new BRadioButton("From Curve", this.spec.method == 1, this.methodGroup);
        panel.add((Widget)this.curveBox, 0, 0);
        this.curveBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.curveChoice = new BComboBox();
        panel.add((Widget)this.curveChoice, 1, 0);
        for (ObjectInfo info : this.curvesVector) {
            this.curveChoice.add((Object)info.getName());
        }
        if (this.spec.curve != null) {
            this.curveChoice.setSelectedValue((Object)this.spec.curve.getName());
        }
        this.curveChoice.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.curveCopiesBox = new BRadioButton("Number Of Copies", this.spec.curveMode == 1, this.modeGroup);
        panel.add((Widget)this.curveCopiesBox, 1, 1);
        this.curveCopiesBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.curveCopiesField = new ValueField((float)this.spec.curveCopies, 7, 4);
        panel.add((Widget)this.curveCopiesField, 2, 1);
        this.curveCopiesField.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.curveStepBox = new BRadioButton("Step Size:", this.spec.curveMode == 0, this.modeGroup);
        panel.add((Widget)this.curveStepBox, 1, 2);
        this.curveStepBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.curveStepField = new ValueField(this.spec.curveStep, 3, 4);
        panel.add((Widget)this.curveStepField, 2, 2);
        this.curveStepField.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.orientationBox = new BCheckBox("Orientation Follows Curve", this.spec.orientation);
        panel.add((Widget)this.orientationBox, 1, 3);
        this.orientationBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.useOriginBox = new BCheckBox("Use Original Position", !this.spec.ignoreOrigin);
        panel.add((Widget)this.useOriginBox, 1, 4);
        this.useOriginBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.useOrientationBox = new BCheckBox("Use Original Orientation", !this.spec.ignoreOrientation);
        panel.add((Widget)this.useOrientationBox, 1, 5);
        this.useOrientationBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        return panel;
    }

    private Widget createOptionsPanel() {
        FormContainer panel = new FormContainer(2, 2);
        panel.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null));
        this.deepBox = new BCheckBox("Include Children", this.spec.deep);
        panel.add((Widget)this.deepBox, 0, 0);
        this.deepBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.groupBox = new BCheckBox("Group", this.spec.group);
        panel.add((Widget)this.groupBox, 0, 1);
        this.groupBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.duplicateBox = new BCheckBox("Skip First Copy", !this.spec.dupFirst);
        panel.add((Widget)this.duplicateBox, 1, 0);
        this.duplicateBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        this.liveBox = new BCheckBox("Live Duplicates", this.spec.live);
        panel.add((Widget)this.liveBox, 1, 1);
        this.liveBox.addEventLink(ValueChangedEvent.class, (Object)this, "updateSpec");
        return panel;
    }

    private Widget createFinishPanel() {
        RowContainer panel = new RowContainer();
        this.okButton = Translate.button((String)"ok", (Object)((Object)this), (String)"doOk");
        panel.add((Widget)this.okButton);
        this.cancelButton = Translate.button((String)"cancel", (Object)((Object)this), (String)"dispose");
        panel.add((Widget)this.cancelButton);
        return panel;
    }

    private void doOk() {
        this.updateSpec();
        this.spec.createArray();
        this.window.rebuildItemList();
        this.window.updateImage();
        this.dispose();
    }

    private void updateSpec() {
        if (this.linearBox.getState()) {
            this.spec.method = 0;
        }
        if (this.curveBox.getState()) {
            this.spec.method = 1;
        }
        this.spec.linearCopies = (int)this.linearCopiesField.getValue();
        this.spec.stepX = this.stepXField.getValue();
        this.spec.stepY = this.stepYField.getValue();
        this.spec.stepZ = this.stepZField.getValue();
        this.spec.intervalX = this.intervalXBox.getState();
        this.spec.intervalY = this.intervalYBox.getState();
        this.spec.intervalZ = this.intervalZBox.getState();
        if (this.curvesVector.size() > 0) {
            this.spec.curve = this.curvesVector.get(this.curveChoice.getSelectedIndex());
        }
        if (this.curveCopiesBox.getState()) {
            this.spec.curveMode = 1;
        }
        if (this.curveStepBox.getState()) {
            this.spec.curveMode = 0;
        }
        this.spec.curveStep = this.curveStepField.getValue();
        this.spec.curveCopies = (int)this.curveCopiesField.getValue();
        this.spec.orientation = this.orientationBox.getState();
        this.spec.ignoreOrientation = !this.useOrientationBox.getState();
        this.spec.ignoreOrigin = !this.useOriginBox.getState();
        this.spec.dupFirst = !this.duplicateBox.getState();
        this.spec.group = this.groupBox.getState();
        this.spec.live = this.liveBox.getState();
        this.spec.deep = this.deepBox.getState();
        this.linearCopiesField.setEnabled(this.spec.method == 0);
        this.stepXField.setEnabled(this.spec.method == 0);
        this.stepYField.setEnabled(this.spec.method == 0);
        this.stepZField.setEnabled(this.spec.method == 0);
        this.linearCopiesLabel.setEnabled(this.spec.method == 0);
        this.stepXLabel.setEnabled(this.spec.method == 0);
        this.stepYLabel.setEnabled(this.spec.method == 0);
        this.stepZLabel.setEnabled(this.spec.method == 0);
        this.intervalXBox.setEnabled(this.spec.method == 0);
        this.intervalYBox.setEnabled(this.spec.method == 0);
        this.intervalZBox.setEnabled(this.spec.method == 0);
        this.curveChoice.setEnabled(this.spec.method == 1);
        this.curveCopiesField.setEnabled(this.spec.method == 1 & this.spec.curveMode == 1);
        this.curveCopiesBox.setEnabled(this.spec.method == 1);
        this.curveStepField.setEnabled(this.spec.method == 1 & this.spec.curveMode == 0);
        this.curveStepBox.setEnabled(this.spec.method == 1);
        this.orientationBox.setEnabled(this.spec.method == 1);
        this.useOriginBox.setEnabled(this.spec.method == 1);
        this.useOrientationBox.setEnabled(this.spec.method == 1);
    }
}

