/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.translators;

import artofillusion.ArtOfIllusion;
import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.image.ImageOrColor;
import artofillusion.image.ImageOrValue;
import artofillusion.math.RGBColor;
import artofillusion.texture.ImageMapTexture;
import artofillusion.texture.Texture;
import artofillusion.texture.UniformTexture;
import artofillusion.ui.Translate;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class OBJImporter {
    /*
     * Exception decompiling
     */
    public static Scene importFile(File f) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[UNCONDITIONALDOLOOP]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void importFile(BFrame parent) {
        BFileChooser bfc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text((String)"importOBJ"));
        if (ArtOfIllusion.getCurrentDirectory() != null) {
            bfc.setDirectory(new File(ArtOfIllusion.getCurrentDirectory()));
        }
        FileNameExtensionFilter objFilter = new FileNameExtensionFilter(Translate.text((String)"fileFilter.obj"), "obj");
        bfc.getComponent().addChoosableFileFilter(objFilter);
        bfc.getComponent().setAcceptAllFileFilterUsed(true);
        bfc.setFileFilter((FileFilter)objFilter);
        if (!bfc.showDialog((Widget)parent)) {
            return;
        }
        ArtOfIllusion.setCurrentDirectory((String)bfc.getDirectory().getAbsolutePath());
        try {
            Scene scene = OBJImporter.importFile(bfc.getSelectedFile());
            scene.setName(bfc.getSelectedFile().getName());
            ArtOfIllusion.newWindow((Scene)scene);
        }
        catch (Exception ex) {
            new BStandardDialog("", (Object)new String[]{Translate.text((String)"errorLoadingFile"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog((Widget)parent);
        }
    }

    private static String[] breakLine(String line) {
        StringTokenizer st = new StringTokenizer(line);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    private static VertexInfo parseVertexSpec(String spec, Vector vertex, Vector texture, Vector normal, int lineno) throws Exception {
        VertexInfo info = new VertexInfo();
        StringTokenizer st = new StringTokenizer(spec, "/", true);
        info.norm = Integer.MAX_VALUE;
        info.tex = Integer.MAX_VALUE;
        int i = 0;
        while (st.hasMoreTokens()) {
            String value = st.nextToken();
            if ("/".equals(value)) {
                ++i;
                continue;
            }
            try {
                int index = Integer.parseInt(value);
                int total = i == 0 ? vertex.size() : (i == 1 ? texture.size() : normal.size());
                index = index < 0 ? (index += total) : --index;
                if (i == 0) {
                    info.vert = index;
                    continue;
                }
                if (i == 1) {
                    info.tex = index;
                    continue;
                }
                info.norm = index;
            }
            catch (NumberFormatException ex) {
                throw new Exception("Illegal value '" + spec + "' found in line " + lineno + ".");
            }
        }
        if (info.tex == Integer.MAX_VALUE) {
            info.tex = info.vert;
        }
        if (info.norm == Integer.MAX_VALUE) {
            info.norm = info.vert;
        }
        return info;
    }

    private static void parseTextures(String file, File baseDir, Hashtable<String, TextureInfo> textures) throws Exception {
        String line;
        File f = new File(baseDir, file);
        if (!f.isFile()) {
            f = new File(file);
        }
        if (!f.isFile()) {
            new BStandardDialog("Error Importing File", (Object)("Cannot locate material file '" + file + "'."), BStandardDialog.ERROR).showMessageDialog(null);
            return;
        }
        BufferedReader in = new BufferedReader(new FileReader(f));
        TextureInfo currentTexture = null;
        while ((line = in.readLine()) != null) {
            try {
                String[] fields;
                if (line.startsWith("#") || (fields = OBJImporter.breakLine(line)).length == 0) continue;
                if ("newmtl".equals(fields[0])) {
                    currentTexture = null;
                    if (fields.length == 1 || textures.get(fields[1]) != null) continue;
                    currentTexture = new TextureInfo();
                    textures.put(fields[1], currentTexture);
                }
                if (currentTexture == null || fields.length < 2) continue;
                if ("Kd".equals(fields[0])) {
                    currentTexture.diffuse = OBJImporter.parseColor(fields);
                    continue;
                }
                if ("Ka".equals(fields[0])) {
                    currentTexture.ambient = OBJImporter.parseColor(fields);
                    continue;
                }
                if ("Ks".equals(fields[0])) {
                    currentTexture.specular = OBJImporter.parseColor(fields);
                    continue;
                }
                if ("d".equals(fields[0]) || "Tr".equals(fields[0])) {
                    currentTexture.transparency = 1.0 - Double.parseDouble(fields[1]);
                    continue;
                }
                if ("Ns".equals(fields[0])) {
                    currentTexture.shininess = Double.parseDouble(fields[1]);
                    continue;
                }
                if ("map_Kd".equals(fields[0])) {
                    currentTexture.diffuseMap = fields[1];
                    continue;
                }
                if ("map_Ka".equals(fields[0])) {
                    currentTexture.ambientMap = fields[1];
                    continue;
                }
                if ("map_Ks".equals(fields[0])) {
                    currentTexture.specularMap = fields[1];
                    continue;
                }
                if ("map_d".equals(fields[0])) {
                    currentTexture.transparentMap = fields[1];
                    continue;
                }
                if (!"map_Bump".equals(fields[0])) continue;
                currentTexture.bumpMap = fields[1];
            }
            catch (Exception ex) {
                in.close();
                throw new Exception("Illegal line '" + line + "' found in file '" + file + "'.");
            }
        }
        in.close();
    }

    private static Texture createTexture(TextureInfo info, String name, Scene scene, File baseDir, Hashtable<String, ImageMap> imageMaps) throws Exception {
        if (info == null) {
            ImageMapTexture tex = new ImageMapTexture();
            tex.setName(name);
            scene.addTexture((Texture)tex);
            return tex;
        }
        info.resolveColors();
        ImageMap diffuseMap = OBJImporter.loadMap(info.diffuseMap, scene, baseDir, imageMaps);
        ImageMap specularMap = OBJImporter.loadMap(info.specularMap, scene, baseDir, imageMaps);
        ImageMap transparentMap = OBJImporter.loadMap(info.transparentMap, scene, baseDir, imageMaps);
        ImageMap bumpMap = OBJImporter.loadMap(info.bumpMap, scene, baseDir, imageMaps);
        RGBColor transparentColor = new RGBColor(info.transparency, info.transparency, info.transparency);
        if (diffuseMap == null && specularMap == null && transparentMap == null && bumpMap == null) {
            UniformTexture tex = new UniformTexture();
            tex.diffuseColor = info.diffuse.duplicate();
            tex.specularColor = info.specular.duplicate();
            tex.transparentColor = transparentColor;
            tex.shininess = (float)info.specularity;
            tex.specularity = 0.0f;
            tex.roughness = info.roughness;
            tex.setName(name);
            scene.addTexture((Texture)tex);
            return tex;
        }
        ImageMapTexture tex = new ImageMapTexture();
        tex.diffuseColor = diffuseMap == null ? new ImageOrColor(info.diffuse) : new ImageOrColor(info.diffuse, diffuseMap);
        tex.specularColor = specularMap == null ? new ImageOrColor(info.specular) : new ImageOrColor(info.specular, specularMap);
        ImageOrColor imageOrColor = tex.transparentColor = transparentMap == null ? new ImageOrColor(transparentColor) : new ImageOrColor(transparentColor, transparentMap);
        if (transparentMap == null && info.transparency == 0.0 && diffuseMap != null && diffuseMap.getComponentCount() == 4) {
            tex.transparentColor = new ImageOrColor(new RGBColor(1.0, 1.0, 1.0));
            tex.transparency = new ImageOrValue(1.0f, diffuseMap, 3);
        }
        if (bumpMap != null) {
            tex.bump = new ImageOrValue(1.0f, bumpMap, 0);
        }
        tex.shininess = new ImageOrValue((float)info.specularity);
        tex.specularity = new ImageOrValue(0.0f);
        tex.roughness = new ImageOrValue((float)info.roughness);
        tex.tileY = true;
        tex.tileX = true;
        tex.mirrorY = false;
        tex.mirrorX = false;
        tex.setName(name);
        scene.addTexture((Texture)tex);
        return tex;
    }

    private static ImageMap loadMap(String name, Scene scene, File baseDir, Hashtable<String, ImageMap> imageMaps) throws Exception {
        if (name == null) {
            return null;
        }
        ImageMap map = imageMaps.get(name);
        if (map != null) {
            return map;
        }
        File f = new File(baseDir, name);
        if (!f.isFile()) {
            f = new File(name);
        }
        if (!f.isFile()) {
            throw new Exception("Cannot locate image map file '" + name + "'.");
        }
        try {
            map = ImageMap.loadImage((File)f);
        }
        catch (InterruptedException ex) {
            throw new Exception("Unable to load image map file '" + f.getAbsolutePath() + "'.");
        }
        scene.addImage(map);
        imageMaps.put(name, map);
        return map;
    }

    private static RGBColor parseColor(String[] fields) throws NumberFormatException {
        if (fields.length < 4) {
            return null;
        }
        return new RGBColor(Double.parseDouble(fields[1]), Double.parseDouble(fields[2]), Double.parseDouble(fields[3]));
    }

    private static class TextureInfo {
        public RGBColor ambient;
        public RGBColor diffuse;
        public RGBColor specular;
        public double shininess;
        public double transparency;
        public double specularity;
        public double roughness;
        public String ambientMap;
        public String diffuseMap;
        public String specularMap;
        public String transparentMap;
        public String bumpMap;

        private TextureInfo() {
        }

        public void resolveColors() {
            if (this.diffuse == null) {
                this.diffuse = this.diffuseMap == null ? new RGBColor(0.0, 0.0, 0.0) : new RGBColor(1.0, 1.0, 1.0);
            }
            if (this.ambient == null) {
                this.ambient = new RGBColor(0.0, 0.0, 0.0);
            }
            if (this.specular == null) {
                this.specular = new RGBColor(0.0, 0.0, 0.0);
            } else {
                this.specularity = 1.0;
            }
            this.diffuse.scale(1.0 - this.transparency);
            this.specular.scale(1.0 - this.transparency);
            this.roughness = 1.0 - (this.shininess - 1.0) / 128.0;
            if (this.roughness > 1.0) {
                this.roughness = 1.0;
            }
            this.checkColorRange(this.ambient);
            this.checkColorRange(this.diffuse);
            this.checkColorRange(this.specular);
        }

        private void checkColorRange(RGBColor c) {
            float r = c.getRed();
            float g = c.getGreen();
            float b = c.getBlue();
            if (r < 0.0f) {
                r = 0.0f;
            }
            if (r > 1.0f) {
                r = 1.0f;
            }
            if (g < 0.0f) {
                g = 0.0f;
            }
            if (g > 1.0f) {
                g = 1.0f;
            }
            if (b < 0.0f) {
                b = 0.0f;
            }
            if (b > 1.0f) {
                b = 1.0f;
            }
            c.setRGB(r, g, b);
        }
    }

    private static class FaceInfo {
        public VertexInfo v1;
        public VertexInfo v2;
        public VertexInfo v3;
        public int smoothingGroup;
        public String texture;

        public FaceInfo(VertexInfo v1, VertexInfo v2, VertexInfo v3, int smoothingGroup, String texture) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.smoothingGroup = smoothingGroup;
            this.texture = texture;
        }

        public VertexInfo getVertex(int which) {
            switch (which) {
                case 0: {
                    return this.v1;
                }
                case 1: {
                    return this.v2;
                }
            }
            return this.v3;
        }
    }

    private static class VertexInfo {
        public int vert;
        public int norm;
        public int tex;

        private VertexInfo() {
        }
    }
}

