/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raster;

import artofillusion.math.RGBColor;
import artofillusion.raster.Fragment;
import artofillusion.raster.ObjectMaterialInfo;

public class TransparentFragment
implements Fragment {
    private int additiveColor;
    private int multiplicativeColor;
    private float depth;
    private Fragment next;

    public TransparentFragment(int additiveColor, int multiplicativeColor, float depth, Fragment next) {
        this.additiveColor = additiveColor;
        this.multiplicativeColor = multiplicativeColor;
        this.depth = depth;
        this.next = next;
    }

    @Override
    public void getAdditiveColor(RGBColor color) {
        color.setERGB(this.additiveColor);
    }

    @Override
    public void getMultiplicativeColor(RGBColor color) {
        color.setERGB(this.multiplicativeColor);
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public float getDepth() {
        return this.depth;
    }

    @Override
    public float getOpaqueDepth() {
        return this.next.getOpaqueDepth();
    }

    @Override
    public ObjectMaterialInfo getMaterialMapping() {
        return null;
    }

    @Override
    public boolean isEntering() {
        return false;
    }

    @Override
    public Fragment getNextFragment() {
        return this.next;
    }

    @Override
    public Fragment insertNextFragment(Fragment fragment) {
        fragment = fragment.getDepth() < this.next.getDepth() ? fragment.insertNextFragment(this.next) : this.next.insertNextFragment(fragment);
        this.next = fragment;
        return this;
    }
}

