/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.BoundingBox;
import artofillusion.math.Vec3;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.RaytracerContext;
import artofillusion.raytracer.SurfaceIntersection;
import java.util.concurrent.atomic.AtomicInteger;

public class Ray {
    public final Vec3 origin;
    public final Vec3 direction;
    public final Vec3 tempVec1;
    public final Vec3 tempVec2;
    public final Vec3 tempVec3;
    public final Vec3 tempVec4;
    public final RaytracerContext rt;
    private int id;
    private static AtomicInteger nextid = new AtomicInteger();

    public Ray(RaytracerContext rt) {
        this.rt = rt;
        this.origin = new Vec3();
        this.direction = new Vec3();
        this.tempVec1 = new Vec3();
        this.tempVec2 = new Vec3();
        this.tempVec3 = new Vec3();
        this.tempVec4 = new Vec3();
        this.id = Ray.getNextID();
    }

    public Vec3 getOrigin() {
        return this.origin;
    }

    public Vec3 getDirection() {
        return this.direction;
    }

    public int getID() {
        return this.id;
    }

    public void newID() {
        this.id = Ray.getNextID();
        this.rt.rtTriPool.reset();
        this.rt.rtDispTriPool.reset();
        this.rt.rtImplicitPool.reset();
    }

    private static int getNextID() {
        return nextid.getAndIncrement();
    }

    public SurfaceIntersection findIntersection(RTObject object) {
        int index = object.index;
        if (this.rt.lastRayID[index] != this.id) {
            this.rt.lastRayID[index] = this.id;
            this.rt.lastRayResult[index] = object.checkIntersection(this);
        }
        return this.rt.lastRayResult[index];
    }

    public boolean intersects(BoundingBox bb) {
        double t2;
        double t1;
        double mint = -1.7976931348623157E308;
        double maxt = Double.MAX_VALUE;
        if (this.direction.x == 0.0) {
            if (this.origin.x < bb.minx || this.origin.x > bb.maxx) {
                return false;
            }
        } else {
            t1 = (bb.minx - this.origin.x) / this.direction.x;
            t2 = (bb.maxx - this.origin.x) / this.direction.x;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return false;
            }
        }
        if (this.direction.y == 0.0) {
            if (this.origin.y < bb.miny || this.origin.y > bb.maxy) {
                return false;
            }
        } else {
            t1 = (bb.miny - this.origin.y) / this.direction.y;
            t2 = (bb.maxy - this.origin.y) / this.direction.y;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return false;
            }
        }
        if (this.direction.z == 0.0) {
            if (this.origin.z < bb.minz || this.origin.z > bb.maxz) {
                return false;
            }
        } else {
            t1 = (bb.minz - this.origin.z) / this.direction.z;
            t2 = (bb.maxz - this.origin.z) / this.direction.z;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return false;
            }
        }
        return true;
    }
}

