/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.FastRandom;
import artofillusion.math.Vec3;
import artofillusion.raytracer.RTDisplacedTriangle;
import artofillusion.raytracer.RTImplicitObject;
import artofillusion.raytracer.RTTriangle;
import artofillusion.raytracer.RTTriangleLowMemory;
import artofillusion.raytracer.Raytracer;
import artofillusion.raytracer.ResourcePool;
import artofillusion.raytracer.SurfaceIntersection;
import java.util.Random;

public class RaytracerContext {
    public Raytracer rt;
    public Vec3 tempVec;
    public Raytracer.RayIntersection intersect;
    public int[] lastRayID;
    public SurfaceIntersection[] lastRayResult;
    public ResourcePool rtTriPool;
    public ResourcePool rtDispTriPool;
    public ResourcePool rtImplicitPool;
    public Random random;

    public RaytracerContext(Raytracer rt) {
        this.rt = rt;
        this.tempVec = new Vec3();
        this.intersect = new Raytracer.RayIntersection();
        this.random = new FastRandom(0L);
        this.rtTriPool = rt.getUseReducedMemory() ? new ResourcePool(RTTriangleLowMemory.TriangleIntersection.class) : new ResourcePool(RTTriangle.TriangleIntersection.class);
        this.rtDispTriPool = new ResourcePool(RTDisplacedTriangle.DisplacedTriangleIntersection.class);
        this.rtImplicitPool = new ResourcePool(RTImplicitObject.ImplicitIntersection.class);
        this.lastRayID = new int[rt.getObjects().length];
        this.lastRayResult = new SurfaceIntersection[rt.getObjects().length];
    }

    public void cleanup() {
        this.intersect = null;
        this.lastRayID = null;
        this.lastRayResult = null;
        this.rtTriPool = null;
        this.rtDispTriPool = null;
        this.rtImplicitPool = null;
    }
}

