/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.RenderingTriangle;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.RaytracerRenderer;
import artofillusion.texture.TextureSpec;
import artofillusion.util.ThreadManager;

public class TrianglePhotonSource
implements PhotonSource {
    private RenderingTriangle tri;
    private RGBColor color;
    private float lightIntensity;

    public TrianglePhotonSource(RenderingTriangle tri, PhotonMap map) {
        this.tri = tri;
        Vec3 vert1 = tri.theMesh.vert[tri.v1];
        Vec3 vert2 = tri.theMesh.vert[tri.v2];
        Vec3 vert3 = tri.theMesh.vert[tri.v3];
        Vec3 e1 = vert2.minus(vert1);
        Vec3 e2 = vert3.minus(vert1);
        double area = 0.5 * e1.cross(e2).length();
        double dist1 = e1.length();
        double dist2 = e2.length();
        double dist3 = vert2.distance(vert3);
        double avgSize = (dist1 + dist2 + dist3) * 0.16666666666666666;
        TextureSpec spec = map.getWorkspace().surfSpec[0];
        double third = 0.3333333333333333;
        this.color = new RGBColor();
        tri.getTextureSpec(spec, 1.0, third, third, third, avgSize, map.getRaytracer().getTime());
        this.color.copy(spec.emissive);
        tri.getTextureSpec(spec, -1.0, third, third, third, avgSize, map.getRaytracer().getTime());
        this.color.add(spec.emissive);
        this.lightIntensity = 0.5f * (this.color.getRed() + this.color.getGreen() + this.color.getBlue()) * (float)area;
    }

    @Override
    public double getTotalIntensity() {
        return this.lightIntensity;
    }

    @Override
    public void generatePhotons(PhotonMap map, double intensity, ThreadManager threads) {
        RaytracerRenderer rt = map.getRenderer();
        TextureSpec spec = map.getWorkspace().surfSpec[0];
        Ray r = new Ray(map.getWorkspace().context);
        Vec3 vert1 = this.tri.theMesh.vert[this.tri.v1];
        Vec3 vert2 = this.tri.theMesh.vert[this.tri.v2];
        Vec3 vert3 = this.tri.theMesh.vert[this.tri.v3];
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        Vec3 trueNorm = this.tri.theMesh.faceNorm[this.tri.index];
        double emittedIntensity = 0.0;
        while (emittedIntensity < intensity) {
            double v;
            double u;
            double w;
            dir.set(0.0, 0.0, 0.0);
            map.randomizePoint(dir, 1.0);
            dir.normalize();
            double dot = trueNorm.dot(dir);
            double absdot = dot > 0.0 ? dot : -dot;
            if (absdot < map.random.nextDouble()) continue;
            while ((w = 1.0 - (u = map.random.nextDouble()) - (v = map.random.nextDouble())) < 0.0) {
            }
            this.tri.getTextureSpec(spec, dot, u, v, w, rt.smoothScale, rt.time);
            this.color.copy(spec.emissive);
            float sum = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
            emittedIntensity += (double)sum;
            if (emittedIntensity > intensity && (emittedIntensity - intensity) / (double)sum > (double)map.random.nextFloat()) {
                return;
            }
            if (sum < 1.0f) {
                if (sum < map.random.nextFloat()) continue;
                this.color.scale(1.0f / sum);
            }
            orig.set(u * vert1.x + v * vert2.x + w * vert3.x, u * vert1.y + v * vert2.y + w * vert3.y, u * vert1.z + v * vert2.z + w * vert3.z);
            r.newID();
            map.spawnPhoton(r, this.color, true);
        }
    }
}

