/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager.postinstall;

import artofillusion.ArtOfIllusion;
import artofillusion.Plugin;
import artofillusion.ui.Translate;
import buoy.widget.BLabel;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextArea;
import buoy.widget.Widget;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class PostInstall
implements Plugin {
    protected ArrayList ok;
    protected ArrayList err;
    protected static File tempDir = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processMessage(int msg, Object[] args) {
        switch (msg) {
            case 0: {
                ArrayList<String> list;
                String[] sub;
                int i;
                try {
                    if (tempDir == null) {
                        tempDir = new File(System.getProperty("java.io.tmpdir"));
                    }
                    if (!tempDir.exists()) {
                        tempDir = new File(ArtOfIllusion.APP_DIRECTORY, "temp");
                    }
                    if (!tempDir.exists()) {
                        tempDir = new File(System.getProperty("user.dir"), "SPMtemp");
                    }
                    if (!tempDir.exists()) {
                        System.out.println("PostInstall: No TEMP dir found");
                        tempDir = null;
                        return;
                    }
                    String prefix = "spmanager-temp-" + System.getProperty("user.name") + "-";
                    String[] sub2 = tempDir.list();
                    for (i = 0; i < sub2.length; ++i) {
                        File lockfile;
                        if (!sub2[i].startsWith(prefix) || sub2[i].endsWith(".lck") || (lockfile = new File(tempDir, sub2[i] + ".lck")).exists()) continue;
                        tempDir = new File(tempDir, sub2[i]);
                        break;
                    }
                    if (!tempDir.getName().startsWith("spmanager-temp-")) {
                        System.out.println("PostInstall: no TEMP sub-tree found");
                        tempDir = null;
                        return;
                    }
                    System.out.println("PostInstall: tempDir is " + tempDir.getAbsolutePath());
                    this.ok = new ArrayList(128);
                    this.err = new ArrayList(128);
                    PostInstall.cleanup(ArtOfIllusion.PLUGIN_DIRECTORY, this.ok, this.err);
                    PostInstall.cleanup(ArtOfIllusion.TOOL_SCRIPT_DIRECTORY, this.ok, this.err);
                    PostInstall.cleanup(ArtOfIllusion.OBJECT_SCRIPT_DIRECTORY, this.ok, this.err);
                    PostInstall.cleanup(ArtOfIllusion.STARTUP_SCRIPT_DIRECTORY, this.ok, this.err);
                    if (tempDir == null) {
                        return;
                    }
                }
                catch (Exception e) {
                    System.out.println("PostInstall: exception raised - aborting: " + e.toString());
                    this.err.add("Exception raised - aborting: " + e.toString());
                    return;
                }
                try {
                    sub = tempDir.list();
                    list = new ArrayList(sub.length);
                    for (i = 0; i < sub.length; ++i) {
                        list.add(tempDir + File.separator + sub[i]);
                    }
                    for (i = 0; i < list.size(); ++i) {
                        File tmp = new File((String)list.get(i));
                        if (tmp.isDirectory() && (sub = tmp.list()).length > 0) {
                            System.out.println("PostInstall: descending into " + tmp.getAbsolutePath());
                            for (int k = 0; k < sub.length; ++k) {
                                list.add(i, tmp.getAbsolutePath() + File.separator + sub[k]);
                            }
                            --i;
                            continue;
                        }
                        System.out.println("PostInstall: deleting " + tmp.getAbsolutePath());
                        tmp.delete();
                    }
                }
                catch (Exception e) {
                    System.out.println("PostInstall: error: " + e);
                    e.printStackTrace();
                }
                System.out.println("PostInstall: deleting " + tempDir.getAbsolutePath());
                tempDir.delete();
                return;
                finally {
                    if (tempDir == null) {
                        return;
                    }
                    try {
                        sub = tempDir.list();
                        list = new ArrayList<String>(sub.length);
                        for (i = 0; i < sub.length; ++i) {
                            list.add(tempDir + File.separator + sub[i]);
                        }
                        for (i = 0; i < list.size(); ++i) {
                            File tmp = new File((String)list.get(i));
                            if (tmp.isDirectory() && (sub = tmp.list()).length > 0) {
                                System.out.println("PostInstall: descending into " + tmp.getAbsolutePath());
                                for (int k = 0; k < sub.length; ++k) {
                                    list.add(i, tmp.getAbsolutePath() + File.separator + sub[k]);
                                }
                                --i;
                                continue;
                            }
                            System.out.println("PostInstall: deleting " + tmp.getAbsolutePath());
                            tmp.delete();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("PostInstall: error: " + e);
                        e.printStackTrace();
                    }
                    System.out.println("PostInstall: deleting " + tempDir.getAbsolutePath());
                    tempDir.delete();
                }
            }
            case 2: {
                try {
                    BLabel messg;
                    BScrollPane detail;
                    int i;
                    BTextArea txt;
                    if (this.err != null && this.err.size() > 0) {
                        txt = new BTextArea(5, 45);
                        txt.setEditable(false);
                        for (i = 0; i < this.err.size(); ++i) {
                            txt.append(this.err.get(i) + "\n");
                        }
                        detail = new BScrollPane((Widget)txt, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_AS_NEEDED);
                        messg = Translate.label((String)"postinstall.errMsg");
                        new BStandardDialog("PostInstall", (Object)new Widget[]{messg, detail}, BStandardDialog.WARNING).showMessageDialog(null);
                    }
                    if (this.ok == null) return;
                    if (this.ok.size() <= 0) return;
                    txt = new BTextArea(5, 45);
                    txt.setEditable(false);
                    for (i = 0; i < this.ok.size(); ++i) {
                        txt.append(this.ok.get(i).toString() + "\n");
                    }
                    detail = new BScrollPane((Widget)txt, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_AS_NEEDED);
                    messg = Translate.label((String)"postinstall:okMsg");
                    BLabel restart = Translate.label((String)"postinstall:restartMsg");
                    new BStandardDialog("PostInstall: ", (Object)new Widget[]{messg, restart, detail}, BStandardDialog.INFORMATION).showMessageDialog(null);
                    return;
                }
                finally {
                    this.ok = null;
                    this.err = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(String path, ArrayList ok, ArrayList err) {
        boolean count = false;
        File to = new File(path);
        File from = new File(tempDir, to.getName());
        if (!from.exists()) {
            System.out.println("PostInstall: FROM path does not exist: " + from.getAbsolutePath());
            return;
        }
        if (!to.exists()) {
            System.out.println("PostInstall: TO path does not exist: " + to.getAbsolutePath());
            return;
        }
        String[] files = from.list();
        if (files == null || files.length == 0) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(".upd")) continue;
            File update = new File(from, files[i]);
            if (update.length() == 0L) {
                if (update.delete()) {
                    System.out.println("PostInstall: deleted zero-length file: " + update.getAbsolutePath());
                    continue;
                }
                System.out.println("PostInstall.cleanup: Could not delete: " + update.getAbsolutePath());
                err.add("could not delete " + update.getAbsolutePath());
                continue;
            }
            String fname = files[i].substring(0, files[i].length() - ".upd".length());
            File plugin = new File(to, fname);
            if (plugin.exists()) {
                plugin.delete();
            }
            if (update.renameTo(plugin)) {
                System.out.println("PostInstall.cleanup: Updated " + fname);
                ok.add("Updated " + fname);
                continue;
            }
            BufferedInputStream is = null;
            OutputStream os = null;
            try {
                int b;
                is = new BufferedInputStream(new FileInputStream(update));
                os = new BufferedOutputStream(new FileOutputStream(plugin));
                while ((b = ((InputStream)is).read()) >= 0) {
                    os.write((byte)b);
                }
                System.out.println("PostInstall.cleanup: Updated " + fname);
                ok.add("Updated (copied) " + fname);
                continue;
            }
            catch (Exception e) {
                System.out.println("PostInstall.cleanup: **Error updating " + fname);
                err.add("couldn't rename or copy " + fname);
                continue;
            }
            finally {
                try {
                    os.flush();
                    os.close();
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
                if (!update.delete()) {
                    System.out.println("PostInstall.cleanup: **Error: Could not delete: " + update.getAbsolutePath());
                    err.add("couldn't delete " + update.getAbsolutePath());
                    try {
                        RandomAccessFile raf = new RandomAccessFile(update, "rw");
                        raf.setLength(0L);
                        raf.close();
                    }
                    catch (Exception e) {
                        System.out.println("PostInstall: " + Translate.text((String)"postinstall:truncateMsg", (Object)update.getAbsolutePath()));
                    }
                }
            }
        }
    }
}

