/*
 * Decompiled with CFR 0.152.
 */
package buoy.internal;

import buoy.event.MouseExitedEvent;
import buoy.event.MouseMovedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.ToolTipEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BToolTip;
import buoy.widget.Widget;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ToolTipMonitor {
    private static WidgetMouseEvent lastMoveEvent;
    private static Timer timer;
    private static final int SHOW_DELAY = 1500;
    private static final int UPDATE_DELAY = 250;

    public static void processMouseEvent(WidgetMouseEvent ev) {
        if (ev instanceof MouseExitedEvent || ev instanceof MousePressedEvent) {
            lastMoveEvent = null;
            timer.setInitialDelay(250);
            timer.restart();
        } else if (ev instanceof MouseMovedEvent) {
            lastMoveEvent = (MouseMovedEvent)ev;
            timer.setInitialDelay(BToolTip.getShowingToolTip() == null ? 1500 : 250);
            timer.restart();
        }
    }

    static {
        timer = new Timer(1500, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (lastMoveEvent == null) {
                            BToolTip.hide();
                            return;
                        }
                        Widget widget = lastMoveEvent.getWidget();
                        if (!widget.getComponent().isDisplayable()) {
                            return;
                        }
                        Point lastPos = lastMoveEvent.getPoint();
                        Point tipPos = new Point(lastPos.x, lastPos.y + 15);
                        widget.dispatchEvent(new ToolTipEvent(widget, lastMoveEvent.getWhen(), lastMoveEvent.getPoint(), tipPos));
                    }
                });
            }
        });
        timer.setRepeats(false);
        timer.stop();
    }
}

