/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;

public class BLabel
extends Widget {
    public static final Position CENTER = new Position(0);
    public static final Position NORTH = new Position(1);
    public static final Position SOUTH = new Position(2);
    public static final Position WEST = new Position(4);
    public static final Position EAST = new Position(8);
    public static final Position NORTHEAST = new Position(BLabel.NORTH.value + BLabel.EAST.value);
    public static final Position SOUTHEAST = new Position(BLabel.SOUTH.value + BLabel.EAST.value);
    public static final Position NORTHWEST = new Position(BLabel.NORTH.value + BLabel.WEST.value);
    public static final Position SOUTHWEST = new Position(BLabel.SOUTH.value + BLabel.WEST.value);

    public BLabel() {
        this((String)null, WEST);
    }

    public BLabel(String text) {
        this(text, WEST);
    }

    public BLabel(String text, Position align) {
        this.component = this.createComponent(text, null);
        this.setAlignment(align);
    }

    public BLabel(Icon image) {
        this(image, WEST);
    }

    public BLabel(Icon image, Position align) {
        this.component = this.createComponent(null, image);
        this.setAlignment(align);
    }

    public BLabel(String text, Icon image, Position align, Position textPos) {
        this.component = this.createComponent(text, image);
        this.setAlignment(align);
        this.setTextPosition(textPos);
    }

    protected JLabel createComponent(String text, Icon image) {
        return new JLabel(text, image, 4);
    }

    public JLabel getComponent() {
        return (JLabel)this.component;
    }

    public String getText() {
        return this.getComponent().getText();
    }

    public void setText(String text) {
        this.getComponent().setText(text);
        this.invalidateSize();
    }

    public Icon getIcon() {
        return this.getComponent().getIcon();
    }

    public void setIcon(Icon image) {
        this.getComponent().setIcon(image);
        this.invalidateSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Position getAlignment() {
        int halign = this.getComponent().getHorizontalAlignment();
        int valign = this.getComponent().getVerticalAlignment();
        return Position.get(halign, valign);
    }

    public void setAlignment(Position alignment) {
        int align = alignment.value;
        JLabel jl = this.getComponent();
        if ((align & BLabel.NORTH.value) != 0) {
            jl.setVerticalAlignment(1);
        } else if ((align & BLabel.SOUTH.value) != 0) {
            jl.setVerticalAlignment(3);
        } else {
            jl.setVerticalAlignment(0);
        }
        if ((align & BLabel.EAST.value) != 0) {
            jl.setHorizontalAlignment(4);
        } else if ((align & BLabel.WEST.value) != 0) {
            jl.setHorizontalAlignment(2);
        } else {
            jl.setHorizontalAlignment(0);
        }
        this.invalidateSize();
    }

    public Position getTextPosition() {
        int hpos = this.getComponent().getHorizontalTextPosition();
        int vpos = this.getComponent().getVerticalTextPosition();
        return Position.get(hpos, vpos);
    }

    public void setTextPosition(Position position) {
        int pos = position.value;
        JLabel jl = this.getComponent();
        if ((pos & BLabel.NORTH.value) != 0) {
            jl.setVerticalTextPosition(1);
        } else if ((pos & BLabel.SOUTH.value) != 0) {
            jl.setVerticalTextPosition(3);
        } else {
            jl.setVerticalTextPosition(0);
        }
        if ((pos & BLabel.EAST.value) != 0) {
            jl.setHorizontalTextPosition(4);
        } else if ((pos & BLabel.WEST.value) != 0) {
            jl.setHorizontalTextPosition(2);
        } else {
            jl.setHorizontalTextPosition(0);
        }
        this.invalidateSize();
    }

    static {
        WidgetEncoder.setPersistenceDelegate(Position.class, new StaticFieldDelegate(BLabel.class));
    }

    public static class Position {
        protected int value;

        private Position(int value) {
            this.value = value;
        }

        private static Position get(int hpos, int vpos) {
            switch (hpos) {
                case 2: {
                    switch (vpos) {
                        case 1: {
                            return NORTHWEST;
                        }
                        case 3: {
                            return SOUTHWEST;
                        }
                    }
                    return WEST;
                }
                case 4: {
                    switch (vpos) {
                        case 1: {
                            return NORTHEAST;
                        }
                        case 3: {
                            return SOUTHEAST;
                        }
                    }
                    return EAST;
                }
            }
            switch (vpos) {
                case 1: {
                    return NORTH;
                }
                case 3: {
                    return SOUTH;
                }
            }
            return CENTER;
        }
    }
}

