/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.vmx;

import de.grogra.reflect.Method;
import de.grogra.xl.query.BytecodeSerialization;
import de.grogra.xl.query.Frame;
import de.grogra.xl.query.MatchConsumer;
import de.grogra.xl.query.QueryState;
import de.grogra.xl.query.Utils;
import de.grogra.xl.query.Variable;
import de.grogra.xl.util.DoubleList;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.ObjectList;
import de.grogra.xl.vmx.AbruptCompletion;
import de.grogra.xl.vmx.Authorization;
import de.grogra.xl.vmx.Routine;
import de.grogra.xl.vmx.RoutineDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.EmptyStackException;

public final class VMXState {
    public static final int[] INT_0 = new int[0];
    private static final ThreadLocal STATE = new ThreadLocal();
    private final Thread thread;
    private final int id;
    private static int nextId = 0;
    private static final int INITIAL_SIZE = 64;
    private int[] istack = new int[64];
    private double[] dstack = new double[64];
    private Object[] astack = new Object[64];
    private int sp = 0;
    private int minSp = 0;
    private int jfp = Integer.MIN_VALUE;
    private int jsize = 0;
    private int fp = Integer.MIN_VALUE;
    private int fsize = 0;
    private ObjectList<VMXFrame> framePool = new ObjectList();
    private Authorization currentAuthorization = null;
    private VMXFrame currentFrame;
    RoutineDescriptor descriptorPool = null;
    final ObjectList<MatchConsumerInFrame> consumerPool = new ObjectList();
    private final ObjectList poolReturn = new ObjectList();
    private final ObjectList poolBreak = new ObjectList();
    private final ObjectList poolThrow = new ObjectList();
    private final ObjectList poolNonlocal = new ObjectList();
    private final ObjectList objectArrays = new ObjectList();
    private final ObjectList<int[]> intArrays = new ObjectList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VMXState() {
        ThreadLocal threadLocal = STATE;
        synchronized (threadLocal) {
            this.id = nextId++;
        }
        this.thread = Thread.currentThread();
        this.pushFrame(null);
    }

    private static void checkIndex(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException();
        }
    }

    static void check(Authorization authorization, Authorization authorization2) {
        if (authorization != authorization2) {
            throw new SecurityException("Authorization " + authorization + " does not match " + authorization2);
        }
    }

    void check(Authorization authorization) {
        if (authorization != this.currentAuthorization) {
            throw new SecurityException("Authorization " + authorization + " does not match " + this.currentAuthorization);
        }
    }

    private void pushFrame(VMXFrame vMXFrame) {
        VMXFrame vMXFrame2 = this.framePool.isEmpty() ? new VMXFrame(this) : (VMXFrame)this.framePool.pop();
        vMXFrame2.fp = this.fp;
        vMXFrame2.size = this.fsize;
        vMXFrame2.jfp = this.jfp;
        vMXFrame2.jsize = this.jsize;
        vMXFrame2.auth = this.currentAuthorization;
        vMXFrame2.staticLink = vMXFrame;
        vMXFrame2.parent = this.currentFrame;
        vMXFrame2.minSp = this.minSp;
        this.currentFrame = vMXFrame2;
    }

    private void popFrame() {
        VMXFrame vMXFrame = this.currentFrame.parent;
        this.currentFrame.parent = null;
        this.framePool.push((Object)this.currentFrame);
        this.loadFrame(vMXFrame);
    }

    private void loadFrame(VMXFrame vMXFrame) {
        this.currentFrame = vMXFrame;
        this.fp = vMXFrame.fp;
        this.fsize = vMXFrame.size;
        this.jfp = vMXFrame.jfp;
        this.jsize = vMXFrame.jsize;
        this.minSp = vMXFrame.minSp;
        this.currentAuthorization = vMXFrame.auth;
    }

    boolean isCurrentFrame(Frame frame) {
        return frame == this.currentFrame;
    }

    public void enter(int n, Authorization authorization) {
        this.currentFrame.spSave = this.sp;
        this.currentAuthorization = authorization;
        this.fp = this.sp;
        this.fsize = n;
        this.jfp = this.sp;
        this.jsize = 0;
        this.setSp(this.fp + n);
        this.minSp = this.sp;
        this.pushFrame(this.currentFrame);
    }

    public void leave(Authorization authorization) {
        this.check(authorization);
        this.popFrame();
        this.setSp(this.currentFrame.spSave);
    }

    public int getId() {
        return this.id;
    }

    public static VMXState current() {
        VMXState vMXState = (VMXState)STATE.get();
        if (vMXState == null) {
            vMXState = new VMXState();
            STATE.set(vMXState);
        }
        return vMXState;
    }

    void setSp(int n) {
        int n2 = this.istack.length;
        if (n > n2) {
            this.istack = new int[n * 3 >> 1];
            IntList.arraycopy((int[])this.istack, (int)0, (int[])this.istack, (int)0, (int)n2);
        }
        if (n > (n2 = this.dstack.length)) {
            this.dstack = new double[n * 3 >> 1];
            DoubleList.arraycopy((double[])this.dstack, (int)0, (double[])this.dstack, (int)0, (int)n2);
        }
        if (n > (n2 = this.astack.length)) {
            this.astack = new Object[n * 3 >> 1];
            ObjectList.arraycopy((Object[])this.astack, (int)0, (Object[])this.astack, (int)0, (int)n2);
        }
        if (n < this.sp) {
            ObjectList.clear((Object[])this.astack, (int)n, (int)(this.sp - n));
        }
        if ((n2 = this.astack.length) > this.sp) {
            n2 = this.sp;
        }
        while (n2 > n) {
            this.astack[--n2] = null;
        }
        this.sp = n;
    }

    public Frame getFrame(Authorization authorization) {
        this.check(authorization);
        return this.currentFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbruptCompletion.Return invoke(Routine routine, int n, Authorization authorization) {
        int n2 = this.sp - routine.getParameterSize();
        this.currentAuthorization = authorization;
        this.fsize = routine.getFrameSize();
        this.jsize = routine.getJavaFrameSize();
        if (routine.hasJavaParameters()) {
            this.jfp = n2;
            this.fp = n2 + this.jsize;
            this.setSp(this.fp + this.fsize);
        } else {
            this.fp = n2;
            this.jfp = n2 + this.fsize;
            this.setSp(this.jfp + this.jsize);
        }
        this.minSp = this.sp;
        VMXFrame vMXFrame = this.currentFrame;
        while (--n >= -1) {
            vMXFrame = this.currentFrame.staticLink;
        }
        this.pushFrame(vMXFrame);
        try {
            AbruptCompletion.Return return_ = routine.execute(this);
            return return_;
        }
        finally {
            this.popFrame();
            this.setSp(n2);
        }
    }

    AbruptCompletion.Return invoke(RoutineDescriptor routineDescriptor) {
        Routine routine = routineDescriptor.routine;
        int n = this.sp - routine.getParameterSize();
        this.currentAuthorization = routineDescriptor.auth;
        this.fsize = routine.getFrameSize();
        this.jsize = routine.getJavaFrameSize();
        if (routine.hasJavaParameters()) {
            this.jfp = n;
            this.fp = n + this.jsize;
            this.setSp(this.fp + this.fsize);
        } else {
            this.fp = n;
            this.jfp = n + this.fsize;
            this.setSp(this.jfp + this.jsize);
        }
        this.minSp = this.sp;
        this.pushFrame(routineDescriptor.staticLink);
        try {
            AbruptCompletion.Return return_ = routine.execute(this);
            return return_;
        }
        catch (AbruptCompletion.Throw throw_) {
            throw this.newNonlocal(routineDescriptor.staticLink, throw_);
        }
        catch (Exception exception) {
            throw this.newNonlocal(routineDescriptor.staticLink, this.newThrow(exception));
        }
        finally {
            this.popFrame();
            this.setSp(n);
        }
    }

    void iseta(int n, int n2) {
        this.istack[n] = n2;
    }

    int igeta(int n) {
        return this.istack[n];
    }

    public void isetj(int n, int n2, Authorization authorization) {
        this.check(authorization);
        VMXState.checkIndex(n, this.jsize);
        this.istack[this.jfp + n] = n2;
    }

    public int igetj(int n, Authorization authorization) {
        this.check(authorization);
        VMXState.checkIndex(n, this.jsize);
        return this.istack[this.jfp + n];
    }

    public static void iset(int n, VMXState vMXState, int n2, int n3, Authorization authorization) {
        int n4;
        if (n2 == 0) {
            vMXState.check(authorization);
            VMXState.checkIndex(n3, vMXState.fsize);
            n4 = vMXState.fp + n3;
        } else {
            VMXFrame vMXFrame = vMXState.currentFrame;
            while (--n2 >= 0) {
                vMXFrame = vMXFrame.staticLink;
            }
            VMXState.check(authorization, vMXFrame.auth);
            VMXState.checkIndex(n3, vMXFrame.size);
            n4 = vMXFrame.fp + n3;
        }
        vMXState.istack[n4] = n;
    }

    public static int iget(VMXState vMXState, int n, int n2, Authorization authorization) {
        int n3;
        if (n == 0) {
            vMXState.check(authorization);
            VMXState.checkIndex(n2, vMXState.fsize);
            n3 = vMXState.fp + n2;
        } else {
            VMXFrame vMXFrame = vMXState.currentFrame;
            while (--n >= 0) {
                vMXFrame = vMXFrame.staticLink;
            }
            VMXState.check(authorization, vMXFrame.auth);
            VMXState.checkIndex(n2, vMXFrame.size);
            n3 = vMXFrame.fp + n2;
        }
        return vMXState.istack[n3];
    }

    public void iset(Local local, int n, Authorization authorization) {
        switch (local.nesting) {
            case -1: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.jsize);
                int n2 = this.jfp + local.index;
                break;
            }
            case 0: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.fsize);
                int n2 = this.fp + local.index;
                break;
            }
            default: {
                int n2;
                int n3 = local.nesting;
                if (n3 == 0) {
                    this.check(authorization);
                    VMXState.checkIndex(local.index, this.fsize);
                    n2 = this.fp + local.index;
                    break;
                }
                VMXFrame vMXFrame = this.currentFrame;
                while (--n3 >= 0) {
                    vMXFrame = vMXFrame.staticLink;
                }
                VMXState.check(authorization, vMXFrame.auth);
                VMXState.checkIndex(local.index, vMXFrame.size);
                n2 = vMXFrame.fp + local.index;
            }
        }
        this.istack[n2] = n;
    }

    public int iget(Local local, Authorization authorization) {
        int n;
        switch (local.nesting) {
            case -1: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.jsize);
                n = this.jfp + local.index;
                break;
            }
            case 0: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.fsize);
                n = this.fp + local.index;
                break;
            }
            default: {
                int n2 = local.nesting;
                if (n2 == 0) {
                    this.check(authorization);
                    VMXState.checkIndex(local.index, this.fsize);
                    n = this.fp + local.index;
                    break;
                }
                VMXFrame vMXFrame = this.currentFrame;
                while (--n2 >= 0) {
                    vMXFrame = vMXFrame.staticLink;
                }
                VMXState.check(authorization, vMXFrame.auth);
                VMXState.checkIndex(local.index, vMXFrame.size);
                n = vMXFrame.fp + local.index;
            }
        }
        return this.istack[n];
    }

    public void ipush(int n) {
        this.setSp(this.sp + 1);
        this.istack[this.sp - 1] = n;
    }

    public int ipop() {
        if (this.sp <= this.minSp) {
            throw new EmptyStackException();
        }
        return this.istack[--this.sp];
    }

    public int ipeek() {
        if (this.sp <= this.minSp) {
            throw new EmptyStackException();
        }
        return this.istack[this.sp - 1];
    }

    public int ipeek(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if ((n = this.sp - n) < this.minSp) {
            throw new EmptyStackException();
        }
        return this.istack[n];
    }

    void lseta(int n, long l) {
        this.istack[n] = (int)(l >> 32);
        this.istack[n + 1] = (int)l;
    }

    long lgeta(int n) {
        return ((long)this.istack[n] << 32) + ((long)this.istack[n + 1] & 0xFFFFFFFFL);
    }

    public void lsetj(int n, long l, Authorization authorization) {
        this.check(authorization);
        VMXState.checkIndex(n, this.jsize);
        this.istack[n += this.jfp] = (int)(l >> 32);
        this.istack[n + 1] = (int)l;
    }

    public long lgetj(int n, Authorization authorization) {
        this.check(authorization);
        VMXState.checkIndex(n, this.jsize);
        return ((long)this.istack[n += this.jfp] << 32) + ((long)this.istack[n + 1] & 0xFFFFFFFFL);
    }

    public static void lset(long l, VMXState vMXState, int n, int n2, Authorization authorization) {
        int n3;
        if (n == 0) {
            vMXState.check(authorization);
            VMXState.checkIndex(n2, vMXState.fsize);
            n3 = vMXState.fp + n2;
        } else {
            VMXFrame vMXFrame = vMXState.currentFrame;
            while (--n >= 0) {
                vMXFrame = vMXFrame.staticLink;
            }
            VMXState.check(authorization, vMXFrame.auth);
            VMXState.checkIndex(n2, vMXFrame.size);
            n3 = vMXFrame.fp + n2;
        }
        vMXState.istack[n3] = (int)(l >> 32);
        vMXState.istack[n3 + 1] = (int)l;
    }

    public static long lget(VMXState vMXState, int n, int n2, Authorization authorization) {
        int n3;
        if (n == 0) {
            vMXState.check(authorization);
            VMXState.checkIndex(n2, vMXState.fsize);
            n3 = vMXState.fp + n2;
        } else {
            VMXFrame vMXFrame = vMXState.currentFrame;
            while (--n >= 0) {
                vMXFrame = vMXFrame.staticLink;
            }
            VMXState.check(authorization, vMXFrame.auth);
            VMXState.checkIndex(n2, vMXFrame.size);
            n3 = vMXFrame.fp + n2;
        }
        return ((long)vMXState.istack[n3] << 32) + ((long)vMXState.istack[n3 + 1] & 0xFFFFFFFFL);
    }

    public void lset(Local local, long l, Authorization authorization) {
        switch (local.nesting) {
            case -1: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.jsize);
                int n = this.jfp + local.index;
                break;
            }
            case 0: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.fsize);
                int n = this.fp + local.index;
                break;
            }
            default: {
                int n;
                int n2 = local.nesting;
                if (n2 == 0) {
                    this.check(authorization);
                    VMXState.checkIndex(local.index, this.fsize);
                    n = this.fp + local.index;
                    break;
                }
                VMXFrame vMXFrame = this.currentFrame;
                while (--n2 >= 0) {
                    vMXFrame = vMXFrame.staticLink;
                }
                VMXState.check(authorization, vMXFrame.auth);
                VMXState.checkIndex(local.index, vMXFrame.size);
                n = vMXFrame.fp + local.index;
            }
        }
        this.istack[n] = (int)(l >> 32);
        this.istack[n + 1] = (int)l;
    }

    public long lget(Local local, Authorization authorization) {
        int n;
        switch (local.nesting) {
            case -1: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.jsize);
                n = this.jfp + local.index;
                break;
            }
            case 0: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.fsize);
                n = this.fp + local.index;
                break;
            }
            default: {
                int n2 = local.nesting;
                if (n2 == 0) {
                    this.check(authorization);
                    VMXState.checkIndex(local.index, this.fsize);
                    n = this.fp + local.index;
                    break;
                }
                VMXFrame vMXFrame = this.currentFrame;
                while (--n2 >= 0) {
                    vMXFrame = vMXFrame.staticLink;
                }
                VMXState.check(authorization, vMXFrame.auth);
                VMXState.checkIndex(local.index, vMXFrame.size);
                n = vMXFrame.fp + local.index;
            }
        }
        return ((long)this.istack[n] << 32) + ((long)this.istack[n + 1] & 0xFFFFFFFFL);
    }

    public void lpush(long l) {
        this.setSp(this.sp + 2);
        this.istack[this.sp - 2] = (int)(l >> 32);
        this.istack[this.sp - 1] = (int)l;
    }

    public long lpop() {
        int n = this.sp -= 2;
        if (n < this.minSp) {
            throw new EmptyStackException();
        }
        return ((long)this.istack[n] << 32) + ((long)this.istack[n + 1] & 0xFFFFFFFFL);
    }

    public long lpeek() {
        if (this.sp - 1 <= this.minSp) {
            throw new EmptyStackException();
        }
        return ((long)this.istack[this.sp - 2] << 32) + ((long)this.istack[this.sp - 1] & 0xFFFFFFFFL);
    }

    public long lpeek(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if ((n = this.sp - n) < this.minSp) {
            throw new EmptyStackException();
        }
        return ((long)this.istack[n] << 32) + ((long)this.istack[n + 1] & 0xFFFFFFFFL);
    }

    void fseta(int n, float f) {
        this.dstack[n] = f;
    }

    float fgeta(int n) {
        return (float)this.dstack[n];
    }

    public void fsetj(int n, float f, Authorization authorization) {
        this.check(authorization);
        VMXState.checkIndex(n, this.jsize);
        this.dstack[this.jfp + n] = f;
    }

    public float fgetj(int n, Authorization authorization) {
        this.check(authorization);
        VMXState.checkIndex(n, this.jsize);
        return (float)this.dstack[this.jfp + n];
    }

    public static void fset(float f, VMXState vMXState, int n, int n2, Authorization authorization) {
        int n3;
        if (n == 0) {
            vMXState.check(authorization);
            VMXState.checkIndex(n2, vMXState.fsize);
            n3 = vMXState.fp + n2;
        } else {
            VMXFrame vMXFrame = vMXState.currentFrame;
            while (--n >= 0) {
                vMXFrame = vMXFrame.staticLink;
            }
            VMXState.check(authorization, vMXFrame.auth);
            VMXState.checkIndex(n2, vMXFrame.size);
            n3 = vMXFrame.fp + n2;
        }
        vMXState.dstack[n3] = f;
    }

    public static float fget(VMXState vMXState, int n, int n2, Authorization authorization) {
        int n3;
        if (n == 0) {
            vMXState.check(authorization);
            VMXState.checkIndex(n2, vMXState.fsize);
            n3 = vMXState.fp + n2;
        } else {
            VMXFrame vMXFrame = vMXState.currentFrame;
            while (--n >= 0) {
                vMXFrame = vMXFrame.staticLink;
            }
            VMXState.check(authorization, vMXFrame.auth);
            VMXState.checkIndex(n2, vMXFrame.size);
            n3 = vMXFrame.fp + n2;
        }
        return (float)vMXState.dstack[n3];
    }

    public void fset(Local local, float f, Authorization authorization) {
        switch (local.nesting) {
            case -1: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.jsize);
                int n = this.jfp + local.index;
                break;
            }
            case 0: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.fsize);
                int n = this.fp + local.index;
                break;
            }
            default: {
                int n;
                int n2 = local.nesting;
                if (n2 == 0) {
                    this.check(authorization);
                    VMXState.checkIndex(local.index, this.fsize);
                    n = this.fp + local.index;
                    break;
                }
                VMXFrame vMXFrame = this.currentFrame;
                while (--n2 >= 0) {
                    vMXFrame = vMXFrame.staticLink;
                }
                VMXState.check(authorization, vMXFrame.auth);
                VMXState.checkIndex(local.index, vMXFrame.size);
                n = vMXFrame.fp + local.index;
            }
        }
        this.dstack[n] = f;
    }

    public float fget(Local local, Authorization authorization) {
        int n;
        switch (local.nesting) {
            case -1: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.jsize);
                n = this.jfp + local.index;
                break;
            }
            case 0: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.fsize);
                n = this.fp + local.index;
                break;
            }
            default: {
                int n2 = local.nesting;
                if (n2 == 0) {
                    this.check(authorization);
                    VMXState.checkIndex(local.index, this.fsize);
                    n = this.fp + local.index;
                    break;
                }
                VMXFrame vMXFrame = this.currentFrame;
                while (--n2 >= 0) {
                    vMXFrame = vMXFrame.staticLink;
                }
                VMXState.check(authorization, vMXFrame.auth);
                VMXState.checkIndex(local.index, vMXFrame.size);
                n = vMXFrame.fp + local.index;
            }
        }
        return (float)this.dstack[n];
    }

    public void fpush(float f) {
        this.setSp(this.sp + 1);
        this.dstack[this.sp - 1] = f;
    }

    public float fpop() {
        if (this.sp <= this.minSp) {
            throw new EmptyStackException();
        }
        return (float)this.dstack[--this.sp];
    }

    public float fpeek() {
        if (this.sp <= this.minSp) {
            throw new EmptyStackException();
        }
        return (float)this.dstack[this.sp - 1];
    }

    public float fpeek(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if ((n = this.sp - n) < this.minSp) {
            throw new EmptyStackException();
        }
        return (float)this.dstack[n];
    }

    void dseta(int n, double d) {
        this.dstack[n] = d;
    }

    double dgeta(int n) {
        return this.dstack[n];
    }

    public void dsetj(int n, double d, Authorization authorization) {
        this.check(authorization);
        VMXState.checkIndex(n, this.jsize);
        this.dstack[this.jfp + n] = d;
    }

    public double dgetj(int n, Authorization authorization) {
        this.check(authorization);
        VMXState.checkIndex(n, this.jsize);
        return this.dstack[this.jfp + n];
    }

    public static void dset(double d, VMXState vMXState, int n, int n2, Authorization authorization) {
        int n3;
        if (n == 0) {
            vMXState.check(authorization);
            VMXState.checkIndex(n2, vMXState.fsize);
            n3 = vMXState.fp + n2;
        } else {
            VMXFrame vMXFrame = vMXState.currentFrame;
            while (--n >= 0) {
                vMXFrame = vMXFrame.staticLink;
            }
            VMXState.check(authorization, vMXFrame.auth);
            VMXState.checkIndex(n2, vMXFrame.size);
            n3 = vMXFrame.fp + n2;
        }
        vMXState.dstack[n3] = d;
    }

    public static double dget(VMXState vMXState, int n, int n2, Authorization authorization) {
        int n3;
        if (n == 0) {
            vMXState.check(authorization);
            VMXState.checkIndex(n2, vMXState.fsize);
            n3 = vMXState.fp + n2;
        } else {
            VMXFrame vMXFrame = vMXState.currentFrame;
            while (--n >= 0) {
                vMXFrame = vMXFrame.staticLink;
            }
            VMXState.check(authorization, vMXFrame.auth);
            VMXState.checkIndex(n2, vMXFrame.size);
            n3 = vMXFrame.fp + n2;
        }
        return vMXState.dstack[n3];
    }

    public void dset(Local local, double d, Authorization authorization) {
        switch (local.nesting) {
            case -1: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.jsize);
                int n = this.jfp + local.index;
                break;
            }
            case 0: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.fsize);
                int n = this.fp + local.index;
                break;
            }
            default: {
                int n;
                int n2 = local.nesting;
                if (n2 == 0) {
                    this.check(authorization);
                    VMXState.checkIndex(local.index, this.fsize);
                    n = this.fp + local.index;
                    break;
                }
                VMXFrame vMXFrame = this.currentFrame;
                while (--n2 >= 0) {
                    vMXFrame = vMXFrame.staticLink;
                }
                VMXState.check(authorization, vMXFrame.auth);
                VMXState.checkIndex(local.index, vMXFrame.size);
                n = vMXFrame.fp + local.index;
            }
        }
        this.dstack[n] = d;
    }

    public double dget(Local local, Authorization authorization) {
        int n;
        switch (local.nesting) {
            case -1: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.jsize);
                n = this.jfp + local.index;
                break;
            }
            case 0: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.fsize);
                n = this.fp + local.index;
                break;
            }
            default: {
                int n2 = local.nesting;
                if (n2 == 0) {
                    this.check(authorization);
                    VMXState.checkIndex(local.index, this.fsize);
                    n = this.fp + local.index;
                    break;
                }
                VMXFrame vMXFrame = this.currentFrame;
                while (--n2 >= 0) {
                    vMXFrame = vMXFrame.staticLink;
                }
                VMXState.check(authorization, vMXFrame.auth);
                VMXState.checkIndex(local.index, vMXFrame.size);
                n = vMXFrame.fp + local.index;
            }
        }
        return this.dstack[n];
    }

    public void dpush(double d) {
        this.setSp(this.sp + 2);
        this.dstack[this.sp - 2] = d;
    }

    public double dpop() {
        if (this.sp - 1 <= this.minSp) {
            throw new EmptyStackException();
        }
        return this.dstack[this.sp -= 2];
    }

    public double dpeek() {
        if (this.sp - 1 <= this.minSp) {
            throw new EmptyStackException();
        }
        return this.dstack[this.sp - 2];
    }

    public double dpeek(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if ((n = this.sp - n) < this.minSp) {
            throw new EmptyStackException();
        }
        return this.dstack[n];
    }

    void aseta(int n, Object object) {
        this.astack[n] = object;
    }

    Object ageta(int n) {
        return this.astack[n];
    }

    public void asetj(int n, Object object, Authorization authorization) {
        this.check(authorization);
        VMXState.checkIndex(n, this.jsize);
        this.astack[this.jfp + n] = object;
    }

    public Object agetj(int n, Authorization authorization) {
        this.check(authorization);
        VMXState.checkIndex(n, this.jsize);
        return this.astack[this.jfp + n];
    }

    public static void aset(Object object, VMXState vMXState, int n, int n2, Authorization authorization) {
        int n3;
        if (n == 0) {
            vMXState.check(authorization);
            VMXState.checkIndex(n2, vMXState.fsize);
            n3 = vMXState.fp + n2;
        } else {
            VMXFrame vMXFrame = vMXState.currentFrame;
            while (--n >= 0) {
                vMXFrame = vMXFrame.staticLink;
            }
            VMXState.check(authorization, vMXFrame.auth);
            VMXState.checkIndex(n2, vMXFrame.size);
            n3 = vMXFrame.fp + n2;
        }
        vMXState.astack[n3] = object;
    }

    public static Object aget(VMXState vMXState, int n, int n2, Authorization authorization) {
        int n3;
        if (n == 0) {
            vMXState.check(authorization);
            VMXState.checkIndex(n2, vMXState.fsize);
            n3 = vMXState.fp + n2;
        } else {
            VMXFrame vMXFrame = vMXState.currentFrame;
            while (--n >= 0) {
                vMXFrame = vMXFrame.staticLink;
            }
            VMXState.check(authorization, vMXFrame.auth);
            VMXState.checkIndex(n2, vMXFrame.size);
            n3 = vMXFrame.fp + n2;
        }
        return vMXState.astack[n3];
    }

    public void aset(Local local, Object object, Authorization authorization) {
        switch (local.nesting) {
            case -1: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.jsize);
                int n = this.jfp + local.index;
                break;
            }
            case 0: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.fsize);
                int n = this.fp + local.index;
                break;
            }
            default: {
                int n;
                int n2 = local.nesting;
                if (n2 == 0) {
                    this.check(authorization);
                    VMXState.checkIndex(local.index, this.fsize);
                    n = this.fp + local.index;
                    break;
                }
                VMXFrame vMXFrame = this.currentFrame;
                while (--n2 >= 0) {
                    vMXFrame = vMXFrame.staticLink;
                }
                VMXState.check(authorization, vMXFrame.auth);
                VMXState.checkIndex(local.index, vMXFrame.size);
                n = vMXFrame.fp + local.index;
            }
        }
        this.astack[n] = object;
    }

    public Object aget(Local local, Authorization authorization) {
        int n;
        switch (local.nesting) {
            case -1: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.jsize);
                n = this.jfp + local.index;
                break;
            }
            case 0: {
                this.check(authorization);
                VMXState.checkIndex(local.index, this.fsize);
                n = this.fp + local.index;
                break;
            }
            default: {
                int n2 = local.nesting;
                if (n2 == 0) {
                    this.check(authorization);
                    VMXState.checkIndex(local.index, this.fsize);
                    n = this.fp + local.index;
                    break;
                }
                VMXFrame vMXFrame = this.currentFrame;
                while (--n2 >= 0) {
                    vMXFrame = vMXFrame.staticLink;
                }
                VMXState.check(authorization, vMXFrame.auth);
                VMXState.checkIndex(local.index, vMXFrame.size);
                n = vMXFrame.fp + local.index;
            }
        }
        return this.astack[n];
    }

    public void apush(Object object) {
        this.setSp(this.sp + 1);
        this.astack[this.sp - 1] = object;
    }

    public Object apop() {
        if (this.sp <= this.minSp) {
            throw new EmptyStackException();
        }
        Object object = this.astack[--this.sp];
        this.astack[this.sp] = null;
        return object;
    }

    public Object apeek() {
        if (this.sp <= this.minSp) {
            throw new EmptyStackException();
        }
        return this.astack[this.sp - 1];
    }

    public Object apeek(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if ((n = this.sp - n) < this.minSp) {
            throw new EmptyStackException();
        }
        return this.astack[n];
    }

    public void pop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (this.sp - n < this.minSp) {
            throw new EmptyStackException();
        }
        this.setSp(this.sp - n);
    }

    int getPointer(VMXFrame vMXFrame, Local local) {
        if (local.nesting == -1) {
            VMXState.checkIndex(local.index, this.jsize);
            return vMXFrame.jfp + local.index;
        }
        int n = local.nesting;
        while (--n >= 0) {
            vMXFrame = vMXFrame.staticLink;
        }
        VMXState.checkIndex(local.index, vMXFrame.size);
        return vMXFrame.fp + local.index;
    }

    public MatchConsumerInFrame invokeInFrame(MatchConsumer matchConsumer, Frame frame) {
        MatchConsumerInFrame matchConsumerInFrame = this.consumerPool.isEmpty() ? new MatchConsumerInFrame() : (MatchConsumerInFrame)this.consumerPool.pop();
        matchConsumerInFrame.orig = matchConsumer;
        matchConsumerInFrame.frame = (VMXFrame)frame;
        return matchConsumerInFrame;
    }

    public AbruptCompletion.Return newReturn() {
        AbruptCompletion.Return return_ = this.poolReturn.isEmpty() ? new AbruptCompletion.Return(this) : (AbruptCompletion.Return)this.poolReturn.pop();
        return return_;
    }

    void dispose(AbruptCompletion.Return return_) {
        this.poolReturn.push((Object)return_);
    }

    public AbruptCompletion.Break newBreak(int n) {
        AbruptCompletion.Break break_ = this.poolBreak.isEmpty() ? new AbruptCompletion.Break(this) : (AbruptCompletion.Break)this.poolBreak.pop();
        break_.label = n;
        return break_;
    }

    void dispose(AbruptCompletion.Break break_) {
        this.poolBreak.push((Object)break_);
    }

    public AbruptCompletion.Throw newThrow(Throwable throwable) {
        AbruptCompletion.Throw throw_ = this.poolThrow.isEmpty() ? new AbruptCompletion.Throw(this) : (AbruptCompletion.Throw)this.poolThrow.pop();
        throwable.getClass();
        throw_.cause = throwable;
        return throw_;
    }

    void dispose(AbruptCompletion.Throw throw_) {
        this.poolThrow.push((Object)throw_);
    }

    AbruptCompletion.Nonlocal newNonlocal(VMXFrame vMXFrame, AbruptCompletion abruptCompletion) {
        AbruptCompletion.Nonlocal nonlocal = this.poolNonlocal.isEmpty() ? new AbruptCompletion.Nonlocal(this) : (AbruptCompletion.Nonlocal)this.poolNonlocal.pop();
        nonlocal.frame = vMXFrame;
        nonlocal.reason = abruptCompletion;
        return nonlocal;
    }

    void dispose(AbruptCompletion.Nonlocal nonlocal) {
        this.poolNonlocal.push((Object)nonlocal);
    }

    public AbruptCompletion.Return ireturn(int n) {
        AbruptCompletion.Return return_ = this.newReturn();
        return_.etype = 6;
        return_.ival = n;
        return return_;
    }

    public AbruptCompletion.Return lreturn(long l) {
        AbruptCompletion.Return return_ = this.newReturn();
        return_.etype = 7;
        return_.lval = l;
        return return_;
    }

    public AbruptCompletion.Return freturn(float f) {
        AbruptCompletion.Return return_ = this.newReturn();
        return_.etype = 8;
        return_.fval = f;
        return return_;
    }

    public AbruptCompletion.Return dreturn(double d) {
        AbruptCompletion.Return return_ = this.newReturn();
        return_.etype = 9;
        return_.dval = d;
        return return_;
    }

    public AbruptCompletion.Return areturn(Object object) {
        AbruptCompletion.Return return_ = this.newReturn();
        return_.etype = 0;
        return_.aval = object;
        return return_;
    }

    public AbruptCompletion.Nonlocal newNonlocal(int n, AbruptCompletion abruptCompletion, Authorization authorization) {
        this.check(authorization);
        VMXFrame vMXFrame = this.currentFrame;
        while (--n >= 0) {
            vMXFrame = vMXFrame.staticLink;
        }
        return this.newNonlocal(vMXFrame, abruptCompletion);
    }

    public AbruptCompletion.Return vreturn() {
        AbruptCompletion.Return return_ = this.newReturn();
        return_.etype = 1;
        return return_;
    }

    private Object[] getObjectArray(int n) {
        Object[] objectArray;
        if (n >= this.objectArrays.size) {
            this.objectArrays.setSize(n + 1);
        }
        if ((objectArray = (Object[])this.objectArrays.get(n)) == null) {
            objectArray = new Object[n];
            this.objectArrays.set(n, (Object)objectArray);
        }
        return objectArray;
    }

    public int[] popIntArray(int n) {
        int[] nArray = this.peekIntArray(n);
        this.sp -= n;
        return nArray;
    }

    public int[] peekIntArray(int n) {
        int n2;
        int[] nArray = (int[])this.intArrays.get(n);
        if (nArray == null) {
            nArray = new int[n];
            this.intArrays.set(n, (Object)nArray);
        }
        if ((n2 = this.sp - n) < this.minSp) {
            throw new EmptyStackException();
        }
        while (--n >= 0) {
            nArray[n] = this.istack[n2 + n];
        }
        return nArray;
    }

    public AbruptCompletion.Return invoke(Method method) {
        Object object;
        int n;
        int n2 = n = method.getParameterCount();
        Object[] objectArray = this.getObjectArray(n2);
        while (n2 > 0) {
            switch (method.getParameterType(--n2).getTypeId()) {
                case 2: {
                    objectArray[n2] = this.ipop() != 0 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 3: {
                    objectArray[n2] = (byte)this.ipop();
                    break;
                }
                case 4: {
                    objectArray[n2] = (short)this.ipop();
                    break;
                }
                case 5: {
                    objectArray[n2] = Character.valueOf((char)this.ipop());
                    break;
                }
                case 6: {
                    objectArray[n2] = this.ipop();
                    break;
                }
                case 7: {
                    objectArray[n2] = this.lpop();
                    break;
                }
                case 8: {
                    objectArray[n2] = Float.valueOf(this.fpop());
                    break;
                }
                case 9: {
                    objectArray[n2] = this.dpop();
                    break;
                }
                case 0: {
                    objectArray[n2] = this.apop();
                }
            }
        }
        try {
            object = method.invoke((method.getModifiers() & 8) == 0 ? this.apop() : null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.newThrow(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw this.newThrow(throwable);
        }
        finally {
            for (n2 = n - 1; n2 >= 0; --n2) {
                objectArray[n2] = null;
            }
        }
        if ("<init>".equals(method.getName())) {
            return this.areturn(object);
        }
        n2 = method.getReturnType().getTypeId();
        switch (n2) {
            case 1: {
                return null;
            }
            case 2: {
                return this.ireturn((Boolean)object != false ? 1 : 0);
            }
            case 5: {
                return this.ireturn(((Character)object).charValue());
            }
            case 3: 
            case 4: 
            case 6: {
                return this.ireturn(((Number)object).intValue());
            }
            case 7: {
                return this.lreturn(((Number)object).longValue());
            }
            case 8: {
                return this.freturn(((Number)object).floatValue());
            }
            case 9: {
                return this.dreturn(((Number)object).doubleValue());
            }
        }
        return this.areturn(object);
    }

    public RoutineDescriptor createDescriptor(Routine routine, int n, Authorization authorization) {
        RoutineDescriptor routineDescriptor = this.descriptorPool;
        if (routineDescriptor != null) {
            this.descriptorPool = routineDescriptor.next;
            routineDescriptor.next = null;
        } else {
            routineDescriptor = new RoutineDescriptor(this);
        }
        routineDescriptor.routine = routine;
        VMXFrame vMXFrame = this.currentFrame;
        while (--n >= -1) {
            vMXFrame = this.currentFrame.staticLink;
        }
        routineDescriptor.auth = authorization;
        routineDescriptor.staticLink = vMXFrame;
        return routineDescriptor;
    }

    public final class MatchConsumerInFrame
    implements MatchConsumer {
        MatchConsumer orig;
        VMXFrame frame;
        QueryState qs;
        int arg;

        MatchConsumerInFrame() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void matchFound(QueryState queryState, int n) {
            this.qs = queryState;
            this.arg = n;
            VMXFrame vMXFrame = VMXState.this.currentFrame;
            VMXState.this.loadFrame(this.frame);
            int n2 = VMXState.this.sp;
            VMXState.this.minSp = n2;
            try {
                this.orig.matchFound(queryState, n);
            }
            finally {
                VMXState.this.setSp(n2);
                VMXState.this.loadFrame(vMXFrame);
            }
            this.qs = null;
        }

        public void dispose() {
            this.orig = null;
            this.qs = null;
            this.frame = null;
            VMXState.this.consumerPool.push((Object)this);
        }
    }

    public static final class Local
    implements BytecodeSerialization.Serializable,
    Variable {
        private static final Object UNSET = new Object(){};
        public static final int JAVA = -1;
        final int nesting;
        final int index;

        public Local(int n, int n2) {
            this.nesting = n;
            this.index = n2;
            if (n2 < 0) {
                throw new IllegalArgumentException("index = " + n2);
            }
        }

        public boolean equals(Object object) {
            return object instanceof Local && ((Local)object).index == this.index && ((Local)object).nesting == this.nesting;
        }

        public int hashCode() {
            return this.index + this.nesting * 31;
        }

        public int getIndex() {
            return this.index;
        }

        public int getNesting() {
            return this.nesting;
        }

        public boolean isJavaLocal() {
            return this.nesting == -1;
        }

        public String toString() {
            switch (this.nesting) {
                case -1: {
                    return "JLocal[" + this.index + ']';
                }
            }
            return "Local[" + this.nesting + ':' + this.index + ']';
        }

        public void write(BytecodeSerialization bytecodeSerialization) throws IOException {
            bytecodeSerialization.beginMethod(Utils.getConstructor((Object)this));
            bytecodeSerialization.visitInt(this.nesting);
            bytecodeSerialization.visitInt(this.index);
            bytecodeSerialization.endMethod();
        }

        public void unset(Frame frame) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            vMXState.aseta(vMXState.getPointer((VMXFrame)frame, this), UNSET);
        }

        public void nullset(Frame frame) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            int n = vMXState.getPointer((VMXFrame)frame, this);
            vMXState.lseta(n, 0L);
            vMXState.dseta(n, Double.NaN);
            vMXState.aseta(n, null);
        }

        public boolean isSet(Frame frame) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            return vMXState.ageta(vMXState.getPointer((VMXFrame)frame, this)) != UNSET;
        }

        public boolean isNull(Frame frame) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            int n = vMXState.getPointer((VMXFrame)frame, this);
            return vMXState.ageta(n) == null && vMXState.igeta(n) == 0;
        }

        public int iget(Frame frame) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            return vMXState.igeta(vMXState.getPointer((VMXFrame)frame, this));
        }

        public void iset(Frame frame, int n) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            int n2 = vMXState.getPointer((VMXFrame)frame, this);
            vMXState.iseta(n2, n);
            vMXState.aseta(n2, this);
        }

        public long lget(Frame frame) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            return vMXState.lgeta(vMXState.getPointer((VMXFrame)frame, this));
        }

        public void lset(Frame frame, long l) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            int n = vMXState.getPointer((VMXFrame)frame, this);
            vMXState.lseta(n, l);
            vMXState.aseta(n, this);
        }

        public float fget(Frame frame) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            return vMXState.fgeta(vMXState.getPointer((VMXFrame)frame, this));
        }

        public void fset(Frame frame, float f) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            int n = vMXState.getPointer((VMXFrame)frame, this);
            vMXState.fseta(n, f);
            vMXState.aseta(n, this);
        }

        public double dget(Frame frame) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            return vMXState.dgeta(vMXState.getPointer((VMXFrame)frame, this));
        }

        public void dset(Frame frame, double d) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            int n = vMXState.getPointer((VMXFrame)frame, this);
            vMXState.dseta(n, d);
            vMXState.aseta(n, this);
        }

        public Object aget(Frame frame) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            return vMXState.ageta(vMXState.getPointer((VMXFrame)frame, this));
        }

        public void aset(Frame frame, Object object) {
            VMXState vMXState = ((VMXFrame)frame).vmx;
            int n = vMXState.getPointer((VMXFrame)frame, this);
            vMXState.aseta(n, object);
            vMXState.iseta(n, 1);
        }
    }

    static final class VMXFrame
    implements Frame {
        final VMXState vmx;
        int fp;
        int size;
        int jfp;
        int jsize;
        int minSp;
        int spSave;
        VMXFrame staticLink;
        VMXFrame parent;
        Authorization auth;

        VMXFrame(VMXState vMXState) {
            this.vmx = vMXState;
        }
    }
}

