/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.Layout;
import de.grogra.imp2d.layout.Node;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2f;

public abstract class ForceBasedLayout2
extends Layout {
    Node node;
    public int fMaxIterations = 15;
    public int fMaxIterationsTemp;
    private float fUnconnectedNodeX = 0.4f;
    private float fUnconnectedNodeY = 0.4f;
    Vector connectedNodes = new Vector();
    Vector unconnectedNodes = new Vector();
    private float fNodeSizeX = 0.0f;
    private float fNodeSizeY = 0.0f;
    protected float fDistanceMultiplierMin = 0.7f;
    protected float fDistanceMultiplierMax = 1.0f;
    protected float fDistanceMultiplier = 0.0f;
    private float sMinDistanceX = 0.4f;
    private float sMinDistanceY = 0.4f;

    protected Layout.Algorithm createAlgorithm() {
        return new FBAlgorithm2();
    }

    protected abstract Point2d repellingForce(Node var1, Node var2);

    protected abstract Point2d springForce(Node var1, Node var2);

    protected abstract double getFDeltaFactor();

    protected abstract void setRandomPosition(Node var1, Random var2);

    public class FBAlgorithm2
    extends Layout.Algorithm {
        public FBAlgorithm2() {
            super(ForceBasedLayout2.this);
        }

        protected void layout(Node node) {
            Node node2;
            int n;
            ForceBasedLayout2.this.node = node;
            ForceBasedLayout2.this.fMaxIterations = 15;
            this.calcMinDistance();
            this.disassociateNodes();
            ForceBasedLayout2.this.fUnconnectedNodeY = (float)this.getMaxBounds((Vector)ForceBasedLayout2.this.unconnectedNodes).y + 0.2f;
            int n2 = ForceBasedLayout2.this.fMaxIterations;
            Random random = new Random();
            Node node3 = ForceBasedLayout2.this.node;
            while (node3 != null) {
                ForceBasedLayout2.this.setRandomPosition(node3, random);
                node3 = node3.next;
            }
            int n3 = 0;
            ForceBasedLayout2.this.fUnconnectedNodeY = (float)this.getMaxBounds((Vector)ForceBasedLayout2.this.unconnectedNodes).y + 0.2f;
            for (n = 0; n < ForceBasedLayout2.this.unconnectedNodes.size(); ++n) {
                double d = ForceBasedLayout2.this.fUnconnectedNodeX;
                double d2 = 0.7f + (float)n3 * ForceBasedLayout2.this.fUnconnectedNodeY;
                ++n3;
                node2 = (Node)((Object)ForceBasedLayout2.this.unconnectedNodes.get(n));
                node2.x = (float)d;
                node2.y = (float)d2;
            }
            while (ForceBasedLayout2.this.fMaxIterations > 0) {
                for (n = 0; n < ForceBasedLayout2.this.connectedNodes.size(); ++n) {
                    int n4;
                    Node node4 = (Node)((Object)ForceBasedLayout2.this.connectedNodes.get(n));
                    Vector vector = this.allocationNodes(node4, ForceBasedLayout2.this.connectedNodes);
                    Vector vector2 = (Vector)vector.get(0);
                    Point2d point2d = new Point2d();
                    node2 = new Point2d(0.0, 0.0);
                    Point2d point2d2 = new Point2d(0.0, 0.0);
                    for (n4 = 0; n4 < vector2.size(); ++n4) {
                        point2d.x = ((Point2d)node2).x + ForceBasedLayout2.this.springForce((Node)node4, (Node)((Node)((Object)vector2.get((int)n4)))).x;
                        point2d.y = ((Point2d)node2).y + ForceBasedLayout2.this.springForce((Node)node4, (Node)((Node)((Object)vector2.get((int)n4)))).y;
                        node2 = point2d;
                    }
                    for (n4 = 0; n4 < ForceBasedLayout2.this.connectedNodes.size(); ++n4) {
                        if (node4.equals((Tuple2f)((Node)((Object)ForceBasedLayout2.this.connectedNodes.get(n4))))) continue;
                        point2d.x = point2d2.x + ForceBasedLayout2.this.repellingForce((Node)node4, (Node)((Node)((Object)ForceBasedLayout2.this.connectedNodes.get((int)n4)))).x;
                        point2d.y = point2d2.y + ForceBasedLayout2.this.repellingForce((Node)node4, (Node)((Node)((Object)ForceBasedLayout2.this.connectedNodes.get((int)n4)))).y;
                        point2d2 = point2d;
                    }
                    point2d.x = ((Point2d)node2).x + point2d2.x;
                    point2d.y = ((Point2d)node2).y + point2d2.y;
                    this.applyVectorToNode(node4, point2d, ForceBasedLayout2.this.getFDeltaFactor());
                }
                --ForceBasedLayout2.this.fMaxIterations;
            }
            ForceBasedLayout2.this.fMaxIterations = n2;
            Node node5 = ForceBasedLayout2.this.node;
            while (node5 != null) {
                ForceBasedLayout2.this.fNodeSizeX = Math.max(ForceBasedLayout2.this.fNodeSizeX, node5.height);
                ForceBasedLayout2.this.fNodeSizeY = Math.max(ForceBasedLayout2.this.fNodeSizeY, node5.width);
                node5 = node5.next;
            }
            double d = ForceBasedLayout2.this.fNodeSizeX + 3.0f * ForceBasedLayout2.this.fUnconnectedNodeX;
            double d3 = this.getMinXNodePositionValue(null, ForceBasedLayout2.this.connectedNodes) - d;
            double d4 = this.getMinYNodePositionValue(null, ForceBasedLayout2.this.connectedNodes) - (double)(2.0f * ForceBasedLayout2.this.fUnconnectedNodeY);
            this.moveNodesToUpperLeft(null, ForceBasedLayout2.this.connectedNodes, d3, d4);
            System.out.println("fMaxIterations: " + ForceBasedLayout2.this.fMaxIterations);
            System.out.println("fUnconnectedNodeX: " + ForceBasedLayout2.this.fUnconnectedNodeX);
            System.out.println("sMinDistanceX: " + ForceBasedLayout2.this.sMinDistanceX);
            System.out.println("sMinDistanceY: " + ForceBasedLayout2.this.sMinDistanceY);
        }

        protected void applyVectorToNode(Node node, Point2d point2d, double d) {
            Point2d point2d2 = new Point2d((double)node.x, (double)node.y);
            double d2 = d;
            float f = 0.4f;
            float f2 = 0.4f;
            double d3 = point2d.x * d2;
            double d4 = point2d.y * d2;
            double d5 = 0.0;
            double d6 = 0.0;
            d5 = d3 > 0.0 ? Math.min((double)f, d3) : Math.max((double)(f *= -1.0f), d3);
            d6 = d4 > 0.0 ? Math.min((double)f2, d4) : Math.max((double)(f2 *= -1.0f), d4);
            point2d2.x += d3;
            point2d2.y += d4;
            node.x = (float)point2d2.x;
            node.y = (float)point2d2.y;
        }

        protected void moveNodesToUpperLeft(Hashtable hashtable, Vector vector, double d, double d2) {
            Enumeration<Object> enumeration = vector == null ? hashtable.keys() : vector.elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)((Object)enumeration.nextElement());
                double d3 = (double)node.x - d;
                double d4 = (double)node.y - d2;
                node.x = (float)d3;
                node.y = (float)d4;
            }
        }

        protected double getMinXNodePositionValue(Hashtable hashtable, Vector vector) {
            double d = 2.147483647E9;
            Enumeration<Object> enumeration = vector == null ? hashtable.keys() : vector.elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)((Object)enumeration.nextElement());
                d = Math.min(d, (double)node.x);
            }
            if (d == 2.147483647E9) {
                d = ForceBasedLayout2.this.fNodeSizeX + ForceBasedLayout2.this.fUnconnectedNodeX;
            }
            return d;
        }

        protected double getMinYNodePositionValue(Hashtable hashtable, Vector vector) {
            double d = 2.147483647E9;
            Enumeration<Object> enumeration = vector == null ? hashtable.keys() : vector.elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)((Object)enumeration.nextElement());
                d = Math.min(d, (double)node.y);
            }
            if (d == 2.147483647E9) {
                d = ForceBasedLayout2.this.fUnconnectedNodeY;
            }
            return d;
        }

        protected Vector allocationNodes(Node node, Vector vector) {
            Vector vector2 = new Vector();
            Vector<Node> vector3 = new Vector<Node>();
            Vector<Node> vector4 = new Vector<Node>();
            for (int i = 0; i < vector.size(); ++i) {
                Edge edge;
                Node node2 = (Node)((Object)vector.get(i));
                if (node2 == node) continue;
                boolean bl = false;
                for (edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                    if ((!edge.source.equals((Tuple2f)node2) || !edge.target.equals((Tuple2f)node)) && (!edge.source.equals((Tuple2f)node) || !edge.target.equals((Tuple2f)node2))) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    for (edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                        if ((!edge.source.equals((Tuple2f)node2) || !edge.target.equals((Tuple2f)node)) && (!edge.source.equals((Tuple2f)node) || !edge.target.equals((Tuple2f)node2))) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    vector3.add(node2);
                    continue;
                }
                vector4.add(node2);
            }
            vector2.add(0, vector3);
            vector2.add(1, vector4);
            return vector2;
        }

        protected void calcMinDistance() {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            double d = (double)(ForceBasedLayout2.this.fDistanceMultiplierMax - ForceBasedLayout2.this.fDistanceMultiplierMin) / 180.0;
            double d2 = (double)ForceBasedLayout2.this.fDistanceMultiplierMin - 0.2 * d;
            double d3 = (double)ForceBasedLayout2.this.connectedNodes.size() * d + d2;
            if (d3 < (double)ForceBasedLayout2.this.fDistanceMultiplierMin) {
                d3 = ForceBasedLayout2.this.fDistanceMultiplierMin;
            }
            if (d3 > (double)ForceBasedLayout2.this.fDistanceMultiplierMax) {
                d3 = ForceBasedLayout2.this.fDistanceMultiplierMax;
            }
            ForceBasedLayout2.this.fDistanceMultiplier = (float)d3;
            Node node = ForceBasedLayout2.this.node;
            while (node != null) {
                f3 = node.height;
                f4 = node.width;
                f = Math.max(f, f3);
                f2 = Math.max(f2, f4);
                node = node.next;
            }
            ForceBasedLayout2.this.sMinDistanceX = f + 2.0f * ForceBasedLayout2.this.fDistanceMultiplier;
            ForceBasedLayout2.this.sMinDistanceY = f2 + 1.0f * ForceBasedLayout2.this.fDistanceMultiplier;
            ForceBasedLayout2.this.fNodeSizeX = f;
        }

        protected Point2d getMaxBounds(Vector vector) {
            if (vector.size() == 0) {
                return new Point2d(0.0, 0.0);
            }
            Point2d point2d = new Point2d();
            for (int i = 0; i < vector.size(); ++i) {
                point2d.set(Math.max((double)((Node)((Object)vector.get((int)i))).height, point2d.x), Math.max((double)((Node)((Object)vector.get((int)i))).width, point2d.y));
            }
            return point2d;
        }

        public void disassociateNodes() {
            Node node = ForceBasedLayout2.this.node;
            while (node != null) {
                if (node.getFirstEdge() != null) {
                    ForceBasedLayout2.this.connectedNodes.add(node);
                } else {
                    ForceBasedLayout2.this.unconnectedNodes.add(node);
                }
                node = node.next;
            }
        }
    }
}

